/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.occurrence.predicate;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.validation.constraints.NotNull;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gbif.api.model.occurrence.predicate.Predicate;

public class CompoundPredicate
implements Predicate {
    @NotNull
    private final Collection<Predicate> predicates;

    @JsonCreator
    protected CompoundPredicate(@JsonProperty(value="predicates") Collection<Predicate> predicates) {
        Preconditions.checkNotNull(predicates, "Predicates may not be null");
        Preconditions.checkArgument(!predicates.isEmpty(), "Predicates may not be empty");
        this.predicates = ImmutableList.copyOf(predicates);
    }

    public Collection<Predicate> getPredicates() {
        return this.predicates;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CompoundPredicate)) {
            return true;
        }
        CompoundPredicate other = (CompoundPredicate)obj;
        return Objects.equal(this.predicates, other.predicates);
    }

    public int hashCode() {
        return Objects.hashCode(this.predicates);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("predicates", this.predicates).toString();
    }
}

