/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.occurrence;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.codehaus.jackson.annotate.JsonAnyGetter;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.gbif.api.model.common.Identifier;
import org.gbif.api.model.common.LinneanClassification;
import org.gbif.api.model.common.LinneanClassificationKeys;
import org.gbif.api.model.common.MediaObject;
import org.gbif.api.model.occurrence.FactOrMeasurment;
import org.gbif.api.model.occurrence.OccurrenceRelation;
import org.gbif.api.model.occurrence.VerbatimOccurrence;
import org.gbif.api.util.ClassificationUtils;
import org.gbif.api.vocabulary.BasisOfRecord;
import org.gbif.api.vocabulary.Continent;
import org.gbif.api.vocabulary.Country;
import org.gbif.api.vocabulary.EstablishmentMeans;
import org.gbif.api.vocabulary.License;
import org.gbif.api.vocabulary.LifeStage;
import org.gbif.api.vocabulary.OccurrenceIssue;
import org.gbif.api.vocabulary.Rank;
import org.gbif.api.vocabulary.Sex;
import org.gbif.api.vocabulary.TypeStatus;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.terms.Term;
import org.gbif.dwc.terms.UnknownTerm;

public class Occurrence
extends VerbatimOccurrence
implements LinneanClassification,
LinneanClassificationKeys {
    public static final String GEO_DATUM = "WGS84";
    private static final Set<String> PROPERTIES = ImmutableSet.copyOf(Iterables.concat(Lists.newArrayList(DwcTerm.geodeticDatum.simpleName(), "class", "countryCode"), Iterables.transform(Iterables.concat(Lists.newArrayList(Occurrence.class.getDeclaredFields()), Lists.newArrayList(VerbatimOccurrence.class.getDeclaredFields())), new Function<Field, String>(){

        @Override
        @Nullable
        public String apply(@Nullable Field f) {
            return f.getName();
        }
    })));
    private BasisOfRecord basisOfRecord;
    private Integer individualCount;
    private Sex sex;
    private LifeStage lifeStage;
    private EstablishmentMeans establishmentMeans;
    private Integer taxonKey;
    private Integer kingdomKey;
    private Integer phylumKey;
    private Integer classKey;
    private Integer orderKey;
    private Integer familyKey;
    private Integer genusKey;
    private Integer subgenusKey;
    private Integer speciesKey;
    private String scientificName;
    private String kingdom;
    private String phylum;
    @JsonProperty(value="class")
    private String clazz;
    private String order;
    private String family;
    private String genus;
    private String subgenus;
    private String species;
    private String genericName;
    private String specificEpithet;
    private String infraspecificEpithet;
    private Rank taxonRank;
    private Date dateIdentified;
    private Double decimalLongitude;
    private Double decimalLatitude;
    private Double coordinatePrecision;
    private Double coordinateUncertaintyInMeters;
    @Deprecated
    private Double coordinateAccuracy;
    private Double elevation;
    private Double elevationAccuracy;
    private Double depth;
    private Double depthAccuracy;
    private Continent continent;
    @JsonSerialize(using=Country.IsoSerializer.class)
    @JsonDeserialize(using=Country.IsoDeserializer.class)
    private Country country;
    private String stateProvince;
    private String waterBody;
    private Integer year;
    private Integer month;
    private Integer day;
    private Date eventDate;
    private TypeStatus typeStatus;
    private String typifiedName;
    private Set<OccurrenceIssue> issues = EnumSet.noneOf(OccurrenceIssue.class);
    private Date modified;
    private Date lastInterpreted;
    private URI references;
    private License license;
    private List<Identifier> identifiers = Lists.newArrayList();
    private List<MediaObject> media = Lists.newArrayList();
    private List<FactOrMeasurment> facts = Lists.newArrayList();
    private List<OccurrenceRelation> relations = Lists.newArrayList();

    public Occurrence() {
    }

    public Occurrence(@Nullable VerbatimOccurrence verbatim) {
        if (verbatim != null) {
            this.setKey(verbatim.getKey());
            this.setDatasetKey(verbatim.getDatasetKey());
            this.setPublishingOrgKey(verbatim.getPublishingOrgKey());
            this.setPublishingCountry(verbatim.getPublishingCountry());
            this.setProtocol(verbatim.getProtocol());
            if (verbatim.getLastCrawled() != null) {
                this.setLastCrawled(new Date(verbatim.getLastCrawled().getTime()));
            }
            if (verbatim.getVerbatimFields() != null) {
                this.getVerbatimFields().putAll(verbatim.getVerbatimFields());
            }
            if (verbatim.getLastParsed() != null) {
                this.setLastParsed(verbatim.getLastParsed());
            }
            this.setExtensions(verbatim.getExtensions());
        }
    }

    @Nullable
    public BasisOfRecord getBasisOfRecord() {
        return this.basisOfRecord;
    }

    public void setBasisOfRecord(BasisOfRecord basisOfRecord) {
        this.basisOfRecord = basisOfRecord;
    }

    @Nullable
    public Integer getIndividualCount() {
        return this.individualCount;
    }

    public void setIndividualCount(Integer individualCount) {
        this.individualCount = individualCount;
    }

    @Nullable
    public Sex getSex() {
        return this.sex;
    }

    public void setSex(Sex sex) {
        this.sex = sex;
    }

    @Nullable
    public LifeStage getLifeStage() {
        return this.lifeStage;
    }

    public void setLifeStage(LifeStage lifeStage) {
        this.lifeStage = lifeStage;
    }

    @Nullable
    public EstablishmentMeans getEstablishmentMeans() {
        return this.establishmentMeans;
    }

    public void setEstablishmentMeans(EstablishmentMeans establishmentMeans) {
        this.establishmentMeans = establishmentMeans;
    }

    @Nullable
    public Integer getTaxonKey() {
        return this.taxonKey;
    }

    public void setTaxonKey(Integer taxonKey) {
        this.taxonKey = taxonKey;
    }

    @Override
    @Nullable
    public Integer getKingdomKey() {
        return this.kingdomKey;
    }

    @Override
    public void setKingdomKey(@Nullable Integer kingdomKey) {
        this.kingdomKey = kingdomKey;
    }

    @Override
    @Nullable
    public Integer getPhylumKey() {
        return this.phylumKey;
    }

    @Override
    public void setPhylumKey(@Nullable Integer phylumKey) {
        this.phylumKey = phylumKey;
    }

    @Override
    @Nullable
    public Integer getClassKey() {
        return this.classKey;
    }

    @Override
    public void setClassKey(@Nullable Integer classKey) {
        this.classKey = classKey;
    }

    @Override
    @Nullable
    public Integer getOrderKey() {
        return this.orderKey;
    }

    @Override
    public void setOrderKey(@Nullable Integer orderKey) {
        this.orderKey = orderKey;
    }

    @Override
    @Nullable
    public Integer getFamilyKey() {
        return this.familyKey;
    }

    @Override
    public void setFamilyKey(@Nullable Integer familyKey) {
        this.familyKey = familyKey;
    }

    @Override
    @Nullable
    public Integer getGenusKey() {
        return this.genusKey;
    }

    @Override
    public void setGenusKey(@Nullable Integer genusKey) {
        this.genusKey = genusKey;
    }

    @Override
    @Nullable
    public Integer getSubgenusKey() {
        return this.subgenusKey;
    }

    @Override
    public void setSubgenusKey(@Nullable Integer subgenusKey) {
        this.subgenusKey = subgenusKey;
    }

    @Override
    @Nullable
    public Integer getHigherRankKey(Rank rank) {
        return ClassificationUtils.getHigherRankKey(this, rank);
    }

    @NotNull
    @JsonIgnore
    public LinkedHashMap<Integer, String> getHigherClassificationMap() {
        return this.taxonKey == null ? ClassificationUtils.getHigherClassificationMap(this) : ClassificationUtils.getHigherClassificationMap(this, this.taxonKey, null, null);
    }

    @Override
    @Nullable
    public Integer getSpeciesKey() {
        return this.speciesKey;
    }

    @Override
    public void setSpeciesKey(@Nullable Integer speciesKey) {
        this.speciesKey = speciesKey;
    }

    @Nullable
    public String getSpecificEpithet() {
        return this.specificEpithet;
    }

    public void setSpecificEpithet(String specificEpithet) {
        this.specificEpithet = specificEpithet;
    }

    @Nullable
    public String getInfraspecificEpithet() {
        return this.infraspecificEpithet;
    }

    public void setInfraspecificEpithet(String infraspecificEpithet) {
        this.infraspecificEpithet = infraspecificEpithet;
    }

    @Nullable
    public Rank getTaxonRank() {
        return this.taxonRank;
    }

    public void setTaxonRank(Rank taxonRank) {
        this.taxonRank = taxonRank;
    }

    @Nullable
    public String getScientificName() {
        return this.scientificName;
    }

    public void setScientificName(@Nullable String scientificName) {
        this.scientificName = scientificName;
    }

    @Override
    @Nullable
    public String getKingdom() {
        return this.kingdom;
    }

    @Override
    public void setKingdom(@Nullable String kingdom) {
        this.kingdom = kingdom;
    }

    @Override
    @Nullable
    public String getPhylum() {
        return this.phylum;
    }

    @Override
    public void setPhylum(@Nullable String phylum) {
        this.phylum = phylum;
    }

    @Override
    @Nullable
    public String getClazz() {
        return this.clazz;
    }

    @Override
    public void setClazz(@Nullable String clazz) {
        this.clazz = clazz;
    }

    @Override
    @Nullable
    public String getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(@Nullable String order) {
        this.order = order;
    }

    @Override
    @Nullable
    public String getFamily() {
        return this.family;
    }

    @Override
    public void setFamily(@Nullable String family) {
        this.family = family;
    }

    @Override
    @Nullable
    public String getGenus() {
        return this.genus;
    }

    @Override
    public void setGenus(@Nullable String genus) {
        this.genus = genus;
    }

    @Nullable
    public String getGenericName() {
        return this.genericName;
    }

    public void setGenericName(String genericName) {
        this.genericName = genericName;
    }

    @Override
    @Nullable
    public String getSubgenus() {
        return this.subgenus;
    }

    @Override
    public void setSubgenus(@Nullable String subgenus) {
        this.subgenus = subgenus;
    }

    @Override
    @Nullable
    public String getHigherRank(Rank rank) {
        return ClassificationUtils.getHigherRank(this, rank);
    }

    @Override
    @Nullable
    public String getSpecies() {
        return this.species;
    }

    @Override
    public void setSpecies(@Nullable String species) {
        this.species = species;
    }

    @Nullable
    public Date getDateIdentified() {
        return this.dateIdentified == null ? null : new Date(this.dateIdentified.getTime());
    }

    public void setDateIdentified(@Nullable Date dateIdentified) {
        this.dateIdentified = dateIdentified == null ? null : new Date(dateIdentified.getTime());
    }

    @Nullable
    public Double getDecimalLongitude() {
        return this.decimalLongitude;
    }

    public void setDecimalLongitude(@Nullable Double decimalLongitude) {
        this.decimalLongitude = decimalLongitude;
    }

    @Nullable
    public Double getDecimalLatitude() {
        return this.decimalLatitude;
    }

    public void setDecimalLatitude(@Nullable Double decimalLatitude) {
        this.decimalLatitude = decimalLatitude;
    }

    @Nullable
    public Double getCoordinateUncertaintyInMeters() {
        return this.coordinateUncertaintyInMeters;
    }

    public void setCoordinateUncertaintyInMeters(@Nullable Double coordinateUncertaintyInMeters) {
        this.coordinateUncertaintyInMeters = coordinateUncertaintyInMeters;
    }

    @Nullable
    public Double getCoordinatePrecision() {
        return this.coordinatePrecision;
    }

    public void setCoordinatePrecision(Double coordinatePrecision) {
        this.coordinatePrecision = coordinatePrecision;
    }

    @Nullable
    @Deprecated
    public Double getCoordinateAccuracy() {
        return this.coordinateAccuracy;
    }

    public void setCoordinateAccuracy(@Nullable Double coordinateAccuracy) {
        this.coordinateAccuracy = coordinateAccuracy;
    }

    @Nullable
    public String getGeodeticDatum() {
        if (this.decimalLatitude != null) {
            return GEO_DATUM;
        }
        return null;
    }

    private void setGeodeticDatum(String datum) {
    }

    @Nullable
    public Double getElevation() {
        return this.elevation;
    }

    public void setElevation(@Nullable Double elevation) {
        this.elevation = elevation;
    }

    @Nullable
    public Double getElevationAccuracy() {
        return this.elevationAccuracy;
    }

    public void setElevationAccuracy(@Nullable Double elevationAccuracy) {
        this.elevationAccuracy = elevationAccuracy;
    }

    @Nullable
    public Double getDepth() {
        return this.depth;
    }

    public void setDepth(@Nullable Double depth) {
        this.depth = depth;
    }

    @Nullable
    public Double getDepthAccuracy() {
        return this.depthAccuracy;
    }

    public void setDepthAccuracy(@Nullable Double depthAccuracy) {
        this.depthAccuracy = depthAccuracy;
    }

    @Nullable
    public Continent getContinent() {
        return this.continent;
    }

    public void setContinent(@Nullable Continent continent) {
        this.continent = continent;
    }

    @Nullable
    @JsonProperty(value="countryCode")
    public Country getCountry() {
        return this.country;
    }

    public void setCountry(@Nullable Country country) {
        this.country = country;
    }

    @Nullable
    @JsonProperty(value="country")
    private String getCountryTitle() {
        return this.country == null ? null : this.country.getTitle();
    }

    private void setCountryTitle(String country) {
    }

    @Nullable
    public String getStateProvince() {
        return this.stateProvince;
    }

    public void setStateProvince(@Nullable String stateProvince) {
        this.stateProvince = stateProvince;
    }

    @Nullable
    public String getWaterBody() {
        return this.waterBody;
    }

    public void setWaterBody(@Nullable String waterBody) {
        this.waterBody = waterBody;
    }

    @Min(value=1500L)
    @Max(value=2020L)
    @Nullable
    public Integer getYear() {
        return this.year;
    }

    public void setYear(@Nullable Integer year) {
        this.year = year;
    }

    @Min(value=1L)
    @Max(value=12L)
    @Nullable
    public Integer getMonth() {
        return this.month;
    }

    public void setMonth(@Nullable Integer month) {
        this.month = month;
    }

    @Min(value=1L)
    @Max(value=31L)
    @Nullable
    public Integer getDay() {
        return this.day;
    }

    public void setDay(@Nullable Integer day) {
        this.day = day;
    }

    @Nullable
    public Date getEventDate() {
        return this.eventDate == null ? null : new Date(this.eventDate.getTime());
    }

    public void setEventDate(@Nullable Date eventDate) {
        this.eventDate = eventDate == null ? null : new Date(eventDate.getTime());
    }

    @Nullable
    public TypeStatus getTypeStatus() {
        return this.typeStatus;
    }

    public void setTypeStatus(@Nullable TypeStatus typeStatus) {
        this.typeStatus = typeStatus;
    }

    @Nullable
    public String getTypifiedName() {
        return this.typifiedName;
    }

    public void setTypifiedName(@Nullable String typifiedName) {
        this.typifiedName = typifiedName;
    }

    @NotNull
    public Set<OccurrenceIssue> getIssues() {
        return this.issues;
    }

    public void setIssues(Set<OccurrenceIssue> issues) {
        Preconditions.checkNotNull("Issues cannot be null", issues);
        this.issues = Sets.newEnumSet(issues, OccurrenceIssue.class);
    }

    public void addIssue(OccurrenceIssue issue) {
        Preconditions.checkNotNull("Issue needs to be specified", issue);
        this.issues.add(issue);
    }

    @Nullable
    public Date getModified() {
        return this.modified == null ? null : new Date(this.modified.getTime());
    }

    public void setModified(@Nullable Date modified) {
        this.modified = modified == null ? null : new Date(modified.getTime());
    }

    @Nullable
    public Date getLastInterpreted() {
        return this.lastInterpreted == null ? null : new Date(this.lastInterpreted.getTime());
    }

    public void setLastInterpreted(@Nullable Date lastInterpreted) {
        this.lastInterpreted = lastInterpreted == null ? null : new Date(lastInterpreted.getTime());
    }

    @Nullable
    public URI getReferences() {
        return this.references;
    }

    public void setReferences(URI references) {
        this.references = references;
    }

    @NotNull
    public License getLicense() {
        return this.license;
    }

    public void setLicense(License license) {
        this.license = license;
    }

    @NotNull
    public List<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    public void setIdentifiers(List<Identifier> identifiers) {
        this.identifiers = identifiers;
    }

    @NotNull
    public List<MediaObject> getMedia() {
        return this.media;
    }

    public void setMedia(List<MediaObject> media) {
        this.media = media;
    }

    @NotNull
    public List<FactOrMeasurment> getFacts() {
        return this.facts;
    }

    public void setFacts(List<FactOrMeasurment> facts) {
        this.facts = facts;
    }

    @NotNull
    public List<OccurrenceRelation> getRelations() {
        return this.relations;
    }

    public void setRelations(List<OccurrenceRelation> relations) {
        this.relations = relations;
    }

    @JsonIgnore
    public boolean hasSpatialIssue() {
        for (OccurrenceIssue rule : OccurrenceIssue.GEOSPATIAL_RULES) {
            if (!this.issues.contains(rule)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(new Object[]{this.basisOfRecord, this.individualCount, this.sex, this.lifeStage, this.establishmentMeans, this.taxonKey, this.kingdomKey, this.phylumKey, this.classKey, this.orderKey, this.familyKey, this.genusKey, this.subgenusKey, this.speciesKey, this.scientificName, this.kingdom, this.phylum, this.clazz, this.order, this.family, this.genus, this.subgenus, this.species, this.genericName, this.specificEpithet, this.infraspecificEpithet, this.taxonRank, this.dateIdentified, this.year, this.month, this.day, this.eventDate, this.decimalLongitude, this.decimalLatitude, this.coordinatePrecision, this.coordinateUncertaintyInMeters, this.elevation, this.elevationAccuracy, this.depth, this.depthAccuracy, this.continent, this.country, this.stateProvince, this.waterBody, this.typeStatus, this.typifiedName, this.issues, this.modified, this.lastInterpreted, this.references, this.identifiers, this.media, this.facts, this.relations, this.license});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Occurrence)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Occurrence that = (Occurrence)obj;
        return Objects.equal((Object)this.basisOfRecord, (Object)that.basisOfRecord) && Objects.equal(this.individualCount, that.individualCount) && Objects.equal((Object)this.sex, (Object)that.sex) && Objects.equal((Object)this.lifeStage, (Object)that.lifeStage) && Objects.equal((Object)this.establishmentMeans, (Object)that.establishmentMeans) && Objects.equal(this.taxonKey, that.taxonKey) && Objects.equal(this.kingdomKey, that.kingdomKey) && Objects.equal(this.phylumKey, that.phylumKey) && Objects.equal(this.classKey, that.classKey) && Objects.equal(this.orderKey, that.orderKey) && Objects.equal(this.familyKey, that.familyKey) && Objects.equal(this.genusKey, that.genusKey) && Objects.equal(this.subgenusKey, that.subgenusKey) && Objects.equal(this.speciesKey, that.speciesKey) && Objects.equal(this.scientificName, that.scientificName) && Objects.equal(this.kingdom, that.kingdom) && Objects.equal(this.phylum, that.phylum) && Objects.equal(this.clazz, that.clazz) && Objects.equal(this.order, that.order) && Objects.equal(this.family, that.family) && Objects.equal(this.genus, that.genus) && Objects.equal(this.subgenus, that.subgenus) && Objects.equal(this.species, that.species) && Objects.equal(this.genericName, that.genericName) && Objects.equal(this.specificEpithet, that.specificEpithet) && Objects.equal(this.infraspecificEpithet, that.infraspecificEpithet) && Objects.equal((Object)this.taxonRank, (Object)that.taxonRank) && Objects.equal(this.dateIdentified, that.dateIdentified) && Objects.equal(this.year, that.year) && Objects.equal(this.month, that.month) && Objects.equal(this.day, that.day) && Objects.equal(this.eventDate, that.eventDate) && Objects.equal(this.decimalLongitude, that.decimalLongitude) && Objects.equal(this.decimalLatitude, that.decimalLatitude) && Objects.equal(this.coordinatePrecision, that.coordinatePrecision) && Objects.equal(this.coordinateUncertaintyInMeters, that.coordinateUncertaintyInMeters) && Objects.equal(this.elevation, that.elevation) && Objects.equal(this.elevationAccuracy, that.elevationAccuracy) && Objects.equal(this.depth, that.depth) && Objects.equal(this.depthAccuracy, that.depthAccuracy) && Objects.equal((Object)this.continent, (Object)that.continent) && Objects.equal((Object)this.country, (Object)that.country) && Objects.equal(this.stateProvince, that.stateProvince) && Objects.equal(this.waterBody, that.waterBody) && Objects.equal((Object)this.typeStatus, (Object)that.typeStatus) && Objects.equal(this.typifiedName, that.typifiedName) && Objects.equal(this.issues, that.issues) && Objects.equal(this.modified, that.modified) && Objects.equal(this.lastInterpreted, that.lastInterpreted) && Objects.equal(this.references, that.references) && Objects.equal(this.identifiers, that.identifiers) && Objects.equal(this.media, that.media) && Objects.equal(this.facts, that.facts) && Objects.equal(this.relations, that.relations) && Objects.equal((Object)this.license, (Object)that.license);
    }

    @Override
    public String toString() {
        return super.toString() + Objects.toStringHelper(this).add("basisOfRecord", (Object)this.basisOfRecord).add("individualCount", this.individualCount).add("sex", (Object)this.sex).add("lifeStage", (Object)this.lifeStage).add("establishmentMeans", (Object)this.establishmentMeans).add("taxonKey", this.taxonKey).add("kingdomKey", this.kingdomKey).add("phylumKey", this.phylumKey).add("classKey", this.classKey).add("orderKey", this.orderKey).add("familyKey", this.familyKey).add("genusKey", this.genusKey).add("subgenusKey", this.subgenusKey).add("speciesKey", this.speciesKey).add("scientificName", this.scientificName).add("kingdom", this.kingdom).add("phylum", this.phylum).add("clazz", this.clazz).add("order", this.order).add("family", this.family).add("genus", this.genus).add("subgenus", this.subgenus).add("species", this.species).add("genericName", this.genericName).add("specificEpithet", this.specificEpithet).add("infraspecificEpithet", this.infraspecificEpithet).add("taxonRank", (Object)this.taxonRank).add("dateIdentified", this.dateIdentified).add("decimalLongitude", this.decimalLongitude).add("decimalLatitude", this.decimalLatitude).add("coordinatePrecision", this.coordinatePrecision).add("coordinateUncertaintyInMeters", this.coordinateUncertaintyInMeters).add("coordinateAccuracy", this.coordinateAccuracy).add("elevation", this.elevation).add("elevationAccuracy", this.elevationAccuracy).add("depth", this.depth).add("depthAccuracy", this.depthAccuracy).add("continent", (Object)this.continent).add("country", (Object)this.country).add("stateProvince", this.stateProvince).add("waterBody", this.waterBody).add("year", this.year).add("month", this.month).add("day", this.day).add("eventDate", this.eventDate).add("typeStatus", (Object)this.typeStatus).add("typifiedName", this.typifiedName).add("issues", this.issues).add("modified", this.modified).add("lastInterpreted", this.lastInterpreted).add("references", this.references).add("license", (Object)this.license).toString();
    }

    @JsonAnyGetter
    private Map<String, String> jsonVerbatimFields() {
        HashMap<String, String> extendedProps = Maps.newHashMap();
        for (Map.Entry<Term, String> prop : this.getVerbatimFields().entrySet()) {
            Term t = prop.getKey();
            if (t instanceof UnknownTerm || PROPERTIES.contains(t.simpleName())) {
                extendedProps.put(t.qualifiedName(), prop.getValue());
                continue;
            }
            extendedProps.put(t.simpleName(), prop.getValue());
        }
        return extendedProps;
    }
}

