/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.occurrence;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gbif.api.model.occurrence.DownloadFormat;
import org.gbif.api.model.occurrence.predicate.Predicate;

public class DownloadRequest {
    private static final String DELIMITER = ",";
    private static final Joiner COMMA_JOINER = Joiner.on(",").skipNulls();
    private static final Splitter COMMA_SPLITTER = Splitter.on(",").omitEmptyStrings().trimResults();
    private String creator;
    private Predicate predicate;
    private Set<String> notificationAddresses;
    private boolean sendNotification;
    private DownloadFormat format;
    private static final DownloadFormat DEFAULT_DOWNLOAD_FORMAT = DownloadFormat.DWCA;

    public DownloadRequest() {
    }

    @JsonCreator
    public DownloadRequest(@JsonProperty(value="predicate") Predicate predicate, @JsonProperty(value="creator") String creator, @JsonProperty(value="notification_address") @Nullable Collection<String> notificationAddresses, @JsonProperty(value="send_notification") @Nullable boolean sendNotification, @JsonProperty(value="format") DownloadFormat format) {
        this.creator = Preconditions.checkNotNull(creator, "Creator cannot be null");
        this.predicate = predicate;
        this.notificationAddresses = notificationAddresses == null ? ImmutableSet.of() : ImmutableSet.copyOf(notificationAddresses);
        this.sendNotification = sendNotification;
        this.format = format == null ? DEFAULT_DOWNLOAD_FORMAT : format;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DownloadRequest)) {
            return false;
        }
        DownloadRequest that = (DownloadRequest)obj;
        return Objects.equal(this.creator, that.creator) && Objects.equal(this.predicate, that.predicate) && Objects.equal(this.notificationAddresses, that.notificationAddresses) && Objects.equal(this.sendNotification, that.sendNotification) && Objects.equal((Object)this.format, (Object)that.format);
    }

    @NotNull
    public String getCreator() {
        return this.creator;
    }

    @Nullable
    public Set<String> getNotificationAddresses() {
        return this.notificationAddresses;
    }

    @Nullable
    @JsonIgnore
    public String getNotificationAddressesAsString() {
        if (this.notificationAddresses != null) {
            return COMMA_JOINER.join(this.notificationAddresses);
        }
        return null;
    }

    @Nullable
    @Valid
    public Predicate getPredicate() {
        return this.predicate;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.creator, this.predicate, this.notificationAddresses, this.sendNotification, this.format});
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setNotificationAddresses(Set<String> notificationAddresses) {
        this.notificationAddresses = notificationAddresses;
    }

    public void setNotificationAddressesAsString(String notificationAddressesAsString) {
        if (notificationAddressesAsString != null) {
            this.notificationAddresses = Sets.newHashSet(COMMA_SPLITTER.split(notificationAddressesAsString));
        }
    }

    public void setPredicate(Predicate predicate) {
        this.predicate = predicate;
    }

    public boolean getSendNotification() {
        return this.sendNotification;
    }

    public void setSendNotification(boolean sendNotification) {
        this.sendNotification = sendNotification;
    }

    public DownloadFormat getFormat() {
        return this.format;
    }

    public void setFormat(DownloadFormat format) {
        this.format = format;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("creator", this.creator).add("predicate", this.predicate).add("notificationAddresses", this.notificationAddresses).add("emailNotification", this.sendNotification).add("format", (Object)this.format).toString();
    }
}

