/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.occurrence;

import com.google.common.base.Objects;
import java.util.Date;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.gbif.api.model.common.DOI;
import org.gbif.api.model.occurrence.DownloadRequest;
import org.gbif.api.model.registry.PostPersist;
import org.gbif.api.model.registry.PrePersist;
import org.gbif.api.vocabulary.License;

public class Download {
    private String key;
    private DOI doi;
    private License license;
    private DownloadRequest request;
    private Date created;
    private Date modified;
    private Status status;
    private String downloadLink;
    private long size;
    private long totalRecords;
    private long numberDatasets;

    @Null(groups={PrePersist.class})
    @NotNull(groups={PostPersist.class})
    @Nullable
    public Date getCreated() {
        return this.created;
    }

    @Nullable
    public String getDownloadLink() {
        return this.downloadLink;
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    @Null(groups={PrePersist.class})
    @NotNull(groups={PostPersist.class})
    @Nullable
    public Date getModified() {
        return this.modified;
    }

    @NotNull
    public DownloadRequest getRequest() {
        return this.request;
    }

    @NotNull
    public Status getStatus() {
        return this.status;
    }

    @JsonIgnore
    public boolean isAvailable() {
        return this.status == Status.SUCCEEDED;
    }

    @Nullable
    public long getSize() {
        return this.size;
    }

    @Nullable
    public long getTotalRecords() {
        return this.totalRecords;
    }

    @Nullable
    public long getNumberDatasets() {
        return this.numberDatasets;
    }

    @Nullable
    public DOI getDoi() {
        return this.doi;
    }

    public License getLicense() {
        return this.license;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public void setDownloadLink(String downloadLink) {
        this.downloadLink = downloadLink;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setDoi(DOI doi) {
        this.doi = doi;
    }

    public void setLicense(License license) {
        this.license = license;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public void setRequest(DownloadRequest request) {
        this.request = request;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setTotalRecords(long totalRecords) {
        this.totalRecords = totalRecords;
    }

    public void setNumberDatasets(long numberDatasets) {
        this.numberDatasets = numberDatasets;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("key", this.key).add("doi", this.doi).add("status", (Object)this.status).add("downloadLink", this.downloadLink).add("request", this.request).add("created", this.created).add("license", (Object)this.license).add("modified", this.modified).add("size", this.size).add("totalRecords", this.totalRecords).add("numberDatasets", this.numberDatasets).toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Download)) {
            return false;
        }
        Download that = (Download)obj;
        return Objects.equal(this.request, that.request) && Objects.equal(this.key, that.key) && Objects.equal(this.doi, that.doi) && Objects.equal((Object)this.license, (Object)that.license) && Objects.equal(this.created, that.created) && Objects.equal(this.modified, that.modified) && Objects.equal((Object)this.status, (Object)that.status) && Objects.equal(this.downloadLink, that.downloadLink) && Objects.equal(this.size, that.size) && Objects.equal(this.totalRecords, that.totalRecords) && Objects.equal(this.numberDatasets, that.numberDatasets);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.key, this.doi, this.license, this.request, this.created, this.modified, this.status, this.downloadLink, this.size, this.totalRecords, this.numberDatasets});
    }

    public static enum Status {
        PREPARING,
        RUNNING,
        SUCCEEDED,
        CANCELLED,
        KILLED,
        FAILED,
        SUSPENDED;

        public static final EnumSet<Status> EXECUTING_STATUSES;
        public static final EnumSet<Status> FINISH_STATUSES;

        static {
            EXECUTING_STATUSES = EnumSet.of(PREPARING, RUNNING, SUSPENDED);
            FINISH_STATUSES = EnumSet.of(SUCCEEDED, CANCELLED, KILLED, FAILED);
        }
    }
}

