/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.metrics.cube;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import javax.annotation.concurrent.NotThreadSafe;
import org.gbif.api.model.metrics.cube.Dimension;
import org.gbif.api.vocabulary.Country;
import org.gbif.api.vocabulary.Language;

@NotThreadSafe
public class ReadBuilder {
    private final Map<Dimension<?>, String> address = Maps.newHashMap();

    public ReadBuilder at(Dimension<Country> dim, Country value) {
        Preconditions.checkNotNull(value, "Dimension cannot be null");
        this.address.put(dim, value.getIso2LetterCode());
        return this;
    }

    public ReadBuilder at(Dimension<Language> dim, Language value) {
        Preconditions.checkNotNull(value, "Dimension cannot be null");
        this.address.put(dim, value.getIso2LetterCode());
        return this;
    }

    public ReadBuilder at(Dimension<? extends Enum<?>> dim, Enum<?> value) {
        Preconditions.checkNotNull(value, "Dimension cannot be null");
        this.address.put(dim, value.name());
        return this;
    }

    public ReadBuilder at(Dimension<Boolean> dim, boolean value) {
        this.address.put(dim, String.valueOf(value));
        return this;
    }

    public ReadBuilder at(Dimension<Double> dim, double value) {
        this.address.put(dim, String.valueOf(value));
        return this;
    }

    public ReadBuilder at(Dimension<Float> dim, float value) {
        this.address.put(dim, String.valueOf(value));
        return this;
    }

    public ReadBuilder at(Dimension<Integer> dim, int value) {
        this.address.put(dim, String.valueOf(value));
        return this;
    }

    public ReadBuilder at(Dimension<String> dim, String value) {
        Preconditions.checkNotNull(value, "Dimension cannot be null");
        this.address.put(dim, value);
        return this;
    }

    public ReadBuilder at(Dimension<UUID> dim, UUID value) {
        Preconditions.checkNotNull(value, "Dimension cannot be null");
        this.address.put(dim, value.toString());
        return this;
    }

    public Map<Dimension<?>, String> build() {
        return this.address;
    }
}

