/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.metrics;

import com.google.common.base.Objects;
import java.io.Serializable;
import org.gbif.api.vocabulary.ProcessingErrorType;

public class RecordError
implements Serializable {
    private static final long serialVersionUID = 4942485228689322658L;
    private ProcessingErrorType processingErrorType;
    private long recordId;
    private String catalogNumber;
    private String collectionCode;
    private String institutionCode;

    public static Builder builder() {
        return new Builder();
    }

    public RecordError() {
    }

    public RecordError(Builder builder) {
        this.processingErrorType = builder.processingErrorType;
        this.recordId = builder.recordId;
        this.catalogNumber = builder.catalogNumber;
        this.collectionCode = builder.collectionCode;
        this.institutionCode = builder.institutionCode;
    }

    public String getCatalogNumber() {
        return this.catalogNumber;
    }

    public void setCatalogNumber(String catalogNumber) {
        this.catalogNumber = catalogNumber;
    }

    public String getCollectionCode() {
        return this.collectionCode;
    }

    public void setCollectionCode(String collectionCode) {
        this.collectionCode = collectionCode;
    }

    public ProcessingErrorType getProcessingErrorType() {
        return this.processingErrorType;
    }

    public void setProcessingErrorType(ProcessingErrorType processingErrorType) {
        this.processingErrorType = processingErrorType;
    }

    public String getInstitutionCode() {
        return this.institutionCode;
    }

    public void setInstitutionCode(String institutionCode) {
        this.institutionCode = institutionCode;
    }

    public long getRecordId() {
        return this.recordId;
    }

    public void setRecordId(long recordId) {
        this.recordId = recordId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RecordError)) {
            return false;
        }
        RecordError that = (RecordError)obj;
        return Objects.equal((Object)this.processingErrorType, (Object)that.processingErrorType) && Objects.equal(this.recordId, that.recordId) && Objects.equal(this.catalogNumber, that.catalogNumber) && Objects.equal(this.collectionCode, that.collectionCode) && Objects.equal(this.institutionCode, that.institutionCode);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.processingErrorType, this.recordId, this.catalogNumber, this.collectionCode, this.institutionCode});
    }

    public String toString() {
        return Objects.toStringHelper(this).add("processingErrorType", (Object)this.processingErrorType).add("recordId", this.recordId).add("catalogNumber", this.catalogNumber).add("collectionCode", this.collectionCode).add("institutionCode", this.institutionCode).toString();
    }

    public static class Builder {
        private ProcessingErrorType processingErrorType;
        private long recordId;
        private String catalogNumber;
        private String collectionCode;
        private String institutionCode;

        public RecordError build() {
            return new RecordError(this);
        }

        public Builder catalogNumber(String catalogNumber) {
            this.catalogNumber = catalogNumber;
            return this;
        }

        public Builder collectionCode(String collectionCode) {
            this.collectionCode = collectionCode;
            return this;
        }

        public Builder errorType(ProcessingErrorType processingErrorType) {
            this.processingErrorType = processingErrorType;
            return this;
        }

        public Builder institutionCode(String institutionCode) {
            this.institutionCode = institutionCode;
            return this;
        }

        public Builder recordId(long recordId) {
            this.recordId = recordId;
            return this;
        }
    }
}

