/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.crawler;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class OccurrenceValidationReport {
    private static final double INVALID_TRIPLET_THRESHOLD = 0.25;
    private final int checkedRecords;
    private final int uniqueTriplets;
    private final int recordsWithInvalidTriplets;
    private final int uniqueOccurrenceIds;
    private final int recordsMissingOccurrenceId;
    private final boolean allRecordsChecked;
    private String invalidationReason;
    private final boolean valid;

    @JsonCreator
    public OccurrenceValidationReport(@JsonProperty(value="checkedRecords") int checkedRecords, @JsonProperty(value="uniqueTriplets") int uniqueTriplets, @JsonProperty(value="invalidTriplets") int recordsWithInvalidTriplets, @JsonProperty(value="uniqueOccIds") int uniqueOccurrenceIds, @JsonProperty(value="missingOccIds") int recordsMissingOccurrenceId, @JsonProperty(value="allRecordsChecked") boolean allRecordsChecked) {
        this.checkedRecords = checkedRecords;
        this.uniqueTriplets = uniqueTriplets;
        this.recordsWithInvalidTriplets = recordsWithInvalidTriplets;
        this.uniqueOccurrenceIds = uniqueOccurrenceIds;
        this.recordsMissingOccurrenceId = recordsMissingOccurrenceId;
        this.allRecordsChecked = allRecordsChecked;
        this.valid = this.validate();
    }

    private boolean validate() {
        boolean looksValid;
        boolean hasRecords = this.checkedRecords > 0;
        double invalidRatio = hasRecords ? (double)this.recordsWithInvalidTriplets / (double)this.checkedRecords : 0.0;
        boolean invalidTripletsBelowLimit = invalidRatio <= 0.25;
        boolean hasUniqueTriplets = this.uniqueTriplets == this.checkedRecords - this.recordsWithInvalidTriplets;
        boolean hasUniqueOccIds = this.uniqueOccurrenceIds == this.checkedRecords - this.recordsMissingOccurrenceId;
        boolean hasGoodOccIds = this.uniqueOccurrenceIds == this.checkedRecords;
        boolean bl = looksValid = invalidTripletsBelowLimit && hasUniqueTriplets || hasGoodOccIds;
        if (!looksValid) {
            ArrayList<String> reasons = Lists.newArrayList();
            if (!invalidTripletsBelowLimit) {
                reasons.add(Math.round(100.0 * invalidRatio) + "% invalid triplets is > than threshold of " + Math.round(25.0) + '%');
            }
            if (!hasUniqueTriplets) {
                reasons.add(this.checkedRecords - this.recordsWithInvalidTriplets - this.uniqueTriplets + " duplicate triplets detected");
            }
            if (!hasGoodOccIds) {
                if (this.recordsMissingOccurrenceId != 0) {
                    reasons.add(this.recordsMissingOccurrenceId + " records without an occurrence id (should be 0)");
                }
                if (!hasUniqueOccIds) {
                    reasons.add(this.checkedRecords - this.recordsMissingOccurrenceId - this.uniqueOccurrenceIds + " duplicate occurrence ids detected");
                }
            }
            String reason = Joiner.on("; ").join(reasons);
            this.invalidationReason = "Archive invalid because [" + reason + ']';
        }
        return looksValid;
    }

    public int getCheckedRecords() {
        return this.checkedRecords;
    }

    public int getUniqueTriplets() {
        return this.uniqueTriplets;
    }

    public int getRecordsWithInvalidTriplets() {
        return this.recordsWithInvalidTriplets;
    }

    public int getUniqueOccurrenceIds() {
        return this.uniqueOccurrenceIds;
    }

    public int getRecordsMissingOccurrenceId() {
        return this.recordsMissingOccurrenceId;
    }

    public boolean isAllRecordsChecked() {
        return this.allRecordsChecked;
    }

    public String getInvalidationReason() {
        return this.invalidationReason;
    }

    public boolean isValid() {
        return this.valid;
    }

    public int hashCode() {
        return Objects.hashCode(this.checkedRecords, this.uniqueTriplets, this.recordsWithInvalidTriplets, this.uniqueOccurrenceIds, this.recordsMissingOccurrenceId, this.allRecordsChecked, this.valid);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OccurrenceValidationReport other = (OccurrenceValidationReport)obj;
        return Objects.equal(this.checkedRecords, other.checkedRecords) && Objects.equal(this.uniqueTriplets, other.uniqueTriplets) && Objects.equal(this.recordsWithInvalidTriplets, other.recordsWithInvalidTriplets) && Objects.equal(this.uniqueOccurrenceIds, other.uniqueOccurrenceIds) && Objects.equal(this.recordsMissingOccurrenceId, other.recordsMissingOccurrenceId) && Objects.equal(this.allRecordsChecked, other.allRecordsChecked) && Objects.equal(this.valid, other.valid);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("checkedRecords", this.checkedRecords).add("uniqueTriplets", this.uniqueTriplets).add("recordsWithInvalidTriplets", this.recordsWithInvalidTriplets).add("uniqueOccurrenceIds", this.uniqueOccurrenceIds).add("recordsMissingOccurrenceId", this.recordsMissingOccurrenceId).add("allRecordsChecked", this.allRecordsChecked).add("invalidationReason", this.invalidationReason).add("valid", this.valid).toString();
    }
}

