/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.crawler;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.List;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class GenericValidationReport {
    private final int checkedRecords;
    private final boolean allRecordsChecked;
    private final List<String> duplicateIds;
    private final List<Integer> rowNumbersMissingId;
    private String invalidationReason;
    private final boolean valid;

    @JsonCreator
    public GenericValidationReport(@JsonProperty(value="checkedRecords") int checkedRecords, @JsonProperty(value="allRecordsChecked") boolean allRecordsChecked, @JsonProperty(value="duplicateIds") List<String> duplicateIds, @JsonProperty(value="rowNumbersMissingId") List<Integer> rowNumbersMissingId) {
        this.checkedRecords = checkedRecords;
        this.allRecordsChecked = allRecordsChecked;
        this.duplicateIds = Preconditions.checkNotNull(duplicateIds, "duplicateIds cannot be null");
        this.rowNumbersMissingId = Preconditions.checkNotNull(rowNumbersMissingId, "rowNumbersMissingId cannot be null");
        this.valid = this.validate();
    }

    private boolean validate() {
        if (!this.duplicateIds.isEmpty()) {
            this.invalidationReason = "Non unique core ids";
            return false;
        }
        if (!this.rowNumbersMissingId.isEmpty()) {
            this.invalidationReason = "Missing core ids";
            return false;
        }
        return true;
    }

    public int getCheckedRecords() {
        return this.checkedRecords;
    }

    public boolean isAllRecordsChecked() {
        return this.allRecordsChecked;
    }

    public List<String> getDuplicateIds() {
        return this.duplicateIds;
    }

    public List<Integer> getRowNumbersMissingId() {
        return this.rowNumbersMissingId;
    }

    public String getInvalidationReason() {
        return this.invalidationReason;
    }

    public boolean isValid() {
        return this.valid;
    }

    public int hashCode() {
        return Objects.hashCode(this.checkedRecords, this.allRecordsChecked, this.duplicateIds, this.rowNumbersMissingId, this.invalidationReason, this.valid);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GenericValidationReport other = (GenericValidationReport)obj;
        return Objects.equal(this.checkedRecords, other.checkedRecords) && Objects.equal(this.allRecordsChecked, other.allRecordsChecked) && Objects.equal(this.duplicateIds, other.duplicateIds) && Objects.equal(this.rowNumbersMissingId, other.rowNumbersMissingId) && Objects.equal(this.invalidationReason, other.invalidationReason) && Objects.equal(this.valid, other.valid);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("checkedRecords", this.checkedRecords).add("duplicateIds", this.duplicateIds).add("rowNumbersMissingId", this.rowNumbersMissingId).add("allRecordsChecked", this.allRecordsChecked).add("invalidationReason", this.invalidationReason).add("valid", this.valid).toString();
    }
}

