/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.crawler;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gbif.api.model.crawler.GenericValidationReport;
import org.gbif.api.model.crawler.OccurrenceValidationReport;

@Immutable
@ThreadSafe
public class DwcaValidationReport {
    private final UUID datasetKey;
    @Nullable
    private final OccurrenceValidationReport occurrenceReport;
    @Nullable
    private final GenericValidationReport genericReport;
    private final String invalidationReason;

    public boolean isValid() {
        return !(this.invalidationReason != null || this.occurrenceReport != null && !this.occurrenceReport.isValid() || this.genericReport != null && !this.genericReport.isValid());
    }

    @JsonCreator
    public DwcaValidationReport(@JsonProperty(value="datasetKey") UUID datasetKey, @JsonProperty(value="occurrenceReport") OccurrenceValidationReport occurrenceReport, @JsonProperty(value="genericReport") GenericValidationReport genericReport, @JsonProperty(value="invalidationReason") String invalidationReason) {
        this.datasetKey = Preconditions.checkNotNull(datasetKey, "datasetKey can't be null");
        Preconditions.checkArgument(invalidationReason != null || occurrenceReport != null || genericReport != null, "Either a report or invalidationReason cannot be null");
        this.occurrenceReport = occurrenceReport;
        this.genericReport = genericReport;
        this.invalidationReason = invalidationReason;
    }

    public DwcaValidationReport(UUID datasetKey, OccurrenceValidationReport occurrenceReport) {
        this.datasetKey = Preconditions.checkNotNull(datasetKey, "datasetKey can't be null");
        this.occurrenceReport = Preconditions.checkNotNull(occurrenceReport, "occurrenceReport can't be null");
        this.genericReport = null;
        this.invalidationReason = null;
    }

    public DwcaValidationReport(UUID datasetKey, GenericValidationReport genericReport) {
        this.datasetKey = Preconditions.checkNotNull(datasetKey, "datasetKey can't be null");
        this.occurrenceReport = null;
        this.genericReport = Preconditions.checkNotNull(genericReport, "genericReport can't be null");
        this.invalidationReason = null;
    }

    public DwcaValidationReport(UUID datasetKey, String invalidationReason) {
        this.datasetKey = Preconditions.checkNotNull(datasetKey, "datasetKey can't be null");
        this.occurrenceReport = null;
        this.genericReport = null;
        this.invalidationReason = Preconditions.checkNotNull(invalidationReason, "invalidationReason can't be null");
    }

    public UUID getDatasetKey() {
        return this.datasetKey;
    }

    public String getInvalidationReason() {
        StringBuilder sb = new StringBuilder();
        if (this.invalidationReason != null) {
            sb.append(this.invalidationReason);
        }
        if (this.occurrenceReport != null && !this.occurrenceReport.isValid()) {
            if (sb.length() > 1) {
                sb.append("\n");
            }
            sb.append("Invalid Occurrences: ");
            sb.append(this.occurrenceReport.getInvalidationReason());
        }
        if (this.genericReport != null && !this.genericReport.isValid()) {
            if (sb.length() > 1) {
                sb.append("\n");
            }
            sb.append("Invalid Checklist: ");
            sb.append(this.genericReport.getInvalidationReason());
        }
        return Strings.emptyToNull(sb.toString());
    }

    public OccurrenceValidationReport getOccurrenceReport() {
        return this.occurrenceReport;
    }

    public GenericValidationReport getGenericReport() {
        return this.genericReport;
    }

    public int hashCode() {
        return Objects.hashCode(this.datasetKey, this.occurrenceReport, this.genericReport, this.invalidationReason);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DwcaValidationReport other = (DwcaValidationReport)obj;
        return Objects.equal(this.datasetKey, other.datasetKey) && Objects.equal(this.occurrenceReport, other.occurrenceReport) && Objects.equal(this.genericReport, other.genericReport) && Objects.equal(this.invalidationReason, other.invalidationReason);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("datasetKey", this.datasetKey).add("invalidationReason", this.invalidationReason).add("occurrenceReport", this.occurrenceReport).add("genericReport", this.genericReport).toString();
    }
}

