/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.common.search;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.List;
import org.gbif.api.model.common.paging.Pageable;
import org.gbif.api.model.common.paging.PagingResponse;
import org.gbif.api.model.common.search.Facet;
import org.gbif.api.model.common.search.SearchParameter;
import org.gbif.api.model.common.search.SpellCheckResponse;

public class SearchResponse<T, P extends SearchParameter>
extends PagingResponse<T> {
    private final List<Facet<P>> facets = Lists.newArrayList();
    private SpellCheckResponse spellCheckResponse;

    public SearchResponse() {
    }

    public SearchResponse(Pageable page) {
        super(page);
    }

    public SearchResponse(PagingResponse<T> response) {
        super(response, response.getCount(), response.getResults());
    }

    public SearchResponse(long offset, int limit) {
        super(offset, limit);
    }

    public SearchResponse(long offset, int pageSize, Long count, List<T> results, List<Facet<P>> facets) {
        super(offset, pageSize, count, results);
        this.setFacets(facets);
    }

    public List<Facet<P>> getFacets() {
        return this.facets;
    }

    public final void setFacets(List<Facet<P>> facets) {
        this.facets.clear();
        if (facets != null) {
            this.facets.addAll(facets);
        }
    }

    public SpellCheckResponse getSpellCheckResponse() {
        return this.spellCheckResponse;
    }

    public void setSpellCheckResponse(SpellCheckResponse spellCheckResponse) {
        this.spellCheckResponse = spellCheckResponse;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SearchResponse)) {
            return false;
        }
        SearchResponse that = (SearchResponse)o;
        return Objects.equal(this.getCount(), that.getCount()) && Objects.equal(this.getResults(), that.getResults()) && Objects.equal(this.facets, that.getFacets()) && Objects.equal(this.getOffset(), that.getOffset()) && Objects.equal(this.getLimit(), that.getLimit()) && Objects.equal(this.spellCheckResponse, that.getSpellCheckResponse());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), this.facets, this.spellCheckResponse);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("count", this.getCount()).add("results", this.getResults()).add("facets", this.facets).add("offset", this.getOffset()).add("limit", this.getLimit()).add("spellCheckResponse", this.spellCheckResponse).toString();
    }
}

