/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.common.search;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.gbif.api.model.common.paging.Pageable;
import org.gbif.api.model.common.paging.PageableBase;
import org.gbif.api.model.common.search.SearchParameter;

public class SearchRequest<P extends SearchParameter>
extends PageableBase {
    private Multimap<P, String> parameters = HashMultimap.create();
    private String q;
    private boolean highlight;
    private boolean spellCheck;
    private int spellCheckCount;

    public SearchRequest() {
        super(0L, 20);
    }

    public SearchRequest(String query) {
        super(0L, 20);
        this.q = query;
    }

    public SearchRequest(Pageable page) {
        super(page.getOffset(), page.getLimit());
    }

    public SearchRequest(long offset, int limit) {
        super(offset, limit);
    }

    public boolean isHighlight() {
        return this.highlight;
    }

    public void setHighlight(boolean highlight) {
        this.highlight = highlight;
    }

    public boolean isSpellCheck() {
        return this.spellCheck;
    }

    public void setSpellCheck(boolean spellCheck) {
        this.spellCheck = spellCheck;
    }

    public int getSpellCheckCount() {
        return this.spellCheckCount;
    }

    public void setSpellCheckCount(int spellCheckCount) {
        this.spellCheckCount = spellCheckCount;
    }

    public Multimap<P, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Multimap<P, String> parameters) {
        this.parameters = parameters;
    }

    public String getQ() {
        return this.q;
    }

    public void setQ(String q) {
        this.q = q;
    }

    public void addParameter(P parameter, Iterable<String> values) {
        for (String parameterValue : values) {
            this.parameters.put(parameter, parameterValue);
        }
    }

    public void addParameter(P parameter, String ... values) {
        for (String value : values) {
            this.addParameter(parameter, value);
        }
    }

    public void addParameter(P parameter, String value) {
        if (value != null) {
            this.parameters.put(parameter, value);
        }
    }

    public void addParameter(P parameter, long value) {
        this.parameters.put(parameter, String.valueOf(value));
    }

    public void addParameter(P parameter, int value) {
        this.parameters.put(parameter, String.valueOf(value));
    }

    public void addParameter(P parameter, double value) {
        this.parameters.put(parameter, String.valueOf(value));
    }

    public void addParameter(P parameter, boolean value) {
        this.parameters.put(parameter, String.valueOf(value));
    }

    public void addParameter(P parameter, Enum<?> value) {
        if (value != null) {
            this.parameters.put(parameter, value.name());
        }
    }

    public void addParameter(P parameter, Date value) {
        if (value != null) {
            SimpleDateFormat iso = new SimpleDateFormat("yyyy-MM-dd");
            this.parameters.put(parameter, iso.format(value));
        }
    }
}

