/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.common.messaging;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;

public class Request<T> {
    private OperationType operationType;
    private Map<String, String> context;
    private T content;

    public T getContent() {
        return this.content;
    }

    public Map<String, String> getContext() {
        return this.context;
    }

    public void setContext(Map<String, String> context) {
        this.context = context;
    }

    protected OperationType getOperationType() {
        return this.operationType;
    }

    protected void setOperationType(OperationType operationType) {
        this.operationType = operationType;
    }

    public void setParameter(T content) {
        this.content = content;
    }

    public static class Builder<T> {
        private OperationType operationType;
        private Map<String, String> context;
        private T content;

        public Request<T> build() {
            Request request = new Request();
            request.operationType = this.operationType;
            request.content = this.content;
            request.context = new ImmutableMap.Builder<String, String>().putAll(this.context).build();
            return request;
        }

        public Builder<T> content(T content) {
            this.content = content;
            this.context = new HashMap<String, String>();
            return this;
        }

        public Builder<T> context(Map<String, String> context) {
            this.context = context;
            return this;
        }

        public Builder<T> contextParam(Map.Entry<String, String> entry) {
            this.context.entrySet().add(entry);
            return this;
        }

        public Builder<T> contextParam(String key, String value) {
            this.context.put(key, value);
            return this;
        }

        public Builder<T> operationType(OperationType operationType) {
            this.operationType = operationType;
            return this;
        }
    }

    public static enum OperationType {
        CREATE,
        RETRIEVE,
        UPDATE,
        DELETE,
        SELECT;

    }
}

