/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.common;

import com.google.common.base.Objects;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.gbif.api.util.IdentifierUtils;
import org.gbif.api.vocabulary.IdentifierType;

public class Identifier {
    private String identifier;
    private String title;
    private IdentifierType type;

    @NotNull
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Nullable
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @NotNull
    public IdentifierType getType() {
        return this.type;
    }

    public void setType(IdentifierType type) {
        this.type = type;
    }

    @Nullable
    public String getIdentifierLink() {
        return IdentifierUtils.getIdentifierLink(this.identifier, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Identifier)) {
            return false;
        }
        Identifier that = (Identifier)obj;
        return Objects.equal(this.identifier, that.identifier) && Objects.equal((Object)this.type, (Object)that.type) && Objects.equal(this.title, that.title);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.identifier, this.type, this.title});
    }

    public String toString() {
        return Objects.toStringHelper(this).add("identifier", this.identifier).add("type", (Object)this.type).add("title", this.title).toString();
    }
}

