/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.checklistbank;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.gbif.api.jackson.RankSerde;
import org.gbif.api.util.UnicodeUtils;
import org.gbif.api.vocabulary.NamePart;
import org.gbif.api.vocabulary.NameType;
import org.gbif.api.vocabulary.Rank;

public class ParsedName {
    public static final Character HYBRID_MARKER = Character.valueOf('\u00d7');
    private static final String HYBRID_MARKER_STR = HYBRID_MARKER.toString();
    private Integer key;
    private String scientificName;
    @JsonProperty(value="rankMarker")
    @JsonSerialize(using=RankSerde.RankJsonSerializer.class)
    @JsonDeserialize(using=RankSerde.RankJsonDeserializer.class)
    private Rank rank;
    private NameType type;
    private String genusOrAbove;
    private String infraGeneric;
    private String specificEpithet;
    private String infraSpecificEpithet;
    private String cultivarEpithet;
    private String strain;
    private NamePart notho;
    private String authorship;
    private String year;
    private String bracketAuthorship;
    private String bracketYear;
    private String sensu;
    private boolean parsed = true;
    private boolean authorsParsed = true;
    private String nomStatus;
    private String remarks;

    public ParsedName() {
    }

    public ParsedName(NameType type, String genusOrAbove, String infraGeneric, String specificEpithet, String infraSpecificEpithet, NamePart notho, Rank rank, String authorship, String year, String bracketAuthorship, String bracketYear, String cultivarEpithet, String strain, String sensu, String nomStatus, String remarks) {
        this.type = type;
        this.genusOrAbove = genusOrAbove;
        this.infraGeneric = infraGeneric;
        this.specificEpithet = specificEpithet;
        this.infraSpecificEpithet = infraSpecificEpithet;
        this.notho = notho;
        this.rank = rank;
        this.authorship = authorship;
        this.year = year;
        this.bracketAuthorship = bracketAuthorship;
        this.bracketYear = bracketYear;
        this.cultivarEpithet = cultivarEpithet;
        this.strain = strain;
        this.sensu = sensu;
        this.nomStatus = nomStatus;
        this.remarks = remarks;
    }

    public String getAuthorship() {
        return this.authorship;
    }

    public void setAuthorship(String authorship) {
        this.authorship = authorship;
    }

    public String getBracketAuthorship() {
        return this.bracketAuthorship;
    }

    public void setBracketAuthorship(String bracketAuthorship) {
        this.bracketAuthorship = bracketAuthorship;
    }

    public String getBracketYear() {
        return this.bracketYear;
    }

    public void setBracketYear(String bracketYear) {
        this.bracketYear = bracketYear;
    }

    public String getCultivarEpithet() {
        return this.cultivarEpithet;
    }

    public void setCultivarEpithet(String cultivarEpithet) {
        this.cultivarEpithet = cultivarEpithet;
    }

    public String getStrain() {
        return this.strain;
    }

    public void setStrain(String strain) {
        this.strain = strain;
    }

    public String getGenusOrAbove() {
        return this.genusOrAbove;
    }

    public String getInfraGeneric() {
        return this.infraGeneric;
    }

    public String getInfraSpecificEpithet() {
        return this.infraSpecificEpithet;
    }

    public String getNomStatus() {
        return this.nomStatus;
    }

    public void setNomStatus(String nomStatus) {
        this.nomStatus = nomStatus;
    }

    public NamePart getNotho() {
        return this.notho;
    }

    public void setNotho(NamePart notho) {
        this.notho = notho;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getSensu() {
        return this.sensu;
    }

    public void setSensu(String sensu) {
        this.sensu = sensu;
    }

    public String getSpecificEpithet() {
        return this.specificEpithet;
    }

    @JsonIgnore
    public String getTerminalEpithet() {
        return this.infraSpecificEpithet == null ? this.specificEpithet : this.infraSpecificEpithet;
    }

    public NameType getType() {
        return this.type;
    }

    public void setType(NameType type) {
        this.type = type;
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    @JsonIgnore
    public boolean hasAuthorship() {
        return this.authorship != null || this.year != null || this.bracketAuthorship != null || this.bracketYear != null;
    }

    public void setRank(Rank rank) {
        this.rank = rank;
    }

    public Integer getKey() {
        return this.key;
    }

    public void setKey(Integer key) {
        this.key = key;
    }

    public String getScientificName() {
        return this.scientificName;
    }

    public void setScientificName(String scientificName) {
        this.scientificName = scientificName;
    }

    public boolean isAuthorsParsed() {
        return this.authorsParsed;
    }

    public void setAuthorsParsed(boolean authorsParsed) {
        this.authorsParsed = authorsParsed;
    }

    public boolean isParsed() {
        return this.parsed;
    }

    public void setParsed(boolean parsed) {
        this.parsed = parsed;
    }

    public String authorshipComplete() {
        StringBuilder sb = new StringBuilder();
        this.appendAuthorship(sb);
        return sb.toString().trim();
    }

    public String buildName(boolean hybridMarker, boolean rankMarker, boolean authorship, boolean infrageneric, boolean genusForInfrageneric, boolean abbreviateGenus, boolean decomposition, boolean asciiOnly, boolean showIndet, boolean nomNote, boolean remarks, boolean showSensu, boolean showCultivar, boolean showStrain) {
        StringBuilder sb = new StringBuilder();
        if (NameType.CANDIDATUS == this.type) {
            sb.append("Candidatus ");
        }
        if (this.genusOrAbove != null && (genusForInfrageneric || this.infraGeneric == null || this.specificEpithet != null)) {
            if (hybridMarker && NamePart.GENERIC == this.notho) {
                sb.append(HYBRID_MARKER);
            }
            if (abbreviateGenus) {
                sb.append(this.genusOrAbove.substring(0, 1)).append('.');
            } else {
                sb.append(this.genusOrAbove);
            }
        }
        if (this.specificEpithet == null) {
            if (Rank.SPECIES == this.rank) {
                if (showIndet) {
                    sb.append(" spec.");
                }
            } else if (this.rank != null && this.rank.isInfraspecific()) {
                if (showIndet) {
                    sb.append(' ');
                    sb.append(this.rank.getMarker());
                }
            } else if (this.infraGeneric != null) {
                if (rankMarker && this.rank != null) {
                    sb.append(' ');
                    this.appendRankMarker(sb, this.rank);
                    sb.append(this.infraGeneric);
                } else if (genusForInfrageneric && this.genusOrAbove != null) {
                    sb.append(" (").append(this.infraGeneric).append(")");
                } else {
                    sb.append(this.infraGeneric);
                }
            }
            if (authorship) {
                this.appendAuthorship(sb);
            }
        } else {
            if (infrageneric && this.infraGeneric != null && (this.rank == null || this.rank == Rank.GENUS)) {
                sb.append(" (");
                sb.append(this.infraGeneric);
                sb.append(')');
            }
            sb.append(' ');
            if (hybridMarker && NamePart.SPECIFIC == this.notho) {
                sb.append(HYBRID_MARKER);
            }
            String epi = this.specificEpithet.replaceAll("[ _-]", "-");
            sb.append(epi);
            if (this.infraSpecificEpithet == null) {
                if (showIndet && this.rank != null && this.rank.isInfraspecific() && (Rank.CULTIVAR != this.rank || this.cultivarEpithet == null)) {
                    sb.append(' ');
                    sb.append(this.rank.getMarker());
                }
                if (authorship) {
                    this.appendAuthorship(sb);
                }
            } else {
                sb.append(' ');
                if (hybridMarker && NamePart.INFRASPECIFIC == this.notho) {
                    if (rankMarker) {
                        sb.append("notho");
                    } else {
                        sb.append(HYBRID_MARKER);
                    }
                }
                if (rankMarker) {
                    this.appendRankMarker(sb, this.rank);
                }
                epi = this.infraSpecificEpithet.replaceAll("[ _-]", "-");
                sb.append(epi);
                if (authorship && !this.isAutonym()) {
                    this.appendAuthorship(sb);
                }
            }
        }
        if (showStrain && this.strain != null) {
            sb.append(" ");
            sb.append(this.strain);
        }
        if (showCultivar && this.cultivarEpithet != null) {
            sb.append(" '");
            sb.append(this.cultivarEpithet);
            sb.append("'");
        }
        if (showSensu && this.sensu != null) {
            sb.append(" ");
            sb.append(this.sensu);
        }
        if (nomNote && this.nomStatus != null) {
            sb.append(", ");
            sb.append(this.nomStatus);
        }
        if (remarks && this.remarks != null) {
            sb.append(" [");
            sb.append(this.remarks);
            sb.append("]");
        }
        String name = sb.toString().trim();
        if (decomposition) {
            name = UnicodeUtils.decompose(name);
        }
        if (asciiOnly) {
            name = UnicodeUtils.ascii(name);
        }
        return Strings.emptyToNull(name);
    }

    private void appendRankMarker(StringBuilder sb, Rank rank) {
        if (rank != null && rank.getMarker() != null) {
            sb.append(rank.getMarker());
            sb.append(' ');
        }
    }

    private void appendAuthorship(StringBuilder sb) {
        if (this.bracketAuthorship == null) {
            if (this.bracketYear != null) {
                sb.append(" (");
                sb.append(this.bracketYear);
                sb.append(")");
            }
        } else {
            sb.append(" (");
            sb.append(this.bracketAuthorship);
            if (this.bracketYear != null) {
                sb.append(", ");
                sb.append(this.bracketYear);
            }
            sb.append(")");
        }
        if (this.authorship != null) {
            sb.append(" ").append(this.authorship);
        }
        if (this.year != null) {
            sb.append(", ");
            sb.append(this.year);
        }
    }

    @JsonProperty
    public String canonicalName() {
        return this.buildName(false, false, false, false, false, false, true, true, true, false, false, false, false, false);
    }

    @JsonProperty
    public String canonicalNameWithMarker() {
        return this.buildName(true, true, false, false, false, false, true, true, true, false, false, false, true, true);
    }

    @JsonProperty
    public String canonicalNameComplete() {
        return this.buildName(true, true, true, false, true, false, true, false, true, false, false, false, true, true);
    }

    public String canonicalSpeciesName() {
        if (this.genusOrAbove != null && this.specificEpithet != null) {
            return this.genusOrAbove + " " + this.specificEpithet;
        }
        return null;
    }

    public String fullName() {
        return this.buildName(true, true, true, true, true, false, false, false, true, true, true, true, true, true);
    }

    @JsonIgnore
    public Integer getBracketYearInt() {
        try {
            return Integer.parseInt(this.bracketYear);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Rank getRank() {
        return this.rank;
    }

    @JsonIgnore
    public Integer getYearInt() {
        try {
            return Integer.parseInt(this.year);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @JsonIgnore
    public boolean isAutonym() {
        return this.specificEpithet != null && this.infraSpecificEpithet != null && this.specificEpithet.equals(this.infraSpecificEpithet);
    }

    @JsonIgnore
    public boolean isBinomial() {
        return this.genusOrAbove != null && this.specificEpithet != null;
    }

    @JsonIgnore
    public boolean isHybridFormula() {
        return NameType.HYBRID == this.type;
    }

    @JsonIgnore
    public boolean isIndetermined() {
        return this.rank != null && (this.rank.isInfrageneric() && this.rank.isSupraspecific() && this.infraGeneric == null || this.rank.isSpeciesOrBelow() && this.specificEpithet == null || this.rank.isInfraspecific() && this.infraSpecificEpithet == null);
    }

    @JsonIgnore
    public boolean isParsableType() {
        return this.type != null && this.type.isParsable();
    }

    @JsonIgnore
    public boolean isQualified() {
        return this.authorship != null && !this.authorship.isEmpty() || this.year != null && !this.year.isEmpty() || this.bracketAuthorship != null && !this.bracketAuthorship.isEmpty() || this.bracketYear != null && !this.bracketYear.isEmpty();
    }

    @JsonIgnore
    public boolean isRecombination() {
        return !StringUtils.isBlank((CharSequence)this.bracketAuthorship) || !StringUtils.isBlank((CharSequence)this.bracketYear);
    }

    public void setGenusOrAbove(String genusOrAbove) {
        if (genusOrAbove != null && genusOrAbove.startsWith(HYBRID_MARKER.toString())) {
            this.genusOrAbove = genusOrAbove.substring(1);
            this.notho = NamePart.GENERIC;
        } else {
            this.genusOrAbove = genusOrAbove;
        }
    }

    public void setHybridFormula(boolean hybrid) {
        if (hybrid) {
            this.type = NameType.HYBRID;
        } else if (NameType.HYBRID == this.type) {
            this.type = null;
        }
    }

    public void setInfraGeneric(String infraGeneric) {
        if (infraGeneric != null && infraGeneric.startsWith(HYBRID_MARKER_STR)) {
            this.infraGeneric = infraGeneric.substring(1);
            this.notho = NamePart.INFRAGENERIC;
        } else {
            this.infraGeneric = infraGeneric;
        }
    }

    public void setInfraSpecificEpithet(String infraSpecies) {
        if (infraSpecies != null && infraSpecies.startsWith(HYBRID_MARKER_STR)) {
            this.infraSpecificEpithet = infraSpecies.substring(1);
            this.notho = NamePart.INFRASPECIFIC;
        } else {
            this.infraSpecificEpithet = infraSpecies;
        }
    }

    public void setSpecificEpithet(String species) {
        if (species != null && species.startsWith(HYBRID_MARKER_STR)) {
            this.specificEpithet = species.substring(1);
            this.notho = NamePart.SPECIFIC;
        } else {
            this.specificEpithet = species;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ParsedName)) {
            return false;
        }
        ParsedName o = (ParsedName)obj;
        return Objects.equal(this.key, o.key) && Objects.equal(this.scientificName, o.scientificName) && Objects.equal((Object)this.type, (Object)o.type) && Objects.equal(this.genusOrAbove, o.genusOrAbove) && Objects.equal(this.infraGeneric, o.infraGeneric) && Objects.equal(this.specificEpithet, o.specificEpithet) && Objects.equal(this.infraSpecificEpithet, o.infraSpecificEpithet) && Objects.equal(this.cultivarEpithet, o.cultivarEpithet) && Objects.equal(this.strain, o.strain) && Objects.equal(this.authorship, o.authorship) && Objects.equal(this.year, o.year) && Objects.equal(this.bracketAuthorship, o.bracketAuthorship) && Objects.equal(this.bracketYear, o.bracketYear) && Objects.equal((Object)this.rank, (Object)o.rank);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.key, this.scientificName, this.type, this.genusOrAbove, this.infraGeneric, this.specificEpithet, this.infraSpecificEpithet, this.cultivarEpithet, this.strain, this.authorship, this.year, this.bracketAuthorship, this.bracketYear, this.rank});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.scientificName);
        if (this.key != null) {
            sb.append(" [");
            sb.append(this.key);
            sb.append("]");
        }
        if (this.genusOrAbove != null) {
            sb.append(" G:").append(this.genusOrAbove);
        }
        if (this.infraGeneric != null) {
            sb.append(" IG:").append(this.infraGeneric);
        }
        if (this.specificEpithet != null) {
            sb.append(" S:").append(this.specificEpithet);
        }
        if (this.rank != null) {
            sb.append(" R:").append((Object)this.rank);
        }
        if (this.infraSpecificEpithet != null) {
            sb.append(" IS:").append(this.infraSpecificEpithet);
        }
        if (this.cultivarEpithet != null) {
            sb.append(" CV:").append(this.cultivarEpithet);
        }
        if (this.strain != null) {
            sb.append(" STR:").append(this.strain);
        }
        if (this.authorship != null) {
            sb.append(" A:").append(this.authorship);
        }
        if (this.year != null) {
            sb.append(" Y:").append(this.year);
        }
        if (this.bracketAuthorship != null) {
            sb.append(" BA:").append(this.bracketAuthorship);
        }
        if (this.bracketYear != null) {
            sb.append(" BY:").append(this.bracketYear);
        }
        if (this.type != null) {
            sb.append(" [");
            sb.append((Object)this.type);
            sb.append("]");
        }
        return this.isHybridFormula() ? " [hybrid]" : sb.toString();
    }
}

