/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.checklistbank;

import com.google.common.base.Objects;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.gbif.api.vocabulary.Rank;

public class NameUsageMetrics {
    private Integer key;
    private int numPhylum;
    private int numClass;
    private int numOrder;
    private int numFamily;
    private int numGenus;
    private int numSubgenus;
    private int numSpecies;
    private int numChildren;
    private int numDescendants;
    private int numSynonyms;

    @NotNull
    public Integer getKey() {
        return this.key;
    }

    public void setKey(Integer key) {
        this.key = key;
    }

    @Min(value=0L)
    public int getNumChildren() {
        return this.numChildren;
    }

    public void setNumChildren(int numChildren) {
        this.numChildren = numChildren;
    }

    @Min(value=0L)
    public int getNumClass() {
        return this.numClass;
    }

    public void setNumClass(int numClass) {
        this.numClass = numClass;
    }

    public int getNumDescendants() {
        return this.numDescendants;
    }

    public void setNumDescendants(int numDescendants) {
        this.numDescendants = numDescendants;
    }

    @Min(value=0L)
    public int getNumFamily() {
        return this.numFamily;
    }

    public void setNumFamily(int numFamily) {
        this.numFamily = numFamily;
    }

    @Min(value=0L)
    public int getNumGenus() {
        return this.numGenus;
    }

    public void setNumGenus(int numGenus) {
        this.numGenus = numGenus;
    }

    @Min(value=0L)
    public int getNumOrder() {
        return this.numOrder;
    }

    public void setNumOrder(int numOrder) {
        this.numOrder = numOrder;
    }

    @Min(value=0L)
    public int getNumPhylum() {
        return this.numPhylum;
    }

    public void setNumPhylum(int numPhylum) {
        this.numPhylum = numPhylum;
    }

    @Min(value=0L)
    public int getNumSpecies() {
        return this.numSpecies;
    }

    public void setNumSpecies(int numSpecies) {
        this.numSpecies = numSpecies;
    }

    @Min(value=0L)
    public int getNumSubgenus() {
        return this.numSubgenus;
    }

    public void setNumSubgenus(int numSubgenus) {
        this.numSubgenus = numSubgenus;
    }

    @Min(value=0L)
    public int getNumSynonyms() {
        return this.numSynonyms;
    }

    public void setNumSynonyms(int numSynonyms) {
        this.numSynonyms = numSynonyms;
    }

    @Nullable
    public Integer getNumByRank(Rank rank) {
        if (rank == Rank.PHYLUM) {
            return this.numPhylum;
        }
        if (rank == Rank.CLASS) {
            return this.numClass;
        }
        if (rank == Rank.ORDER) {
            return this.numOrder;
        }
        if (rank == Rank.FAMILY) {
            return this.numFamily;
        }
        if (rank == Rank.GENUS) {
            return this.numGenus;
        }
        if (rank == Rank.SUBGENUS) {
            return this.numSubgenus;
        }
        if (rank == Rank.SPECIES) {
            return this.numSpecies;
        }
        return null;
    }

    public int hashCode() {
        return Objects.hashCode(this.key, this.numPhylum, this.numClass, this.numOrder, this.numFamily, this.numGenus, this.numSubgenus, this.numSpecies, this.numChildren, this.numDescendants, this.numSynonyms);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NameUsageMetrics other = (NameUsageMetrics)obj;
        return Objects.equal(this.key, other.key) && Objects.equal(this.numPhylum, other.numPhylum) && Objects.equal(this.numClass, other.numClass) && Objects.equal(this.numOrder, other.numOrder) && Objects.equal(this.numFamily, other.numFamily) && Objects.equal(this.numGenus, other.numGenus) && Objects.equal(this.numSubgenus, other.numSubgenus) && Objects.equal(this.numSpecies, other.numSpecies) && Objects.equal(this.numChildren, other.numChildren) && Objects.equal(this.numDescendants, other.numDescendants) && Objects.equal(this.numSynonyms, other.numSynonyms);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("key", this.key).add("numPhylum", this.numPhylum).add("numClass", this.numClass).add("numOrder", this.numOrder).add("numFamily", this.numFamily).add("numGenus", this.numGenus).add("numSubgenus", this.numSubgenus).add("numSpecies", this.numSpecies).add("numChildren", this.numChildren).add("numDescendants", this.numDescendants).add("numSynonyms", this.numSynonyms).toString();
    }
}

