/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.checklistbank;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nullable;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gbif.api.model.common.LinneanClassification;
import org.gbif.api.model.common.LinneanClassificationKeys;
import org.gbif.api.util.ClassificationUtils;
import org.gbif.api.vocabulary.Rank;
import org.gbif.api.vocabulary.TaxonomicStatus;

public class NameUsageMatch
implements LinneanClassification,
LinneanClassificationKeys,
Serializable {
    private static final long serialVersionUID = -8927655067465421358L;
    private Integer usageKey;
    private String scientificName;
    private String canonicalName;
    private Rank rank;
    private TaxonomicStatus status;
    private Integer confidence;
    private String note;
    private MatchType matchType = MatchType.NONE;
    private List<NameUsageMatch> alternatives;
    private String kingdom;
    private String phylum;
    @JsonProperty(value="class")
    private String clazz;
    private String order;
    private String family;
    private String genus;
    private String subgenus;
    private String species;
    private Integer kingdomKey;
    private Integer phylumKey;
    private Integer classKey;
    private Integer orderKey;
    private Integer familyKey;
    private Integer genusKey;
    private Integer subgenusKey;
    private Integer speciesKey;

    @Min(value=0L)
    @Max(value=100L)
    public Integer getConfidence() {
        return this.confidence;
    }

    public void setConfidence(Integer confidence) {
        this.confidence = confidence;
    }

    public MatchType getMatchType() {
        return this.matchType;
    }

    public void setMatchType(MatchType matchType) {
        this.matchType = matchType;
    }

    @Nullable
    public Rank getRank() {
        return this.rank;
    }

    public void setRank(Rank rank) {
        this.rank = rank;
    }

    @Nullable
    public String getScientificName() {
        return this.scientificName;
    }

    public void setScientificName(String scientificName) {
        this.scientificName = scientificName;
    }

    @Nullable
    public Integer getUsageKey() {
        return this.usageKey;
    }

    public void setUsageKey(Integer usageKey) {
        this.usageKey = usageKey;
    }

    public boolean isSynonym() {
        return this.status != null && this.status.isSynonym();
    }

    public TaxonomicStatus getStatus() {
        return this.status;
    }

    public void setStatus(TaxonomicStatus status) {
        this.status = status;
    }

    @Override
    @Nullable
    public String getKingdom() {
        return this.kingdom;
    }

    @Override
    public void setKingdom(String kingdom) {
        this.kingdom = kingdom;
    }

    @Override
    @Nullable
    public String getPhylum() {
        return this.phylum;
    }

    @Override
    public void setPhylum(String phylum) {
        this.phylum = phylum;
    }

    @Override
    @Nullable
    public String getClazz() {
        return this.clazz;
    }

    @Override
    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    @Override
    @Nullable
    public String getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(String order) {
        this.order = order;
    }

    @Override
    @Nullable
    public String getFamily() {
        return this.family;
    }

    @Override
    public void setFamily(String family) {
        this.family = family;
    }

    @Override
    @Nullable
    public String getGenus() {
        return this.genus;
    }

    @Override
    public void setGenus(String genus) {
        this.genus = genus;
    }

    @Override
    @Nullable
    public String getSubgenus() {
        return this.subgenus;
    }

    @Override
    public void setSubgenus(String subgenus) {
        this.subgenus = subgenus;
    }

    @Override
    @Nullable
    public String getSpecies() {
        return this.species;
    }

    @Override
    public void setSpecies(String species) {
        this.species = species;
    }

    @Override
    @Nullable
    public Integer getKingdomKey() {
        return this.kingdomKey;
    }

    @Override
    public void setKingdomKey(Integer kingdomKey) {
        this.kingdomKey = kingdomKey;
    }

    @Override
    @Nullable
    public Integer getPhylumKey() {
        return this.phylumKey;
    }

    @Override
    public void setPhylumKey(Integer phylumKey) {
        this.phylumKey = phylumKey;
    }

    @Override
    @Nullable
    public Integer getClassKey() {
        return this.classKey;
    }

    @Override
    public void setClassKey(Integer classKey) {
        this.classKey = classKey;
    }

    @Override
    @Nullable
    public Integer getOrderKey() {
        return this.orderKey;
    }

    @Override
    public void setOrderKey(Integer orderKey) {
        this.orderKey = orderKey;
    }

    @Override
    @Nullable
    public Integer getFamilyKey() {
        return this.familyKey;
    }

    @Override
    public void setFamilyKey(Integer familyKey) {
        this.familyKey = familyKey;
    }

    @Override
    @Nullable
    public Integer getGenusKey() {
        return this.genusKey;
    }

    @Override
    public void setGenusKey(Integer genusKey) {
        this.genusKey = genusKey;
    }

    @Override
    @Nullable
    public Integer getSubgenusKey() {
        return this.subgenusKey;
    }

    @Override
    public void setSubgenusKey(Integer subgenusKey) {
        this.subgenusKey = subgenusKey;
    }

    @Override
    @Nullable
    public Integer getSpeciesKey() {
        return this.speciesKey;
    }

    @Override
    public void setSpeciesKey(Integer speciesKey) {
        this.speciesKey = speciesKey;
    }

    @Override
    @Nullable
    public String getHigherRank(Rank rank) {
        return ClassificationUtils.getHigherRank(this, rank);
    }

    @Override
    public Integer getHigherRankKey(Rank rank) {
        return ClassificationUtils.getHigherRankKey(this, rank);
    }

    @Nullable
    public String getCanonicalName() {
        return this.canonicalName;
    }

    public void setCanonicalName(String canonicalName) {
        this.canonicalName = canonicalName;
    }

    @Nullable
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    @Nullable
    public List<NameUsageMatch> getAlternatives() {
        return this.alternatives;
    }

    public void setAlternatives(List<NameUsageMatch> alternatives) {
        this.alternatives = alternatives;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.usageKey, this.scientificName, this.canonicalName, this.rank, this.status, this.confidence, this.note, this.matchType, this.alternatives, this.kingdom, this.phylum, this.clazz, this.order, this.family, this.genus, this.subgenus, this.species, this.kingdomKey, this.phylumKey, this.classKey, this.orderKey, this.familyKey, this.genusKey, this.subgenusKey, this.speciesKey});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NameUsageMatch other = (NameUsageMatch)obj;
        return Objects.equal(this.usageKey, other.usageKey) && Objects.equal(this.scientificName, other.scientificName) && Objects.equal(this.canonicalName, other.canonicalName) && Objects.equal((Object)this.rank, (Object)other.rank) && Objects.equal((Object)this.status, (Object)other.status) && Objects.equal(this.confidence, other.confidence) && Objects.equal(this.note, other.note) && Objects.equal((Object)this.matchType, (Object)other.matchType) && Objects.equal(this.alternatives, other.alternatives) && Objects.equal(this.kingdom, other.kingdom) && Objects.equal(this.phylum, other.phylum) && Objects.equal(this.clazz, other.clazz) && Objects.equal(this.order, other.order) && Objects.equal(this.family, other.family) && Objects.equal(this.genus, other.genus) && Objects.equal(this.subgenus, other.subgenus) && Objects.equal(this.species, other.species) && Objects.equal(this.kingdomKey, other.kingdomKey) && Objects.equal(this.phylumKey, other.phylumKey) && Objects.equal(this.classKey, other.classKey) && Objects.equal(this.orderKey, other.orderKey) && Objects.equal(this.familyKey, other.familyKey) && Objects.equal(this.genusKey, other.genusKey) && Objects.equal(this.subgenusKey, other.subgenusKey) && Objects.equal(this.speciesKey, other.speciesKey);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("usageKey", this.usageKey).add("scientificName", this.scientificName).add("canonicalName", this.canonicalName).add("rank", (Object)this.rank).add("status", (Object)this.status).add("confidence", this.confidence).add("note", this.note).add("matchType", (Object)this.matchType).add("alternatives", this.alternatives).add("kingdom", this.kingdom).add("phylum", this.phylum).add("clazz", this.clazz).add("order", this.order).add("family", this.family).add("genus", this.genus).add("subgenus", this.subgenus).add("species", this.species).add("kingdomKey", this.kingdomKey).add("phylumKey", this.phylumKey).add("classKey", this.classKey).add("orderKey", this.orderKey).add("familyKey", this.familyKey).add("genusKey", this.genusKey).add("subgenusKey", this.subgenusKey).add("speciesKey", this.speciesKey).toString();
    }

    public static enum MatchType {
        EXACT,
        FUZZY,
        HIGHERRANK,
        NONE;

    }
}

