/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.checklistbank;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.gbif.api.model.checklistbank.Description;
import org.gbif.api.model.checklistbank.Distribution;
import org.gbif.api.model.checklistbank.NameUsage;
import org.gbif.api.model.checklistbank.NameUsageMediaObject;
import org.gbif.api.model.checklistbank.Reference;
import org.gbif.api.model.checklistbank.SpeciesProfile;
import org.gbif.api.model.checklistbank.TypeSpecimen;
import org.gbif.api.model.checklistbank.VernacularName;
import org.gbif.api.model.common.Identifier;
import org.gbif.api.vocabulary.IdentifierType;
import org.gbif.api.vocabulary.ThreatStatus;

public class NameUsageContainer
extends NameUsage {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private List<Description> descriptions = Lists.newArrayList();
    private List<Distribution> distributions = Lists.newArrayList();
    private List<Identifier> identifiers = Lists.newArrayList();
    private List<NameUsageMediaObject> media = Lists.newArrayList();
    private List<Reference> referenceList = Lists.newArrayList();
    private List<SpeciesProfile> speciesProfiles = Lists.newArrayList();
    private List<NameUsage> synonyms = Lists.newArrayList();
    private List<NameUsage> combinations = Lists.newArrayList();
    private List<TypeSpecimen> typeSpecimens = Lists.newArrayList();
    private List<VernacularName> vernacularNames = Lists.newArrayList();

    public NameUsageContainer() {
    }

    public NameUsageContainer(NameUsage usage) {
        try {
            JsonNode propTree = (JsonNode)MAPPER.convertValue((Object)usage, JsonNode.class);
            MAPPER.readerForUpdating((Object)this).readValue(propTree);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to copy NameUsage properties to NameUsageContainer", e);
        }
    }

    @NotNull
    public List<Description> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(List<Description> descriptions) {
        this.descriptions = descriptions;
    }

    @NotNull
    public List<Distribution> getDistributions() {
        return this.distributions;
    }

    public void setDistributions(List<Distribution> distributions) {
        this.distributions = distributions;
    }

    @NotNull
    public Set<String> getHabitats() {
        LinkedHashSet<String> habitats = Sets.newLinkedHashSet();
        for (SpeciesProfile sp : this.speciesProfiles) {
            if (Strings.isNullOrEmpty(sp.getHabitat())) continue;
            habitats.add(sp.getHabitat());
        }
        return habitats;
    }

    public List<NameUsageMediaObject> getMedia() {
        return this.media;
    }

    public void setMedia(List<NameUsageMediaObject> media) {
        this.media = media;
    }

    @NotNull
    public List<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    public void setIdentifiers(List<Identifier> identifiers) {
        this.identifiers = identifiers;
    }

    @NotNull
    @JsonIgnore
    public List<Identifier> getIdentifierByType(IdentifierType type) {
        ArrayList<Identifier> ids = Lists.newArrayList();
        for (Identifier i : this.identifiers) {
            if (type != i.getType()) continue;
            ids.add(i);
        }
        return ids;
    }

    @NotNull
    public List<Reference> getReferenceList() {
        return this.referenceList;
    }

    public void setReferenceList(List<Reference> referenceList) {
        this.referenceList = referenceList;
    }

    @NotNull
    public List<SpeciesProfile> getSpeciesProfiles() {
        return this.speciesProfiles;
    }

    public void setSpeciesProfiles(List<SpeciesProfile> speciesProfiles) {
        this.speciesProfiles = speciesProfiles;
    }

    public List<NameUsage> getSynonyms() {
        return this.synonyms;
    }

    public void setSynonyms(List<NameUsage> synonyms) {
        this.synonyms = synonyms;
    }

    @NotNull
    public List<NameUsage> getCombinations() {
        return this.combinations;
    }

    public void setCombinations(List<NameUsage> combinations) {
        this.combinations = combinations;
    }

    @NotNull
    public List<TypeSpecimen> getTypeSpecimens() {
        return this.typeSpecimens;
    }

    public void setTypeSpecimens(List<TypeSpecimen> typeSpecimens) {
        this.typeSpecimens = typeSpecimens;
    }

    @NotNull
    public List<VernacularName> getVernacularNames() {
        return this.vernacularNames;
    }

    public void setVernacularNames(List<VernacularName> vernacularNames) {
        this.vernacularNames = vernacularNames;
    }

    @NotNull
    public Set<String> getLivingPeriods() {
        LinkedHashSet<String> periods = Sets.newLinkedHashSet();
        for (SpeciesProfile sp : this.speciesProfiles) {
            if (Strings.isNullOrEmpty(sp.getLivingPeriod())) continue;
            periods.add(sp.getLivingPeriod());
        }
        return periods;
    }

    @NotNull
    public Set<ThreatStatus> getThreatStatus() {
        LinkedHashSet<ThreatStatus> threats = Sets.newLinkedHashSet();
        for (Distribution d : this.distributions) {
            if (d.getThreatStatus() == null) continue;
            threats.add(d.getThreatStatus());
        }
        return threats;
    }

    public Boolean isExtinct() {
        int ctrue = 0;
        int cfalse = 0;
        for (SpeciesProfile sp : this.speciesProfiles) {
            if (sp.isExtinct() == null) continue;
            if (sp.isExtinct().booleanValue()) {
                ++ctrue;
                continue;
            }
            if (sp.isExtinct().booleanValue()) continue;
            ++cfalse;
        }
        return ctrue + cfalse == 0 ? null : Boolean.valueOf(ctrue >= cfalse);
    }

    public Boolean isFreshwater() {
        int ctrue = 0;
        int cfalse = 0;
        for (SpeciesProfile sp : this.speciesProfiles) {
            if (sp.isFreshwater() == null) continue;
            if (sp.isFreshwater().booleanValue()) {
                ++ctrue;
                continue;
            }
            if (sp.isFreshwater().booleanValue()) continue;
            ++cfalse;
        }
        return ctrue + cfalse == 0 ? null : Boolean.valueOf(ctrue >= cfalse);
    }

    public Boolean isMarine() {
        int ctrue = 0;
        int cfalse = 0;
        for (SpeciesProfile sp : this.speciesProfiles) {
            if (sp.isMarine() == null) continue;
            if (sp.isMarine().booleanValue()) {
                ++ctrue;
                continue;
            }
            if (sp.isMarine().booleanValue()) continue;
            ++cfalse;
        }
        return ctrue + cfalse == 0 ? null : Boolean.valueOf(ctrue >= cfalse);
    }

    public Boolean isTerrestrial() {
        int ctrue = 0;
        int cfalse = 0;
        for (SpeciesProfile sp : this.speciesProfiles) {
            if (sp.isTerrestrial() == null) continue;
            if (sp.isTerrestrial().booleanValue()) {
                ++ctrue;
                continue;
            }
            if (sp.isTerrestrial().booleanValue()) continue;
            ++cfalse;
        }
        return ctrue + cfalse == 0 ? null : Boolean.valueOf(ctrue >= cfalse);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof NameUsageContainer) {
            if (!super.equals(object)) {
                return false;
            }
            NameUsageContainer other = (NameUsageContainer)object;
            return Objects.equal(this.descriptions, other.descriptions) && Objects.equal(this.distributions, other.distributions) && Objects.equal(this.media, other.media) && Objects.equal(this.referenceList, other.referenceList) && Objects.equal(this.speciesProfiles, other.speciesProfiles) && Objects.equal(this.synonyms, other.synonyms) && Objects.equal(this.typeSpecimens, other.typeSpecimens) && Objects.equal(this.vernacularNames, other.vernacularNames);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.descriptions, this.distributions, this.media, this.referenceList, this.speciesProfiles, this.synonyms, this.typeSpecimens, this.vernacularNames);
    }

    static {
        MAPPER.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

