/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.checklistbank;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Date;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gbif.api.model.Constants;
import org.gbif.api.model.common.LinneanClassification;
import org.gbif.api.model.common.LinneanClassificationKeys;
import org.gbif.api.util.ClassificationUtils;
import org.gbif.api.vocabulary.NameType;
import org.gbif.api.vocabulary.NameUsageIssue;
import org.gbif.api.vocabulary.NomenclaturalStatus;
import org.gbif.api.vocabulary.Origin;
import org.gbif.api.vocabulary.Rank;
import org.gbif.api.vocabulary.TaxonomicStatus;

public class NameUsage
implements LinneanClassification,
LinneanClassificationKeys {
    private Integer key;
    private Integer nubKey;
    private Integer nameKey;
    private String taxonID;
    private Integer sourceTaxonKey;
    private String kingdom;
    private String phylum;
    @JsonProperty(value="class")
    private String clazz;
    private String order;
    private String family;
    private String genus;
    private String subgenus;
    private String species;
    private Integer kingdomKey;
    private Integer phylumKey;
    private Integer classKey;
    private Integer orderKey;
    private Integer familyKey;
    private Integer genusKey;
    private Integer subgenusKey;
    private Integer speciesKey;
    private UUID datasetKey;
    private UUID constituentKey;
    private Integer parentKey;
    private String parent;
    private Integer proParteKey;
    private Integer acceptedKey;
    private String accepted;
    private Integer basionymKey;
    private String basionym;
    private String scientificName;
    private String canonicalName;
    private String vernacularName;
    private String authorship;
    private NameType nameType;
    private Rank rank;
    private Origin origin;
    private TaxonomicStatus taxonomicStatus;
    private Set<NomenclaturalStatus> nomenclaturalStatus = Sets.newHashSet();
    private String remarks;
    private String publishedIn;
    private String accordingTo;
    private int numDescendants;
    private URI references;
    private Date modified;
    private Date deleted;
    private Date lastCrawled;
    private Date lastInterpreted;
    private Set<NameUsageIssue> issues = EnumSet.noneOf(NameUsageIssue.class);

    public Integer getNameKey() {
        return this.nameKey;
    }

    public void setNameKey(Integer nameKey) {
        this.nameKey = nameKey;
    }

    @Nullable
    public Integer getSourceTaxonKey() {
        return this.sourceTaxonKey;
    }

    public void setSourceTaxonKey(Integer sourceTaxonKey) {
        this.sourceTaxonKey = sourceTaxonKey;
    }

    public String getAccepted() {
        return this.accepted;
    }

    public void setAccepted(String accepted) {
        this.accepted = accepted;
    }

    public Integer getAcceptedKey() {
        return this.acceptedKey;
    }

    public void setAcceptedKey(Integer acceptedKey) {
        this.acceptedKey = acceptedKey;
    }

    @Nullable
    public String getAccordingTo() {
        return this.accordingTo;
    }

    public void setAccordingTo(String accordingTo) {
        this.accordingTo = accordingTo;
    }

    @Nullable
    public String getAuthorship() {
        return this.authorship;
    }

    public void setAuthorship(String authorship) {
        this.authorship = authorship;
    }

    public String getBasionym() {
        return this.basionym;
    }

    public void setBasionym(String basionym) {
        this.basionym = basionym;
    }

    @Nullable
    public Integer getBasionymKey() {
        return this.basionymKey;
    }

    public void setBasionymKey(Integer basionymKey) {
        this.basionymKey = basionymKey;
    }

    @Nullable
    public String getCanonicalName() {
        return this.canonicalName;
    }

    public void setCanonicalName(String canonicalName) {
        this.canonicalName = canonicalName;
    }

    @NotNull
    public UUID getDatasetKey() {
        return this.datasetKey;
    }

    public void setDatasetKey(UUID datasetKey) {
        this.datasetKey = datasetKey;
    }

    @NotNull
    public Integer getKey() {
        return this.key;
    }

    public void setKey(Integer key) {
        this.key = key;
    }

    public NameType getNameType() {
        return this.nameType;
    }

    public void setNameType(NameType nameType) {
        this.nameType = nameType;
    }

    public Set<NomenclaturalStatus> getNomenclaturalStatus() {
        return this.nomenclaturalStatus;
    }

    public void setNomenclaturalStatus(Set<NomenclaturalStatus> nomenclaturalStatus) {
        this.nomenclaturalStatus = nomenclaturalStatus;
    }

    @Nullable
    public Integer getNubKey() {
        return this.nubKey;
    }

    public void setNubKey(Integer nubKey) {
        this.nubKey = nubKey;
    }

    public int getNumDescendants() {
        return this.numDescendants;
    }

    public void setNumDescendants(int numDescendants) {
        this.numDescendants = numDescendants;
    }

    @NotNull
    public Origin getOrigin() {
        return this.origin;
    }

    public void setOrigin(Origin origin) {
        this.origin = origin;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    @Nullable
    public Integer getParentKey() {
        return this.parentKey;
    }

    public void setParentKey(Integer parentKey) {
        this.parentKey = parentKey;
    }

    public Integer getProParteKey() {
        return this.proParteKey;
    }

    public void setProParteKey(Integer proParteKey) {
        this.proParteKey = proParteKey;
    }

    @Nullable
    public String getPublishedIn() {
        return this.publishedIn;
    }

    public void setPublishedIn(String publishedIn) {
        this.publishedIn = publishedIn;
    }

    @Nullable
    public Rank getRank() {
        return this.rank;
    }

    public void setRank(Rank rank) {
        this.rank = rank;
    }

    @NotNull
    public String getScientificName() {
        return this.scientificName;
    }

    public void setScientificName(String scientificName) {
        this.scientificName = scientificName;
    }

    @Nullable
    public UUID getConstituentKey() {
        return this.constituentKey;
    }

    public void setConstituentKey(UUID constituentKey) {
        this.constituentKey = constituentKey;
    }

    @Nullable
    public String getVernacularName() {
        return this.vernacularName;
    }

    public void setVernacularName(String vernacularName) {
        this.vernacularName = vernacularName;
    }

    public void setTaxonomicStatus(TaxonomicStatus taxonomicStatus) {
        this.taxonomicStatus = taxonomicStatus;
    }

    @Override
    public String getKingdom() {
        return this.kingdom;
    }

    @Override
    public void setKingdom(String kingdom) {
        this.kingdom = kingdom;
    }

    @Override
    public String getPhylum() {
        return this.phylum;
    }

    @Override
    public void setPhylum(String phylum) {
        this.phylum = phylum;
    }

    @Override
    public String getClazz() {
        return this.clazz;
    }

    @Override
    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    @Override
    public String getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(String order) {
        this.order = order;
    }

    @Override
    public String getFamily() {
        return this.family;
    }

    @Override
    public void setFamily(String family) {
        this.family = family;
    }

    @Override
    public String getGenus() {
        return this.genus;
    }

    @Override
    public void setGenus(String genus) {
        this.genus = genus;
    }

    @Override
    public String getSubgenus() {
        return this.subgenus;
    }

    @Override
    public void setSubgenus(String subgenus) {
        this.subgenus = subgenus;
    }

    @Override
    public String getSpecies() {
        return this.species;
    }

    @Override
    public void setSpecies(String species) {
        this.species = species;
    }

    @Override
    public Integer getKingdomKey() {
        return this.kingdomKey;
    }

    @Override
    public void setKingdomKey(Integer kingdomKey) {
        this.kingdomKey = kingdomKey;
    }

    @Override
    public Integer getPhylumKey() {
        return this.phylumKey;
    }

    @Override
    public void setPhylumKey(Integer phylumKey) {
        this.phylumKey = phylumKey;
    }

    @Override
    public Integer getClassKey() {
        return this.classKey;
    }

    @Override
    public void setClassKey(Integer classKey) {
        this.classKey = classKey;
    }

    @Override
    public Integer getOrderKey() {
        return this.orderKey;
    }

    @Override
    public void setOrderKey(Integer orderKey) {
        this.orderKey = orderKey;
    }

    @Override
    public Integer getFamilyKey() {
        return this.familyKey;
    }

    @Override
    public void setFamilyKey(Integer familyKey) {
        this.familyKey = familyKey;
    }

    @Override
    public Integer getGenusKey() {
        return this.genusKey;
    }

    @Override
    public void setGenusKey(Integer genusKey) {
        this.genusKey = genusKey;
    }

    @Override
    public Integer getSubgenusKey() {
        return this.subgenusKey;
    }

    @Override
    public void setSubgenusKey(Integer subgenusKey) {
        this.subgenusKey = subgenusKey;
    }

    @Override
    public Integer getSpeciesKey() {
        return this.speciesKey;
    }

    @Override
    public void setSpeciesKey(Integer speciesKey) {
        this.speciesKey = speciesKey;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Nullable
    @JsonIgnore
    public String getCanonicalOrScientificName() {
        return this.canonicalName == null ? this.scientificName : this.canonicalName;
    }

    @Nullable
    public URI getReferences() {
        return this.references;
    }

    public void setReferences(URI references) {
        this.references = references;
    }

    @Override
    public String getHigherRank(Rank rank) {
        return ClassificationUtils.getHigherRank(this, rank);
    }

    @Override
    public Integer getHigherRankKey(Rank rank) {
        return ClassificationUtils.getHigherRankKey(this, rank);
    }

    @NotNull
    @JsonIgnore
    public LinkedHashMap<Integer, String> getHigherClassificationMap() {
        return ClassificationUtils.getHigherClassificationMap(this, this.key, this.parentKey, this.parent);
    }

    @Nullable
    public String getTaxonID() {
        return this.taxonID;
    }

    @Nullable
    public TaxonomicStatus getTaxonomicStatus() {
        return this.taxonomicStatus;
    }

    @Nullable
    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    @Nullable
    public Date getDeleted() {
        return this.deleted;
    }

    public void setDeleted(Date deleted) {
        this.deleted = deleted;
    }

    @Nullable
    public Date getLastCrawled() {
        return this.lastCrawled;
    }

    public void setLastCrawled(Date lastCrawled) {
        this.lastCrawled = lastCrawled;
    }

    @Nullable
    public Date getLastInterpreted() {
        return this.lastInterpreted;
    }

    public void setLastInterpreted(Date lastInterpreted) {
        this.lastInterpreted = lastInterpreted;
    }

    @NotNull
    public Set<NameUsageIssue> getIssues() {
        return this.issues;
    }

    public void setIssues(Set<NameUsageIssue> issues) {
        Preconditions.checkNotNull(issues, "Issues cannot be null");
        this.issues = Sets.newEnumSet(issues, NameUsageIssue.class);
    }

    public void addIssue(NameUsageIssue issue) {
        Preconditions.checkNotNull(issue, "Issue needs to be specified");
        this.issues.add(issue);
    }

    @JsonIgnore
    public boolean isNub() {
        return this.datasetKey.equals(Constants.NUB_DATASET_KEY);
    }

    @JsonIgnore
    public boolean isProParte() {
        return this.proParteKey != null;
    }

    public boolean isSynonym() {
        return this.taxonomicStatus != null && this.taxonomicStatus.isSynonym();
    }

    public void setTaxonID(String taxonID) {
        this.taxonID = taxonID;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.key, this.nameKey, this.kingdom, this.phylum, this.clazz, this.order, this.family, this.genus, this.subgenus, this.species, this.kingdomKey, this.phylumKey, this.classKey, this.orderKey, this.familyKey, this.genusKey, this.subgenusKey, this.speciesKey, this.datasetKey, this.constituentKey, this.nubKey, this.parentKey, this.parent, this.proParteKey, this.acceptedKey, this.accepted, this.basionymKey, this.basionym, this.scientificName, this.canonicalName, this.vernacularName, this.authorship, this.nameType, this.taxonomicStatus, this.nomenclaturalStatus, this.rank, this.publishedIn, this.accordingTo, this.numDescendants, this.origin, this.remarks, this.references, this.taxonID, this.modified, this.deleted, this.lastCrawled, this.lastInterpreted, this.issues});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NameUsage other = (NameUsage)obj;
        return Objects.equal(this.key, other.key) && Objects.equal(this.nameKey, other.nameKey) && Objects.equal(this.kingdom, other.kingdom) && Objects.equal(this.phylum, other.phylum) && Objects.equal(this.clazz, other.clazz) && Objects.equal(this.order, other.order) && Objects.equal(this.family, other.family) && Objects.equal(this.genus, other.genus) && Objects.equal(this.subgenus, other.subgenus) && Objects.equal(this.species, other.species) && Objects.equal(this.kingdomKey, other.kingdomKey) && Objects.equal(this.phylumKey, other.phylumKey) && Objects.equal(this.classKey, other.classKey) && Objects.equal(this.orderKey, other.orderKey) && Objects.equal(this.familyKey, other.familyKey) && Objects.equal(this.genusKey, other.genusKey) && Objects.equal(this.subgenusKey, other.subgenusKey) && Objects.equal(this.speciesKey, other.speciesKey) && Objects.equal(this.datasetKey, other.datasetKey) && Objects.equal(this.constituentKey, other.constituentKey) && Objects.equal(this.nubKey, other.nubKey) && Objects.equal(this.parentKey, other.parentKey) && Objects.equal(this.parent, other.parent) && Objects.equal(this.proParteKey, other.proParteKey) && Objects.equal(this.acceptedKey, other.acceptedKey) && Objects.equal(this.accepted, other.accepted) && Objects.equal(this.basionymKey, other.basionymKey) && Objects.equal(this.basionym, other.basionym) && Objects.equal(this.scientificName, other.scientificName) && Objects.equal(this.canonicalName, other.canonicalName) && Objects.equal(this.vernacularName, other.vernacularName) && Objects.equal(this.authorship, other.authorship) && Objects.equal((Object)this.nameType, (Object)other.nameType) && Objects.equal((Object)this.taxonomicStatus, (Object)other.taxonomicStatus) && Objects.equal(this.nomenclaturalStatus, other.nomenclaturalStatus) && Objects.equal((Object)this.rank, (Object)other.rank) && Objects.equal(this.publishedIn, other.publishedIn) && Objects.equal(this.accordingTo, other.accordingTo) && Objects.equal(this.numDescendants, other.numDescendants) && Objects.equal((Object)this.origin, (Object)other.origin) && Objects.equal(this.references, other.references) && Objects.equal(this.taxonID, other.taxonID) && Objects.equal(this.remarks, other.remarks) && Objects.equal(this.modified, other.modified) && Objects.equal(this.deleted, other.deleted) && Objects.equal(this.lastCrawled, other.lastCrawled) && Objects.equal(this.lastInterpreted, other.lastInterpreted) && Objects.equal(this.issues, other.issues);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("key", this.key).add("nameKey", this.nameKey).add("kingdom", this.kingdom).add("phylum", this.phylum).add("clazz", this.clazz).add("order", this.order).add("family", this.family).add("genus", this.genus).add("subgenus", this.subgenus).add("species", this.species).add("kingdomKey", this.kingdomKey).add("phylumKey", this.phylumKey).add("classKey", this.classKey).add("orderKey", this.orderKey).add("familyKey", this.familyKey).add("genusKey", this.genusKey).add("subgenusKey", this.subgenusKey).add("speciesKey", this.speciesKey).add("datasetKey", this.datasetKey).add("subDatasetKey", this.constituentKey).add("nubKey", this.nubKey).add("parentKey", this.parentKey).add("parent", this.parent).add("proParteKey", this.proParteKey).add("acceptedKey", this.acceptedKey).add("accepted", this.accepted).add("basionymKey", this.basionymKey).add("basionym", this.basionym).add("scientificName", this.scientificName).add("canonicalName", this.canonicalName).add("vernacularName", this.vernacularName).add("authorship", this.authorship).add("nameType", (Object)this.nameType).add("taxonomicStatus", (Object)this.taxonomicStatus).add("nomenclaturalStatus", this.nomenclaturalStatus).add("rank", (Object)this.rank).add("publishedIn", this.publishedIn).add("accordingTo", this.accordingTo).add("numDescendants", this.numDescendants).add("origin", (Object)this.origin).add("remarks", this.remarks).add("references", this.references).add("taxonID", this.taxonID).add("modified", this.modified).add("deleted", this.deleted).add("lastCrawled", this.lastCrawled).add("lastInterpreted", this.lastInterpreted).add("issues", this.issues).toString();
    }
}

