/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.checklistbank;

import com.google.common.base.Objects;
import javax.annotation.Nullable;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.gbif.api.model.checklistbank.NameUsageExtension;
import org.gbif.api.vocabulary.CitesAppendix;
import org.gbif.api.vocabulary.Country;
import org.gbif.api.vocabulary.EstablishmentMeans;
import org.gbif.api.vocabulary.LifeStage;
import org.gbif.api.vocabulary.OccurrenceStatus;
import org.gbif.api.vocabulary.ThreatStatus;

public class Distribution
implements NameUsageExtension {
    private String locationId;
    private String locality;
    private Country country;
    private OccurrenceStatus status;
    private LifeStage lifeStage;
    private String temporal;
    private ThreatStatus threatStatus;
    private EstablishmentMeans establishmentMeans;
    private CitesAppendix appendixCites;
    private String source;
    private Integer sourceTaxonKey;
    private Integer startDayOfYear;
    private Integer endDayOfYear;
    private String remarks;

    @Nullable
    public CitesAppendix getAppendixCites() {
        return this.appendixCites;
    }

    public void setAppendixCites(CitesAppendix appendixCites) {
        this.appendixCites = appendixCites;
    }

    @Nullable
    public Country getCountry() {
        return this.country;
    }

    public void setCountry(Country country) {
        this.country = country;
    }

    @Nullable
    @Min(value=1L)
    @Max(value=366L)
    public Integer getEndDayOfYear() {
        return this.endDayOfYear;
    }

    public void setEndDayOfYear(Integer endDayOfYear) {
        this.endDayOfYear = endDayOfYear;
    }

    @Nullable
    public EstablishmentMeans getEstablishmentMeans() {
        return this.establishmentMeans;
    }

    public void setEstablishmentMeans(EstablishmentMeans establishmentMeans) {
        this.establishmentMeans = establishmentMeans;
    }

    @Nullable
    public LifeStage getLifeStage() {
        return this.lifeStage;
    }

    public void setLifeStage(LifeStage lifeStage) {
        this.lifeStage = lifeStage;
    }

    @Nullable
    public String getLocality() {
        return this.locality;
    }

    public void setLocality(String locality) {
        this.locality = locality;
    }

    public String getLocationId() {
        return this.locationId;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    @Nullable
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Override
    @Nullable
    public String getSource() {
        return this.source;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
    }

    @Override
    @Nullable
    public Integer getSourceTaxonKey() {
        return this.sourceTaxonKey;
    }

    @Override
    public void setSourceTaxonKey(Integer sourceTaxonKey) {
        this.sourceTaxonKey = sourceTaxonKey;
    }

    @Nullable
    @Min(value=1L)
    @Max(value=366L)
    public Integer getStartDayOfYear() {
        return this.startDayOfYear;
    }

    public void setStartDayOfYear(Integer startDayOfYear) {
        this.startDayOfYear = startDayOfYear;
    }

    @Nullable
    public OccurrenceStatus getStatus() {
        return this.status;
    }

    public void setStatus(OccurrenceStatus status) {
        this.status = status;
    }

    @Nullable
    public String getTemporal() {
        return this.temporal;
    }

    public void setTemporal(String temporal) {
        this.temporal = temporal;
    }

    @Nullable
    public ThreatStatus getThreatStatus() {
        return this.threatStatus;
    }

    public void setThreatStatus(ThreatStatus threatStatus) {
        this.threatStatus = threatStatus;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Distribution)) {
            return false;
        }
        Distribution that = (Distribution)object;
        return Objects.equal(this.locality, that.locality) && Objects.equal((Object)this.country, (Object)that.country) && Objects.equal((Object)this.status, (Object)that.status) && Objects.equal((Object)this.lifeStage, (Object)that.lifeStage) && Objects.equal(this.temporal, that.temporal) && Objects.equal((Object)this.threatStatus, (Object)that.threatStatus) && Objects.equal((Object)this.establishmentMeans, (Object)that.establishmentMeans) && Objects.equal((Object)this.appendixCites, (Object)that.appendixCites) && Objects.equal(this.source, that.source) && Objects.equal(this.sourceTaxonKey, that.sourceTaxonKey) && Objects.equal(this.startDayOfYear, that.startDayOfYear) && Objects.equal(this.endDayOfYear, that.endDayOfYear);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.locality, this.country, this.status, this.lifeStage, this.temporal, this.threatStatus, this.establishmentMeans, this.appendixCites, this.source, this.startDayOfYear, this.endDayOfYear});
    }

    public String toString() {
        return Objects.toStringHelper(this).add("locality", this.locality).add("country", (Object)this.country).add("status", (Object)this.status).add("lifeStage", (Object)this.lifeStage).add("temporal", this.temporal).add("threatStatus", (Object)this.threatStatus).add("establishmentMeans", (Object)this.establishmentMeans).add("appendixCites", (Object)this.appendixCites).add("source", this.source).add("sourceTaxonKey", this.sourceTaxonKey).add("startDayOfYear", this.startDayOfYear).add("endDayOfYear", this.endDayOfYear).add("locationId", this.locationId).add("remarks", this.remarks).toString();
    }
}

