/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.checklistbank;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Past;
import org.gbif.api.vocabulary.Extension;
import org.gbif.api.vocabulary.Kingdom;
import org.gbif.api.vocabulary.Language;
import org.gbif.api.vocabulary.NameUsageIssue;
import org.gbif.api.vocabulary.Origin;
import org.gbif.api.vocabulary.Rank;

public class DatasetMetrics {
    private int key;
    private UUID datasetKey;
    private int usagesCount;
    private int synonymsCount;
    private int distinctNamesCount;
    private int nubMatchingCount;
    private int colMatchingCount;
    private int nubCoveragePct;
    private int colCoveragePct;
    private Map<UUID, Integer> countByConstituent = Maps.newHashMap();
    private Map<Kingdom, Integer> countByKingdom = Maps.newHashMap();
    private Map<Rank, Integer> countByRank = Maps.newHashMap();
    private Map<Language, Integer> countNamesByLanguage = Maps.newHashMap();
    private Map<Extension, Integer> countExtRecordsByExtension = Maps.newHashMap();
    private Map<Origin, Integer> countByOrigin = Maps.newHashMap();
    private Map<NameUsageIssue, Integer> countByIssue = Maps.newHashMap();
    private Map<String, Integer> otherCount = Maps.newHashMap();
    private Date created;
    private Date downloaded;

    public int getKey() {
        return this.key;
    }

    public void setKey(int key) {
        this.key = key;
    }

    @Max(value=100L)
    @Min(value=0L)
    public int getColCoveragePct() {
        return this.colCoveragePct;
    }

    public void setColCoveragePct(int colCoveragePct) {
        this.colCoveragePct = colCoveragePct;
    }

    @NotNull
    public Map<UUID, Integer> getCountByConstituent() {
        return this.countByConstituent;
    }

    public void setCountByConstituent(Map<UUID, Integer> countByConstituent) {
        this.countByConstituent = countByConstituent;
    }

    @NotNull
    public Map<Kingdom, Integer> getCountByKingdom() {
        return this.countByKingdom;
    }

    public void setCountByKingdom(Map<Kingdom, Integer> countByKingdom) {
        this.countByKingdom = countByKingdom;
    }

    @NotNull
    public Map<Rank, Integer> getCountByRank() {
        return this.countByRank;
    }

    public void setCountByRank(Map<Rank, Integer> countByRank) {
        this.countByRank = countByRank;
    }

    @Min(value=0L)
    public int getDistinctNamesCount() {
        return this.distinctNamesCount;
    }

    public void setDistinctNamesCount(int distinctNamesCount) {
        this.distinctNamesCount = distinctNamesCount;
    }

    @NotNull
    public Map<Extension, Integer> getCountExtRecordsByExtension() {
        return this.countExtRecordsByExtension;
    }

    public void setCountExtRecordsByExtension(Map<Extension, Integer> countExtRecordsByExtension) {
        this.countExtRecordsByExtension = countExtRecordsByExtension;
    }

    @Min(value=0L)
    public int getColMatchingCount() {
        return this.colMatchingCount;
    }

    public void setColMatchingCount(int colMatchingCount) {
        this.colMatchingCount = colMatchingCount;
    }

    @Min(value=0L)
    public int getNubMatchingCount() {
        return this.nubMatchingCount;
    }

    public void setNubMatchingCount(int nubMatchingCount) {
        this.nubMatchingCount = nubMatchingCount;
    }

    @NotNull
    public Map<Language, Integer> getCountNamesByLanguage() {
        return this.countNamesByLanguage;
    }

    public void setCountNamesByLanguage(Map<Language, Integer> countNamesByLanguage) {
        this.countNamesByLanguage = countNamesByLanguage;
    }

    @Min(value=0L)
    public int getSynonymsCount() {
        return this.synonymsCount;
    }

    public void setSynonymsCount(int synonymsCount) {
        this.synonymsCount = synonymsCount;
    }

    @Min(value=0L)
    public int getUsagesCount() {
        return this.usagesCount;
    }

    public void setUsagesCount(int usagesCount) {
        this.usagesCount = usagesCount;
    }

    @NotNull
    public Map<Origin, Integer> getCountByOrigin() {
        return this.countByOrigin;
    }

    public void setCountByOrigin(Map<Origin, Integer> countByOrigin) {
        this.countByOrigin = countByOrigin;
    }

    @NotNull
    public Map<NameUsageIssue, Integer> getCountByIssue() {
        return this.countByIssue;
    }

    public void setCountByIssue(Map<NameUsageIssue, Integer> countByIssue) {
        this.countByIssue = countByIssue;
    }

    @NotNull
    @Past
    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    @NotNull
    @Past
    public Date getDownloaded() {
        return this.downloaded;
    }

    public void setDownloaded(Date downloaded) {
        this.downloaded = downloaded;
    }

    @NotNull
    public UUID getDatasetKey() {
        return this.datasetKey;
    }

    public void setDatasetKey(UUID datasetKey) {
        this.datasetKey = datasetKey;
    }

    @Max(value=100L)
    @Min(value=0L)
    public int getNubCoveragePct() {
        return this.nubCoveragePct;
    }

    public void setNubCoveragePct(int nubCoveragePct) {
        this.nubCoveragePct = nubCoveragePct;
    }

    @Min(value=0L)
    public int getCountByKingdom(Kingdom kingdom) {
        return this.getCountFromMap(this.countByKingdom, (Object)kingdom);
    }

    @Min(value=0L)
    public int getCountByRank(Rank rank) {
        return this.getCountFromMap(this.countByRank, (Object)rank);
    }

    @Min(value=0L)
    public int getCountByOrigin(Origin origin) {
        return this.getCountFromMap(this.countByOrigin, (Object)origin);
    }

    @Min(value=0L)
    public int getCountByIssue(NameUsageIssue issue) {
        return this.getCountFromMap(this.countByIssue, (Object)issue);
    }

    @Min(value=0L)
    public int getOtherCount(String key) {
        return this.getCountFromMap(this.otherCount, key);
    }

    @Min(value=0L)
    public int getCountNamesByLanguage(Language language) {
        return this.getCountFromMap(this.countNamesByLanguage, (Object)language);
    }

    @Min(value=0L)
    public int getExtensionRecordCount(Extension extension) {
        return this.getCountFromMap(this.countExtRecordsByExtension, (Object)extension);
    }

    public Map<String, Integer> getOtherCount() {
        return this.otherCount;
    }

    public void setOtherCount(Map<String, Integer> otherCount) {
        this.otherCount = otherCount;
    }

    private int getCountFromMap(Map<?, Integer> map, Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Null not allowed");
        }
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DatasetMetrics)) {
            return false;
        }
        DatasetMetrics that = (DatasetMetrics)object;
        return Objects.equal(this.key, that.key) && Objects.equal(this.datasetKey, that.datasetKey) && Objects.equal(this.usagesCount, that.usagesCount) && Objects.equal(this.synonymsCount, that.synonymsCount) && Objects.equal(this.distinctNamesCount, that.distinctNamesCount) && Objects.equal(this.nubMatchingCount, that.nubMatchingCount) && Objects.equal(this.colMatchingCount, that.colMatchingCount) && Objects.equal(this.nubCoveragePct, that.nubCoveragePct) && Objects.equal(this.colCoveragePct, that.colCoveragePct) && Objects.equal(this.countByConstituent, that.countByConstituent) && Objects.equal(this.countByKingdom, that.countByKingdom) && Objects.equal(this.countByRank, that.countByRank) && Objects.equal(this.countNamesByLanguage, that.countNamesByLanguage) && Objects.equal(this.countExtRecordsByExtension, that.countExtRecordsByExtension) && Objects.equal(this.countByOrigin, that.countByOrigin) && Objects.equal(this.countByIssue, that.countByIssue) && Objects.equal(this.otherCount, that.otherCount) && Objects.equal(this.created, that.created) && Objects.equal(this.downloaded, that.downloaded);
    }

    public int hashCode() {
        return Objects.hashCode(this.key, this.datasetKey, this.usagesCount, this.synonymsCount, this.distinctNamesCount, this.nubMatchingCount, this.colMatchingCount, this.nubCoveragePct, this.colCoveragePct, this.countByConstituent, this.countByKingdom, this.countByRank, this.countNamesByLanguage, this.countExtRecordsByExtension, this.countByOrigin, this.countByIssue, this.otherCount, this.created, this.downloaded);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("key", this.key).add("datasetKey", this.datasetKey).add("usagesCount", this.usagesCount).add("synonymsCount", this.synonymsCount).add("distinctNamesCount", this.distinctNamesCount).add("nubMatchingCount", this.nubMatchingCount).add("colMatchingCount", this.colMatchingCount).add("nubCoveragePct", this.nubCoveragePct).add("colCoveragePct", this.colCoveragePct).add("countByConstituent", this.countByConstituent).add("countByKingdom", this.countByKingdom).add("countByRank", this.countByRank).add("countNamesByLanguage", this.countNamesByLanguage).add("countExtRecordsByExtension", this.countExtRecordsByExtension).add("countByOrigin", this.countByOrigin).add("countByIssue", this.countByIssue).add("otherCount", this.otherCount).add("created", this.created).add("downloaded", this.downloaded).toString();
    }
}

