/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.utils.text;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.Normalizer;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import org.apache.commons.lang3.text.WordUtils;

public class StringUtils {
    private static Pattern MARKER = Pattern.compile("\\p{M}");
    public static final int LINNEAN_YEAR = 1751;
    private static final String CONS = "BCDFGHJKLMNPQRSTVWXYZ";
    private static final Pattern OCT = Pattern.compile("^[0-7]+$");
    private static final Pattern HEX = Pattern.compile("^[0-9abcdefABCDEF]+$");
    private static final String VOC = "AEIOU";
    private static Random rnd = new Random();

    private StringUtils() {
    }

    public static String foldToAscii(String x) {
        if (x == null) {
            return null;
        }
        x = StringUtils.replaceSpecialCases(x);
        x = Normalizer.normalize(x, Normalizer.Form.NFD);
        return MARKER.matcher(x).replaceAll("");
    }

    private static String replaceSpecialCases(String x) {
        StringBuffer sb = new StringBuffer();
        block16: for (int i = 0; i < x.length(); ++i) {
            char c = x.charAt(i);
            switch (c) {
                case '\u00df': {
                    sb.append("ss");
                    continue block16;
                }
                case '\u00c6': {
                    sb.append("AE");
                    continue block16;
                }
                case '\u00e6': {
                    sb.append("ae");
                    continue block16;
                }
                case '\u00d0': {
                    sb.append("D");
                    continue block16;
                }
                case '\u0111': {
                    sb.append("d");
                    continue block16;
                }
                case '\u00f0': {
                    sb.append("d");
                    continue block16;
                }
                case '\u00d8': {
                    sb.append("O");
                    continue block16;
                }
                case '\u00f8': {
                    sb.append("o");
                    continue block16;
                }
                case '\u0152': {
                    sb.append("OE");
                    continue block16;
                }
                case '\u0153': {
                    sb.append("oe");
                    continue block16;
                }
                case '\u0166': {
                    sb.append("T");
                    continue block16;
                }
                case '\u0167': {
                    sb.append("t");
                    continue block16;
                }
                case '\u0141': {
                    sb.append("L");
                    continue block16;
                }
                case '\u0142': {
                    sb.append("l");
                    continue block16;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String increase(String x) {
        if (x == null) {
            return null;
        }
        if (x.equals("")) {
            return x;
        }
        char[] chars = x.toCharArray();
        int idx = chars.length - 1;
        boolean appendingNeeded = false;
        Character lastOriginalChar = null;
        while (idx >= 0) {
            char c = chars[idx];
            if (!Character.isLetter(c)) {
                --idx;
                continue;
            }
            if (lastOriginalChar == null) {
                lastOriginalChar = Character.valueOf(c);
            }
            if (c == 'z') {
                chars[idx] = 97;
                appendingNeeded = true;
            } else if (c == 'Z') {
                chars[idx] = 65;
                appendingNeeded = true;
            } else {
                chars[idx] = c = (char)(c + '\u0001');
                appendingNeeded = false;
                break;
            }
            --idx;
        }
        if (appendingNeeded) {
            char append = lastOriginalChar == null || Character.isLowerCase(lastOriginalChar.charValue()) ? (char)'a' : 'A';
            return String.valueOf(chars) + append;
        }
        return String.valueOf(chars);
    }

    public static String randomSpecies() {
        return StringUtils.randomGenus() + " " + StringUtils.randomEpithet();
    }

    public static String randomGenus() {
        return WordUtils.capitalize((String)StringUtils.randomString(rnd.nextInt(9) + 3).toLowerCase());
    }

    public static String randomEpithet() {
        return StringUtils.randomString(rnd.nextInt(12) + 4).toLowerCase();
    }

    public static String randomFamily() {
        return WordUtils.capitalize((String)StringUtils.randomString(rnd.nextInt(15) + 5).toLowerCase()) + "idae";
    }

    public static String randomAuthor() {
        return WordUtils.capitalize((String)StringUtils.randomString(rnd.nextInt(12) + 1).toLowerCase());
    }

    public static String randomString(int len) {
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            if (rnd.nextInt(3) > 1) {
                sb.append(CONS.charAt(rnd.nextInt(CONS.length())));
                continue;
            }
            sb.append(VOC.charAt(rnd.nextInt(VOC.length())));
        }
        return sb.toString();
    }

    public static String randomSpeciesYear() {
        int maxYear = Calendar.getInstance().get(1);
        return String.valueOf(1751 + rnd.nextInt(maxYear - 1751 + 1));
    }

    public static Integer parseInteger(String x) {
        try {
            return Integer.valueOf(x);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Boolean parseBoolean(String x) {
        if ((x = org.apache.commons.lang3.StringUtils.trimToEmpty((String)x).toLowerCase()).equals("true") || x.equals("t") || x.equals("1") || x.equals("yes") || x.equals("y")) {
            return true;
        }
        if (x.equals("false") || x.equals("f") || x.equals("0") || x.equals("no") || x.equals("n")) {
            return false;
        }
        return null;
    }

    public static String unescapeUnicodeChars(String text) {
        if (text == null) {
            return null;
        }
        int i = 0;
        int len = text.length();
        StringBuffer sb = new StringBuffer(len);
        while (i < len) {
            int c;
            block13: {
                if ((c = text.charAt(i++)) == 92 && i < len) {
                    c = text.charAt(i++);
                    try {
                        String hex;
                        if (c == 117 && text.length() >= i + 4) {
                            hex = text.substring(i, i + 4);
                            if (HEX.matcher(hex).find()) {
                                c = (char)Integer.parseInt(hex, 16);
                                i += 4;
                                break block13;
                            }
                            throw new NumberFormatException("No hex value: " + hex);
                        }
                        if (c == 110 && text.length() >= i + 2) {
                            String oct = text.substring(i, i + 2);
                            if (OCT.matcher(oct).find()) {
                                c = (char)Integer.parseInt(oct, 8);
                                i += 2;
                                break block13;
                            }
                            throw new NumberFormatException("No octal value: " + oct);
                        }
                        if (c == 120 && text.length() >= i + 2) {
                            hex = text.substring(i, i + 2);
                            if (HEX.matcher(hex).find()) {
                                c = (char)Integer.parseInt(hex, 16);
                                i += 2;
                                break block13;
                            }
                            throw new NumberFormatException("No hex value: " + hex);
                        }
                        if (c == 114 || c == 110 || c == 116) {
                            c = 32;
                            break block13;
                        }
                        throw new NumberFormatException("No char escape");
                    }
                    catch (NumberFormatException e) {
                        if (c == 110) {
                            c = 32;
                        }
                        c = 92;
                        --i;
                    }
                }
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    public static String joinIfNotNull(String delimiter, Object ... values) {
        return Joiner.on(delimiter).skipNulls().join(values);
    }

    public static Map<String, String> upper(Map<String, String> map) {
        HashMap<String, String> upperMap = Maps.newHashMap();
        for (String k : map.keySet()) {
            String v = map.get(k);
            if (v != null) {
                v = v.trim().toUpperCase();
            }
            upperMap.put(k.toUpperCase(), v);
        }
        return upperMap;
    }

    public static String emptyLowerCase(String x) {
        if (Strings.isNullOrEmpty(x)) {
            return "";
        }
        return x.trim().toLowerCase();
    }

    public static String getStackTrace(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }
}

