/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.utils.file.tabular;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.gbif.utils.file.tabular.SuperCsvFileReader;
import org.gbif.utils.file.tabular.TabularDataFileReader;
import org.supercsv.prefs.CsvPreference;

public class TabularFiles {
    public static TabularDataFileReader<List<String>> newTabularFileReader(InputStream in, char quoteChar, char delimiterChar, String endOfLineSymbols, Charset charset, boolean headerLine) {
        Preconditions.checkNotNull(in, "An InputStream must be provided");
        Preconditions.checkNotNull(charset, "A Charset must be provided");
        return new SuperCsvFileReader(in, quoteChar, delimiterChar, endOfLineSymbols, charset, headerLine);
    }

    public static TabularDataFileReader<List<String>> newTabularFileReader(InputStream in, char delimiterChar, boolean headerLine) {
        return TabularFiles.newTabularFileReader(in, CsvPreference.STANDARD_PREFERENCE.getQuoteChar(), delimiterChar, CsvPreference.STANDARD_PREFERENCE.getEndOfLineSymbols(), Charsets.UTF_8, headerLine);
    }
}

