/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.utils.file.tabular;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import org.gbif.utils.file.tabular.TabularDataFileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.io.CsvListReader;
import org.supercsv.prefs.CsvPreference;

class SuperCsvFileReader
implements TabularDataFileReader<List<String>> {
    private static final Logger LOG = LoggerFactory.getLogger(TabularDataFileReader.class);
    private final CsvListReader csvListReader;
    private final boolean headerLineIncluded;
    private List<String> headerLine;
    private boolean headerLineRead = false;

    SuperCsvFileReader(InputStream in, char quoteChar, char delimiterChar, String endOfLineSymbols, Charset charset, boolean headerLineIncluded) {
        CsvPreference.Builder builder = new CsvPreference.Builder(quoteChar, (int)delimiterChar, endOfLineSymbols).ignoreEmptyLines(true);
        this.csvListReader = new CsvListReader((Reader)new InputStreamReader(in, charset), builder.build());
        this.headerLineIncluded = headerLineIncluded;
        this.headerLineRead = !headerLineIncluded;
    }

    @Override
    public List<String> getHeaderLine() throws IOException {
        if (this.headerLineIncluded && !this.headerLineRead) {
            this.headerLine = this.csvListReader.read();
            this.headerLineRead = true;
        }
        return this.headerLine;
    }

    @Override
    public List<String> read() throws IOException {
        if (this.headerLineRead) {
            return this.csvListReader.read();
        }
        this.headerLine = this.csvListReader.read();
        this.headerLineRead = true;
        return this.csvListReader.read();
    }

    @Override
    public void close() {
        if (this.csvListReader != null) {
            try {
                this.csvListReader.close();
            }
            catch (IOException e) {
                LOG.warn("Exception while closing tabular data file", (Throwable)e);
            }
        }
    }
}

