/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.utils.file.csv;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.gbif.utils.file.CharsetDetection;
import org.gbif.utils.file.UnkownCharsetException;
import org.gbif.utils.file.csv.CSVReader;
import org.gbif.utils.file.csv.UnkownDelimitersException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVReaderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CSVReaderFactory.class);
    private static final String[] POTENTIAL_DELIMITERS = new String[]{",", "\t", ";", "|"};
    private static final int ROWS_TO_INSPECT = 10;

    public static CSVReader build(File source, String delimiter, boolean header) throws IOException {
        return new CSVReader(source, CSVReaderFactory.detectEncoding(source), delimiter, null, (Integer)(header ? 1 : 0));
    }

    public static CSVReader build(File source, String encoding, String delimiter, Character quotes, Integer headerRows) throws IOException {
        return new CSVReader(source, encoding, delimiter, quotes, headerRows);
    }

    public static CSVReader build(File source, String encoding, String delimiter, Integer headerRows) throws IOException {
        return new CSVReader(source, encoding, delimiter, Character.valueOf('\"'), headerRows);
    }

    public static CSVReader build(InputStream stream, String encoding, String delimiter, Character quotes, Integer headerRows) throws IOException {
        return new CSVReader(stream, encoding, delimiter, quotes, headerRows);
    }

    public static CSVReader build(File source, Integer headerRows) throws IOException {
        String encoding = CSVReaderFactory.detectEncoding(source);
        CSVMetadata csvMeta = CSVReaderFactory.extractCsvMetadata(source, encoding);
        return new CSVReader(source, encoding, csvMeta.getDelimiter(), csvMeta.getQuotedBy(), headerRows);
    }

    public static CSVReader build(File source) throws IOException {
        return CSVReaderFactory.build(source, 1);
    }

    public static CSVReader buildTabReader(InputStream stream, String encoding, Integer headerRows) throws IOException {
        return new CSVReader(stream, encoding, "\t", null, headerRows);
    }

    public static CSVReader buildUtf8TabReader(InputStream stream) throws IOException {
        return CSVReaderFactory.buildTabReader(stream, "utf8", 0);
    }

    public static CSVMetadata extractCsvMetadata(File source, String encoding) throws UnkownDelimitersException {
        CSVMetadata csvMetadata = new CSVMetadata();
        int maxColumns = 0;
        for (String delim : POTENTIAL_DELIMITERS) {
            CSVReader reader;
            ArrayList<Character> potentialQuotes = new ArrayList<Character>();
            try {
                reader = CSVReaderFactory.build(source, encoding, delim, null, (Integer)1);
                Character firstChar = CSVReaderFactory.likelyQuoteChar(reader);
                reader.close();
                if (firstChar != null) {
                    potentialQuotes.add(firstChar);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (delim.equals(",")) {
                potentialQuotes.add(Character.valueOf('\"'));
                potentialQuotes.add(Character.valueOf('\''));
                potentialQuotes.add(null);
            } else {
                potentialQuotes.add(null);
                potentialQuotes.add(Character.valueOf('\"'));
                potentialQuotes.add(Character.valueOf('\''));
            }
            for (Character quote : potentialQuotes) {
                try {
                    reader = CSVReaderFactory.build(source, encoding, delim, quote, (Integer)0);
                    int x = CSVReaderFactory.consistentRowSize(reader);
                    if (x > maxColumns) {
                        csvMetadata.setDelimiter(delim);
                        csvMetadata.setQuotedBy(quote);
                        maxColumns = x;
                    }
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (maxColumns < 1) {
            throw new UnkownDelimitersException("Unable to detect field delimiter");
        }
        return csvMetadata;
    }

    private static int consistentRowSize(CSVReader reader) {
        int columns = 0;
        boolean plusMinusOne = false;
        for (int rowNum = 0; reader.hasNext() && rowNum < 10; ++rowNum) {
            String[] row = reader.next();
            if (rowNum == 0) {
                columns = row.length;
            }
            if (Math.abs(columns - row.length) > 1) {
                return -1;
            }
            if (columns == row.length) continue;
            plusMinusOne = true;
        }
        if (plusMinusOne) {
            return columns - 2;
        }
        return columns;
    }

    private static String detectEncoding(File source) throws UnkownCharsetException {
        Charset encoding;
        try {
            encoding = CharsetDetection.detectEncoding(source, 16384);
            if (encoding == null) {
                throw new UnkownCharsetException("Unable to detect the files character encoding");
            }
        }
        catch (IOException e) {
            throw new UnkownCharsetException(e);
        }
        return encoding.displayName();
    }

    private static Character likelyQuoteChar(CSVReader reader) {
        Character quote = null;
        int line = 0;
        block0: while (reader.hasNext() && line < 10) {
            ++line;
            String[] row = reader.next();
            if (row == null) continue;
            for (String col : row) {
                if (col == null || col.length() <= 0 || col.length() <= 1 || col.charAt(0) != col.charAt(col.length() - 1)) continue;
                char potQuote = col.charAt(0);
                if (Character.isLetterOrDigit(potQuote)) continue block0;
                if (quote == null) {
                    quote = Character.valueOf(potQuote);
                    continue;
                }
                if (quote.equals(Character.valueOf(potQuote))) continue;
                quote = null;
                continue block0;
            }
        }
        return quote;
    }

    public static class CSVMetadata {
        String delimiter;
        Character quotedBy;

        public String getDelimiter() {
            return this.delimiter;
        }

        public void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        public Character getQuotedBy() {
            return this.quotedBy;
        }

        public void setQuotedBy(Character quotedBy) {
            this.quotedBy = quotedBy;
        }
    }
}

