/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.utils.collection;

import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CompactHashSet<T>
extends AbstractSet<T> {
    protected static final int INITIAL_SIZE = 3;
    protected static final double LOAD_FACTOR = 0.75;
    protected static final Object nullObject = new Object();
    protected static final Object deletedObject = new Object();
    protected int elements;
    protected int freecells;
    protected Object[] objects;
    protected int modCount;

    public CompactHashSet() {
        this.objects = new Object[3];
        this.elements = 0;
        this.freecells = this.objects.length;
        this.modCount = 0;
    }

    public CompactHashSet(Collection c) {
        this(c.size());
        this.addAll(c);
    }

    public CompactHashSet(int size) {
        this.objects = new Object[size == 0 ? 1 : size];
        this.elements = 0;
        this.freecells = this.objects.length;
        this.modCount = 0;
    }

    @Override
    public boolean add(T x) {
        Object o = x;
        if (o == null) {
            o = nullObject;
        }
        int hash = o.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.objects.length;
        int offset = 1;
        int deletedix = -1;
        while (!(this.objects[index] == null || this.objects[index].hashCode() == hash && this.objects[index].equals(o))) {
            if (this.objects[index] == deletedObject) {
                deletedix = index;
            }
            index = (index + offset & Integer.MAX_VALUE) % this.objects.length;
            if ((offset = offset * 2 + 1) != -1) continue;
            offset = 2;
        }
        if (this.objects[index] == null) {
            if (deletedix != -1) {
                index = deletedix;
            } else {
                --this.freecells;
            }
            ++this.modCount;
            ++this.elements;
            this.objects[index] = o;
            if (1.0 - (double)this.freecells / (double)this.objects.length > 0.75) {
                this.rehash(this.objects.length);
                if (1.0 - (double)this.freecells / (double)this.objects.length > 0.75) {
                    this.rehash(this.objects.length * 2 + 1);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.elements = 0;
        for (int ix = 0; ix < this.objects.length; ++ix) {
            this.objects[ix] = null;
        }
        this.freecells = this.objects.length;
        ++this.modCount;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            o = nullObject;
        }
        int hash = o.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.objects.length;
        int offset = 1;
        while (!(this.objects[index] == null || this.objects[index].hashCode() == hash && this.objects[index].equals(o))) {
            index = (index + offset & Integer.MAX_VALUE) % this.objects.length;
            if ((offset = offset * 2 + 1) != -1) continue;
            offset = 2;
        }
        return this.objects[index] != null;
    }

    public void dump() {
        System.out.println("Size: " + this.objects.length);
        System.out.println("Elements: " + this.elements);
        System.out.println("Free cells: " + this.freecells);
        System.out.println();
        for (int ix = 0; ix < this.objects.length; ++ix) {
            System.out.println("[" + ix + "]: " + this.objects[ix]);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.elements == 0;
    }

    @Override
    public Iterator iterator() {
        return new CompactHashIterator();
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.objects.length;
        Object[] newObjects = new Object[newCapacity];
        for (int ix = 0; ix < oldCapacity; ++ix) {
            Object o = this.objects[ix];
            if (o == null || o == deletedObject) continue;
            int hash = o.hashCode();
            int index = (hash & Integer.MAX_VALUE) % newCapacity;
            int offset = 1;
            while (newObjects[index] != null) {
                index = (index + offset & Integer.MAX_VALUE) % newCapacity;
                if ((offset = offset * 2 + 1) != -1) continue;
                offset = 2;
            }
            newObjects[index] = o;
        }
        this.objects = newObjects;
        this.freecells = this.objects.length - this.elements;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            o = nullObject;
        }
        int hash = o.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.objects.length;
        int offset = 1;
        while (!(this.objects[index] == null || this.objects[index].hashCode() == hash && this.objects[index].equals(o))) {
            index = (index + offset & Integer.MAX_VALUE) % this.objects.length;
            if ((offset = offset * 2 + 1) != -1) continue;
            offset = 2;
        }
        if (this.objects[index] != null) {
            this.objects[index] = deletedObject;
            ++this.modCount;
            --this.elements;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.elements;
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.elements];
        Object[] objects = this.objects;
        int pos = 0;
        for (Object object : objects) {
            if (object == null || object == deletedObject) continue;
            result[pos++] = object == nullObject ? null : object;
        }
        return result;
    }

    @Override
    public Object[] toArray(Object[] a) {
        int size = this.elements;
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        Object[] objects = this.objects;
        int pos = 0;
        for (Object object : objects) {
            if (object == null || object == deletedObject) continue;
            a[pos++] = object == nullObject ? null : object;
        }
        return a;
    }

    private class CompactHashIterator
    implements Iterator<T> {
        private int index = 0;
        private int lastReturned = -1;
        private int expectedModCount;

        CompactHashIterator() {
            while (this.index < CompactHashSet.this.objects.length && (CompactHashSet.this.objects[this.index] == null || CompactHashSet.this.objects[this.index] == deletedObject)) {
                ++this.index;
            }
            this.expectedModCount = CompactHashSet.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.index < CompactHashSet.this.objects.length;
        }

        @Override
        public T next() {
            if (CompactHashSet.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            int length = CompactHashSet.this.objects.length;
            if (this.index >= length) {
                this.lastReturned = -2;
                throw new NoSuchElementException();
            }
            this.lastReturned = this.index++;
            while (this.index < length && (CompactHashSet.this.objects[this.index] == null || CompactHashSet.this.objects[this.index] == deletedObject)) {
                ++this.index;
            }
            if (CompactHashSet.this.objects[this.lastReturned] == nullObject) {
                return null;
            }
            return CompactHashSet.this.objects[this.lastReturned];
        }

        @Override
        public void remove() {
            if (CompactHashSet.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastReturned == -1 || this.lastReturned == -2) {
                throw new IllegalStateException();
            }
            if (CompactHashSet.this.objects[this.lastReturned] != null && CompactHashSet.this.objects[this.lastReturned] != deletedObject) {
                CompactHashSet.this.objects[this.lastReturned] = deletedObject;
                --CompactHashSet.this.elements;
                ++CompactHashSet.this.modCount;
                this.expectedModCount = CompactHashSet.this.modCount;
            }
        }
    }
}

