/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.analysis.layers;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.layers.intersect.SimpleRegion;
import au.org.ala.spatial.analysis.layers.Records;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.util.ByteArrayBuilder;

public class LayersServiceRecords
extends Records {
    public LayersServiceRecords(String biocache_service_url, String q, double[] bbox, String filename, SimpleRegion region) throws IOException {
        super(biocache_service_url, q, bbox, filename, region);
    }

    public LayersServiceRecords(String biocache_service_url, String q, double[] bbox, String filename, SimpleRegion region, String facetField) throws IOException {
        super(biocache_service_url, q, bbox, filename, region, facetField);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void init(String biocache_service_url, String q, double[] bbox, String filename, SimpleRegion region, String facetField) throws IOException {
        int speciesEstimate = 250000;
        int recordsEstimate = 26000000;
        int pageSize = 50000;
        if (bbox == null) {
            bbox = new double[]{-180.0, -90.0, 180.0, 90.0};
        }
        String bboxTerm = String.format("longitude:%%5B%f%%20TO%%20%f%%5D%%20AND%%20latitude:%%5B%f%%20TO%%20%f%%5D", bbox[0], bbox[2], bbox[1], bbox[3]);
        this.points = new ArrayList(recordsEstimate);
        this.lsidIdx = new ArrayList(recordsEstimate);
        this.years = new ArrayList(recordsEstimate);
        HashMap<String, Integer> lsidMap = new HashMap<String, Integer>(speciesEstimate);
        int start = 0;
        RandomAccessFile raf = null;
        if (filename != null) {
            raf = new RandomAccessFile(filename, "rw");
        }
        while (start < 300000000) {
            String[] line;
            String url = biocache_service_url + "/userdata/sample?q=" + q;
            System.out.println("url: " + url);
            CSVReader csv = null;
            try {
                int n;
                InputStream is = LayersServiceRecords.getUrlStream(url);
                ZipInputStream zis = new ZipInputStream(is);
                ZipEntry ze = zis.getNextEntry();
                ByteArrayBuilder bab = new ByteArrayBuilder();
                byte[] b = new byte[1024];
                while ((n = zis.read(b, 0, 1024)) > 0) {
                    bab.write(b, 0, n);
                }
                csv = new CSVReader((Reader)new StringReader(IOUtils.toString((byte[])bab.toByteArray(), (String)"UTF-8")));
                is.close();
            }
            catch (Exception e) {
                System.out.println("failed to get userdata as csv for url: " + url);
                e.printStackTrace();
            }
            if (csv == null) {
                throw new IOException("failed to get records from layers-service.");
            }
            int[] header = new int[2];
            int row = start;
            int currentCount = 0;
            while ((line = csv.readNext()) != null) {
                if (raf != null) {
                    for (int i = 0; i < line.length; ++i) {
                        if (i > 0) {
                            raf.write(",".getBytes());
                        }
                        raf.write(line[i].getBytes());
                    }
                    raf.write("\n".getBytes());
                }
                if (++currentCount == 1) {
                    for (int i = 0; i < line.length; ++i) {
                        if (line[i].equals("longitude")) {
                            header[0] = i;
                        }
                        if (!line[i].equals("latitude")) continue;
                        header[1] = i;
                    }
                    System.out.println("header info:" + header[0] + "," + header[1]);
                } else if (line.length >= 3) {
                    try {
                        double longitude = Double.parseDouble(line[header[0]]);
                        double latitude = Double.parseDouble(line[header[1]]);
                        if (region == null || region.isWithin_EPSG900913(longitude, latitude)) {
                            this.points.add(longitude);
                            this.points.add(latitude);
                            String species = "default";
                            Integer idx = (Integer)lsidMap.get(species);
                            if (idx == null) {
                                idx = lsidMap.size();
                                lsidMap.put(species, idx);
                            }
                            this.lsidIdx.add(idx);
                            this.years.add((short)0);
                        }
                    }
                    catch (Exception e) {
                    }
                    finally {
                        if (this.lsidIdx.size() * 2 < this.points.size()) {
                            this.points.remove(this.points.size() - 1);
                            this.points.remove(this.points.size() - 1);
                        } else if (this.years.size() < this.lsidIdx.size()) {
                            this.years.add((short)0);
                        }
                    }
                }
                ++row;
            }
            start = start == 0 ? row - 1 : row;
            csv.close();
            if (currentCount != 0 && currentCount >= pageSize) continue;
            break;
        }
        if (raf != null) {
            raf.close();
        }
        this.lsids = new String[lsidMap.size()];
        for (Map.Entry e : lsidMap.entrySet()) {
            this.lsids[((Integer)e.getValue()).intValue()] = (String)e.getKey();
        }
        System.out.println("Got " + this.getRecordsSize() + " records of " + this.getSpeciesSize() + " species");
    }
}

