/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.tabulation;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.WKTReader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.GeometryBuilder;
import org.geotools.graph.util.ZipUtil;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class Intersection {
    private static LinkedBlockingQueue<String> lbqWriter = new LinkedBlockingQueue();

    public static void main(String[] args) {
        System.out.println("produces a shapefile with the intersection.\r\nusage: shapefile1 shapefile2 outputShapefile");
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add(args[1]);
        Intersection.intersectShapefiles(args[0], list2, args[2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void intersectionZipToShapefile(File intersectionZip, File shapeFile) {
        try {
            String id1;
            ZipInputStream zis = new ZipInputStream(new FileInputStream(intersectionZip));
            ZipEntry ze = zis.getNextEntry();
            InputStreamReader isr = new InputStreamReader(zis);
            BufferedReader br = new BufferedReader(isr);
            SimpleFeatureType type = Intersection.createFeatureType();
            ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
            SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(type);
            while ((id1 = br.readLine()) != null) {
                String id2 = br.readLine();
                WKTReader wktReader = new WKTReader();
                String wkt = br.readLine();
                Geometry geom = wktReader.read(wkt);
                if (geom instanceof Polygon) {
                    geom = new GeometryBuilder().multiPolygon(new Polygon[]{(Polygon)geom});
                }
                featureBuilder.add((Object)geom);
                SimpleFeature feature = featureBuilder.buildFeature(null);
                feature.setAttribute("id1", (Object)id1);
                feature.setAttribute("id2", (Object)id2);
                feature.setDefaultGeometry((Object)geom);
                features.add(feature);
            }
            ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
            HashMap<String, Serializable> params = new HashMap<String, Serializable>();
            params.put("url", shapeFile.toURI().toURL());
            params.put("create spatial index", Boolean.TRUE);
            ShapefileDataStore newDataStore = (ShapefileDataStore)dataStoreFactory.createNewDataStore(params);
            newDataStore.createSchema(type);
            newDataStore.forceSchemaCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            DefaultTransaction transaction = new DefaultTransaction("create");
            String typeName = newDataStore.getTypeNames()[0];
            ContentFeatureSource featureSource = newDataStore.getFeatureSource(typeName);
            if (featureSource instanceof SimpleFeatureStore) {
                SimpleFeatureStore featureStore = (SimpleFeatureStore)featureSource;
                DefaultFeatureCollection collection = new DefaultFeatureCollection();
                collection.addAll(features);
                featureStore.setTransaction((Transaction)transaction);
                try {
                    featureStore.addFeatures((FeatureCollection)collection);
                    transaction.commit();
                }
                catch (Exception problem) {
                    transaction.rollback();
                }
                finally {
                    transaction.close();
                }
            }
            zis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static SimpleFeatureType createFeatureType() {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("ActiveArea");
        builder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        builder.add("id1", String.class);
        builder.add("id2", String.class);
        builder.add("the_geom", MultiPolygon.class);
        return builder.buildFeatureType();
    }

    static void intersectShapefilesInDir(String shapefileDir, List intersectionFileNames, String outputDir) {
        File f = new File("/data/ala/data/layers/ready/shape/");
        File[] list = f.listFiles();
        Arrays.sort(list, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return (int)(o1.length() - o2.length());
            }
        });
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].getPath().endsWith(".shp")) continue;
            ArrayList<String> files = new ArrayList<String>();
            for (int j = i + 1; j < list.length; ++j) {
                if (!list[j].getPath().endsWith(".shp")) continue;
                File out = new File(outputDir + "/intersection_" + list[i].getName() + "_" + list[j].getName() + ".txt");
                File outZip = new File(outputDir + "/intersection_" + list[i].getName() + "_" + list[j].getName() + ".zip");
                File out2 = new File(outputDir + "/intersection_" + list[j].getName() + "_" + list[i].getName() + ".txt");
                File outZip2 = new File(outputDir + "/intersection_" + list[j].getName() + "_" + list[i].getName() + ".zip");
                if (out.exists() || outZip.exists() || out2.exists() || outZip2.exists()) continue;
                files.add(list[j].getPath());
            }
            Intersection.intersectShapefiles(list[i].getPath(), files, outputDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void intersectShapefiles(String filename1, List filenames2, String outputDir) {
        System.out.println("intersectShapefiles START");
        DataStore dataStore1 = null;
        DataStore dataStore2 = null;
        FeatureIterator iterator1 = null;
        FeatureIterator iterator2 = null;
        try {
            final LinkedBlockingQueue<Object[]> lbq = new LinkedBlockingQueue<Object[]>();
            final AtomicInteger ai = new AtomicInteger(0);
            HashMap<String, URL> map1 = new HashMap<String, URL>();
            map1.put("url", new File(filename1).toURI().toURL());
            dataStore1 = DataStoreFinder.getDataStore(map1);
            String typeName1 = dataStore1.getTypeNames()[0];
            SimpleFeatureSource source1 = dataStore1.getFeatureSource(typeName1);
            iterator1 = source1.getFeatures().features();
            System.out.println(filename1 + ": shape count=" + source1.getCount(Query.ALL));
            int count1 = 0;
            ArrayList<Geometry> geoms1 = new ArrayList<Geometry>();
            ArrayList<String> ids1 = new ArrayList<String>();
            while (iterator1.hasNext()) {
                ++count1;
                SimpleFeature feature1 = (SimpleFeature)iterator1.next();
                Geometry geom1 = (Geometry)feature1.getDefaultGeometry();
                BoundingBox bb = feature1.getBounds();
                int len = geom1.toText().length();
                Geometry[] glist = new Geometry[]{geom1};
                if (len > 1000000) {
                    glist = Intersection.split(geom1, 4, 4);
                }
                for (int n = 0; n < glist.length; ++n) {
                    try {
                        if (!(glist[n].getArea() > 0.0)) continue;
                        geoms1.add(glist[n]);
                        ids1.add(feature1.getID());
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            for (int h = 0; h < filenames2.size(); ++h) {
                long startTime = System.currentTimeMillis();
                File outf = new File(outputDir + "/intersection_" + new File(filename1).getName() + "_" + new File((String)filenames2.get(h)).getName() + ".txt");
                File outZip = new File(outputDir + "/intersection_" + new File(filename1).getName() + "_" + new File((String)filenames2.get(h)).getName() + ".zip");
                try {
                    HashMap<String, URL> map2 = new HashMap<String, URL>();
                    map2.put("url", new File((String)filenames2.get(h)).toURI().toURL());
                    dataStore2 = DataStoreFinder.getDataStore(map2);
                    String typeName2 = dataStore2.getTypeNames()[0];
                    SimpleFeatureSource source2 = dataStore2.getFeatureSource(typeName2);
                    System.out.println((String)filenames2.get(h) + ": shape count=" + source2.getCount(Query.ALL));
                    iterator2 = source2.getFeatures().features();
                    double[] bb2 = new double[4 * source2.getCount(Query.ALL)];
                    String[] id2 = new String[source2.getCount(Query.ALL)];
                    Geometry[] g2 = new Geometry[source2.getCount(Query.ALL)];
                    int i = 0;
                    while (iterator2.hasNext()) {
                        try {
                            SimpleFeature feature2 = (SimpleFeature)iterator2.next();
                            BoundingBox b = feature2.getBounds();
                            bb2[i] = b.getMinX();
                            bb2[i + 1] = b.getMinY();
                            bb2[i + 2] = b.getMaxX();
                            bb2[i + 3] = b.getMaxY();
                            id2[i / 4] = feature2.getID();
                            g2[i / 4] = (Geometry)feature2.getDefaultGeometry();
                            i += 4;
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.out);
                        }
                    }
                    System.out.println("bounding box compare");
                    for (int n = 0; n < geoms1.size(); ++n) {
                        Geometry geom1 = (Geometry)geoms1.get(n);
                        Envelope e = geom1.getEnvelopeInternal();
                        for (int j = 0; j < g2.length; ++j) {
                            int jj = j * 4;
                            if (!(bb2[jj] <= e.getMaxX()) || !(bb2[jj + 2] >= e.getMinX()) || !(bb2[jj + 1] <= e.getMaxY()) || !(bb2[jj + 3] >= e.getMinY())) continue;
                            Object[] newtask = new Object[7];
                            newtask[0] = geom1;
                            newtask[1] = g2[j];
                            newtask[2] = null;
                            newtask[3] = ids1.get(n);
                            newtask[4] = id2[j];
                            lbq.put(newtask);
                        }
                    }
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
                finally {
                    if (iterator2 != null) {
                        iterator2.close();
                    }
                    if (dataStore2 != null) {
                        dataStore2.dispose();
                    }
                }
                System.out.println("comparisons required: " + lbq.size());
                final CountDownLatch cdl = new CountDownLatch(lbq.size());
                final LinkedBlockingQueue outputWriterPool = new LinkedBlockingQueue();
                ArrayList<BufferedWriter> outputWriters = new ArrayList<BufferedWriter>();
                Thread[] threads = new Thread[8];
                for (int j = 0; j < threads.length; ++j) {
                    outputWriters.add(new BufferedWriter(new FileWriter(new File(outf.getPath() + "." + j))));
                    outputWriterPool.put(outputWriters.get(j));
                    threads[j] = new Thread(){

                        @Override
                        public void run() {
                            try {
                                long timePos = System.currentTimeMillis();
                                BufferedWriter bw = (BufferedWriter)outputWriterPool.take();
                                while (true) {
                                    Object[] os = (Object[])lbq.take();
                                    if (lbq.size() % 5000 == 0) {
                                        System.out.print("(" + lbq.size() + ")");
                                    }
                                    Geometry geom1 = (Geometry)((Geometry)os[0]).clone();
                                    Geometry g2 = (Geometry)((Geometry)os[1]).clone();
                                    String id1 = (String)os[3];
                                    String id2 = (String)os[4];
                                    try {
                                        Geometry intersection;
                                        if (geom1.intersects(g2) && (intersection = geom1.intersection(g2)).getArea() > 0.0) {
                                            Intersection.writeIntersection(bw, id1, id2, intersection);
                                            ai.incrementAndGet();
                                        }
                                    }
                                    catch (Exception e) {
                                        Intersection.writeIntersection(bw, id1, id2 + ", error: " + e.getMessage(), null);
                                    }
                                    cdl.countDown();
                                }
                            }
                            catch (InterruptedException e) {
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                cdl.countDown();
                            }
                        }
                    };
                    threads[j].start();
                }
                cdl.await();
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(outf));
                for (int j = 0; j < threads.length; ++j) {
                    threads[j].interrupt();
                    ((BufferedWriter)outputWriters.get(j)).flush();
                    ((BufferedWriter)outputWriters.get(j)).close();
                    File f = new File(outf.getPath() + "." + j);
                    BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
                    byte[] bytes = new byte[1024];
                    int len = 0;
                    while ((len = bis.read(bytes)) > 0) {
                        bos.write(bytes, 0, len);
                    }
                    bis.close();
                    f.delete();
                }
                bos.flush();
                bos.close();
                System.out.println("total time: " + outf.getName() + " = " + (System.currentTimeMillis() - startTime) + "ms");
                try {
                    ZipUtil.zip((String)outZip.getPath(), (String[])new String[]{outf.getPath()});
                    FileUtils.deleteQuietly((File)outf);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (iterator1 != null) {
                iterator1.close();
            }
            if (dataStore1 != null) {
                dataStore1.dispose();
            }
        }
    }

    static void writeIntersection(BufferedWriter bw, String id1, String id2, Geometry g) throws Exception {
        if (g != null) {
            bw.write(id1 + "\n" + id2 + "\n" + g.toText() + "\n");
        } else {
            bw.write(id1 + "\n" + id2 + "\n\n");
        }
    }

    static Geometry[] split(Geometry geom, int xsize, int ysize) {
        Envelope bb = geom.getEnvelopeInternal();
        double[] xs = new double[xsize + 1];
        xs[0] = bb.getMinX();
        for (int i = 1; i < xsize; ++i) {
            xs[i] = bb.getMinX() + (bb.getMaxX() - bb.getMinX()) * (double)i / (double)xsize;
        }
        xs[xsize] = bb.getMaxX();
        double[] ys = new double[ysize + 1];
        ys[0] = bb.getMinY();
        for (int i = 1; i < ysize; ++i) {
            ys[i] = bb.getMinY() + (bb.getMaxY() - bb.getMinY()) * (double)i / (double)ysize;
        }
        ys[ysize] = bb.getMaxY();
        Geometry[] glist = new Geometry[xsize * ysize];
        int gi = 0;
        for (int x = 0; x < xsize; ++x) {
            for (int y = 0; y < ysize; ++y) {
                GeometryBuilder gb = new GeometryBuilder();
                Polygon g = gb.box(xs[x], ys[y], xs[x + 1], ys[y + 1]);
                glist[gi] = g.intersection(geom);
                ++gi;
            }
        }
        return glist;
    }
}

