/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.stats;

import au.org.ala.layers.stats.AreaThread;
import au.org.ala.layers.stats.BboxThread;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;

public class ObjectsStatsGenerator {
    static int CONCURRENT_THREADS = 10;
    static String db_url = "jdbc:postgresql://ala-maps-db.vic.csiro.au:5432/layersdb";
    static String db_usr = "postgres";
    static String db_pwd = "postgres";

    private static Connection getConnection() {
        Connection conn = null;
        try {
            Class.forName("org.postgresql.Driver");
            String url = db_url;
            conn = DriverManager.getConnection(url, db_usr, db_pwd);
        }
        catch (Exception e) {
            System.out.println("Unable to create Connection");
            e.printStackTrace(System.out);
        }
        return conn;
    }

    public static void main(String[] args) {
        long start = System.currentTimeMillis();
        System.out.println("args[0] = threadcount, args[1] = db connection string, args[2] = db username, args[3] = password");
        if (args.length >= 4) {
            CONCURRENT_THREADS = Integer.parseInt(args[0]);
            db_url = args[1];
            db_usr = args[2];
            db_pwd = args[3];
        }
        Connection c = ObjectsStatsGenerator.getConnection();
        String count_sql = "select count(*) as cnt from objects where area_km is null and st_geometrytype(the_geom) <> 'ST_Point' ";
        int count = 0;
        try {
            Statement s = c.createStatement();
            ResultSet rs = s.executeQuery(count_sql);
            while (rs.next()) {
                count = rs.getInt("cnt");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int iter = count / 200000;
        System.out.println("Breaking into " + iter + " iterations");
        for (int i = 0; i <= iter; ++i) {
            long iterStart = System.currentTimeMillis();
            ObjectsStatsGenerator.updateArea();
            System.out.println("iteration " + i + " completed after " + (System.currentTimeMillis() - iterStart) + "ms");
            System.out.println("total time taken is " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    private static void updateBbox() {
        try {
            int j;
            Connection conn = ObjectsStatsGenerator.getConnection();
            String sql = "SELECT pid from objects where bbox is null limit 200000;";
            System.out.println("loading bbox ...");
            Statement s1 = conn.createStatement();
            ResultSet rs1 = s1.executeQuery(sql);
            LinkedBlockingQueue<String[]> data = new LinkedBlockingQueue<String[]>();
            while (rs1.next()) {
                data.put(new String[]{rs1.getString("pid")});
            }
            CountDownLatch cdl = new CountDownLatch(data.size());
            BboxThread[] threads = new BboxThread[CONCURRENT_THREADS];
            for (j = 0; j < CONCURRENT_THREADS; ++j) {
                threads[j] = new BboxThread(data, cdl, ObjectsStatsGenerator.getConnection().createStatement());
                threads[j].start();
            }
            cdl.await();
            for (j = 0; j < CONCURRENT_THREADS; ++j) {
                threads[j].s.close();
                threads[j].interrupt();
            }
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private static void updateArea() {
        try {
            int j;
            Connection conn = ObjectsStatsGenerator.getConnection();
            String sql = "SELECT pid from objects where area_km is null and st_geometrytype(the_geom) <> 'Point' limit 200000;";
            System.out.println("loading area_km ...");
            Statement s1 = conn.createStatement();
            ResultSet rs1 = s1.executeQuery(sql);
            LinkedBlockingQueue<String> data = new LinkedBlockingQueue<String>();
            while (rs1.next()) {
                data.put(rs1.getString("pid"));
            }
            CountDownLatch cdl = new CountDownLatch(data.size());
            AreaThread[] threads = new AreaThread[CONCURRENT_THREADS];
            for (j = 0; j < CONCURRENT_THREADS; ++j) {
                threads[j] = new AreaThread(data, cdl, ObjectsStatsGenerator.getConnection().createStatement());
                threads[j].start();
            }
            cdl.await();
            for (j = 0; j < CONCURRENT_THREADS; ++j) {
                threads[j].s.close();
                threads[j].interrupt();
            }
            rs1.close();
            s1.close();
            conn.close();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

