/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.legend;

import au.org.ala.layers.legend.LegendDecade;
import au.org.ala.layers.legend.LegendEqualArea;
import au.org.ala.layers.legend.LegendObject;
import au.org.ala.layers.legend.QueryField;
import java.util.Arrays;

public class LegendBuilder {
    public static LegendObject build(QueryField qf) {
        switch (qf.getFieldType()) {
            case INT: {
                return LegendBuilder.intLegend(qf);
            }
            case LONG: {
                return LegendBuilder.longLegend(qf);
            }
            case FLOAT: {
                return LegendBuilder.floatLegend(qf);
            }
            case DOUBLE: {
                return LegendBuilder.doubleLegend(qf);
            }
        }
        return LegendBuilder.stringLegend(qf);
    }

    private static LegendObject intLegend(QueryField qf) {
        int[] raw = qf.intData;
        double[] d = new double[raw.length];
        for (int i = 0; i < raw.length; ++i) {
            d[i] = raw[i] == Integer.MIN_VALUE ? Double.NaN : (double)raw[i];
        }
        return LegendBuilder.legendFromDoubles(d, qf);
    }

    public static LegendObject legendFromDoubles(double[] d, QueryField qf) {
        Arrays.sort(d);
        float[] f = new float[d.length];
        for (int i = 0; i < d.length; ++i) {
            f[i] = (float)d[i];
        }
        LegendEqualArea legend = new LegendEqualArea();
        legend.generate(f);
        legend.determineGroupSizes(f);
        return new LegendObject(legend, qf.getFieldType());
    }

    public static LegendObject legendForDecades(double[] d, QueryField qf) {
        LegendDecade legend = new LegendDecade();
        Arrays.sort(d);
        float[] f = new float[d.length];
        for (int i = 0; i < d.length; ++i) {
            f[i] = (float)d[i];
        }
        legend.generate(f);
        return new LegendObject(legend, qf.getFieldType());
    }

    private static LegendObject longLegend(QueryField qf) {
        long[] raw = qf.longData;
        double[] d = new double[raw.length];
        for (int i = 0; i < raw.length; ++i) {
            d[i] = raw[i] == Long.MIN_VALUE ? Double.NaN : (double)raw[i];
        }
        return LegendBuilder.legendFromDoubles(d, qf);
    }

    private static LegendObject floatLegend(QueryField qf) {
        float[] raw = qf.floatData;
        double[] d = new double[raw.length];
        for (int i = 0; i < raw.length; ++i) {
            d[i] = raw[i];
        }
        return LegendBuilder.legendFromDoubles(d, qf);
    }

    private static LegendObject doubleLegend(QueryField qf) {
        double[] raw = qf.doubleData;
        double[] d = new double[raw.length];
        for (int i = 0; i < raw.length; ++i) {
            d[i] = raw[i];
        }
        return LegendBuilder.legendFromDoubles(d, qf);
    }

    private static LegendObject stringLegend(QueryField qf) {
        return new LegendObject(qf.stringData, qf.stringCounts);
    }
}

