/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.intersect;

import au.org.ala.layers.intersect.ComplexRegion;
import au.org.ala.layers.intersect.ShapeRecords;
import java.io.Serializable;
import java.util.ArrayList;

class ShapesReference
implements Serializable {
    ArrayList<Integer>[][] mask;
    int mask_dimension;
    double mask_long_multiplier;
    double mask_lat_multiplier;
    double[][] boundingbox_all;
    ShapeRecords sr;

    public ShapesReference(ShapeRecords sr_) {
        this.sr = sr_;
        this.boundingbox_all = new double[2][2];
        this.mask_dimension = (int)Math.sqrt(this.sr.getNumberOfRecords());
        if (this.mask_dimension < 3) {
            this.mask = null;
            return;
        }
        this.mask = new ArrayList[this.mask_dimension][this.mask_dimension];
        boolean first_time = true;
        for (ComplexRegion s : sr_.getRegions()) {
            double[][] bb = s.getBoundingBox();
            if (first_time || this.boundingbox_all[0][0] > bb[0][0]) {
                this.boundingbox_all[0][0] = bb[0][0];
            }
            if (first_time || this.boundingbox_all[1][0] < bb[1][0]) {
                this.boundingbox_all[1][0] = bb[1][0];
            }
            if (first_time || this.boundingbox_all[0][1] > bb[0][1]) {
                this.boundingbox_all[0][1] = bb[0][1];
            }
            if (first_time || this.boundingbox_all[1][1] < bb[1][1]) {
                this.boundingbox_all[1][1] = bb[1][1];
            }
            first_time = false;
        }
        ArrayList<ComplexRegion> sra = this.sr.getRegions();
        for (int j = 0; j < sra.size(); ++j) {
            ComplexRegion s = sra.get(j);
            int[][] map = s.getOverlapGridCells_Box(this.boundingbox_all[0][0], this.boundingbox_all[0][1], this.boundingbox_all[1][0], this.boundingbox_all[1][1], this.mask_dimension, this.mask_dimension, s.getBoundingBox(), null, false);
            for (int i = 0; i < map.length; ++i) {
                if (this.mask[map[i][0]][map[i][1]] == null) {
                    this.mask[map[i][0]][map[i][1]] = new ArrayList();
                }
                this.mask[map[i][0]][map[i][1]].add(j);
            }
        }
        this.mask_long_multiplier = (double)this.mask_dimension / (this.boundingbox_all[1][0] - this.boundingbox_all[0][0]);
        this.mask_lat_multiplier = (double)this.mask_dimension / (this.boundingbox_all[1][1] - this.boundingbox_all[0][1]);
    }

    public int intersection(double longitude, double latitude) {
        block3: {
            ArrayList<ComplexRegion> sra;
            block2: {
                sra = this.sr.getRegions();
                if (this.mask == null) break block2;
                int long1 = (int)Math.floor((longitude - this.boundingbox_all[0][0]) * this.mask_long_multiplier);
                int lat1 = (int)Math.floor((latitude - this.boundingbox_all[0][1]) * this.mask_lat_multiplier);
                if (long1 < 0 || long1 >= this.mask[0].length || lat1 < 0 || lat1 >= this.mask.length || this.mask[long1][lat1] == null) break block3;
                ArrayList<Integer> ali = this.mask[long1][lat1];
                for (int i = 0; i < ali.size(); ++i) {
                    if (!sra.get(ali.get(i)).isWithin(longitude, latitude)) continue;
                    return ali.get(i);
                }
                break block3;
            }
            for (int i = 0; i < sra.size(); ++i) {
                if (!sra.get(i).isWithin(longitude, latitude)) continue;
                return i;
            }
        }
        return -1;
    }
}

