/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.intersect;

import java.io.FileInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

class ShapeHeader
implements Serializable {
    static final long serialVersionUID = 1219127870707511387L;
    int filecode;
    int filelength;
    int version;
    int shapetype;
    double[] boundingbox;
    boolean isvalid;

    public ShapeHeader(String fileprefix) {
        try {
            FileInputStream fis = new FileInputStream(fileprefix + ".shp");
            FileChannel fc = fis.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate(1024);
            fc.read(buffer);
            buffer.flip();
            buffer.order(ByteOrder.BIG_ENDIAN);
            this.filecode = buffer.getInt();
            buffer.getInt();
            buffer.getInt();
            buffer.getInt();
            buffer.getInt();
            buffer.getInt();
            this.filelength = buffer.getInt();
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            this.version = buffer.getInt();
            this.shapetype = buffer.getInt();
            this.boundingbox = new double[8];
            for (int i = 0; i < 8; ++i) {
                this.boundingbox[i] = buffer.getDouble();
            }
            fis.close();
            this.isvalid = true;
        }
        catch (Exception e) {
            System.out.println("loading header error: " + fileprefix + ": " + e.toString());
            e.printStackTrace();
        }
    }

    public int getShapeType() {
        return this.shapetype;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\r\nFile Code: \r\n");
        sb.append(String.valueOf(this.filecode));
        sb.append("\r\nFile Length: \r\n");
        sb.append(String.valueOf(this.filelength));
        sb.append("\r\nVersion: \r\n");
        sb.append(String.valueOf(this.version));
        sb.append("\r\nShape Type: \r\n");
        sb.append(String.valueOf(this.shapetype));
        int i = 0;
        sb.append("\r\nXmin: \r\n");
        sb.append(String.valueOf(this.boundingbox[i++]));
        sb.append("\r\nYmin: \r\n");
        sb.append(String.valueOf(this.boundingbox[i++]));
        sb.append("\r\nXmax: \r\n");
        sb.append(String.valueOf(this.boundingbox[i++]));
        sb.append("\r\nYmax: \r\n");
        sb.append(String.valueOf(this.boundingbox[i++]));
        sb.append("\r\nZmin: \r\n");
        sb.append(String.valueOf(this.boundingbox[i++]));
        sb.append("\r\nZmax: \r\n");
        sb.append(String.valueOf(this.boundingbox[i++]));
        sb.append("\r\nMmin: \r\n");
        sb.append(String.valueOf(this.boundingbox[i++]));
        sb.append("\r\nMmax: \r\n");
        sb.append(String.valueOf(this.boundingbox[i++]));
        return sb.toString();
    }

    public boolean isValid() {
        return this.isvalid;
    }
}

