/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.dao;

import au.org.ala.layers.dao.TaskDAO;
import au.org.ala.layers.dto.Task;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.simple.ParameterizedBeanPropertyRowMapper;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="taskDao")
public class TaskDAOImpl
implements TaskDAO {
    private static final Logger logger = Logger.getLogger(TaskDAOImpl.class);
    private SimpleJdbcTemplate jdbcTemplate;
    private SimpleJdbcInsert insertTask;

    @Resource(name="dataSource")
    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
        this.insertTask = new SimpleJdbcInsert(dataSource).withTableName("task").usingColumns(new String[]{"name", "json", "size"});
    }

    @Override
    public List<Task> getTasks(int page, int pageSize, int minSize, int maxSize, boolean includeFinished, boolean includeStarted) {
        String sql = "SELECT * FROM task WHERE size >= " + minSize + " AND size <= " + maxSize + (!includeFinished ? " AND finished is NULL " : " ") + (!includeStarted ? " AND started is NULL " : " ") + " ORDER BY created " + " LIMIT " + pageSize + " OFFSET " + page;
        System.out.println(sql);
        return this.jdbcTemplate.query(sql, (ParameterizedRowMapper)ParameterizedBeanPropertyRowMapper.newInstance(Task.class), new Object[0]);
    }

    @Override
    @Transactional
    public synchronized void addTask(String name, String json, Integer size) {
        if (this.jdbcTemplate.queryForInt("select count(*) from task where name = '" + name + "' and " + (json == null ? " json = '' " : " json = '" + json + "' ") + " and started is null ", new Object[0]) == 0) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("name", name);
            m.put("json", json);
            m.put("size", size);
            this.insertTask.execute(m);
        }
    }

    @Override
    public synchronized boolean startTask(int id) {
        if (this.jdbcTemplate.queryForInt("select count(*) from task where id = " + id + " AND started is NULL", new Object[0]) > 0) {
            String sql = "UPDATE task SET started = CURRENT_TIMESTAMP WHERE id = " + id + " AND started is NULL";
            this.jdbcTemplate.update(sql, new Object[0]);
            return true;
        }
        return false;
    }

    @Override
    public void endTask(int id, String error) {
        if (error != null && error.length() > 0) {
            String sql = "UPDATE task SET finished = CURRENT_TIMESTAMP , error = ?  WHERE id = " + id;
            this.jdbcTemplate.update(sql, new Object[]{error});
        } else {
            String sql = "UPDATE task SET finished = CURRENT_TIMESTAMP  WHERE id = " + id;
            this.jdbcTemplate.update(sql, new Object[0]);
        }
    }

    @Override
    public Task getNextTask(int maxSize) {
        List<Task> tasks = this.getTasks(0, 1, -1, maxSize, false, false);
        if (tasks.size() > 0) {
            return tasks.get(0);
        }
        return null;
    }

    @Override
    public void resetStartedTasks() {
        String sql = "UPDATE task SET started = null WHERE started is not null AND finished is null";
        this.jdbcTemplate.update(sql, new Object[0]);
    }
}

