/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.dao;

import au.org.ala.layers.dao.DistributionDAO;
import au.org.ala.layers.dto.Distribution;
import au.org.ala.layers.dto.Facet;
import au.org.ala.layers.intersect.IntersectConfig;
import au.org.ala.layers.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.simple.ParameterizedBeanPropertyRowMapper;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Service;

@Service(value="distributionDao")
public class DistributionDAOImpl
implements DistributionDAO {
    private static final Logger logger = Logger.getLogger(DistributionDAOImpl.class);
    private final String SELECT_CLAUSE = "select gid,spcode,scientific,authority_,common_nam,\"family\",genus_name,specific_n,min_depth,max_depth,pelagic_fl,coastal_fl,desmersal_fl,estuarine_fl,family_lsid,genus_lsid,caab_species_number,caab_family_number,group_name,metadata_u,wmsurl,lsid,type,area_name,pid,checklist_name,area_km,notes,geom_idx,image_quality,data_resource_uid,endemic";
    private SimpleJdbcTemplate jdbcTemplate;
    private String viewName = "distributions";
    private DataSource dataSource;

    @Override
    public Distribution findDistributionByLSIDOrName(String lsidOrName, String type) {
        List<Distribution> ds = this.findDistributionsByLSIDOrName(lsidOrName, type);
        if (ds != null && ds.size() > 0) {
            return ds.get(0);
        }
        return null;
    }

    @Override
    public List<Distribution> findDistributionsByLSIDOrName(String lsidOrName, String type) {
        String sql = "select gid,spcode,scientific,authority_,common_nam,\"family\",genus_name,specific_n,min_depth,max_depth,pelagic_fl,coastal_fl,desmersal_fl,estuarine_fl,family_lsid,genus_lsid,caab_species_number,caab_family_number,group_name,metadata_u,wmsurl,lsid,type,area_name,pid,checklist_name,area_km,notes,geom_idx,image_quality,data_resource_uid,endemic from " + this.viewName + " WHERE " + "(lsid=:lsid OR caab_species_number=:caab_species_number " + "OR scientific like :scientificName OR scientific like :scientificNameWithSubgenus) AND type = :distribution_type limit 1";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("lsid", lsidOrName);
        params.put("scientificName", lsidOrName);
        params.put("scientificNameWithSubgenus", this.removeSubGenus(lsidOrName));
        params.put("caab_species_number", lsidOrName);
        params.put("distribution_type", type);
        List<Distribution> ds = this.updateWMSUrl(this.jdbcTemplate.query(sql, (ParameterizedRowMapper)ParameterizedBeanPropertyRowMapper.newInstance(Distribution.class), params));
        return ds;
    }

    private String removeSubGenus(String str) {
        if (str != null && str.contains("(") && str.contains(")")) {
            return str.replaceAll(" \\([A-Z][a-z]{1,}\\) ", " ");
        }
        return str;
    }

    @Override
    public List<Distribution> queryDistributions(String wkt, double min_depth, double max_depth, Integer geomIdx, String lsids, String type, String[] dataResources, Boolean endemic) {
        return this.queryDistributions(wkt, min_depth, max_depth, null, null, null, null, null, geomIdx, lsids, null, null, null, null, type, dataResources, endemic);
    }

    @Override
    public List<Distribution> queryDistributions(String wkt, double min_depth, double max_depth, Boolean pelagic, Boolean coastal, Boolean estuarine, Boolean desmersal, String groupName, Integer geomIdx, String lsids, String[] families, String[] familyLsids, String[] genera, String[] generaLsids, String type, String[] dataResources, Boolean endemic) {
        logger.info((Object)"Getting distributions list");
        StringBuilder whereClause = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.constructWhereClause(min_depth, max_depth, pelagic, coastal, estuarine, desmersal, groupName, geomIdx, lsids, families, familyLsids, genera, generaLsids, type, dataResources, params, whereClause, endemic);
        if (wkt != null && wkt.length() > 0) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("ST_INTERSECTS(the_geom, ST_GEOMFROMTEXT( :wkt , 4326))");
            params.put("wkt", wkt);
        }
        String sql = "select gid,spcode,scientific,authority_,common_nam,\"family\",genus_name,specific_n,min_depth,max_depth,pelagic_fl,coastal_fl,desmersal_fl,estuarine_fl,family_lsid,genus_lsid,caab_species_number,caab_family_number,group_name,metadata_u,wmsurl,lsid,type,area_name,pid,checklist_name,area_km,notes,geom_idx,image_quality,data_resource_uid,endemic from " + this.viewName;
        if (whereClause.length() > 0) {
            sql = sql + " WHERE " + whereClause.toString();
        }
        return this.updateWMSUrl(this.jdbcTemplate.query(sql, (ParameterizedRowMapper)ParameterizedBeanPropertyRowMapper.newInstance(Distribution.class), params));
    }

    @Override
    public List<Facet> queryDistributionsFamilyCounts(String wkt, double min_depth, double max_depth, Boolean pelagic, Boolean coastal, Boolean estuarine, Boolean desmersal, String groupName, Integer geomIdx, String lsids, String[] families, String[] familyLsids, String[] genera, String[] generaLsids, String type, String[] dataResources, Boolean endemic) {
        logger.info((Object)"Getting distributions list - family counts");
        StringBuilder whereClause = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.constructWhereClause(min_depth, max_depth, pelagic, coastal, estuarine, desmersal, groupName, geomIdx, lsids, families, familyLsids, genera, generaLsids, type, dataResources, params, whereClause, endemic);
        if (wkt != null && wkt.length() > 0) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("ST_INTERSECTS(the_geom, ST_GEOMFROMTEXT( :wkt , 4326))");
            params.put("wkt", wkt);
        }
        String sql = "Select family as name, count(*) as count from " + this.viewName;
        if (whereClause.length() > 0) {
            sql = sql + " WHERE " + whereClause.toString();
        }
        sql = sql + " group by family";
        return this.jdbcTemplate.query(sql, (ParameterizedRowMapper)ParameterizedBeanPropertyRowMapper.newInstance(Facet.class), params);
    }

    @Override
    public Distribution getDistributionBySpcode(long spcode, String type, boolean noWkt) {
        String wktTerm = noWkt ? "" : ", ST_AsText(the_geom) AS geometry";
        String sql = "select gid,spcode,scientific,authority_,common_nam,\"family\",genus_name,specific_n,min_depth,max_depth,pelagic_fl,coastal_fl,desmersal_fl,estuarine_fl,family_lsid,genus_lsid,caab_species_number,caab_family_number,group_name,metadata_u,wmsurl,lsid,type,area_name,pid,checklist_name,area_km,notes,geom_idx,image_quality,data_resource_uid,endemic" + wktTerm + ", ST_AsText(bounding_box) as bounding_box FROM " + this.viewName + " WHERE spcode= ? AND type= ?";
        List<Distribution> d = this.updateWMSUrl(this.jdbcTemplate.query(sql, (ParameterizedRowMapper)ParameterizedBeanPropertyRowMapper.newInstance(Distribution.class), new Object[]{(double)spcode, type}));
        if (d.size() > 0) {
            return d.get(0);
        }
        return null;
    }

    public List<Distribution> queryDistributionsByRadius(float longitude, float latitude, float radiusInMetres, double min_depth, double max_depth, Integer geomIdx, String lsids, String[] families, String[] familyLsids, String[] genera, String[] generaLsids, String type, String[] dataResources, Boolean endemic) {
        return this.queryDistributionsByRadius(longitude, latitude, radiusInMetres, min_depth, max_depth, null, null, null, null, null, geomIdx, lsids, families, familyLsids, genera, generaLsids, type, dataResources, endemic);
    }

    @Override
    public List<Distribution> queryDistributionsByRadius(float longitude, float latitude, float radiusInMetres, double min_depth, double max_depth, Boolean pelagic, Boolean coastal, Boolean estuarine, Boolean desmersal, String groupName, Integer geomIdx, String lsids, String[] families, String[] familyLsids, String[] genera, String[] generaLsids, String type, String[] dataResources, Boolean endemic) {
        logger.info((Object)("Getting distributions list with a radius - " + radiusInMetres + "m"));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("radius", this.convertMetresToDecimalDegrees(Float.valueOf(radiusInMetres)));
        params.put("type", type);
        String pointGeom = "POINT(" + longitude + " " + latitude + ")";
        String sql = "select gid,spcode,scientific,authority_,common_nam,\"family\",genus_name,specific_n,min_depth,max_depth,pelagic_fl,coastal_fl,desmersal_fl,estuarine_fl,family_lsid,genus_lsid,caab_species_number,caab_family_number,group_name,metadata_u,wmsurl,lsid,type,area_name,pid,checklist_name,area_km,notes,geom_idx,image_quality,data_resource_uid,endemic from " + this.viewName + " where ST_DWithin(the_geom, ST_GeomFromText('" + pointGeom + "', 4326), :radius)";
        StringBuilder whereClause = new StringBuilder();
        this.constructWhereClause(min_depth, max_depth, pelagic, coastal, estuarine, desmersal, groupName, geomIdx, lsids, families, familyLsids, genera, generaLsids, type, dataResources, params, whereClause, endemic);
        if (whereClause.length() > 0) {
            sql = sql + " AND " + whereClause.toString();
        }
        return this.updateWMSUrl(this.jdbcTemplate.query(sql, (ParameterizedRowMapper)ParameterizedBeanPropertyRowMapper.newInstance(Distribution.class), params));
    }

    @Override
    public List<Facet> queryDistributionsByRadiusFamilyCounts(float longitude, float latitude, float radiusInMetres, double min_depth, double max_depth, Boolean pelagic, Boolean coastal, Boolean estuarine, Boolean desmersal, String groupName, Integer geomIdx, String lsids, String[] families, String[] familyLsids, String[] genera, String[] generaLsids, String type, String[] dataResources, Boolean endemic) {
        logger.info((Object)"Getting distributions list with a radius");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("radius", this.convertMetresToDecimalDegrees(Float.valueOf(radiusInMetres)));
        params.put("type", type);
        String pointGeom = "POINT(" + longitude + " " + latitude + ")";
        String sql = "Select family as name, count(*) as count from " + this.viewName + " where ST_DWithin(the_geom, ST_GeomFromText('" + pointGeom + "', 4326), :radius)";
        StringBuilder whereClause = new StringBuilder();
        this.constructWhereClause(min_depth, max_depth, pelagic, coastal, estuarine, desmersal, groupName, geomIdx, lsids, families, familyLsids, genera, generaLsids, type, dataResources, params, whereClause, endemic);
        if (whereClause.length() > 0) {
            sql = sql + " AND " + whereClause.toString();
        }
        sql = sql + " group by family";
        return this.jdbcTemplate.query(sql, (ParameterizedRowMapper)ParameterizedBeanPropertyRowMapper.newInstance(Facet.class), params);
    }

    @Override
    public List<Distribution> getDistributionByLSID(String[] lsids, String type, boolean noWkt) {
        String wktTerm = noWkt ? "" : ", ST_AsText(the_geom) AS geometry";
        String sql = "select gid,spcode,scientific,authority_,common_nam,\"family\",genus_name,specific_n,min_depth,max_depth,pelagic_fl,coastal_fl,desmersal_fl,estuarine_fl,family_lsid,genus_lsid,caab_species_number,caab_family_number,group_name,metadata_u,wmsurl,lsid,type,area_name,pid,checklist_name,area_km,notes,geom_idx,image_quality,data_resource_uid,endemic" + wktTerm + ", ST_AsText(bounding_box) as bounding_box FROM " + this.viewName + "  WHERE lsid IN (:lsids) AND type = :distribution_type ";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("lsids", Arrays.asList(lsids));
        params.put("distribution_type", type);
        return this.updateWMSUrl(this.jdbcTemplate.query(sql, (ParameterizedRowMapper)ParameterizedBeanPropertyRowMapper.newInstance(Distribution.class), params));
    }

    public Double convertMetresToDecimalDegrees(Float metres) {
        return (double)metres.floatValue() / 1.11 * 1.0E-5;
    }

    private void constructWhereClause(double min_depth, double max_depth, Boolean pelagic, Boolean coastal, Boolean estuarine, Boolean desmersal, String groupName, Integer geomIdx, String lsids, String[] families, String[] familyLsids, String[] genera, String[] generaLsids, String type, String[] dataResources, Map<String, Object> params, StringBuilder where, Boolean endemic) {
        if (geomIdx != null && geomIdx >= 0) {
            where.append(" geom_idx = :geom_idx ");
            params.put("geom_idx", geomIdx);
        }
        if (lsids != null && lsids.length() > 0) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append(":lsids LIKE '% '||lsid||' %'  ");
            params.put("lsids", " " + lsids.replace(",", " ") + " ");
        }
        if (dataResources != null && dataResources.length > 0) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append("data_resource_uid IN (:dataResources) ");
            params.put("dataResources", Arrays.asList(dataResources));
        }
        if (min_depth != -1.0 && max_depth != -1.0) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append("min_depth <= :max_depth AND max_depth >= :min_depth ");
            params.put("max_depth", new Double(max_depth));
            params.put("min_depth", new Double(min_depth));
        } else if (min_depth != -1.0) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append("max_depth >= :min_depth ");
            params.put("min_depth", new Double(min_depth));
        } else if (max_depth != -1.0) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append("min_depth <= :max_depth ");
            params.put("max_depth", new Double(max_depth));
        }
        if (pelagic != null) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            if (pelagic.booleanValue()) {
                where.append("pelagic_fl > 0 ");
            } else {
                where.append("pelagic_fl = 0 ");
            }
        }
        if (coastal != null) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append("coastal_fl = :coastal ");
            params.put("coastal", coastal);
        }
        if (estuarine != null) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append("estuarine_fl = :estuarine ");
            params.put("estuarine", estuarine);
        }
        if (desmersal != null) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append("desmersal_fl = :desmersal ");
            params.put("desmersal", desmersal);
        }
        if (type != null) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append("type = :distribution_type ");
            params.put("distribution_type", type);
        }
        if (groupName != null) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append("group_name = :groupName ");
            params.put("groupName", groupName);
        }
        if (families != null) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append("family IN (:families) ");
            params.put("families", Arrays.asList(families));
        }
        if (familyLsids != null) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append("family_lsid IN (:familyLsids) ");
            params.put("familyLsids", Arrays.asList(familyLsids));
        }
        if (genera != null) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append("genus_name IN (:genera) ");
            params.put("genera", Arrays.asList(genera));
        }
        if (generaLsids != null) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append("genus_lsid IN (:generaLsids) ");
            params.put("generaLsids", Arrays.asList(generaLsids));
        }
        if (endemic != null) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append("endemic= :endemic");
            params.put("endemic", endemic);
        }
    }

    private List<Distribution> updateWMSUrl(List<Distribution> distributions) {
        if (distributions != null) {
            for (Distribution distribution : distributions) {
                if (distribution.getWmsurl() == null) continue;
                if (!distribution.getWmsurl().startsWith("/")) {
                    distribution.setWmsurl(distribution.getWmsurl().replace("<COMMON_GEOSERVER_URL>", IntersectConfig.getGeoserverUrl()));
                    continue;
                }
                distribution.setWmsurl(IntersectConfig.getGeoserverUrl() + distribution.getWmsurl());
            }
        }
        return distributions;
    }

    @Override
    public int getNumberOfVertices(String lsid, String type) {
        return this.jdbcTemplate.queryForInt("SELECT st_npoints(st_collect(ds.the_geom)) from distributionshapes ds join distributiondata dd on dd.geom_idx = ds.id where dd.lsid=? and type=?", new Object[]{lsid, type});
    }

    @Override
    public void store(Distribution d, String source_url) {
        String insertSql;
        String sql = "select id from distributionshapes where id = " + d.getGeom_idx();
        List list = this.jdbcTemplate.queryForList(sql, new Object[0]);
        if (list == null || list.size() == 0) {
            if (d.getGeometry() == null || d.getGeometry().length() == 0) {
                JSONObject jo = JSONObject.fromObject((Object)Util.readUrl(source_url));
                d.setGeometry(jo.getString("geometry"));
            }
            insertSql = "insert into distributionshapes (id, pid, the_geom, name, area_km) values ( ? , ? , st_geomfromtext(?, 4326) , ? , ?);";
            this.jdbcTemplate.update(insertSql, new Object[]{d.getGeom_idx(), d.getPid(), d.getGeometry(), d.getArea_name(), d.getArea_km()});
        }
        if ((list = this.jdbcTemplate.queryForList(sql = "select spcode from distributiondata where spcode = " + d.getSpcode(), new Object[0])) == null || list.size() == 0) {
            insertSql = "INSERT INTO public.distributiondata(            gid, spcode, scientific, authority_, common_nam, family, genus_name,             specific_n, min_depth, max_depth, pelagic_fl, metadata_u, the_geom,             wmsurl, lsid, geom_idx, type, checklist_name, notes, estuarine_fl,             coastal_fl, desmersal_fl, group_name, genus_exemplar, family_exemplar,             caab_species_number, caab_species_url, caab_family_number, caab_family_url,             metadata_uuid, family_lsid, genus_lsid, bounding_box, data_resource_uid,             original_scientific_name, image_quality, the_geom_orig, endemic)    VALUES (?, ?, ?, ?, ?, ?, ?,             ?, ?, ?, ?, ?, ?,             ?, ?, ?, ?, ?, ?, ?,             ?, ?, ?, ?, ?,             ?, ?, ?, ?,             ?, ?, ?, ?, ?,             ?, ?, ?, ?);";
            this.jdbcTemplate.update(insertSql, new Object[]{d.getGid(), d.getSpcode(), d.getScientific(), d.getAuthority_(), d.getCommon_nam(), d.getFamily(), d.getGenus_name(), d.getSpecific_n(), d.getMin_depth(), d.getMax_depth(), d.getPelagic_fl(), d.getMetadata_u(), null, d.getWmsurl().substring(d.getWmsurl().indexOf("/wms?service")), d.getLsid(), d.getGeom_idx(), d.getType(), d.getChecklist_name(), d.getNotes(), d.getEstuarine_fl(), d.getCoastal_fl(), d.getDesmersal_fl(), d.getGroup_name(), null, null, d.getCaab_species_number(), null, d.getCaab_family_number(), null, null, d.getFamily_lsid(), d.getGenus_lsid(), d.getBounding_box(), d.getData_resource_uid(), null, d.getImage_quality(), null, d.getEndemic()});
        }
    }

    @Override
    public Map<String, Double> identifyOutlierPointsForDistribution(String lsid, Map<String, Map<String, Double>> points, String type) {
        HashMap<String, Double> outlierDistances = new HashMap<String, Double>();
        HashMap<String, String> uuidLookup = new HashMap<String, String>();
        try {
            StringBuilder pointsString = new StringBuilder();
            ArrayList<String> uuids = new ArrayList<String>();
            for (String uuid : points.keySet()) {
                Map<String, Double> pointDetails = points.get(uuid);
                if (pointDetails == null) continue;
                Double latitude = pointDetails.get("decimalLatitude");
                Double longitude = pointDetails.get("decimalLongitude");
                if (latitude == null || longitude == null) continue;
                if (pointsString.length() > 0) {
                    pointsString.append(",");
                } else {
                    pointsString.append("MULTIPOINT(");
                }
                pointsString.append(longitude).append(" ").append(latitude);
                uuids.add(uuid);
                uuidLookup.put(longitude + " " + latitude, uuid);
            }
            pointsString.append(")");
            List outlierDistancesQueryResult = this.jdbcTemplate.queryForList("select points.path as id, st_x(points.geom) as x, st_y(points.geom) as y, ST_DISTANCE(points.geom, d.the_geom) as distance from (select geography(st_collect(the_geom)) as the_geom, st_setsrid(st_extent(bounding_box), 4326) as bounding_box from distributions where lsid = ? and type = ? ) d, st_dump(st_setsrid(sT_GeomFromText( ? ), 4326)) points where bounding_box is null or st_intersects(d.bounding_box, points.geom) ", new Object[]{lsid, type, pointsString});
            for (Map queryResultRow : outlierDistancesQueryResult) {
                Double distance = (Double)queryResultRow.get("distance");
                if (!(distance > 0.0)) continue;
                String id = queryResultRow.get("id").toString();
                if (id != null) {
                    id = (String)uuids.get(Integer.parseInt(queryResultRow.get("id").toString().replace("{", "").replace("}", "")) - 1);
                } else {
                    String key = queryResultRow.get("x") + " " + queryResultRow.get("y");
                    id = (String)uuidLookup.get(key);
                    uuidLookup.remove(key);
                }
                if (id == null) {
                    logger.error((Object)("Error fetching uuid for distribution distance with xy: " + queryResultRow.get("x") + " " + queryResultRow.get("y")));
                }
                outlierDistances.put(id, distance);
            }
        }
        catch (EmptyResultDataAccessException ex) {
            throw new IllegalArgumentException("No expert distribution associated with lsid " + lsid, ex);
        }
        return outlierDistances;
    }

    @Resource(name="dataSource")
    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
        this.dataSource = dataSource;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }
}

