/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.tool;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.caches.LocationDAO$;
import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.model.Location;
import au.org.ala.biocache.util.Json$;
import au.org.ala.biocache.util.OptionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

public final class ReloadSampling$
implements Tool {
    public static final ReloadSampling$ MODULE$;
    private final Logger logger;

    static {
        new ReloadSampling$();
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    public Logger logger() {
        return this.logger;
    }

    @Override
    public String cmd() {
        return "load-sampling";
    }

    @Override
    public String desc() {
        return "Re-samples the coordinates in occ table with contents of loc table. This assumes the loc table has been refreshed with more recent sampling data (new layers).";
    }

    @Override
    public void main(String[] args) {
        ObjectRef startKey = new ObjectRef((Object)"");
        ObjectRef endKey = new ObjectRef((Object)"");
        OptionParser parser = new OptionParser(startKey, endKey){
            {
                this.opt("s", "start", "The row key to start with", (Function1<String, BoxedUnit>)new Serializable(this, startKey$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef startKey$1;

                    public final void apply(String s) {
                        this.startKey$1.elem = s;
                    }
                    {
                        this.startKey$1 = startKey$1;
                    }
                });
                this.opt("e", "end", "The row key to end with", (Function1<String, BoxedUnit>)new Serializable(this, endKey$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef endKey$1;

                    public final void apply(String s) {
                        this.endKey$1.elem = s;
                    }
                    {
                        this.endKey$1 = endKey$1;
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            this.logger().info("Starting the import of sample data...");
            IntRef counter = new IntRef(0);
            Config$.MODULE$.persistenceManager().pageOverSelect("occ", (Function2<String, Map<String, String>, Object>)new Serializable(counter){
                public static final long serialVersionUID = 0L;
                private final IntRef counter$1;

                public final boolean apply(String guid, Map<String, String> map) {
                    Tuple3 tuple3;
                    block7: {
                        block4: {
                            block6: {
                                Tuple3 tuple32;
                                Object object;
                                Option<Tuple3<Location, Map<String, String>, Map<String, String>>> point;
                                block5: {
                                    String lat2 = (String)map.getOrElse((Object)"decimalLatitude.p", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    });
                                    String lon2 = (String)map.getOrElse((Object)"decimalLongitude.p", (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    });
                                    if (lat2 == null || lon2 == null) break block4;
                                    point = LocationDAO$.MODULE$.getByLatLon(lat2, lon2);
                                    if (!point.isEmpty()) break block5;
                                    object = BoxedUnit.UNIT;
                                    break block6;
                                }
                                tuple3 = (Tuple3)point.get();
                                if (tuple3 == null) break block7;
                                Location location = (Location)tuple3._1();
                                Map environmentalLayers = (Map)tuple3._2();
                                Map contextualLayers = (Map)tuple3._3();
                                Tuple3 tuple33 = tuple32 = new Tuple3((Object)location, (Object)environmentalLayers, (Object)contextualLayers);
                                Location location2 = (Location)tuple33._1();
                                Map environmentalLayers2 = (Map)tuple33._2();
                                Map contextualLayers2 = (Map)tuple33._3();
                                object = Config$.MODULE$.persistenceManager().put(guid, "occ", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"el.p"), (Object)Json$.MODULE$.toJSON((Map<String, Object>)environmentalLayers2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"cl.p"), (Object)Json$.MODULE$.toJSON((Map<String, Object>)contextualLayers2))}))), false);
                            }
                            ++this.counter$1.elem;
                            if (this.counter$1.elem % 10000 == 0) {
                                ReloadSampling$.MODULE$.logger().info(new StringBuilder().append((Object)"Import of sample data ").append((Object)BoxesRunTime.boxToInteger((int)this.counter$1.elem)).append((Object)" Last key ").append((Object)guid).toString());
                            }
                        }
                        return true;
                    }
                    throw new MatchError((Object)tuple3);
                }
                {
                    this.counter$1 = counter$1;
                }
            }, (String)startKey.elem, (String)endKey.elem, 1000, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"decimalLatitude.p", "decimalLongitude.p"}));
            this.logger().info(new StringBuilder().append((Object)"Import of sampling complete: ").append((Object)BoxesRunTime.boxToInteger((int)counter.elem)).append((Object)"processed").toString());
        }
    }

    private ReloadSampling$() {
        MODULE$ = this;
        Tool$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"ReloadSampling");
    }
}

