/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.tool;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.ObserverCallback;
import au.org.ala.biocache.cmd.IncrementalTool;
import au.org.ala.biocache.cmd.IncrementalTool$class;
import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.dao.OccurrenceDAO;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.persistence.PersistenceManager;
import au.org.ala.biocache.processor.RecordProcessor;
import au.org.ala.biocache.tool.Consumer;
import au.org.ala.biocache.tool.Consumer$;
import au.org.ala.biocache.tool.ProcessRecords$;
import au.org.ala.biocache.util.FileHelper$;
import au.org.ala.biocache.util.OptionParser;
import au.org.ala.biocache.util.StringConsumer;
import java.io.File;
import java.util.concurrent.ArrayBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.actors.Actor;
import scala.actors.Actor$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class ProcessRecords$
implements Tool,
IncrementalTool {
    public static final ProcessRecords$ MODULE$;
    private final OccurrenceDAO occurrenceDAO;
    private final PersistenceManager persistenceManager;
    private final Logger logger;

    static {
        new ProcessRecords$();
    }

    @Override
    public Option<String> getDeleteRowFile(String resourceUid) {
        return IncrementalTool$class.getDeleteRowFile(this, resourceUid);
    }

    @Override
    public Tuple2<Object, Option<String>> hasRowKey(String resourceUid) {
        return IncrementalTool$class.hasRowKey(this, resourceUid);
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    @Override
    public String cmd() {
        return "process";
    }

    @Override
    public String desc() {
        return "Process records (geospatial, taxonomy)";
    }

    public OccurrenceDAO occurrenceDAO() {
        return this.occurrenceDAO;
    }

    public PersistenceManager persistenceManager() {
        return this.persistenceManager;
    }

    public Logger logger() {
        return this.logger;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void main(String[] args) {
        block7: {
            this.logger().info("Starting processing...");
            threads = new IntRef(4);
            startUuid = new ObjectRef((Object)None$.MODULE$);
            endUuid = new ObjectRef((Object)None$.MODULE$);
            checkDeleted = new BooleanRef(false);
            dataResourceUid = new ObjectRef((Object)None$.MODULE$);
            checkRowKeyFile = new BooleanRef(false);
            rowKeyFile = "";
            abortIfNotRowKeyFile = new BooleanRef(false);
            parser = new OptionParser(threads, startUuid, endUuid, checkDeleted, dataResourceUid, checkRowKeyFile, abortIfNotRowKeyFile){
                {
                    this.intOpt("t", "thread", "The number of threads to use", (Function1<Object, BoxedUnit>)new Serializable(this, threads$4){
                        public static final long serialVersionUID = 0L;
                        private final IntRef threads$4;

                        public final void apply(int v) {
                            this.apply$mcVI$sp(v);
                        }

                        public void apply$mcVI$sp(int v) {
                            this.threads$4.elem = v;
                        }
                        {
                            this.threads$4 = threads$4;
                        }
                    });
                    this.opt("s", "start", "The record to start with", (Function1<String, BoxedUnit>)new Serializable(this, startUuid$2){
                        public static final long serialVersionUID = 0L;
                        private final ObjectRef startUuid$2;

                        public final void apply(String v) {
                            this.startUuid$2.elem = new Some((Object)v);
                        }
                        {
                            this.startUuid$2 = startUuid$2;
                        }
                    });
                    this.opt("e", "end", "The record to end with", (Function1<String, BoxedUnit>)new Serializable(this, endUuid$1){
                        public static final long serialVersionUID = 0L;
                        private final ObjectRef endUuid$1;

                        public final void apply(String v) {
                            this.endUuid$1.elem = new Some((Object)v);
                        }
                        {
                            this.endUuid$1 = endUuid$1;
                        }
                    });
                    this.opt("dr", "resource", "The data resource to process", (Function1<String, BoxedUnit>)new Serializable(this, dataResourceUid$1){
                        public static final long serialVersionUID = 0L;
                        private final ObjectRef dataResourceUid$1;

                        public final void apply(String v) {
                            this.dataResourceUid$1.elem = new Some((Object)v);
                        }
                        {
                            this.dataResourceUid$1 = dataResourceUid$1;
                        }
                    });
                    this.booleanOpt("cd", "checkDeleted", "Check deleted records", (Function1<Object, BoxedUnit>)new Serializable(this, checkDeleted$1){
                        public static final long serialVersionUID = 0L;
                        private final BooleanRef checkDeleted$1;

                        public final void apply(boolean v) {
                            this.checkDeleted$1.elem = v;
                        }
                        {
                            this.checkDeleted$1 = checkDeleted$1;
                        }
                    });
                    this.opt("crk", "check for row key file", (Function0<BoxedUnit>)new Serializable(this, checkRowKeyFile$1){
                        public static final long serialVersionUID = 0L;
                        private final BooleanRef checkRowKeyFile$1;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.checkRowKeyFile$1.elem = true;
                        }
                        {
                            this.checkRowKeyFile$1 = checkRowKeyFile$1;
                        }
                    });
                    this.opt("acrk", "abort if no row key file found", (Function0<BoxedUnit>)new Serializable(this, abortIfNotRowKeyFile$1){
                        public static final long serialVersionUID = 0L;
                        private final BooleanRef abortIfNotRowKeyFile$1;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.abortIfNotRowKeyFile$1.elem = true;
                        }
                        {
                            this.abortIfNotRowKeyFile$1 = abortIfNotRowKeyFile$1;
                        }
                    });
                }
            };
            if (!parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) break block7;
            if (!((Option)dataResourceUid.elem).isEmpty() && checkRowKeyFile.elem) {
                var12_11 = this.hasRowKey((String)((Option)dataResourceUid.elem).get());
                if (var12_11 != null) {
                    hasRowKey = var12_11._1$mcZ$sp();
                    retrievedRowKeyFile = (Option)var12_11._2();
                    var11_15 = var15_14 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)hasRowKey), (Object)retrievedRowKeyFile);
                    hasRowKey = var11_15._1$mcZ$sp();
                    retrievedRowKeyFile = (Option)var11_15._2();
                    rowKeyFile = (String)retrievedRowKeyFile.getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "";
                        }
                    });
                } else {
                    throw new MatchError(var12_11);
                }
            }
            if (!abortIfNotRowKeyFile.elem) ** GOTO lbl-1000
            v0 = rowKeyFile;
            var18_18 = "";
            if (!(v0 == null ? var18_18 != null : v0.equals(var18_18) == false) || !new File(rowKeyFile).exists()) {
                this.logger().warn("No rowkey file was found for this processing. Aborting.");
            } else lbl-1000:
            // 2 sources

            {
                v1 = rowKeyFile;
                var19_19 = "";
                if (!(v1 != null ? v1.equals(var19_19) == false : var19_19 != null)) {
                    this.logger().info(new StringBuilder().append((Object)"Processing ").append(((Option)dataResourceUid.elem).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "";
                        }
                    })).append((Object)" from ").append((Object)((Option)startUuid.elem)).append((Object)"to ").append((Object)((Option)endUuid.elem)).append((Object)" with ").append((Object)BoxesRunTime.boxToInteger((int)threads.elem)).append((Object)"actors").toString());
                    x$4 = threads.elem;
                    x$5 = (Option)startUuid.elem;
                    x$6 = (Option)dataResourceUid.elem;
                    x$7 = checkDeleted.elem;
                    x$8 = (Option)endUuid.elem;
                    x$9 = this.processRecords$default$5();
                    this.processRecords(x$4, (Option<String>)x$5, (Option<String>)x$6, x$7, x$9, (Option<String>)x$8);
                } else {
                    this.processFileOfRowKeys(new File(rowKeyFile), threads.elem);
                }
            }
        }
        this.persistenceManager().shutdown();
    }

    public int getProcessedTotal(Actor[] pool) {
        IntRef size2 = new IntRef(0);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), pool.length - 1).foreach$mVc$sp((Function1)new Serializable(pool, size2){
            public static final long serialVersionUID = 0L;
            private final Actor[] pool$1;
            private final IntRef size$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.size$1.elem += ((Consumer)this.pool$1[i]).processedRecords();
            }
            {
                this.pool$1 = pool$1;
                this.size$1 = size$1;
            }
        });
        return size2.elem;
    }

    public void processFileOfRowKeys(File file, int threads) {
        ArrayBlockingQueue queue = new ArrayBlockingQueue(100);
        IntRef ids = new IntRef(0);
        RecordProcessor recordProcessor = new RecordProcessor();
        StringConsumer[] pool = (StringConsumer[])Array$.MODULE$.fill(threads, (Function0)new Serializable(queue, ids, recordProcessor){
            public static final long serialVersionUID = 0L;
            private final ArrayBlockingQueue queue$1;
            private final IntRef ids$1;
            public final RecordProcessor recordProcessor$1;

            public final StringConsumer apply() {
                IntRef counter = new IntRef(0);
                LongRef startTime = new LongRef(System.currentTimeMillis());
                LongRef finishTime = new LongRef(System.currentTimeMillis());
                StringConsumer p = new StringConsumer(this.queue$1, this.ids$1.elem, (Function1<String, BoxedUnit>)new Serializable(this, counter, startTime, finishTime){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.9 $outer;
                    private final IntRef counter$1;
                    private final LongRef startTime$1;
                    private final LongRef finishTime$1;

                    public final void apply(String guid) {
                        ++this.counter$1.elem;
                        Option<FullRecord[]> rawProcessed = Config$.MODULE$.occurrenceDAO().getRawProcessedByRowKey(guid);
                        if (!rawProcessed.isEmpty()) {
                            FullRecord[] rp = (FullRecord[])rawProcessed.get();
                            this.$outer.recordProcessor$1.processRecord(rp[0], rp[1], this.$outer.recordProcessor$1.processRecord$default$3(), this.$outer.recordProcessor$1.processRecord$default$4());
                            if (this.counter$1.elem % 1000 == 0) {
                                this.finishTime$1.elem = System.currentTimeMillis();
                                ProcessRecords$.MODULE$.logger().info(new StringBuilder().append(this.counter$1.elem).append((Object)" >> Last key : ").append((Object)rp[0].uuid()).append((Object)", records per sec: ").append((Object)BoxesRunTime.boxToFloat((float)(1000.0f / ((float)(this.finishTime$1.elem - this.startTime$1.elem) / 1000.0f)))).toString());
                                this.startTime$1.elem = System.currentTimeMillis();
                            }
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.counter$1 = counter$1;
                        this.startTime$1 = startTime$1;
                        this.finishTime$1 = finishTime$1;
                    }
                });
                ++this.ids$1.elem;
                p.start();
                return p;
            }
            {
                this.queue$1 = queue$1;
                this.ids$1 = ids$1;
                this.recordProcessor$1 = recordProcessor$1;
            }
        }, ClassTag$.MODULE$.apply(StringConsumer.class));
        FileHelper$.MODULE$.file2helper(file).foreachLine((Function1<String, BoxedUnit>)new Serializable(queue){
            public static final long serialVersionUID = 0L;
            private final ArrayBlockingQueue queue$1;

            public final void apply(String line) {
                this.queue$1.put(line.trim());
            }
            {
                this.queue$1 = queue$1;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])pool).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(StringConsumer t) {
                t.shouldStop_$eq(true);
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])pool).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(StringConsumer x$2) {
                x$2.join();
            }
        });
    }

    public void processRecords(File file, int threads, Option<String> startUuid) {
        IntRef ids = new IntRef(0);
        Actor[] pool = (Actor[])Array$.MODULE$.fill(threads, (Function0)new Serializable(ids){
            public static final long serialVersionUID = 0L;
            private final IntRef ids$2;

            public final Actor apply() {
                Consumer p = new Consumer(Actor$.MODULE$.self(), this.ids$2.elem, Consumer$.MODULE$.$lessinit$greater$default$3());
                ++this.ids$2.elem;
                return p.start();
            }
            {
                this.ids$2 = ids$2;
            }
        }, ClassTag$.MODULE$.apply(Actor.class));
        this.logger().info("Starting to process a list of records...");
        long start = System.currentTimeMillis();
        long startTime = System.currentTimeMillis();
        LongRef finishTime = new LongRef(System.currentTimeMillis());
        ObjectRef buff = new ObjectRef((Object)new ArrayBuffer());
        IntRef batches = new IntRef(0);
        IntRef count = new IntRef(0);
        this.logger().debug("Initialised actors...");
        FileHelper$.MODULE$.file2helper(file).foreachLine((Function1<String, BoxedUnit>)new Serializable(threads, startUuid, pool, start, startTime, finishTime, buff, batches, count){
            public static final long serialVersionUID = 0L;
            private final int threads$2;
            private final Option startUuid$1;
            private final Actor[] pool$2;
            private final long start$1;
            private final long startTime$2;
            private final LongRef finishTime$2;
            private final ObjectRef buff$1;
            private final IntRef batches$1;
            private final IntRef count$1;

            /*
             * Unable to fully structure code
             */
            public final void apply(String line) {
                ++this.count$1.elem;
                if (this.startUuid$1.isEmpty()) ** GOTO lbl-1000
                v0 = this.startUuid$1.get();
                var2_2 = line;
                if (!(v0 != null ? v0.equals(var2_2) == false : var2_2 != null)) lbl-1000:
                // 2 sources

                {
                    v1 = ((ArrayBuffer)this.buff$1.elem).$plus$eq((Object)line);
                } else {
                    v1 = BoxedUnit.UNIT;
                }
                if (((ArrayBuffer)this.buff$1.elem).size() >= 50) {
                    actor = (Consumer)this.pool$2[this.batches$1.elem % this.threads$2];
                    ++this.batches$1.elem;
                    ++this.count$1.elem;
                    while (true) {
                        if (actor.ready()) {
                            actor.$bang(((ArrayBuffer)this.buff$1.elem).toArray(ClassTag$.MODULE$.apply(String.class)));
                            ((ArrayBuffer)this.buff$1.elem).clear();
                            break;
                        }
                        Thread.sleep(50L);
                    }
                }
                if (this.count$1.elem % 1000 == 0) {
                    this.finishTime$2.elem = System.currentTimeMillis();
                    ProcessRecords$.MODULE$.logger().info(new StringBuilder().append(this.count$1.elem).append((Object)" >> Last key : ").append((Object)line).append((Object)", records per sec: ").append((Object)BoxesRunTime.boxToFloat((float)(1000.0f / ((float)(this.finishTime$2.elem - this.startTime$2) / 1000.0f)))).append((Object)", time taken for ").append((Object)BoxesRunTime.boxToInteger((int)1000)).append((Object)" records: ").append((Object)BoxesRunTime.boxToFloat((float)((float)(this.finishTime$2.elem - this.startTime$2) / 1000.0f))).append((Object)", total time: ").append((Object)BoxesRunTime.boxToFloat((float)((float)(this.finishTime$2.elem - this.start$1) / 60000.0f))).append((Object)" minutes").toString());
                }
            }
            {
                this.threads$2 = threads$2;
                this.startUuid$1 = startUuid$1;
                this.pool$2 = pool$2;
                this.start$1 = start$1;
                this.startTime$2 = startTime$2;
                this.finishTime$2 = finishTime$2;
                this.buff$1 = buff$1;
                this.batches$1 = batches$1;
                this.count$1 = count$1;
            }
        });
        if (!((ArrayBuffer)buff.elem).isEmpty()) {
            ((Consumer)pool[0]).$bang(((ArrayBuffer)buff.elem).toArray(ClassTag$.MODULE$.apply(String.class)));
            ++batches.elem;
        }
        this.logger().info(new StringBuilder().append(count.elem).append((Object)", records per sec: ").append((Object)BoxesRunTime.boxToFloat((float)(1000.0f / ((float)(finishTime.elem - startTime) / 1000.0f)))).append((Object)", time taken for ").append((Object)BoxesRunTime.boxToInteger((int)1000)).append((Object)" records: ").append((Object)BoxesRunTime.boxToFloat((float)((float)(finishTime.elem - startTime) / 1000.0f))).append((Object)", total time: ").append((Object)BoxesRunTime.boxToFloat((float)((float)(finishTime.elem - start) / 60000.0f))).append((Object)" minutes").toString());
        this.logger().info("Finished.");
        Predef$.MODULE$.refArrayOps((Object[])pool).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Actor actor) {
                actor.$bang((Object)"exit");
            }
        });
        while (batches.elem > this.getProcessedTotal(pool)) {
            this.logger().info(new StringBuilder().append(batches.elem).append((Object)" : ").append((Object)BoxesRunTime.boxToInteger((int)this.getProcessedTotal(pool))).toString());
            Thread.sleep(50L);
        }
    }

    public void performPaging(Function1<Option<Tuple2<FullRecord, FullRecord>>, Object> proc, String startKey, String endKey, int pageSize) {
        this.occurrenceDAO().pageOverRawProcessed((Function1<Option<Tuple2<FullRecord, FullRecord>>, Object>)new Serializable(proc){
            public static final long serialVersionUID = 0L;
            private final Function1 proc$1;

            public final boolean apply(Option<Tuple2<FullRecord, FullRecord>> rawAndProcessed) {
                return BoxesRunTime.unboxToBoolean((Object)this.proc$1.apply(rawAndProcessed));
            }
            {
                this.proc$1 = proc$1;
            }
        }, startKey, endKey, this.occurrenceDAO().pageOverRawProcessed$default$4());
    }

    public String performPaging$default$2() {
        return "";
    }

    public String performPaging$default$3() {
        return "";
    }

    public int performPaging$default$4() {
        return 1000;
    }

    public void processRecords(int threads, Option<String> firstKey, Option<String> dr, boolean checkDeleted, ObserverCallback callback, Option<String> lastKey) {
        String endUuid = lastKey.isDefined() ? (String)lastKey.get() : (dr.isEmpty() ? "" : new StringBuilder().append((Object)((String)dr.get())).append((Object)"|~").toString());
        String startUuid = firstKey.isEmpty() && !dr.isEmpty() ? new StringBuilder().append((Object)((String)dr.get())).append((Object)"|").toString() : (String)firstKey.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        IntRef ids = new IntRef(0);
        Actor[] pool = (Actor[])Array$.MODULE$.fill(threads, (Function0)new Serializable(callback, ids){
            public static final long serialVersionUID = 0L;
            private final ObserverCallback callback$1;
            private final IntRef ids$3;

            public final Actor apply() {
                Consumer p = new Consumer(Actor$.MODULE$.self(), this.ids$3.elem, this.callback$1 != null);
                ++this.ids$3.elem;
                return p.start();
            }
            {
                this.callback$1 = callback$1;
                this.ids$3 = ids$3;
            }
        }, ClassTag$.MODULE$.apply(Actor.class));
        this.logger().info(new StringBuilder().append((Object)"Starting with ").append((Object)startUuid).append((Object)" ending with ").append((Object)endUuid).toString());
        long start = System.currentTimeMillis();
        LongRef startTime = new LongRef(System.currentTimeMillis());
        LongRef finishTime = new LongRef(System.currentTimeMillis());
        this.logger().debug("Initialised actors...");
        IntRef count = new IntRef(0);
        ObjectRef guid = new ObjectRef((Object)"");
        IntRef batches = new IntRef(0);
        ObjectRef buff = new ObjectRef((Object)new ArrayBuffer());
        this.performPaging((Function1<Option<Tuple2<FullRecord, FullRecord>>, Object>)new Serializable(threads, callback, pool, start, startTime, finishTime, count, guid, batches, buff){
            public static final long serialVersionUID = 0L;
            private final int threads$1;
            private final ObserverCallback callback$1;
            private final Actor[] pool$3;
            private final long start$2;
            private final LongRef startTime$3;
            private final LongRef finishTime$3;
            private final IntRef count$2;
            private final ObjectRef guid$1;
            private final IntRef batches$2;
            private final ObjectRef buff$2;

            public final boolean apply(Option<Tuple2<FullRecord, FullRecord>> rawAndProcessed) {
                String string = (String)this.guid$1.elem;
                String string2 = "";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    ProcessRecords$.MODULE$.logger().info(new StringBuilder().append((Object)"First rowKey processed: ").append((Object)((FullRecord)((Tuple2)rawAndProcessed.get())._1()).rowKey()).toString());
                }
                this.guid$1.elem = ((FullRecord)((Tuple2)rawAndProcessed.get())._1()).rowKey();
                ++this.count$2.elem;
                Object object = rawAndProcessed.isEmpty() || ((FullRecord)((Tuple2)rawAndProcessed.get())._1()).deleted() ? BoxedUnit.UNIT : ((ArrayBuffer)this.buff$2.elem).$plus$eq(rawAndProcessed.get());
                if (((ArrayBuffer)this.buff$2.elem).size() >= 50) {
                    Consumer actor = (Consumer)this.pool$3[this.batches$2.elem % this.threads$1];
                    ++this.batches$2.elem;
                    while (true) {
                        if (actor.ready()) {
                            actor.$bang(((ArrayBuffer)this.buff$2.elem).toArray(ClassTag$.MODULE$.apply(Tuple2.class)));
                            ((ArrayBuffer)this.buff$2.elem).clear();
                            break;
                        }
                        Thread.sleep(50L);
                    }
                }
                if (this.callback$1 != null && this.count$2.elem % 100 == 0) {
                    this.callback$1.progressMessage(this.count$2.elem);
                }
                if (this.count$2.elem % 1000 == 0) {
                    this.finishTime$3.elem = System.currentTimeMillis();
                    ProcessRecords$.MODULE$.logger().info(new StringBuilder().append(this.count$2.elem).append((Object)" >> Last key : ").append((Object)((FullRecord)((Tuple2)rawAndProcessed.get())._1()).rowKey()).append((Object)", records per sec: ").append((Object)BoxesRunTime.boxToFloat((float)(1000.0f / ((float)(this.finishTime$3.elem - this.startTime$3.elem) / 1000.0f)))).append((Object)", time taken for ").append((Object)BoxesRunTime.boxToInteger((int)1000)).append((Object)" records: ").append((Object)BoxesRunTime.boxToFloat((float)((float)(this.finishTime$3.elem - this.startTime$3.elem) / 1000.0f))).append((Object)", total time: ").append((Object)BoxesRunTime.boxToFloat((float)((float)(this.finishTime$3.elem - this.start$2) / 60000.0f))).append((Object)" minutes").toString());
                    this.startTime$3.elem = System.currentTimeMillis();
                }
                return true;
            }
            {
                this.threads$1 = threads$1;
                this.callback$1 = callback$1;
                this.pool$3 = pool$3;
                this.start$2 = start$2;
                this.startTime$3 = startTime$3;
                this.finishTime$3 = finishTime$3;
                this.count$2 = count$2;
                this.guid$1 = guid$1;
                this.batches$2 = batches$2;
                this.buff$2 = buff$2;
            }
        }, startUuid, endUuid, this.performPaging$default$4());
        this.logger().info(new StringBuilder().append((Object)"Last row key processed: ").append((Object)((String)guid.elem)).toString());
        if (((ArrayBuffer)buff.elem).nonEmpty()) {
            ((Consumer)pool[0]).$bang(((ArrayBuffer)buff.elem).toArray(ClassTag$.MODULE$.apply(Tuple2.class)));
            ++batches.elem;
        }
        this.logger().info("Finished.");
        Predef$.MODULE$.refArrayOps((Object[])pool).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Actor actor) {
                actor.$bang((Object)"exit");
            }
        });
        while (batches.elem > this.getProcessedTotal(pool)) {
            Thread.sleep(50L);
        }
    }

    public boolean processRecords$default$4() {
        return false;
    }

    public ObserverCallback processRecords$default$5() {
        return null;
    }

    public Option<String> processRecords$default$6() {
        return None$.MODULE$;
    }

    private ProcessRecords$() {
        MODULE$ = this;
        Tool$class.$init$(this);
        IncrementalTool$class.$init$(this);
        this.occurrenceDAO = Config$.MODULE$.occurrenceDAO();
        this.persistenceManager = Config$.MODULE$.persistenceManager();
        this.logger = LoggerFactory.getLogger((String)"ProcessRecords");
    }
}

