/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.processor;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.dao.OccurrenceDAO;
import au.org.ala.biocache.load.FullRecordMapper$;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.model.Processed$;
import au.org.ala.biocache.model.QualityAssertion;
import au.org.ala.biocache.model.Version;
import au.org.ala.biocache.model.Versions$;
import au.org.ala.biocache.processor.Processor;
import au.org.ala.biocache.processor.Processors$;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005%c\u0001B\u0001\u0003\u00015\u0011qBU3d_J$\u0007K]8dKN\u001cxN\u001d\u0006\u0003\u0007\u0011\t\u0011\u0002\u001d:pG\u0016\u001c8o\u001c:\u000b\u0005\u00151\u0011\u0001\u00032j_\u000e\f7\r[3\u000b\u0005\u001dA\u0011aA1mC*\u0011\u0011BC\u0001\u0004_J<'\"A\u0006\u0002\u0005\u0005,8\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007\"B\u000b\u0001\t\u00031\u0012A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\u0003\u0011\u001dQ\u0002A1A\u0005\u0002m\ta\u0001\\8hO\u0016\u0014X#\u0001\u000f\u0011\u0005u\tS\"\u0001\u0010\u000b\u0005}\u0001\u0013!B:mMRR'\"A\u0005\n\u0005\tr\"A\u0002'pO\u001e,'\u000f\u0003\u0004%\u0001\u0001\u0006I\u0001H\u0001\bY><w-\u001a:!\u0011\u001d1\u0003A1A\u0005\u0002\u001d\n1\u0002\u001d:pG\u0016\u001c8\u000fV5nKV\t\u0001\u0006\u0005\u0002*]5\t!F\u0003\u0002,Y\u0005!A.\u00198h\u0015\u0005i\u0013\u0001\u00026bm\u0006L!a\f\u0016\u0003\rM#(/\u001b8h\u0011\u0019\t\u0004\u0001)A\u0005Q\u0005a\u0001O]8dKN\u001cH+[7fA!91\u0007\u0001b\u0001\n\u0003!\u0014A\u00033va2L7-\u0019;fgV\tQ\u0007E\u00027w!j\u0011a\u000e\u0006\u0003qe\n\u0011\"[7nkR\f'\r\\3\u000b\u0005i\u0002\u0012AC2pY2,7\r^5p]&\u0011Ah\u000e\u0002\u0005\u0019&\u001cH\u000f\u0003\u0004?\u0001\u0001\u0006I!N\u0001\fIV\u0004H.[2bi\u0016\u001c\b\u0005C\u0003A\u0001\u0011\u0005\u0011)\u0001\bqe>\u001cWm]:SK\u000e|'\u000fZ:\u0015\u0005\t+\u0005CA\bD\u0013\t!\u0005C\u0001\u0003V]&$\b\"\u0002$@\u0001\u00049\u0015a\u0002:po.+\u0017p\u001d\t\u0004\u0011B\u0013fBA%O\u001d\tQU*D\u0001L\u0015\taE\"\u0001\u0004=e>|GOP\u0005\u0002#%\u0011q\nE\u0001\ba\u0006\u001c7.Y4f\u0013\ta\u0014K\u0003\u0002P!A\u00111K\u0016\b\u0003\u001fQK!!\u0016\t\u0002\rA\u0013X\rZ3g\u0013\tysK\u0003\u0002V!!)\u0011\f\u0001C\u00015\u0006i\u0001O]8dKN\u001c(+Z2pe\u0012$RaW1jWB\u0004Ba\u0015/S=&\u0011Ql\u0016\u0002\u0004\u001b\u0006\u0004\bCA\u0015`\u0013\t\u0001'F\u0001\u0004PE*,7\r\u001e\u0005\u0006Eb\u0003\raY\u0001\u0004e\u0006<\bC\u00013h\u001b\u0005)'B\u00014\u0005\u0003\u0015iw\u000eZ3m\u0013\tAWM\u0001\u0006Gk2d'+Z2pe\u0012DQA\u001b-A\u0002\r\f\u0001cY;se\u0016tG\u000f\u0015:pG\u0016\u001c8/\u001a3\t\u000f1D\u0006\u0013!a\u0001[\u0006)!-\u0019;dQB\u0011qB\\\u0005\u0003_B\u0011qAQ8pY\u0016\fg\u000eC\u0004r1B\u0005\t\u0019A7\u0002\u0013\u0019L'o\u001d;M_\u0006$\u0007\"B:\u0001\t\u0003!\u0018!E<sSR,\u0007K]8dKN\u001c()\u0019;dQR\u0011!)\u001e\u0005\u0006YJ\u0004\rA\u001e\t\u0004\u0011B[\u0006\"B-\u0001\t\u0003AHcA=\u0002\bA!qB_2}\u0013\tY\bC\u0001\u0004UkBdWM\r\t\u0005'r\u0013V\u0010\u0005\u0003\u0010}\u0006\u0005\u0011BA@\u0011\u0005\u0015\t%O]1z!\r!\u00171A\u0005\u0004\u0003\u000b)'\u0001E)vC2LG/_!tg\u0016\u0014H/[8o\u0011\u0015\u0011w\u000f1\u0001d\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u001b\ta\u0003\u001d:pG\u0016\u001c8OU3d_J$\u0017I\u001c3Va\u0012\fG/\u001a\u000b\u0004\u0005\u0006=\u0001B\u00022\u0002\n\u0001\u00071\rC\u0004\u0002\u0014\u0001!\t!!\u0006\u0002'\u0005$GMU3d_J$\u0017I\u001c3Qe>\u001cWm]:\u0015\u000bI\u000b9\"a\u0007\t\u000f\u0005e\u0011\u0011\u0003a\u0001%\u0006yA-\u0019;b%\u0016\u001cx.\u001e:dKVKG\r\u0003\u0005\u0002\u001e\u0005E\u0001\u0019AA\u0010\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0005'r\u0013&\u000bC\u0004\u0002$\u0001!\t!!\n\u0002\u0013\u0005$GMU3d_J$G#\u0002*\u0002(\u0005%\u0002bBA\r\u0003C\u0001\rA\u0015\u0005\t\u0003;\t\t\u00031\u0001\u0002 !I\u0011Q\u0006\u0001\u0012\u0002\u0013\u0005\u0011qF\u0001\u0018aJ|7-Z:t%\u0016\u001cwN\u001d3%I\u00164\u0017-\u001e7uIM*\"!!\r+\u00075\f\u0019d\u000b\u0002\u00026A!\u0011qGA!\u001b\t\tID\u0003\u0003\u0002<\u0005u\u0012!C;oG\",7m[3e\u0015\r\ty\u0004E\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\"\u0003s\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\t9\u0005AI\u0001\n\u0003\ty#A\fqe>\u001cWm]:SK\u000e|'\u000f\u001a\u0013eK\u001a\fW\u000f\u001c;%i\u0001")
public class RecordProcessor {
    private final Logger logger = LoggerFactory.getLogger(RecordProcessor.class);
    private final String processTime = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final List<String> duplicates = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"D", "D1", "D2"}));

    public Logger logger() {
        return this.logger;
    }

    public String processTime() {
        return this.processTime;
    }

    public List<String> duplicates() {
        return this.duplicates;
    }

    public void processRecords(List<String> rowKeys) {
        this.logger().debug(new StringBuilder().append((Object)"Starting to process all the records in the list: ").append(rowKeys).toString());
        IntRef counter = new IntRef(0);
        LongRef startTime = new LongRef(System.currentTimeMillis());
        LongRef finishTime = new LongRef(System.currentTimeMillis());
        rowKeys.foreach((Function1)new Serializable(this, counter, startTime, finishTime){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RecordProcessor $outer;
            private final IntRef counter$1;
            private final LongRef startTime$1;
            private final LongRef finishTime$1;

            public final void apply(String rowKey) {
                Option<FullRecord[]> rawProcessed = Config$.MODULE$.occurrenceDAO().getRawProcessedByRowKey(rowKey);
                if (!rawProcessed.isEmpty()) {
                    FullRecord[] rp = (FullRecord[])rawProcessed.get();
                    this.$outer.processRecord(rp[0], rp[1], this.$outer.processRecord$default$3(), this.$outer.processRecord$default$4());
                    if (this.counter$1.elem % 100 == 0) {
                        this.finishTime$1.elem = System.currentTimeMillis();
                        this.$outer.logger().debug(new StringBuilder().append(this.counter$1.elem).append((Object)" >> Last key : ").append((Object)rp[0].uuid()).append((Object)", records per sec: ").append((Object)BoxesRunTime.boxToFloat((float)(100.0f / ((float)(this.finishTime$1.elem - this.startTime$1.elem) / 1000.0f)))).toString());
                        this.startTime$1.elem = System.currentTimeMillis();
                    }
                }
                ++this.counter$1.elem;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.counter$1 = counter$1;
                this.startTime$1 = startTime$1;
                this.finishTime$1 = finishTime$1;
            }
        });
    }

    public scala.collection.immutable.Map<String, Object> processRecord(FullRecord raw, FullRecord currentProcessed, boolean batch, boolean firstLoad) {
        scala.collection.immutable.Map map;
        try {
            String guid = raw.rowKey();
            OccurrenceDAO occurrenceDAO = (OccurrenceDAO)Config$.MODULE$.getInstance(OccurrenceDAO.class);
            FullRecord processed = raw.createNewProcessedRecord();
            ObjectRef assertions = new ObjectRef((Object)new HashMap());
            Processors$.MODULE$.foreach((Function1<Processor, BoxedUnit>)new Serializable(this, raw, currentProcessed, firstLoad, guid, processed, assertions){
                public static final long serialVersionUID = 0L;
                private final FullRecord raw$2;
                private final FullRecord currentProcessed$1;
                private final boolean firstLoad$1;
                private final String guid$1;
                private final FullRecord processed$1;
                private final ObjectRef assertions$1;

                public final void apply(Processor processor) {
                    if (!processor.getName().equals("offline") || !this.firstLoad$1) {
                        ((HashMap)this.assertions$1.elem).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)processor.getName()), (Object)processor.process(this.guid$1, this.raw$2, this.processed$1, (Option<FullRecord>)new Some((Object)this.currentProcessed$1))));
                    }
                }
                {
                    this.raw$2 = raw$2;
                    this.currentProcessed$1 = currentProcessed$1;
                    this.firstLoad$1 = firstLoad$1;
                    this.guid$1 = guid$1;
                    this.processed$1 = processed$1;
                    this.assertions$1 = assertions$1;
                }
            });
            processed.lastModifiedTime_$eq(this.processTime());
            Some systemAssertions = new Some((Object)((HashMap)assertions.elem).toMap(Predef$.MODULE$.conforms()));
            if (batch) {
                map = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"rowKey"), (Object)guid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"oldRecord"), (Object)currentProcessed), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"newRecord"), (Object)processed), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"assertions"), (Object)systemAssertions), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"version"), (Object)Processed$.MODULE$)}));
            } else {
                occurrenceDAO.updateOccurrence(guid, currentProcessed, processed, (Option<scala.collection.immutable.Map<String, QualityAssertion[]>>)systemAssertions, Processed$.MODULE$);
                map = null;
            }
        }
        catch (Exception exception) {
            this.logger().error(new StringBuilder().append((Object)"Error processing record: ").append((Object)raw.rowKey()).append((Object)", ").append((Object)exception.getMessage()).toString(), (Throwable)exception);
            map = null;
        }
        return map;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeProcessBatch(List<scala.collection.immutable.Map<String, Object>> batch) {
        OccurrenceDAO occurrenceDAO = (OccurrenceDAO)Config$.MODULE$.getInstance(OccurrenceDAO.class);
        int retries = 0;
        boolean processedOK = false;
        if (processedOK) return;
        if (retries >= 6) return;
        {
            occurrenceDAO.updateOccurrenceBatch(batch);
            return;
        }
    }

    public Tuple2<FullRecord, scala.collection.immutable.Map<String, QualityAssertion[]>> processRecord(FullRecord raw) {
        FullRecord processed = raw.createNewProcessedRecord();
        HashMap assertions = new HashMap();
        Processors$.MODULE$.foreach((Function1<Processor, BoxedUnit>)new Serializable(this, raw, processed, assertions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RecordProcessor $outer;
            private final FullRecord raw$1;
            private final FullRecord processed$2;
            private final HashMap assertions$2;

            public final void apply(Processor processor) {
                if (this.$outer.logger().isDebugEnabled()) {
                    this.$outer.logger().debug(new StringBuilder().append((Object)"Running processor ").append((Object)processor.getName()).toString());
                }
                this.assertions$2.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)processor.getName()), (Object)processor.process(this.raw$1.rowKey(), this.raw$1, this.processed$2, processor.process$default$4())));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.raw$1 = raw$1;
                this.processed$2 = processed$2;
                this.assertions$2 = assertions$2;
            }
        });
        return new Tuple2((Object)processed, (Object)assertions.toMap(Predef$.MODULE$.conforms()));
    }

    public boolean processRecord$default$3() {
        return false;
    }

    public boolean processRecord$default$4() {
        return false;
    }

    public void processRecordAndUpdate(FullRecord raw) {
        Tuple2<FullRecord, scala.collection.immutable.Map<String, QualityAssertion[]>> tuple2 = this.processRecord(raw);
        if (tuple2 != null) {
            Tuple2 tuple22;
            FullRecord processed = (FullRecord)tuple2._1();
            scala.collection.immutable.Map assertions = (scala.collection.immutable.Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)processed, (Object)assertions);
            FullRecord processed2 = (FullRecord)tuple23._1();
            scala.collection.immutable.Map assertions2 = (scala.collection.immutable.Map)tuple23._2();
            Some systemAssertions = new Some((Object)assertions2);
            processed2.lastModifiedTime_$eq(this.processTime());
            Config$.MODULE$.occurrenceDAO().updateOccurrence(raw.rowKey(), processed2, (Option<scala.collection.immutable.Map<String, QualityAssertion[]>>)systemAssertions, Processed$.MODULE$);
            return;
        }
        throw new MatchError(tuple2);
    }

    /*
     * WARNING - void declaration
     */
    public String addRecordAndProcess(String dataResourceUid, scala.collection.immutable.Map<String, String> properties) {
        void var3_3;
        String uuid = (String)properties.getOrElse((Object)"uuid", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return UUID.randomUUID().toString();
            }
        });
        String rowKey = new StringBuilder().append((Object)dataResourceUid).append((Object)"|").append((Object)uuid).toString();
        FullRecord raw = FullRecordMapper$.MODULE$.createFullRecord(rowKey, (Map<String, String>)properties, (Version)Versions$.MODULE$.RAW());
        raw.uuid_$eq(uuid);
        raw.attribution().dataResourceUid_$eq(dataResourceUid);
        Config$.MODULE$.occurrenceDAO().updateOccurrence(raw.rowKey(), raw, (Version)Versions$.MODULE$.RAW());
        RecordProcessor processor = new RecordProcessor();
        processor.processRecordAndUpdate(raw);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public String addRecord(String dataResourceUid, scala.collection.immutable.Map<String, String> properties) {
        void var3_3;
        String uuid = (String)properties.getOrElse((Object)"uuid", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return UUID.randomUUID().toString();
            }
        });
        String rowKey = new StringBuilder().append((Object)dataResourceUid).append((Object)"|").append((Object)uuid).toString();
        FullRecord raw = FullRecordMapper$.MODULE$.createFullRecord(rowKey, (Map<String, String>)properties, (Version)Versions$.MODULE$.RAW());
        raw.uuid_$eq(uuid);
        raw.attribution().dataResourceUid_$eq(dataResourceUid);
        Config$.MODULE$.occurrenceDAO().updateOccurrence(raw.rowKey(), raw, (Version)Versions$.MODULE$.RAW());
        boolean downloaded = Config$.MODULE$.occurrenceDAO().downloadMedia(raw);
        if (downloaded) {
            Config$.MODULE$.occurrenceDAO().updateOccurrence(raw.rowKey(), raw, (Version)Versions$.MODULE$.RAW());
        }
        return var3_3;
    }
}

