/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.processor;

import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.model.QualityAssertion;
import au.org.ala.biocache.model.QualityAssertion$;
import au.org.ala.biocache.parser.CollectorNameParser$;
import au.org.ala.biocache.processor.Processor;
import au.org.ala.biocache.processor.Processor$class;
import au.org.ala.biocache.vocab.AssertionCodes$;
import au.org.ala.biocache.vocab.AssertionStatus$;
import au.org.ala.biocache.vocab.EstablishmentMeans$;
import au.org.ala.biocache.vocab.Interactions$;
import au.org.ala.biocache.vocab.OccurrenceStatus$;
import au.org.ala.biocache.vocab.Term;
import org.apache.commons.lang.StringUtils;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001B\u0001\u0003\u00015\u0011a#T5tG\u0016dG.\u00198f_V\u001c\bK]8dKN\u001cxN\u001d\u0006\u0003\u0007\u0011\t\u0011\u0002\u001d:pG\u0016\u001c8o\u001c:\u000b\u0005\u00151\u0011\u0001\u00032j_\u000e\f7\r[3\u000b\u0005\u001dA\u0011aA1mC*\u0011\u0011BC\u0001\u0004_J<'\"A\u0006\u0002\u0005\u0005,8\u0001A\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u0016-5\t!!\u0003\u0002\u0018\u0005\tI\u0001K]8dKN\u001cxN\u001d\u0005\u00063\u0001!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"!\u0006\u0001\t\u000fu\u0001!\u0019!C\u0001=\u0005QA*S*U?\u0012+E*S'\u0016\u0003}\u0001\"\u0001I\u0013\u000e\u0003\u0005R!AI\u0012\u0002\u00115\fGo\u00195j]\u001eT!\u0001\n\t\u0002\tU$\u0018\u000e\\\u0005\u0003M\u0005\u0012QAU3hKbDa\u0001\u000b\u0001!\u0002\u0013y\u0012a\u0003'J'R{F)\u0012'J\u001b\u0002BqA\u000b\u0001C\u0002\u0013\u0005a$\u0001\nj]R,'/Y2uS>t\u0007+\u0019;uKJt\u0007B\u0002\u0017\u0001A\u0003%q$A\nj]R,'/Y2uS>t\u0007+\u0019;uKJt\u0007\u0005C\u0003/\u0001\u0011\u0005q&A\u0004qe>\u001cWm]:\u0015\u000bAJ$iR%\u0011\u0007=\t4'\u0003\u00023!\t)\u0011I\u001d:bsB\u0011AgN\u0007\u0002k)\u0011a\u0007B\u0001\u0006[>$W\r\\\u0005\u0003qU\u0012\u0001#U;bY&$\u00180Q:tKJ$\u0018n\u001c8\t\u000bij\u0003\u0019A\u001e\u0002\t\u001d,\u0018\u000e\u001a\t\u0003y}r!aD\u001f\n\u0005y\u0002\u0012A\u0002)sK\u0012,g-\u0003\u0002A\u0003\n11\u000b\u001e:j]\u001eT!A\u0010\t\t\u000b\rk\u0003\u0019\u0001#\u0002\u0007I\fw\u000f\u0005\u00025\u000b&\u0011a)\u000e\u0002\u000b\rVdGNU3d_J$\u0007\"\u0002%.\u0001\u0004!\u0015!\u00039s_\u000e,7o]3e\u0011\u001dQU\u0006%AA\u0002-\u000bQ\u0002\\1tiB\u0013xnY3tg\u0016$\u0007cA\bM\t&\u0011Q\n\u0005\u0002\u0007\u001fB$\u0018n\u001c8\t\u000b=\u0003A\u0011\u0001)\u0002/A\u0014xnY3tg>\u001b7-\u001e:sK:\u001cWm\u0015;biV\u001cH\u0003B)U+Z\u0003\"a\u0004*\n\u0005M\u0003\"\u0001B+oSRDQa\u0011(A\u0002\u0011CQ\u0001\u0013(A\u0002\u0011CQa\u0016(A\u0002a\u000b!\"Y:tKJ$\u0018n\u001c8t!\rIflM\u0007\u00025*\u00111\fX\u0001\b[V$\u0018M\u00197f\u0015\ti\u0006#\u0001\u0006d_2dWm\u0019;j_:L!a\u0018.\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\u0005\u0006\u001f\u0002!\t!\u0019\u000b\u0003E\u001a\u0004BaD2<K&\u0011A\r\u0005\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007=a5\u0007C\u0003hA\u0002\u00071(A\nsC^|5mY;se\u0016t7-Z*uCR,8\u000fC\u0003j\u0001\u0011\u0005!.A\u000bqe>\u001cWm]:NSN\u001cwjY2veJ,gnY3\u0015\tE[G.\u001c\u0005\u0006\u0007\"\u0004\r\u0001\u0012\u0005\u0006\u0011\"\u0004\r\u0001\u0012\u0005\u0006/\"\u0004\r\u0001\u0017\u0005\u0006_\u0002!\t\u0001]\u0001\u0012aJ|7-Z:t\u0007>dG.Z2u_J\u001cH\u0003B9ukZ\u0004\"a\u0004:\n\u0005M\u0004\"aA!os\")1I\u001ca\u0001\t\")\u0001J\u001ca\u0001\t\")qK\u001ca\u00011\")\u0001\u0010\u0001C\u0001s\u0006I\u0002O]8dKN\u001cXi\u001d;bE2L7\u000f[7f]RlU-\u00198t)\u0011\t&p\u001f?\t\u000b\r;\b\u0019\u0001#\t\u000b!;\b\u0019\u0001#\t\u000b];\b\u0019\u0001-\t\u000by\u0004A\u0011A@\u0002+A\u0014xnY3tg&#WM\u001c;jM&\u001c\u0017\r^5p]R9\u0001,!\u0001\u0002\u0004\u0005\u0015\u0001\"B\"~\u0001\u0004!\u0005\"\u0002%~\u0001\u0004!\u0005\"B,~\u0001\u0004A\u0006bBA\u0005\u0001\u0011\u0005\u00111B\u0001\u0014aJ|7-Z:t\u0013:$XM]1di&|gn\u001d\u000b\b#\u00065\u0011qBA\t\u0011\u0019Q\u0014q\u0001a\u0001w!11)a\u0002A\u0002\u0011Ca\u0001SA\u0004\u0001\u0004!\u0005bBA\u000b\u0001\u0011\u0005\u0011qC\u0001\u0011a\u0006\u00148/Z%oi\u0016\u0014\u0018m\u0019;j_:$B!!\u0007\u0002\u001cA\u0019q\u0002T\u001e\t\r\r\u000b\u0019\u00021\u0001<\u0011\u001d\ty\u0002\u0001C\u0001\u0003C\tQ\u0002\u001d:pG\u0016\u001c8/S7bO\u0016\u001cH#C)\u0002$\u0005\u0015\u0012qEA\u0015\u0011\u0019Q\u0014Q\u0004a\u0001w!11)!\bA\u0002\u0011Ca\u0001SA\u000f\u0001\u0004!\u0005BB,\u0002\u001e\u0001\u0007\u0001\fC\u0004\u0002.\u0001!\t!a\f\u0002\u000f\u001d,GOT1nKV\u0011\u0011\u0011\u0007\t\u0005\u0003g\ti$\u0004\u0002\u00026)!\u0011qGA\u001d\u0003\u0011a\u0017M\\4\u000b\u0005\u0005m\u0012\u0001\u00026bm\u0006L1\u0001QA\u001b\u0011%\t\t\u0005AI\u0001\n\u0003\n\u0019%A\tqe>\u001cWm]:%I\u00164\u0017-\u001e7uIQ*\"!!\u0012+\u0007-\u000b9e\u000b\u0002\u0002JA!\u00111JA+\u001b\t\tiE\u0003\u0003\u0002P\u0005E\u0013!C;oG\",7m[3e\u0015\r\t\u0019\u0006E\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA,\u0003\u001b\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class MiscellaneousProcessor
implements Processor {
    private final Regex LIST_DELIM;
    private final Regex interactionPattern;

    public Regex LIST_DELIM() {
        return this.LIST_DELIM;
    }

    public Regex interactionPattern() {
        return this.interactionPattern;
    }

    @Override
    public QualityAssertion[] process(String guid, FullRecord raw, FullRecord processed, Option<FullRecord> lastProcessed) {
        ArrayBuffer assertions = new ArrayBuffer();
        this.processImages(guid, raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
        this.processInteractions(guid, raw, processed);
        this.processEstablishmentMeans(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
        this.processIdentification(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
        this.processCollectors(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
        this.processMiscOccurrence(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
        this.processOccurrenceStatus(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
        return (QualityAssertion[])assertions.toArray(ClassTag$.MODULE$.apply(QualityAssertion.class));
    }

    @Override
    public Option<FullRecord> process$default$4() {
        return None$.MODULE$;
    }

    public void processOccurrenceStatus(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        Tuple2<String, Option<QualityAssertion>> tuple2 = this.processOccurrenceStatus(raw.occurrence().occurrenceStatus());
        if (tuple2 != null) {
            Tuple2 tuple22;
            String processedValue = (String)tuple2._1();
            Option qaOption = (Option)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)processedValue, (Object)qaOption);
            String processedValue2 = (String)tuple23._1();
            Option qaOption2 = (Option)tuple23._2();
            processed.occurrence().occurrenceStatus_$eq(processedValue2);
            if (!qaOption2.isEmpty()) {
                assertions.$plus$eq(qaOption2.get());
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<String, Option<QualityAssertion>> processOccurrenceStatus(String rawOccurrenceStatus) {
        Option<Term> matchedTerm;
        return StringUtils.isNotBlank((String)rawOccurrenceStatus) ? ((matchedTerm = OccurrenceStatus$.MODULE$.matchTerm(rawOccurrenceStatus)).isEmpty() ? new Tuple2((Object)"unknown", (Object)new Some((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNRECOGNISED_OCCURRENCE_STATUS()))) : new Tuple2((Object)((Term)matchedTerm.get()).canonical(), (Object)None$.MODULE$)) : new Tuple2((Object)"present", (Object)new Some((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ASSUMED_PRESENT_OCCURRENCE_STATUS())));
    }

    public void processMiscOccurrence(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        ArrayBuffer arrayBuffer = StringUtils.isBlank((String)raw.occurrence().catalogNumber()) ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_CATALOGUENUMBER(), "No catalogue number provided")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_CATALOGUENUMBER(), AssertionStatus$.MODULE$.PASSED()));
        if (StringUtils.isNotBlank((String)raw.occurrence().dataGeneralizations())) {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DATA_ARE_GENERALISED()));
        } else {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DATA_ARE_GENERALISED(), AssertionStatus$.MODULE$.PASSED()));
        }
    }

    public Object processCollectors(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        BoxedUnit boxedUnit;
        if (StringUtils.isNotBlank((String)raw.occurrence().recordedBy())) {
            Option<List<String>> parsedCollectors = CollectorNameParser$.MODULE$.parseForList(raw.occurrence().recordedBy());
            if (parsedCollectors.isDefined()) {
                processed.occurrence().recordedBy_$eq(((TraversableOnce)parsedCollectors.get()).mkString("|"));
                boxedUnit = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.RECORDED_BY_UNPARSABLE(), 1));
            } else {
                boxedUnit = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.RECORDED_BY_UNPARSABLE(), "Can not parse recordedBy"));
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    public void processEstablishmentMeans(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        if (StringUtils.isNotBlank((String)raw.occurrence().establishmentMeans())) {
            Option cultEscaped;
            String[] ameans = this.LIST_DELIM().split((CharSequence)raw.occurrence().establishmentMeans());
            String[] newmeans = (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])ameans).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(String means) {
                    Option<Term> term = EstablishmentMeans$.MODULE$.matchTerm(means);
                    return term.isDefined() ? ((Term)term.get()).getCanonical() : "";
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$2) {
                    return x$2.length() > 0;
                }
            });
            if (!Predef$.MODULE$.refArrayOps((Object[])newmeans).isEmpty()) {
                processed.occurrence().establishmentMeans_$eq(Predef$.MODULE$.refArrayOps((Object[])newmeans).mkString("; "));
            }
            if ((cultEscaped = Predef$.MODULE$.refArrayOps((Object[])newmeans).find((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean apply(String em) {
                    String string = em;
                    String string2 = "cultivated";
                    if (string == null) {
                        if (string2 == null) return true;
                    } else if (string.equals(string2)) return true;
                    String string3 = em;
                    String string4 = "assumed to be cultivated";
                    if (string3 == null) {
                        if (string4 == null) return true;
                    } else if (string3.equals(string4)) return true;
                    String string5 = em;
                    String string6 = "formerly cultivated (extinct)";
                    if (string5 == null) {
                        if (string6 == null) return true;
                    } else if (string5.equals(string6)) return true;
                    String string7 = em;
                    String string8 = "possibly cultivated";
                    if (string7 == null) {
                        if (string8 == null) return true;
                    } else if (string7.equals(string8)) return true;
                    String string9 = em;
                    String string10 = "presumably cultivated";
                    if (string9 != null) {
                        if (!string9.equals(string10)) return false;
                        return true;
                    }
                    if (string10 == null) return true;
                    return false;
                }
            })).isDefined()) {
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.OCCURRENCE_IS_CULTIVATED_OR_ESCAPEE()));
            } else {
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.OCCURRENCE_IS_CULTIVATED_OR_ESCAPEE(), 1));
            }
        }
    }

    public ArrayBuffer<QualityAssertion> processIdentification(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        ArrayBuffer arrayBuffer = raw.identification().identificationQualifier() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_IDENTIFICATIONQUALIFIER(), "Missing identificationQualifier")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_IDENTIFICATIONQUALIFIER(), AssertionStatus$.MODULE$.PASSED()));
        ArrayBuffer arrayBuffer2 = raw.identification().identifiedBy() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_IDENTIFIEDBY(), "Missing identifiedBy")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_IDENTIFIEDBY(), AssertionStatus$.MODULE$.PASSED()));
        ArrayBuffer arrayBuffer3 = raw.identification().identificationReferences() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_IDENTIFICATIONREFERENCES(), "Missing identificationReferences")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_IDENTIFICATIONREFERENCES(), AssertionStatus$.MODULE$.PASSED()));
        return raw.identification().dateIdentified() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_DATEIDENTIFIED(), "Missing dateIdentified")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_DATEIDENTIFIED(), 1));
    }

    public void processInteractions(String guid, FullRecord raw, FullRecord processed) {
        Option<Term> term;
        Option<String> interaction;
        if (!(raw.occurrence().associatedTaxa() == null || raw.occurrence().associatedTaxa().isEmpty() || (interaction = this.parseInteraction(raw.occurrence().associatedTaxa())).isEmpty() || (term = Interactions$.MODULE$.matchTerm((String)interaction.get())).isEmpty())) {
            processed.occurrence().interactions_$eq((String[])((Object[])new String[]{((Term)term.get()).getCanonical()}));
        }
    }

    public Option<String> parseInteraction(String raw) {
        None$ none$;
        String string = raw;
        Option option = this.interactionPattern().unapplySeq((Object)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            String interaction = (String)((LinearSeqOptimized)option.get()).apply(0);
            none$ = new Some((Object)interaction);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void processImages(String guid, FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        processed.occurrence().images_$eq(raw.occurrence().images());
        processed.occurrence().sounds_$eq(raw.occurrence().sounds());
        processed.occurrence().videos_$eq(raw.occurrence().videos());
    }

    @Override
    public String getName() {
        return "image";
    }

    public MiscellaneousProcessor() {
        Processor$class.$init$(this);
        this.LIST_DELIM = new StringOps(Predef$.MODULE$.augmentString(";")).r();
        this.interactionPattern = new StringOps(Predef$.MODULE$.augmentString("([A-Za-z]*):([\\x00-\\x7F\\s]*)")).r();
    }
}

