/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.processor;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.caches.LocationDAO$;
import au.org.ala.biocache.caches.SensitiveAreaDAO$;
import au.org.ala.biocache.caches.TaxonProfileDAO$;
import au.org.ala.biocache.load.FullRecordMapper$;
import au.org.ala.biocache.model.Feet$;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.model.Location;
import au.org.ala.biocache.model.MeasurementUnit;
import au.org.ala.biocache.model.QualityAssertion;
import au.org.ala.biocache.model.QualityAssertion$;
import au.org.ala.biocache.model.TaxonProfile;
import au.org.ala.biocache.model.Versions$;
import au.org.ala.biocache.parser.DistanceRangeParser$;
import au.org.ala.biocache.parser.VerbatimLatLongParser$;
import au.org.ala.biocache.poso.POSO;
import au.org.ala.biocache.processor.GISPoint;
import au.org.ala.biocache.processor.GISPoint$;
import au.org.ala.biocache.processor.Processor;
import au.org.ala.biocache.processor.Processor$class;
import au.org.ala.biocache.util.GISUtil$;
import au.org.ala.biocache.util.GridUtil$;
import au.org.ala.biocache.util.Json$;
import au.org.ala.biocache.util.StringHelper$;
import au.org.ala.biocache.vocab.AssertionCodes$;
import au.org.ala.biocache.vocab.AssertionStatus$;
import au.org.ala.biocache.vocab.BBox;
import au.org.ala.biocache.vocab.Countries$;
import au.org.ala.biocache.vocab.CountryCentrePoints$;
import au.org.ala.biocache.vocab.HabitatMap$;
import au.org.ala.biocache.vocab.LatLng;
import au.org.ala.biocache.vocab.StateProvinceCentrePoints$;
import au.org.ala.biocache.vocab.StateProvinceToCountry$;
import au.org.ala.biocache.vocab.StateProvinces$;
import au.org.ala.biocache.vocab.Term;
import au.org.ala.sds.SensitiveDataService;
import au.org.ala.sds.model.Message;
import au.org.ala.sds.util.GeoLocationHelper;
import au.org.ala.sds.validation.ValidationOutcome;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.geotools.referencing.CRS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.io.Source$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\t]c\u0001B\u0001\u0003\u00015\u0011\u0011\u0003T8dCRLwN\u001c)s_\u000e,7o]8s\u0015\t\u0019A!A\u0005qe>\u001cWm]:pe*\u0011QAB\u0001\tE&|7-Y2iK*\u0011q\u0001C\u0001\u0004C2\f'BA\u0005\u000b\u0003\ry'o\u001a\u0006\u0002\u0017\u0005\u0011\u0011-^\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005U1R\"\u0001\u0002\n\u0005]\u0011!!\u0003)s_\u000e,7o]8s\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u0016\u0001!9Q\u0004\u0001b\u0001\n\u0003q\u0012A\u00027pO\u001e,'/F\u0001 !\t\u0001C%D\u0001\"\u0015\t\u00113%A\u0003tY\u001a$$NC\u0001\n\u0013\t)\u0013E\u0001\u0004M_\u001e<WM\u001d\u0005\u0007O\u0001\u0001\u000b\u0011B\u0010\u0002\u000f1|wmZ3sA!9\u0011\u0006\u0001b\u0001\n\u0003Q\u0013aA:egV\t1\u0006\u0005\u0002-]5\tQF\u0003\u0002*\r%\u0011q&\f\u0002\u0015'\u0016t7/\u001b;jm\u0016$\u0015\r^1TKJ4\u0018nY3\t\rE\u0002\u0001\u0015!\u0003,\u0003\u0011\u0019Hm\u001d\u0011\t\u0011M\u0002\u0001R1A\u0005\u0002Q\nqb\u0019:t\u000bB\u001cxmQ8eKNl\u0015\r]\u000b\u0002kA!agO\u001f>\u001b\u00059$B\u0001\u001d:\u0003%IW.\\;uC\ndWM\u0003\u0002;!\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005q:$aA'baB\u0011a(\u0011\b\u0003\u001f}J!\u0001\u0011\t\u0002\rA\u0013X\rZ3g\u0013\t\u00115I\u0001\u0004TiJLgn\u001a\u0006\u0003\u0001BA\u0001\"\u0012\u0001\t\u0002\u0003\u0006K!N\u0001\u0011GJ\u001cX\t]:h\u0007>$Wm]'ba\u0002B\u0001b\u0012\u0001\t\u0006\u0004%\t\u0001N\u0001\u0011u>tW-\u00129tO\u000e{G-Z:NCBD\u0001\"\u0013\u0001\t\u0002\u0003\u0006K!N\u0001\u0012u>tW-\u00129tO\u000e{G-Z:NCB\u0004\u0003\"B&\u0001\t\u0003a\u0015a\u00029s_\u000e,7o\u001d\u000b\u0006\u001bZCVl\u0018\t\u0004\u001f9\u0003\u0016BA(\u0011\u0005\u0015\t%O]1z!\t\tF+D\u0001S\u0015\t\u0019F!A\u0003n_\u0012,G.\u0003\u0002V%\n\u0001\u0012+^1mSRL\u0018i]:feRLwN\u001c\u0005\u0006/*\u0003\r!P\u0001\u0005OVLG\rC\u0003Z\u0015\u0002\u0007!,A\u0002sC^\u0004\"!U.\n\u0005q\u0013&A\u0003$vY2\u0014VmY8sI\")aL\u0013a\u00015\u0006I\u0001O]8dKN\u001cX\r\u001a\u0005\bA*\u0003\n\u00111\u0001b\u00035a\u0017m\u001d;Qe>\u001cWm]:fIB\u0019qB\u0019.\n\u0005\r\u0004\"AB(qi&|g\u000eC\u0003f\u0001\u0011\u0005a-A\u000bdQ\u0016\u001c7\u000eT8dCRLwN\\*vaBd\u0017.\u001a3\u0015\t\u001dlgn\u001c\t\u0004Q.\u0004V\"A5\u000b\u0005)L\u0014aB7vi\u0006\u0014G.Z\u0005\u0003Y&\u00141\"\u0011:sCf\u0014UO\u001a4fe\")\u0011\f\u001aa\u00015\")a\f\u001aa\u00015\")\u0001\u000f\u001aa\u0001O\u0006Q\u0011m]:feRLwN\\:\t\u000bI\u0004A\u0011B:\u00023A\u0014xnY3tgN#\u0018\r^3D_VtGO]=WC2,Xm\u001d\u000b\u0005i^D\u0018\u0010\u0005\u0002\u0010k&\u0011a\u000f\u0005\u0002\u0005+:LG\u000fC\u0003Zc\u0002\u0007!\fC\u0003_c\u0002\u0007!\fC\u0003qc\u0002\u0007q\rC\u0003|\u0001\u0011%A0A\nwC2LG-\u0019;f\u0007>|'\u000fZ5oCR,7\u000f\u0006\u0003u{z|\b\"B-{\u0001\u0004Q\u0006\"\u00020{\u0001\u0004Q\u0006\"\u00029{\u0001\u00049\u0007bBA\u0002\u0001\u0011%\u0011QA\u0001\u0018aJ|7-Z:t\u00032$\u0018\u000e^;eK\u0006sG\rR3qi\"$\u0012\u0002^A\u0004\u0003\u0013\tY!!\u0004\t\r]\u000b\t\u00011\u0001>\u0011\u0019I\u0016\u0011\u0001a\u00015\"1a,!\u0001A\u0002iCa\u0001]A\u0001\u0001\u00049\u0007bBA\t\u0001\u0011%\u00111C\u0001\u0013aJ|7-Z:t\u001b&tW*\u0019=EKB$\b\u000eF\u0004u\u0003+\t9\"!\u0007\t\re\u000by\u00011\u0001[\u0011\u0019q\u0016q\u0002a\u00015\"1\u0001/a\u0004A\u0002\u001dDq!!\b\u0001\t\u0013\ty\"\u0001\rqe>\u001cWm]:WKJ\u0014\u0017\r^5n\u000b2,g/\u0019;j_:$r\u0001^A\u0011\u0003G\t)\u0003\u0003\u0004Z\u00037\u0001\rA\u0017\u0005\u0007=\u0006m\u0001\u0019\u0001.\t\rA\fY\u00021\u0001h\u0011\u001d\tI\u0003\u0001C\u0005\u0003W\tA\u0003\u001d:pG\u0016\u001c8OV3sE\u0006$\u0018.\u001c#faRDGc\u0002;\u0002.\u0005=\u0012\u0011\u0007\u0005\u00073\u0006\u001d\u0002\u0019\u0001.\t\ry\u000b9\u00031\u0001[\u0011\u0019\u0001\u0018q\u0005a\u0001O\"9\u0011Q\u0007\u0001\u0005\n\u0005]\u0012aF:fiB\u0013xnY3tg\u0016$7i\\8sI&t\u0017\r^3t)\u001d!\u0018\u0011HA\u001e\u0003{Aa!WA\u001a\u0001\u0004Q\u0006B\u00020\u00024\u0001\u0007!\f\u0003\u0004q\u0003g\u0001\ra\u001a\u0005\b\u0003\u0003\u0002A\u0011AA\"\u00039\u0001(o\\2fgNd\u0015\r\u001e'p]\u001e$\u0002$!\u0012\u0002N\u0005E\u0013QKA-\u0003;\n\t'!\u001a\u0002j\u00055\u0014\u0011OA;!\u0011y!-a\u0012\u0011\u0007U\tI%C\u0002\u0002L\t\u0011\u0001bR%T!>Lg\u000e\u001e\u0005\b\u0003\u001f\ny\u00041\u0001>\u0003-\u0011\u0018m\u001e'bi&$X\u000fZ3\t\u000f\u0005M\u0013q\ba\u0001{\u0005a!/Y<M_:<\u0017\u000e^;eK\"9\u0011qKA \u0001\u0004i\u0014\u0001\u0005:bo\u001e+w\u000eZ3uS\u000e$\u0015\r^;n\u0011\u001d\tY&a\u0010A\u0002u\n\u0001C^3sE\u0006$\u0018.\u001c'bi&$X\u000fZ3\t\u000f\u0005}\u0013q\ba\u0001{\u0005\tb/\u001a:cCRLW\u000eT8oO&$X\u000fZ3\t\u000f\u0005\r\u0014q\ba\u0001{\u0005Ya/\u001a:cCRLWn\u0015*T\u0011\u001d\t9'a\u0010A\u0002u\nq!Z1ti&tw\rC\u0004\u0002l\u0005}\u0002\u0019A\u001f\u0002\u00119|'\u000f\u001e5j]\u001eDq!a\u001c\u0002@\u0001\u0007Q(\u0001\u0003{_:,\u0007bBA:\u0003\u007f\u0001\r!P\u0001\u000eOJLGMU3gKJ,gnY3\t\rA\fy\u00041\u0001h\u0011\u001d\tI\b\u0001C\u0005\u0003w\n\u0011\u0004\u001d:pG\u0016\u001c8\u000fR3dS6\fGnQ8pe\u0012Lg.\u0019;fgRQ\u0011QIA?\u0003\u007f\n\t)a!\t\u000f\u0005=\u0013q\u000fa\u0001{!9\u00111KA<\u0001\u0004i\u0004bBA,\u0003o\u0002\r!\u0010\u0005\u0007a\u0006]\u0004\u0019A4\t\u000f\u0005\u001d\u0005\u0001\"\u0003\u0002\n\u0006Q\u0002O]8dKN\u001ch+\u001a:cCRLWnQ8pe\u0012Lg.\u0019;fgRQ\u0011QIAF\u0003\u001b\u000by)a'\t\u000f\u0005\r\u0014Q\u0011a\u0001{!1\u0001/!\"A\u0002\u001dD\u0001\"!%\u0002\u0006\u0002\u0007\u00111S\u0001\u0013I\u0016\u001c\u0017.\\1m-\u0016\u0014(-\u0019;j[2\u000bG\u000f\u0005\u0003\u0010E\u0006U\u0005cA\b\u0002\u0018&\u0019\u0011\u0011\u0014\t\u0003\u000b\u0019cw.\u0019;\t\u0011\u0005u\u0015Q\u0011a\u0001\u0003'\u000b1\u0003Z3dS6\fGNV3sE\u0006$\u0018.\u001c'p]\u001eDq!!)\u0001\t\u0013\t\u0019+\u0001\u000eqe>\u001cWm]:O_J$\b.\u001b8h\u000b\u0006\u001cH/\u001b8h5>tW\r\u0006\u0007\u0002F\u0005\u0015\u0016qUAU\u0003W\u000bi\u000bC\u0004\u0002d\u0005}\u0005\u0019A\u001f\t\u000f\u0005\u001d\u0014q\u0014a\u0001{!9\u00111NAP\u0001\u0004i\u0004bBA8\u0003?\u0003\r!\u0010\u0005\u0007a\u0006}\u0005\u0019A4\t\u000f\u0005E\u0006\u0001\"\u0001\u00024\u0006\u0001s-\u001a;Ok6\u0014WM](g\t\u0016\u001c\u0017.\\1m!2\f7-Z:J]\u0012{WO\u00197f)\u0011\t),a/\u0011\u0007=\t9,C\u0002\u0002:B\u00111!\u00138u\u0011\u001d\ti,a,A\u0002u\nq\u0002Z3dS6\fG.Q:TiJLgn\u001a\u0005\b\u0003\u0003\u0004A\u0011BAb\u00039awn\\6va\u0016\u00038oZ\"pI\u0016$B!!2\u0002HB\u0019qBY\u001f\t\u000f\u0005%\u0017q\u0018a\u0001{\u0005\u00191M]:\t\u000f\u00055\u0007\u0001\"\u0003\u0002P\u0006Q2\r[3dW\u000e{wN\u001d3j]\u0006$X-\u00168dKJ$\u0018-\u001b8usR9A/!5\u0002T\u0006U\u0007BB-\u0002L\u0002\u0007!\f\u0003\u0004_\u0003\u0017\u0004\rA\u0017\u0005\u0007a\u0006-\u0007\u0019A4\t\u000f\u0005e\u0007\u0001\"\u0003\u0002\\\u000692\r[3dW\u001a{'\u000fS1cSR\fG/T5t[\u0006$8\r\u001b\u000b\bi\u0006u\u0017q\\Aq\u0011\u0019I\u0016q\u001ba\u00015\"1a,a6A\u0002iCa\u0001]Al\u0001\u00049\u0007bBAs\u0001\u0011%\u0011q]\u0001\u0016C\u0012$7i\u001c8tKJ4\u0018\r^5p]N#\u0018\r^;t)\u0015!\u0018\u0011^Av\u0011\u0019I\u00161\u001da\u00015\"1a,a9A\u0002iCq!a<\u0001\t\u0013\t\t0A\u000bdQ\u0016\u001c7NR8s'R\fG/Z'jg6\fGo\u00195\u0015\u000fQ\f\u00190!>\u0002x\"1\u0011,!<A\u0002iCaAXAw\u0001\u0004Q\u0006B\u00029\u0002n\u0002\u0007q\rC\u0004\u0002|\u0002!\t!!@\u00025Y\fG.\u001b3bi\u0016<Um\u001c:fM\u0016\u0014XM\\2f-\u0006dW/Z:\u0015\u000f\u001d\fyP!\u0001\u0003\u0004!1\u0011,!?A\u0002iCaAXA}\u0001\u0004Q\u0006B\u00029\u0002z\u0002\u0007q\rC\u0004\u0003\b\u0001!\tA!\u0003\u00023Y\fG.\u001b3bi\u0016\u001cun\u001c:eS:\fG/Z:WC2,Xm\u001d\u000b\t\u0005\u0017\u0011\tBa\u0005\u0003\u0016A\u0019qB!\u0004\n\u0007\t=\u0001CA\u0002B]fDa!\u0017B\u0003\u0001\u0004Q\u0006B\u00020\u0003\u0006\u0001\u0007!\f\u0003\u0004q\u0005\u000b\u0001\ra\u001a\u0005\b\u00053\u0001A\u0011\u0002B\u000e\u0003I\u0001(o\\2fgN\u001cVM\\:ji&4\u0018\u000e^=\u0015\u000bQ\u0014iBa\b\t\re\u00139\u00021\u0001[\u0011\u0019q&q\u0003a\u00015\"9!1\u0005\u0001\u0005\n\t\u0015\u0012aD4fi\u0016C\u0018m\u0019;TG&t\u0015-\\3\u0015\u0007u\u00129\u0003\u0003\u0004Z\u0005C\u0001\rA\u0017\u0005\b\u0005W\u0001A\u0011\u0001B\u0017\u0003\u001d9W\r\u001e(b[\u0016,\"Aa\f\u0011\t\tE\"1H\u0007\u0003\u0005gQAA!\u000e\u00038\u0005!A.\u00198h\u0015\t\u0011I$\u0001\u0003kCZ\f\u0017b\u0001\"\u00034!I!q\b\u0001\u0012\u0002\u0013\u0005#\u0011I\u0001\u0012aJ|7-Z:tI\u0011,g-Y;mi\u0012\"TC\u0001B\"U\r\t'QI\u0016\u0003\u0005\u000f\u0002BA!\u0013\u0003T5\u0011!1\n\u0006\u0005\u0005\u001b\u0012y%A\u0005v]\u000eDWmY6fI*\u0019!\u0011\u000b\t\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003V\t-#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class LocationProcessor
implements Processor {
    private final Logger logger;
    private final SensitiveDataService sds;
    private scala.collection.immutable.Map<String, String> crsEpsgCodesMap;
    private scala.collection.immutable.Map<String, String> zoneEpsgCodesMap;
    private volatile byte bitmap$0;

    private scala.collection.immutable.Map crsEpsgCodesMap$lzycompute() {
        LocationProcessor locationProcessor = this;
        synchronized (locationProcessor) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                ObjectRef valuesMap = new ObjectRef((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
                Source$.MODULE$.fromURL(this.getClass().getResource("/crsEpsgCodes.txt"), "utf-8").getLines().toList().foreach((Function1)new Serializable(this, valuesMap){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef valuesMap$1;

                    public final void apply(String line) {
                        String[] values = new StringOps(Predef$.MODULE$.augmentString(line)).split('=');
                        this.valuesMap$1.elem = ((scala.collection.immutable.Map)this.valuesMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)values[0]), (Object)values[1]));
                    }
                    {
                        this.valuesMap$1 = valuesMap$1;
                    }
                });
                this.crsEpsgCodesMap = (scala.collection.immutable.Map)valuesMap.elem;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.crsEpsgCodesMap;
        }
    }

    private scala.collection.immutable.Map zoneEpsgCodesMap$lzycompute() {
        LocationProcessor locationProcessor = this;
        synchronized (locationProcessor) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                ObjectRef valuesMap = new ObjectRef((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
                Source$.MODULE$.fromURL(this.getClass().getResource("/zoneEpsgCodes.txt"), "utf-8").getLines().toList().foreach((Function1)new Serializable(this, valuesMap){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef valuesMap$2;

                    public final void apply(String line) {
                        String[] values = new StringOps(Predef$.MODULE$.augmentString(line)).split('=');
                        this.valuesMap$2.elem = ((scala.collection.immutable.Map)this.valuesMap$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)values[0]), (Object)values[1]));
                    }
                    {
                        this.valuesMap$2 = valuesMap$2;
                    }
                });
                this.zoneEpsgCodesMap = (scala.collection.immutable.Map)valuesMap.elem;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.zoneEpsgCodesMap;
        }
    }

    public Logger logger() {
        return this.logger;
    }

    public SensitiveDataService sds() {
        return this.sds;
    }

    public scala.collection.immutable.Map<String, String> crsEpsgCodesMap() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.crsEpsgCodesMap$lzycompute() : this.crsEpsgCodesMap;
    }

    public scala.collection.immutable.Map<String, String> zoneEpsgCodesMap() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.zoneEpsgCodesMap$lzycompute() : this.zoneEpsgCodesMap;
    }

    @Override
    public QualityAssertion[] process(String guid, FullRecord raw, FullRecord processed, Option<FullRecord> lastProcessed) {
        Tuple3 tuple3;
        block8: {
            ArrayBuffer assertions;
            block7: {
                Tuple3 tuple32;
                Option<Tuple3<Location, scala.collection.immutable.Map<String, String>, scala.collection.immutable.Map<String, String>>> point;
                this.logger().debug(new StringBuilder().append((Object)"Processing location for guid: ").append((Object)guid).toString());
                assertions = new ArrayBuffer();
                this.setProcessedCoordinates(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
                this.processAltitudeAndDepth(guid, raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
                if (processed.location().decimalLatitude() != null && processed.location().decimalLongitude() != null) {
                    this.validateCoordinatesValues(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
                    this.checkCoordinateUncertainty(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
                }
                if (Config$.MODULE$.sdsEnabled()) {
                    this.processSensitivity(raw, processed);
                }
                if (processed.location().decimalLatitude() != null && processed.location().decimalLongitude() != null) {
                    scala.collection.immutable.Map<String, String> intersectValues = SensitiveAreaDAO$.MODULE$.intersect(processed.location().decimalLongitude(), processed.location().decimalLatitude());
                    processed.location().stateProvince_$eq((String)intersectValues.getOrElse((Object)Config$.MODULE$.stateProvinceLayerID(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }));
                    processed.location().lga_$eq((String)intersectValues.getOrElse((Object)Config$.MODULE$.localGovLayerID(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }));
                    processed.location().country_$eq((String)intersectValues.getOrElse((Object)Config$.MODULE$.countriesLayerID(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }));
                    if (processed.location().country() == null && processed.location().stateProvince() != null) {
                        processed.location().country_$eq(Config$.MODULE$.defaultCountry());
                    }
                    processed.location().habitat_$eq(raw.location().habitat());
                    processed.location().biome_$eq((String)(intersectValues.getOrElse((Object)Config$.MODULE$.terrestrialLayerID(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }) == null ? (intersectValues.getOrElse((Object)Config$.MODULE$.marineLayerID(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }) == null ? null : "Marine") : "Terrestrial"));
                    this.checkForStateMismatch(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
                    this.addConservationStatus(raw, processed);
                    this.checkForHabitatMismatch(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
                }
                if ((point = LocationDAO$.MODULE$.getByLatLon(processed.location().decimalLatitude(), processed.location().decimalLongitude())).isEmpty()) break block7;
                tuple3 = (Tuple3)point.get();
                if (tuple3 == null) break block8;
                Location location = (Location)tuple3._1();
                scala.collection.immutable.Map environmentalLayers = (scala.collection.immutable.Map)tuple3._2();
                scala.collection.immutable.Map contextualLayers = (scala.collection.immutable.Map)tuple3._3();
                Tuple3 tuple33 = tuple32 = new Tuple3((Object)location, (Object)environmentalLayers, (Object)contextualLayers);
                Location location2 = (Location)tuple33._1();
                scala.collection.immutable.Map environmentalLayers2 = (scala.collection.immutable.Map)tuple33._2();
                scala.collection.immutable.Map contextualLayers2 = (scala.collection.immutable.Map)tuple33._3();
                processed.locationDetermined_$eq(true);
                processed.el_$eq(JavaConversions$.MODULE$.mapAsJavaMap((Map)environmentalLayers2));
                processed.cl_$eq(JavaConversions$.MODULE$.mapAsJavaMap((Map)contextualLayers2));
            }
            this.checkLocationSupplied(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
            this.validateCoordinates(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
            this.processStateCountryValues(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
            this.validateGeoreferenceValues(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
            return (QualityAssertion[])assertions.toArray(ClassTag$.MODULE$.apply(QualityAssertion.class));
        }
        throw new MatchError((Object)tuple3);
    }

    @Override
    public Option<FullRecord> process$default$4() {
        return None$.MODULE$;
    }

    public ArrayBuffer<QualityAssertion> checkLocationSupplied(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        return processed.location().decimalLatitude() == null || processed.location().decimalLongitude() == null ? (raw.location().footprintWKT() == null && raw.location().locality() == null && raw.location().locationID() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.LOCATION_NOT_SUPPLIED())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.LOCATION_NOT_SUPPLIED(), AssertionStatus$.MODULE$.PASSED()))) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.LOCATION_NOT_SUPPLIED(), AssertionStatus$.MODULE$.PASSED()));
    }

    private void processStateCountryValues(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        Option<Term> countryCodeTerm;
        Option<Term> countryTerm;
        Option<Term> stateTerm;
        if (processed.location().stateProvince() == null && raw.location().decimalLatitude() == null && raw.location().decimalLongitude() == null && !(stateTerm = StateProvinces$.MODULE$.matchTerm(raw.location().stateProvince())).isEmpty()) {
            processed.location().stateProvince_$eq(((Term)stateTerm.get()).canonical());
            if (Config$.MODULE$.sdsEnabled()) {
                this.processSensitivity(raw, processed);
            }
            processed.location().country_$eq((String)StateProvinceToCountry$.MODULE$.map().getOrElse((Object)processed.location().stateProvince(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            }));
        }
        if (processed.location().country() == null && raw.location().decimalLatitude() == null && raw.location().decimalLongitude() == null && !(countryTerm = Countries$.MODULE$.matchTerm(raw.location().country())).isEmpty()) {
            processed.location().country_$eq(((Term)countryTerm.get()).canonical());
        }
        if (processed.location().country() == null && raw.location().countryCode() != null && !(countryCodeTerm = Countries$.MODULE$.matchTerm(raw.location().countryCode())).isEmpty()) {
            processed.location().country_$eq(((Term)countryCodeTerm.get()).canonical());
        }
    }

    private void validateCoordinates(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        ArrayBuffer arrayBuffer = raw.location().country() == null && processed.location().country() != null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COUNTRY_INFERRED_FROM_COORDINATES(), AssertionStatus$.MODULE$.FAILED())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COUNTRY_INFERRED_FROM_COORDINATES(), AssertionStatus$.MODULE$.PASSED()));
        ArrayBuffer arrayBuffer2 = StateProvinceCentrePoints$.MODULE$.coordinatesMatchCentre(processed.location().stateProvince(), raw.location().decimalLatitude(), raw.location().decimalLongitude()) ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_CENTRE_OF_STATEPROVINCE(), new StringBuilder().append((Object)"Coordinates are centre point of ").append((Object)processed.location().stateProvince()).toString())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_CENTRE_OF_STATEPROVINCE(), AssertionStatus$.MODULE$.PASSED()));
        if (CountryCentrePoints$.MODULE$.coordinatesMatchCentre(processed.location().country(), raw.location().decimalLatitude(), raw.location().decimalLongitude())) {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_CENTRE_OF_COUNTRY(), new StringBuilder().append((Object)"Coordinates are centre point of ").append((Object)processed.location().country()).toString()));
        } else {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_CENTRE_OF_COUNTRY(), AssertionStatus$.MODULE$.PASSED()));
        }
    }

    private void processAltitudeAndDepth(String guid, FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        this.processVerbatimDepth(raw, processed, assertions);
        this.processVerbatimElevation(raw, processed, assertions);
        this.processMinMaxDepth(raw, processed, assertions);
    }

    private void processMinMaxDepth(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        BoxedUnit boxedUnit;
        if (raw.location().minimumDepthInMeters() == null || raw.location().maximumDepthInMeters() == null) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            try {
                float min = new StringOps(Predef$.MODULE$.augmentString(raw.location().minimumDepthInMeters())).toFloat();
                float max = new StringOps(Predef$.MODULE$.augmentString(raw.location().maximumDepthInMeters())).toFloat();
                if (min > max) {
                    processed.location().minimumDepthInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)max)).toString());
                    processed.location().maximumDepthInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)min)).toString());
                    boxedUnit = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MIN_MAX_DEPTH_REVERSED(), new StringBuilder().append((Object)"The minimum, ").append((Object)BoxesRunTime.boxToFloat((float)min)).append((Object)", and maximum, ").append((Object)BoxesRunTime.boxToFloat((float)max)).append((Object)", depths have been transposed.").toString()));
                } else {
                    processed.location().minimumDepthInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)min)).toString());
                    processed.location().maximumDepthInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)max)).toString());
                    boxedUnit = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MIN_MAX_DEPTH_REVERSED(), AssertionStatus$.MODULE$.PASSED()));
                }
            }
            catch (Exception exception) {
                this.logger().debug(new StringBuilder().append((Object)"Exception thrown processing minimumDepthInMeters:").append((Object)exception.getMessage()).toString());
                boxedUnit = BoxedUnit.UNIT;
            }
        }
        if (raw.location().minimumElevationInMeters() != null && raw.location().maximumElevationInMeters() != null) {
            try {
                float min = new StringOps(Predef$.MODULE$.augmentString(raw.location().minimumElevationInMeters())).toFloat();
                float max = new StringOps(Predef$.MODULE$.augmentString(raw.location().maximumElevationInMeters())).toFloat();
                if (min > max) {
                    processed.location().minimumElevationInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)max)).toString());
                    processed.location().maximumElevationInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)min)).toString());
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MIN_MAX_ALTITUDE_REVERSED(), new StringBuilder().append((Object)"The minimum, ").append((Object)BoxesRunTime.boxToFloat((float)min)).append((Object)", and maximum, ").append((Object)BoxesRunTime.boxToFloat((float)max)).append((Object)", elevations have been transposed.").toString()));
                } else {
                    processed.location().minimumElevationInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)min)).toString());
                    processed.location().maximumElevationInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)max)).toString());
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MIN_MAX_ALTITUDE_REVERSED(), AssertionStatus$.MODULE$.PASSED()));
                }
            }
            catch (Exception exception) {
                this.logger().debug(new StringBuilder().append((Object)"Exception thrown processing elevation:").append((Object)exception.getMessage()).toString());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processVerbatimElevation(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        if (raw.location().verbatimElevation() == null) return;
        Option<Tuple2<Object, MeasurementUnit>> parseElevationResult = DistanceRangeParser$.MODULE$.parse(raw.location().verbatimElevation());
        if (parseElevationResult.isDefined()) {
            Tuple2 tuple2;
            Tuple2 tuple22 = (Tuple2)parseElevationResult.get();
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            float velevation = BoxesRunTime.unboxToFloat((Object)tuple22._1());
            MeasurementUnit sourceUnit = (MeasurementUnit)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)velevation), (Object)sourceUnit);
            float velevation2 = BoxesRunTime.unboxToFloat((Object)tuple23._1());
            MeasurementUnit sourceUnit2 = (MeasurementUnit)tuple23._2();
            processed.location().verbatimElevation_$eq(((Object)BoxesRunTime.boxToFloat((float)velevation2)).toString());
            ArrayBuffer arrayBuffer = velevation2 > (float)10000 || velevation2 < (float)-100 ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ALTITUDE_OUT_OF_RANGE(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Elevation ", " is greater than 10,000 metres or less than -100 metres."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)velevation2)})))) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ALTITUDE_OUT_OF_RANGE(), AssertionStatus$.MODULE$.PASSED()));
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ALTITUDE_NON_NUMERIC(), AssertionStatus$.MODULE$.PASSED()));
            MeasurementUnit measurementUnit = sourceUnit2;
            Feet$ feet$ = Feet$.MODULE$;
            if (!(measurementUnit != null ? !measurementUnit.equals(feet$) : feet$ != null)) {
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ALTITUDE_IN_FEET(), "The supplied altitude was in feet it has been converted to metres"));
                return;
            } else {
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ALTITUDE_IN_FEET(), AssertionStatus$.MODULE$.PASSED()));
            }
            return;
        } else {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ALTITUDE_NON_NUMERIC(), new StringBuilder().append((Object)"Can't parse verbatimElevation ").append((Object)raw.location().verbatimElevation()).toString()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processVerbatimDepth(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        if (raw.location().verbatimDepth() == null) return;
        Option<Tuple2<Object, MeasurementUnit>> parseDepthResult = DistanceRangeParser$.MODULE$.parse(raw.location().verbatimDepth());
        if (parseDepthResult.isDefined()) {
            Tuple2 tuple2;
            Tuple2 tuple22 = (Tuple2)parseDepthResult.get();
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            float vdepth = BoxesRunTime.unboxToFloat((Object)tuple22._1());
            MeasurementUnit sourceUnit = (MeasurementUnit)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)vdepth), (Object)sourceUnit);
            float vdepth2 = BoxesRunTime.unboxToFloat((Object)tuple23._1());
            MeasurementUnit sourceUnit2 = (MeasurementUnit)tuple23._2();
            processed.location().verbatimDepth_$eq(((Object)BoxesRunTime.boxToFloat((float)vdepth2)).toString());
            ArrayBuffer arrayBuffer = vdepth2 > (float)10000 ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DEPTH_OUT_OF_RANGE(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Depth ", " is greater than 10,000 metres"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)vdepth2)})))) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DEPTH_OUT_OF_RANGE(), AssertionStatus$.MODULE$.PASSED()));
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DEPTH_NON_NUMERIC(), AssertionStatus$.MODULE$.PASSED()));
            MeasurementUnit measurementUnit = sourceUnit2;
            Feet$ feet$ = Feet$.MODULE$;
            if (!(measurementUnit != null ? !measurementUnit.equals(feet$) : feet$ != null)) {
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DEPTH_IN_FEET(), "The supplied depth was in feet it has been converted to metres"));
                return;
            } else {
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DEPTH_IN_FEET(), AssertionStatus$.MODULE$.PASSED()));
            }
            return;
        } else {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DEPTH_NON_NUMERIC(), new StringBuilder().append((Object)"Can't parse verbatimDepth ").append((Object)raw.location().verbatimDepth()).toString()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setProcessedCoordinates(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        if (raw.location().originalDecimalLatitude() == null || raw.location().originalDecimalLongitude() == null) {
            Option<GISPoint> gisPointOption = this.processLatLong(raw.location().decimalLatitude(), raw.location().decimalLongitude(), raw.location().geodeticDatum(), raw.location().verbatimLatitude(), raw.location().verbatimLongitude(), raw.location().verbatimSRS(), raw.location().easting(), raw.location().northing(), raw.location().zone(), raw.location().gridReference(), assertions);
            Option<GISPoint> option = gisPointOption;
            if (option instanceof Some) {
                Some some = (Some)option;
                GISPoint gisPoint = (GISPoint)some.x();
                processed.location().decimalLatitude_$eq(gisPoint.latitude());
                processed.location().decimalLongitude_$eq(gisPoint.longitude());
                processed.location().geodeticDatum_$eq(gisPoint.datum());
                processed.location().coordinateUncertaintyInMeters_$eq(gisPoint.coordinateUncertaintyInMeters());
                processed.location().bbox_$eq(new StringBuilder().append((Object)gisPoint.minLatitude()).append((Object)",").append((Object)gisPoint.minLongitude()).append((Object)",").append((Object)gisPoint.maxLatitude()).append((Object)",").append((Object)gisPoint.maxLongitude()).toString());
                processed.location().northing_$eq(gisPoint.northing());
                processed.location().easting_$eq(gisPoint.easting());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            } else {
                None$ none$ = None$.MODULE$;
                Option<GISPoint> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) throw new MatchError(option);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        } else {
            processed.location().decimalLatitude_$eq(raw.location().originalDecimalLatitude());
            processed.location().decimalLongitude_$eq(raw.location().originalDecimalLongitude());
            processed.location().verbatimLatitude_$eq(raw.location().originalVerbatimLatitude());
            processed.location().verbatimLongitude_$eq(raw.location().originalVerbatimLongitude());
            raw.location().decimalLatitude_$eq(raw.location().originalDecimalLatitude());
            raw.location().decimalLongitude_$eq(raw.location().originalDecimalLongitude());
        }
    }

    public Option<GISPoint> processLatLong(String rawLatitude, String rawLongitude, String rawGeodeticDatum, String verbatimLatitude, String verbatimLongitude, String verbatimSRS, String easting, String northing, String zone, String gridReference, ArrayBuffer<QualityAssertion> assertions) {
        Option<GISPoint> option;
        if (rawLatitude == null || rawLongitude == null || StringHelper$.MODULE$.string2helper(rawLatitude).toFloatWithOption().isEmpty() || StringHelper$.MODULE$.string2helper(rawLongitude).toFloatWithOption().isEmpty()) {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_COORDINATES_NOT_SUPPLIED()));
            if (verbatimLatitude == null || verbatimLongitude == null) {
                if (easting == null || northing == null || zone == null) {
                    if (gridReference == null) {
                        option = None$.MODULE$;
                    } else {
                        Option<GISPoint> result = GridUtil$.MODULE$.processGridReference(gridReference);
                        Object object = result.isEmpty() ? BoxedUnit.UNIT : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATED_FROM_GRID_REF()));
                        option = result;
                    }
                } else {
                    option = this.processNorthingEastingZone(verbatimSRS, easting, northing, zone, assertions);
                }
            } else {
                Option<Object> decimalVerbatimLat = StringHelper$.MODULE$.string2helper(verbatimLatitude).toFloatWithOption();
                Option<Object> decimalVerbatimLong = StringHelper$.MODULE$.string2helper(verbatimLongitude).toFloatWithOption();
                if (decimalVerbatimLat.isEmpty() || decimalVerbatimLong.isEmpty()) {
                    decimalVerbatimLat = VerbatimLatLongParser$.MODULE$.parse(verbatimLatitude);
                    decimalVerbatimLong = VerbatimLatLongParser$.MODULE$.parse(verbatimLongitude);
                }
                option = decimalVerbatimLat.isEmpty() || decimalVerbatimLong.isEmpty() ? None$.MODULE$ : this.processVerbatimCoordinates(verbatimSRS, assertions, decimalVerbatimLat, decimalVerbatimLong);
            }
        } else {
            option = this.processDecimalCoordinates(rawLatitude, rawLongitude, rawGeodeticDatum, assertions);
        }
        return option;
    }

    private Option<GISPoint> processDecimalCoordinates(String rawLatitude, String rawLongitude, String rawGeodeticDatum, ArrayBuffer<QualityAssertion> assertions) {
        Tuple2 tuple2;
        block7: {
            Some some;
            block3: {
                Tuple2 tuple22;
                Option<Tuple2<String, String>> reprojectedCoords;
                block6: {
                    Option<String> sourceEpsgCode;
                    block5: {
                        block4: {
                            block2: {
                                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_COORDINATES_NOT_SUPPLIED(), AssertionStatus$.MODULE$.PASSED()));
                                if (rawGeodeticDatum != null) break block2;
                                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.GEODETIC_DATUM_ASSUMED_WGS84(), "Geodetic datum assumed to be WGS84 (EPSG:4326)"));
                                some = new Some((Object)new GISPoint(rawLatitude, rawLongitude, GISUtil$.MODULE$.WGS84_EPSG_Code(), null, GISPoint$.MODULE$.apply$default$5(), GISPoint$.MODULE$.apply$default$6(), GISPoint$.MODULE$.apply$default$7(), GISPoint$.MODULE$.apply$default$8(), GISPoint$.MODULE$.apply$default$9(), GISPoint$.MODULE$.apply$default$10()));
                                break block3;
                            }
                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.GEODETIC_DATUM_ASSUMED_WGS84(), AssertionStatus$.MODULE$.PASSED()));
                            sourceEpsgCode = this.lookupEpsgCode(rawGeodeticDatum);
                            if (!sourceEpsgCode.isEmpty()) break block4;
                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNRECOGNIZED_GEODETIC_DATUM(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Geodetic datum ", " not recognized."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rawGeodeticDatum}))));
                            some = new Some((Object)new GISPoint(rawLatitude, rawLongitude, rawGeodeticDatum, null, GISPoint$.MODULE$.apply$default$5(), GISPoint$.MODULE$.apply$default$6(), GISPoint$.MODULE$.apply$default$7(), GISPoint$.MODULE$.apply$default$8(), GISPoint$.MODULE$.apply$default$9(), GISPoint$.MODULE$.apply$default$10()));
                            break block3;
                        }
                        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNRECOGNIZED_GEODETIC_DATUM(), AssertionStatus$.MODULE$.PASSED()));
                        Object object = sourceEpsgCode.get();
                        String string = GISUtil$.MODULE$.WGS84_EPSG_Code();
                        if (object != null ? !object.equals(string) : string != null) break block5;
                        some = new Some((Object)new GISPoint(rawLatitude, rawLongitude, GISUtil$.MODULE$.WGS84_EPSG_Code(), null, GISPoint$.MODULE$.apply$default$5(), GISPoint$.MODULE$.apply$default$6(), GISPoint$.MODULE$.apply$default$7(), GISPoint$.MODULE$.apply$default$8(), GISPoint$.MODULE$.apply$default$9(), GISPoint$.MODULE$.apply$default$10()));
                        break block3;
                    }
                    int desiredNoDecimalPlaces = package$.MODULE$.min(this.getNumberOfDecimalPlacesInDouble(rawLatitude), this.getNumberOfDecimalPlacesInDouble(rawLongitude));
                    reprojectedCoords = GISUtil$.MODULE$.reprojectCoordinatesToWGS84(new StringOps(Predef$.MODULE$.augmentString(rawLatitude)).toDouble(), new StringOps(Predef$.MODULE$.augmentString(rawLongitude)).toDouble(), (String)sourceEpsgCode.get(), desiredNoDecimalPlaces);
                    if (!reprojectedCoords.isEmpty()) break block6;
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CONVERSION_FAILED(), "Transformation of decimal latiude and longitude to WGS84 failed"));
                    some = None$.MODULE$;
                    break block3;
                }
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CONVERSION_FAILED(), AssertionStatus$.MODULE$.PASSED()));
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CONVERTED(), "Decimal latitude and longitude were converted to WGS84 (EPSG:4326)"));
                tuple2 = (Tuple2)reprojectedCoords.get();
                if (tuple2 == null) break block7;
                String reprojectedLatitude = (String)tuple2._1();
                String reprojectedLongitude = (String)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)reprojectedLatitude, (Object)reprojectedLongitude);
                String reprojectedLatitude2 = (String)tuple23._1();
                String reprojectedLongitude2 = (String)tuple23._2();
                some = new Some((Object)new GISPoint(reprojectedLatitude2, reprojectedLongitude2, GISUtil$.MODULE$.WGS84_EPSG_Code(), null, GISPoint$.MODULE$.apply$default$5(), GISPoint$.MODULE$.apply$default$6(), GISPoint$.MODULE$.apply$default$7(), GISPoint$.MODULE$.apply$default$8(), GISPoint$.MODULE$.apply$default$9(), GISPoint$.MODULE$.apply$default$10()));
            }
            return some;
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<GISPoint> processVerbatimCoordinates(String verbatimSRS, ArrayBuffer<QualityAssertion> assertions, Option<Object> decimalVerbatimLat, Option<Object> decimalVerbatimLong) {
        None$ none$;
        if (StringHelper$.MODULE$.string2helper(decimalVerbatimLat.get().toString()).isLatitude() && StringHelper$.MODULE$.string2helper(decimalVerbatimLong.get().toString()).isLongitude()) {
            if (verbatimSRS == null) {
                if (StringHelper$.MODULE$.string2helper(decimalVerbatimLat.get().toString()).isLatitude() && StringHelper$.MODULE$.string2helper(decimalVerbatimLong.get().toString()).isLongitude()) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_VERBATIM_FAILED(), AssertionStatus$.MODULE$.PASSED()));
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATED_FROM_VERBATIM(), "Decimal latitude and longitude were calculated using verbatimLatitude, verbatimLongitude and verbatimSRS"));
                    none$ = new Some((Object)new GISPoint(decimalVerbatimLat.get().toString(), decimalVerbatimLong.get().toString(), GISUtil$.MODULE$.WGS84_EPSG_Code(), null, GISPoint$.MODULE$.apply$default$5(), GISPoint$.MODULE$.apply$default$6(), GISPoint$.MODULE$.apply$default$7(), GISPoint$.MODULE$.apply$default$8(), GISPoint$.MODULE$.apply$default$9(), GISPoint$.MODULE$.apply$default$10()));
                    return none$;
                } else {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_VERBATIM_FAILED(), "Could not parse verbatim latitude and longitude"));
                    none$ = None$.MODULE$;
                }
                return none$;
            } else {
                Option<String> sourceEpsgCode = this.lookupEpsgCode(verbatimSRS);
                if (sourceEpsgCode.isEmpty()) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_VERBATIM_FAILED(), new StringBuilder().append((Object)"Unrecognized verbatimSRS ").append((Object)verbatimSRS).toString()));
                    none$ = None$.MODULE$;
                    return none$;
                } else {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_VERBATIM_FAILED(), AssertionStatus$.MODULE$.PASSED()));
                    Object object = sourceEpsgCode.get();
                    String string = GISUtil$.MODULE$.WGS84_EPSG_Code();
                    if (!(object != null ? !object.equals(string) : string != null)) {
                        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATED_FROM_VERBATIM(), "Decimal latitude and longitude were calculated using verbatimLatitude, verbatimLongitude and verbatimSRS"));
                        none$ = new Some((Object)new GISPoint(decimalVerbatimLat.get().toString(), decimalVerbatimLong.get().toString(), GISUtil$.MODULE$.WGS84_EPSG_Code(), null, GISPoint$.MODULE$.apply$default$5(), GISPoint$.MODULE$.apply$default$6(), GISPoint$.MODULE$.apply$default$7(), GISPoint$.MODULE$.apply$default$8(), GISPoint$.MODULE$.apply$default$9(), GISPoint$.MODULE$.apply$default$10()));
                        return none$;
                    } else {
                        int desiredNoDecimalPlaces = package$.MODULE$.min(this.getNumberOfDecimalPlacesInDouble(decimalVerbatimLat.get().toString()), this.getNumberOfDecimalPlacesInDouble(decimalVerbatimLong.get().toString()));
                        Option<Tuple2<String, String>> reprojectedCoords = GISUtil$.MODULE$.reprojectCoordinatesToWGS84(BoxesRunTime.unboxToFloat((Object)decimalVerbatimLat.get()), BoxesRunTime.unboxToFloat((Object)decimalVerbatimLong.get()), (String)sourceEpsgCode.get(), desiredNoDecimalPlaces);
                        if (reprojectedCoords.isEmpty()) {
                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_VERBATIM_FAILED(), "Transformation of verbatim latiude and longitude to WGS84 failed"));
                            none$ = None$.MODULE$;
                            return none$;
                        } else {
                            Tuple2 tuple2;
                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_VERBATIM_FAILED(), AssertionStatus$.MODULE$.PASSED()));
                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATED_FROM_VERBATIM(), "Decimal latitude and longitude were calculated using verbatimLatitude, verbatimLongitude and verbatimSRS"));
                            Tuple2 tuple22 = (Tuple2)reprojectedCoords.get();
                            if (tuple22 == null) throw new MatchError((Object)tuple22);
                            String reprojectedLatitude = (String)tuple22._1();
                            String reprojectedLongitude = (String)tuple22._2();
                            Tuple2 tuple23 = tuple2 = new Tuple2((Object)reprojectedLatitude, (Object)reprojectedLongitude);
                            String reprojectedLatitude2 = (String)tuple23._1();
                            String reprojectedLongitude2 = (String)tuple23._2();
                            none$ = new Some((Object)new GISPoint(reprojectedLatitude2, reprojectedLongitude2, GISUtil$.MODULE$.WGS84_EPSG_Code(), null, GISPoint$.MODULE$.apply$default$5(), GISPoint$.MODULE$.apply$default$6(), GISPoint$.MODULE$.apply$default$7(), GISPoint$.MODULE$.apply$default$8(), GISPoint$.MODULE$.apply$default$9(), GISPoint$.MODULE$.apply$default$10()));
                        }
                    }
                }
            }
            return none$;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<GISPoint> processNorthingEastingZone(String verbatimSRS, String easting, String northing, String zone, ArrayBuffer<QualityAssertion> assertions) {
        None$ none$;
        String epsgCodeKey;
        String string = epsgCodeKey = verbatimSRS == null ? new StringBuilder().append((Object)"GDA94|").append((Object)zone).toString() : new StringBuilder().append((Object)verbatimSRS.toUpperCase()).append((Object)"|").append((Object)zone).toString();
        if (this.zoneEpsgCodesMap().contains((Object)epsgCodeKey)) {
            String crsEpsgCode = (String)this.zoneEpsgCodesMap().apply((Object)epsgCodeKey);
            Option<Object> eastingAsDouble = StringHelper$.MODULE$.string2helper(easting).toDoubleWithOption();
            Option<Object> northingAsDouble = StringHelper$.MODULE$.string2helper(northing).toDoubleWithOption();
            if (eastingAsDouble.isEmpty() || northingAsDouble.isEmpty()) {
                none$ = None$.MODULE$;
                return none$;
            } else {
                Option<Tuple2<String, String>> reprojectedCoords = GISUtil$.MODULE$.reprojectCoordinatesToWGS84(BoxesRunTime.unboxToDouble((Object)eastingAsDouble.get()), BoxesRunTime.unboxToDouble((Object)northingAsDouble.get()), crsEpsgCode, 5);
                if (reprojectedCoords.isEmpty()) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_EASTING_NORTHING_FAILED(), "Transformation of verbatim easting and northing to WGS84 failed"));
                    none$ = None$.MODULE$;
                    return none$;
                } else {
                    Tuple2 tuple2;
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_EASTING_NORTHING_FAILED(), AssertionStatus$.MODULE$.PASSED()));
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATED_FROM_EASTING_NORTHING(), "Decimal latitude and longitude were calculated using easting, northing and zone."));
                    Tuple2 tuple22 = (Tuple2)reprojectedCoords.get();
                    if (tuple22 == null) throw new MatchError((Object)tuple22);
                    String reprojectedLatitude = (String)tuple22._1();
                    String reprojectedLongitude = (String)tuple22._2();
                    Tuple2 tuple23 = tuple2 = new Tuple2((Object)reprojectedLatitude, (Object)reprojectedLongitude);
                    String reprojectedLatitude2 = (String)tuple23._1();
                    String reprojectedLongitude2 = (String)tuple23._2();
                    none$ = new Some((Object)new GISPoint(reprojectedLatitude2, reprojectedLongitude2, GISUtil$.MODULE$.WGS84_EPSG_Code(), null, GISPoint$.MODULE$.apply$default$5(), GISPoint$.MODULE$.apply$default$6(), GISPoint$.MODULE$.apply$default$7(), GISPoint$.MODULE$.apply$default$8(), GISPoint$.MODULE$.apply$default$9(), GISPoint$.MODULE$.apply$default$10()));
                }
            }
            return none$;
        } else {
            ArrayBuffer arrayBuffer = verbatimSRS == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_EASTING_NORTHING_FAILED(), new StringBuilder().append((Object)"Unrecognized zone GDA94 / MGA zone ").append((Object)zone).toString())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_EASTING_NORTHING_FAILED(), new StringBuilder().append((Object)"Unrecognized zone ").append((Object)verbatimSRS).append((Object)" / zone ").append((Object)zone).toString()));
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public int getNumberOfDecimalPlacesInDouble(String decimalAsString) {
        String[] tokens = new StringOps(Predef$.MODULE$.augmentString(decimalAsString)).split('.');
        return tokens.length == 2 ? tokens[1].length() : 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Option<String> lookupEpsgCode(String crs) {
        None$ none$;
        if (StringUtils.startsWithIgnoreCase((String)crs, (String)"EPSG:")) {
            try {
                CRS.decode((String)crs.toUpperCase());
                none$ = new Some((Object)crs.toUpperCase());
                return none$;
            }
            catch (Exception exception) {
                none$ = None$.MODULE$;
                return none$;
            }
        } else {
            if (this.crsEpsgCodesMap().contains((Object)crs.toUpperCase())) {
                none$ = new Some(this.crsEpsgCodesMap().apply((Object)crs.toUpperCase()));
                return none$;
            }
            none$ = None$.MODULE$;
            return none$;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkCoordinateUncertainty(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        ArrayBuffer arrayBuffer;
        BoxedUnit boxedUnit;
        boolean checkedPrecision = false;
        if (raw.location().coordinateUncertaintyInMeters() != null && raw.location().coordinateUncertaintyInMeters().length() > 0) {
            Option<Tuple2<Object, MeasurementUnit>> parsedResult = DistanceRangeParser$.MODULE$.parse(raw.location().coordinateUncertaintyInMeters());
            if (parsedResult.isEmpty()) {
                String comment = new StringBuilder().append((Object)"Supplied uncertainty, ").append((Object)raw.location().coordinateUncertaintyInMeters()).append((Object)", is not a supported format").toString();
                boxedUnit = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNCERTAINTY_RANGE_MISMATCH(), comment));
            } else {
                ArrayBuffer arrayBuffer2;
                Tuple2 tuple2;
                Tuple2 tuple22 = (Tuple2)parsedResult.get();
                if (tuple22 == null) throw new MatchError((Object)tuple22);
                float parsedValue = BoxesRunTime.unboxToFloat((Object)tuple22._1());
                MeasurementUnit rawUnit = (MeasurementUnit)tuple22._2();
                Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)parsedValue), (Object)rawUnit);
                float parsedValue2 = BoxesRunTime.unboxToFloat((Object)tuple23._1());
                MeasurementUnit rawUnit2 = (MeasurementUnit)tuple23._2();
                if (parsedValue2 > 0.0f) {
                    arrayBuffer2 = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNCERTAINTY_RANGE_MISMATCH(), AssertionStatus$.MODULE$.PASSED()));
                } else {
                    String comment = new StringBuilder().append((Object)"Supplied uncertainty, ").append((Object)raw.location().coordinateUncertaintyInMeters()).append((Object)", is not a supported format").toString();
                    arrayBuffer2 = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNCERTAINTY_RANGE_MISMATCH(), comment));
                }
                processed.location().coordinateUncertaintyInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)parsedValue2)).toString());
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            Option<Object> value;
            if (raw.location().coordinatePrecision() != null && !(value = StringHelper$.MODULE$.string2helper(raw.location().coordinatePrecision()).toFloatWithOption()).isEmpty() && BoxesRunTime.unboxToFloat((Object)value.get()) > 1.0f) {
                processed.location().coordinateUncertaintyInMeters_$eq(((Object)BoxesRunTime.boxToInteger((int)((int)BoxesRunTime.unboxToFloat((Object)value.get())))).toString());
                String comment = new StringBuilder().append((Object)"Supplied precision, ").append((Object)raw.location().coordinatePrecision()).append((Object)", is assumed to be uncertainty in metres").toString();
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNCERTAINTY_IN_PRECISION(), comment));
                checkedPrecision = true;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        if (raw.location().coordinatePrecision() == null) {
            arrayBuffer = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_COORDINATEPRECISION(), "Missing coordinatePrecision"));
        } else {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_COORDINATEPRECISION(), AssertionStatus$.MODULE$.PASSED()));
            if (checkedPrecision) {
                arrayBuffer = BoxedUnit.UNIT;
            } else {
                Option<Object> value = StringHelper$.MODULE$.string2helper(raw.location().coordinatePrecision()).toFloatWithOption();
                if (value.isDefined()) {
                    if (BoxesRunTime.unboxToFloat((Object)value.get()) > 0.0f && BoxesRunTime.unboxToFloat((Object)value.get()) <= 1.0f) {
                        int lonp;
                        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.PRECISION_RANGE_MISMATCH(), AssertionStatus$.MODULE$.PASSED()));
                        int pre = raw.location().coordinatePrecision().contains(".") ? raw.location().coordinatePrecision().split("\\.")[1].length() : 0;
                        String lat2 = processed.location().decimalLatitude();
                        String string = processed.location().decimalLongitude();
                        int latp = lat2.contains(".") ? lat2.split("\\.")[1].length() : 0;
                        int n = lonp = string.contains(".") ? string.split("\\.")[1].length() : 0;
                        arrayBuffer = pre == latp && pre == lonp ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATE_PRECISION_MISMATCH(), AssertionStatus$.MODULE$.PASSED())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATE_PRECISION_MISMATCH()));
                    } else {
                        arrayBuffer = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.PRECISION_RANGE_MISMATCH(), "Coordinate precision is not between 0 and 1"));
                    }
                } else {
                    arrayBuffer = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.PRECISION_RANGE_MISMATCH(), "Unable to parse the coordinate precision"));
                }
            }
        }
        if (processed.location().coordinateUncertaintyInMeters() == null) {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNCERTAINTY_NOT_SPECIFIED(), "Uncertainty was not supplied"));
            return;
        } else {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNCERTAINTY_NOT_SPECIFIED(), AssertionStatus$.MODULE$.PASSED()));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void checkForHabitatMismatch(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        block9: {
            block8: {
                if (processed.location().biome() == null) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATE_HABITAT_MISMATCH(), 2));
                    return;
                }
                taxonProfileWithOption = TaxonProfileDAO$.MODULE$.getByGuid(processed.classification().taxonConceptID());
                genusProfileWithOption = TaxonProfileDAO$.MODULE$.getByGuid(processed.classification().genusID());
                if (taxonProfileWithOption.isEmpty()) break block8;
                if (((TaxonProfile)taxonProfileWithOption.get()).habitats() == null || Predef$.MODULE$.refArrayOps((Object[])((TaxonProfile)taxonProfileWithOption.get()).habitats()).isEmpty()) break block8;
                v0 = ((TaxonProfile)taxonProfileWithOption.get()).habitats();
                break block9;
            }
            if (genusProfileWithOption.isEmpty()) ** GOTO lbl-1000
            if (((TaxonProfile)genusProfileWithOption.get()).habitats() != null && !Predef$.MODULE$.refArrayOps((Object[])((TaxonProfile)genusProfileWithOption.get()).habitats()).isEmpty()) {
                v0 = ((TaxonProfile)genusProfileWithOption.get()).habitats();
            } else lbl-1000:
            // 2 sources

            {
                v0 = habitats = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
            }
        }
        if (Predef$.MODULE$.refArrayOps((Object[])habitats).isEmpty()) {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATE_HABITAT_MISMATCH(), AssertionStatus$.MODULE$.UNCHECKED()));
        } else {
            habitatsAsString = Predef$.MODULE$.refArrayOps((Object[])habitats).mkString(",");
            habitatFromPoint = processed.location().biome();
            validHabitat = HabitatMap$.MODULE$.areTermsCompatible(habitatFromPoint, habitatsForSpecies = habitats);
            if (!validHabitat.isEmpty()) {
                if (BoxesRunTime.unboxToBoolean((Object)validHabitat.get())) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATE_HABITAT_MISMATCH(), AssertionStatus$.MODULE$.PASSED()));
                } else {
                    this.logger().debug(new StringBuilder().append((Object)"[QualityAssertion] ******** Habitats incompatible for ROWKEY: ").append((Object)raw.rowKey()).append((Object)", processed:").append((Object)processed.location().biome()).append((Object)", retrieved:").append((Object)habitatsAsString).append((Object)", http://maps.google.com/?ll=").append((Object)processed.location().decimalLatitude()).append((Object)",").append((Object)processed.location().decimalLongitude()).toString());
                    comment = new StringBuilder().append((Object)"Recognised habitats for species: ").append((Object)habitatsAsString).append((Object)", Value determined from coordinates: ").append((Object)habitatFromPoint).toString();
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATE_HABITAT_MISMATCH(), comment));
                }
            }
        }
    }

    private void addConservationStatus(FullRecord raw, FullRecord processed) {
        Option<TaxonProfile> taxonProfileWithOption = TaxonProfileDAO$.MODULE$.getByGuid(processed.classification().taxonConceptID());
        if (!taxonProfileWithOption.isEmpty()) {
            TaxonProfile taxonProfile = (TaxonProfile)taxonProfileWithOption.get();
            if (taxonProfile.conservation() != null) {
                Option<String> country = taxonProfile.retrieveConservationStatus(processed.location().country());
                processed.occurrence().countryConservation_$eq((String)country.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                }));
                Option<String> state = taxonProfile.retrieveConservationStatus(processed.location().stateProvince());
                processed.occurrence().stateConservation_$eq((String)state.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                }));
                Option<String> global = taxonProfile.retrieveConservationStatus("Global");
                processed.occurrence().globalConservation_$eq((String)global.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                }));
            }
        }
    }

    private void checkForStateMismatch(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        if (processed.location().stateProvince() == null || raw.location().stateProvince() == null) {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.STATE_COORDINATE_MISMATCH(), AssertionStatus$.MODULE$.UNCHECKED()));
        } else {
            Option<Term> stateTerm = StateProvinces$.MODULE$.matchTerm(raw.location().stateProvince());
            if (stateTerm.isEmpty() || processed.location().stateProvince().equalsIgnoreCase(((Term)stateTerm.get()).canonical())) {
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.STATE_COORDINATE_MISMATCH(), AssertionStatus$.MODULE$.PASSED()));
            } else {
                this.logger().debug(new StringBuilder().append((Object)"[QualityAssertion] ").append((Object)raw.rowKey()).append((Object)", processed:").append((Object)processed.location().stateProvince()).append((Object)", raw:").append((Object)raw.location().stateProvince()).toString());
                String comment = new StringBuilder().append((Object)"Supplied: ").append((Object)((Term)stateTerm.get()).canonical()).append((Object)", calculated: ").append((Object)processed.location().stateProvince()).toString();
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.STATE_COORDINATE_MISMATCH(), comment));
            }
        }
    }

    public ArrayBuffer<QualityAssertion> validateGeoreferenceValues(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        ArrayBuffer arrayBuffer = raw.location().geodeticDatum() == null && processed.location().geodeticDatum() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEODETICDATUM(), "Missing geodeticDatum")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEODETICDATUM(), AssertionStatus$.MODULE$.PASSED()));
        ArrayBuffer arrayBuffer2 = raw.location().georeferencedBy() == null && processed.location().georeferencedBy() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERNCEDBY(), "Missing georeferencedBy")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERNCEDBY(), AssertionStatus$.MODULE$.PASSED()));
        ArrayBuffer arrayBuffer3 = raw.location().georeferenceProtocol() == null && processed.location().georeferenceProtocol() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCEPROTOCOL(), "Missing georeferenceProtocol")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCEPROTOCOL(), AssertionStatus$.MODULE$.PASSED()));
        ArrayBuffer arrayBuffer4 = raw.location().georeferenceSources() == null && processed.location().georeferenceSources() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCESOURCES(), "Missing georeferenceSources")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCESOURCES(), AssertionStatus$.MODULE$.PASSED()));
        ArrayBuffer arrayBuffer5 = raw.location().georeferenceVerificationStatus() == null && processed.location().georeferenceVerificationStatus() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCEVERIFICATIONSTATUS(), "Missing georeferenceVerificationStatus")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCEVERIFICATIONSTATUS(), AssertionStatus$.MODULE$.PASSED()));
        return StringUtils.isBlank((String)raw.location().georeferencedDate()) && !raw.miscProperties().containsKey("georeferencedDate") ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCE_DATE())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCE_DATE(), AssertionStatus$.MODULE$.PASSED()));
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object validateCoordinatesValues(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        BoxedUnit boxedUnit;
        Some some;
        Tuple2 tuple2;
        float lon2;
        float lat2;
        BoxedUnit boxedUnit2;
        block20: {
            block19: {
                ArrayBuffer arrayBuffer;
                ArrayBuffer arrayBuffer2;
                Option<Object> latWithOption = StringHelper$.MODULE$.string2helper(processed.location().decimalLatitude()).toFloatWithOption();
                Option<Object> lonWithOption = StringHelper$.MODULE$.string2helper(processed.location().decimalLongitude()).toFloatWithOption();
                if (latWithOption.isEmpty() || lonWithOption.isEmpty()) {
                    boxedUnit2 = BoxedUnit.UNIT;
                    return boxedUnit2;
                }
                lat2 = BoxesRunTime.unboxToFloat((Object)latWithOption.get());
                lon2 = BoxesRunTime.unboxToFloat((Object)lonWithOption.get());
                if (lat2 < (float)-90 || lat2 > (float)90 || lon2 < (float)-180 || lon2 > (float)180) {
                    if (lon2 >= (float)-90 && lon2 <= (float)90 && lat2 >= (float)-180 && lat2 <= (float)180) {
                        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVERTED_COORDINATES(), new StringBuilder().append((Object)"Assume that coordinates have been inverted. Original values: ").append((Object)processed.location().decimalLatitude()).append((Object)",").append((Object)processed.location().decimalLongitude()).toString()));
                        String tmp = processed.location().decimalLatitude();
                        processed.location().decimalLatitude_$eq(processed.location().decimalLongitude());
                        processed.location().decimalLongitude_$eq(tmp);
                        arrayBuffer2 = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_OUT_OF_RANGE(), AssertionStatus$.MODULE$.PASSED()));
                    } else {
                        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_OUT_OF_RANGE(), new StringBuilder().append((Object)"Coordinates are out of range: ").append((Object)processed.location().decimalLatitude()).append((Object)",").append((Object)processed.location().decimalLongitude()).toString()));
                        arrayBuffer2 = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVERTED_COORDINATES(), AssertionStatus$.MODULE$.PASSED()));
                    }
                } else {
                    arrayBuffer2 = assertions.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new QualityAssertion[]{QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVERTED_COORDINATES(), AssertionStatus$.MODULE$.PASSED()), QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_OUT_OF_RANGE(), AssertionStatus$.MODULE$.PASSED())}));
                }
                if (lat2 == 0.0f && lon2 == 0.0f) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ZERO_COORDINATES(), "Coordinates 0,0"));
                    processed.location().decimalLatitude_$eq(null);
                    processed.location().decimalLongitude_$eq(null);
                    arrayBuffer = BoxedUnit.UNIT;
                } else {
                    arrayBuffer = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ZERO_COORDINATES(), AssertionStatus$.MODULE$.PASSED()));
                }
                ArrayBuffer arrayBuffer3 = lat2 == 0.0f ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ZERO_LATITUDE_COORDINATES(), "Latitude 0,0")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ZERO_LATITUDE_COORDINATES(), AssertionStatus$.MODULE$.PASSED()));
                ArrayBuffer arrayBuffer4 = lon2 == 0.0f ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ZERO_LONGITUDE_COORDINATES(), "Longitude 0,0")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ZERO_LONGITUDE_COORDINATES(), AssertionStatus$.MODULE$.PASSED()));
                if (raw.location().country() == null) break block19;
                String string = raw.location().country();
                String string2 = "";
                if (string != null ? !string.equals(string2) : string2 != null) break block20;
            }
            boxedUnit2 = BoxedUnit.UNIT;
            return boxedUnit2;
        }
        Option<Term> country = Countries$.MODULE$.matchTerm(raw.location().country());
        if (country.isEmpty()) {
            boxedUnit2 = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNKNOWN_COUNTRY_NAME(), new StringBuilder().append((Object)"Country name '").append((Object)raw.location().country()).append((Object)"' not recognised.").toString()));
            return boxedUnit2;
        }
        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNKNOWN_COUNTRY_NAME(), AssertionStatus$.MODULE$.PASSED()));
        Option<Tuple2<LatLng, BBox>> option = CountryCentrePoints$.MODULE$.matchName(((Term)country.get()).canonical());
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).x()) != null) {
            BoxedUnit boxedUnit3;
            BBox bbox = (BBox)tuple2._2();
            if (bbox.containsPoint(lat2, lon2)) {
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boolean hasCoordinateMismatch = true;
                if (bbox.containsPoint(lat2 * (float)-1, lon2)) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.NEGATED_LATITUDE(), new StringBuilder().append((Object)"Latitude seems to be negated. Original value:").append((Object)processed.location().decimalLatitude()).toString()));
                    processed.location().decimalLatitude_$eq(((Object)BoxesRunTime.boxToFloat((float)(lat2 * (float)-1))).toString());
                    hasCoordinateMismatch = false;
                }
                if (bbox.containsPoint(lat2, lon2 * (float)-1)) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.NEGATED_LONGITUDE(), new StringBuilder().append((Object)"Longitude seems to be negated. Original value: ").append((Object)processed.location().decimalLongitude()).toString()));
                    processed.location().decimalLongitude_$eq(((Object)BoxesRunTime.boxToFloat((float)(lon2 * (float)-1))).toString());
                    hasCoordinateMismatch = false;
                }
                boxedUnit3 = hasCoordinateMismatch ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COUNTRY_COORDINATE_MISMATCH())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COUNTRY_COORDINATE_MISMATCH(), AssertionStatus$.MODULE$.PASSED()));
            }
            boxedUnit = boxedUnit3;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        boxedUnit2 = boxedUnit;
        return boxedUnit2;
    }

    private void processSensitivity(FullRecord raw, FullRecord processed) {
        Object object;
        this.logger().debug("Starting SDS check");
        scala.collection.mutable.Map rawMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Predef$.MODULE$.refArrayOps((Object[])raw.objectArray()).foreach((Function1)new Serializable(this, rawMap){
            public static final long serialVersionUID = 0L;
            private final scala.collection.mutable.Map rawMap$1;

            public final void apply(POSO poso) {
                scala.collection.immutable.Map<String, String> map = FullRecordMapper$.MODULE$.mapObjectToProperties(poso, Versions$.MODULE$.RAW());
                JavaConversions$.MODULE$.mutableMapAsJavaMap(this.rawMap$1).putAll(JavaConversions$.MODULE$.mapAsJavaMap(map));
            }
            {
                this.rawMap$1 = rawMap$1;
            }
        });
        if (StringHelper$.MODULE$.string2helper(processed.location().decimalLongitude()).toDoubleWithOption().isEmpty() || StringHelper$.MODULE$.string2helper(processed.location().decimalLatitude()).toDoubleWithOption().isEmpty()) {
            object = BoxedUnit.UNIT;
        } else {
            Option<Term> stringMatchState;
            scala.collection.immutable.Map<String, String> layerIntersect = SensitiveAreaDAO$.MODULE$.intersect(new StringOps(Predef$.MODULE$.augmentString(processed.location().decimalLongitude())).toDouble(), new StringOps(Predef$.MODULE$.augmentString(processed.location().decimalLatitude())).toDouble());
            JavaConversions$.MODULE$.asScalaBuffer(GeoLocationHelper.getGeospatialLayers()).foreach((Function1)new Serializable(this, rawMap, layerIntersect){
                public static final long serialVersionUID = 0L;
                private final scala.collection.mutable.Map rawMap$1;
                private final scala.collection.immutable.Map layerIntersect$1;

                public final Option<String> apply(String key) {
                    return this.rawMap$1.put((Object)key, this.layerIntersect$1.getOrElse((Object)key, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "n/a";
                        }
                    }));
                }
                {
                    this.rawMap$1 = rawMap$1;
                    this.layerIntersect$1 = layerIntersect$1;
                }
            });
            String intersectStateProvince = (String)layerIntersect.getOrElse((Object)Config$.MODULE$.stateProvinceLayerID(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            });
            object = StringUtils.isBlank((String)intersectStateProvince) ? ((stringMatchState = StateProvinces$.MODULE$.matchTerm(raw.location().stateProvince())).isEmpty() ? BoxedUnit.UNIT : rawMap.put((Object)"stateProvince", (Object)((Term)stringMatchState.get()).canonical())) : rawMap.put((Object)"stateProvince", (Object)intersectStateProvince);
        }
        if (processed.event().day() != null) {
            rawMap.update((Object)"day", (Object)processed.event().day());
        }
        if (processed.event().month() != null) {
            rawMap.update((Object)"month", (Object)processed.event().month());
        }
        if (processed.event().year() != null) {
            rawMap.update((Object)"year", (Object)processed.event().year());
        }
        String exact = this.getExactSciName(raw);
        ValidationOutcome outcome = this.sds().testMapDetails(Config$.MODULE$.sdsFinder(), JavaConversions$.MODULE$.mutableMapAsJavaMap(rawMap), exact, processed.classification().taxonConceptID());
        this.logger().debug(new StringBuilder().append((Object)"SDS outcome: ").append((Object)outcome).toString());
        if (outcome != null && outcome.isValid() && outcome.isSensitive()) {
            Object object2;
            if (outcome.getResult() == null) {
                if (!outcome.isLoadable() && Config$.MODULE$.obeySDSIsLoadable()) {
                    this.logger().warn(new StringBuilder().append((Object)"SDS isLoadable status is currently not being used. Would apply to: ").append((Object)processed.uuid()).toString());
                }
                object2 = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit;
                scala.collection.mutable.Map map = JavaConversions$.MODULE$.mapAsScalaMap(outcome.getResult());
                scala.collection.mutable.Map stringMap = (scala.collection.mutable.Map)map.collect((PartialFunction)new Serializable(this, processed){
                    public static final long serialVersionUID = 0L;
                    private final FullRecord processed$1;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends Tuple2<String, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 != null) {
                            String key = (String)A1._1();
                            Object value = A1._2();
                            if (value != null) {
                                Tuple2 tuple2;
                                String string = key;
                                String string2 = "originalSensitiveValues";
                                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                    HashMap osv = (HashMap)value;
                                    Object object2 = this.processed$1.location().coordinateUncertaintyInMeters() == null ? BoxedUnit.UNIT : osv.put("coordinateUncertaintyInMeters.p", this.processed$1.location().coordinateUncertaintyInMeters());
                                    JavaConversions$.MODULE$.asScalaBuffer(GeoLocationHelper.getGeospatialLayers()).foreach((Function1)new Serializable(this, osv){
                                        public static final long serialVersionUID = 0L;
                                        private final HashMap osv$1;

                                        public final String apply(String key) {
                                            return (String)this.osv$1.remove(key);
                                        }
                                        {
                                            this.osv$1 = osv$1;
                                        }
                                    });
                                    String newv = Json$.MODULE$.toJSON(osv);
                                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)key), (Object)newv);
                                } else {
                                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)key), (Object)value.toString());
                                }
                                object = tuple2;
                                return (B1)object;
                            }
                        }
                        object = function1.apply(x1);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Tuple2<String, Object> x1) {
                        Object value;
                        Tuple2<String, Object> tuple2 = x1;
                        boolean bl = tuple2 != null && (value = tuple2._2()) != null;
                        return bl;
                    }
                    {
                        this.processed$1 = processed$1;
                    }
                }, Map$.MODULE$.canBuildFrom());
                Option uncertainty = stringMap.get((Object)"generalisationInMetres");
                if (uncertainty.isEmpty()) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    if (StringUtils.isNotEmpty((String)((String)uncertainty.get()).toString())) {
                        float currentUncertainty = StringUtils.isNotEmpty((String)processed.location().coordinateUncertaintyInMeters()) ? Float.parseFloat(processed.location().coordinateUncertaintyInMeters()) : 0.0f;
                        float newUncertainty = currentUncertainty + (float)Integer.parseInt(((String)uncertainty.get()).toString());
                        processed.location().coordinateUncertaintyInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)newUncertainty)).toString());
                    }
                    processed.location().decimalLatitude_$eq((String)stringMap.getOrElse((Object)"decimalLatitude", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "";
                        }
                    }));
                    processed.location().decimalLongitude_$eq((String)stringMap.getOrElse((Object)"decimalLongitude", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "";
                        }
                    }));
                    boxedUnit = stringMap.$minus$eq((Object)"generalisationInMetres");
                }
                processed.occurrence().informationWithheld_$eq((String)stringMap.getOrElse((Object)"informationWithheld", (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                }));
                processed.occurrence().dataGeneralizations_$eq((String)stringMap.getOrElse((Object)"dataGeneralizations", (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                }));
                stringMap.$minus$eq((Object)"informationWithheld");
                stringMap.$minus$eq((Object)"dataGeneralizations");
                raw.event().day_$eq("");
                processed.event().day_$eq("");
                processed.event().eventDate_$eq("");
                if (processed.event().eventDateEnd() != null) {
                    processed.event().eventDateEnd_$eq("");
                }
                object2 = StringUtils.isNotBlank((String)raw.rowKey()) ? Config$.MODULE$.persistenceManager().put(raw.rowKey(), "occ", (scala.collection.immutable.Map<String, String>)stringMap.toMap(Predef$.MODULE$.conforms()), false) : BoxedUnit.UNIT;
            }
            if (outcome.getReport().getMessages() != null) {
                ObjectRef infoMessage = new ObjectRef((Object)"");
                JavaConversions$.MODULE$.asScalaBuffer(outcome.getReport().getMessages()).foreach((Function1)new Serializable(this, infoMessage){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef infoMessage$1;

                    public final void apply(Message message) {
                        this.infoMessage$1.elem = new StringBuilder().append((Object)((String)this.infoMessage$1.elem)).append((Object)new StringBuilder().append((Object)message.getCategory()).append((Object)"\t").append((Object)message.getMessageText()).append((Object)"\n").toString()).toString();
                    }
                    {
                        this.infoMessage$1 = infoMessage$1;
                    }
                });
                processed.occurrence().informationWithheld_$eq((String)infoMessage.elem);
            }
        } else if (StringUtils.isNotBlank((String)raw.rowKey()) && raw.occurrence().originalSensitiveValues() != null && !raw.occurrence().originalSensitiveValues().isEmpty()) {
            Config$.MODULE$.persistenceManager().put(raw.rowKey(), "occ", (scala.collection.immutable.Map<String, String>)raw.occurrence().originalSensitiveValues().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"originalSensitiveValues"), (Object)"")), false);
        }
    }

    private String getExactSciName(FullRecord raw) {
        return raw.classification().scientificName() == null ? (raw.classification().subspecies() == null ? (raw.classification().species() == null ? (raw.classification().genus() == null ? (raw.classification().vernacularName() == null ? raw.classification().scientificName() : raw.classification().vernacularName()) : (raw.classification().specificEpithet() == null ? raw.classification().genus() : (raw.classification().infraspecificEpithet() == null ? new StringBuilder().append((Object)raw.classification().genus()).append((Object)" ").append((Object)raw.classification().specificEpithet()).toString() : new StringBuilder().append((Object)raw.classification().genus()).append((Object)" ").append((Object)raw.classification().specificEpithet()).append((Object)" ").append((Object)raw.classification().infraspecificEpithet()).toString()))) : raw.classification().species()) : raw.classification().subspecies()) : raw.classification().scientificName();
    }

    @Override
    public String getName() {
        return FullRecordMapper$.MODULE$.geospatialQa();
    }

    public LocationProcessor() {
        Processor$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"LocationProcessor");
        this.sds = new SensitiveDataService();
    }
}

