/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.load;

import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.index.IndexRecords$;
import au.org.ala.biocache.load.Loader;
import au.org.ala.biocache.tool.ProcessRecords$;
import au.org.ala.biocache.tool.Sampling$;
import au.org.ala.biocache.util.OptionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public final class IngestTool$
implements Tool {
    public static final IngestTool$ MODULE$;
    private final Logger logger;

    static {
        new IngestTool$();
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    public Logger logger() {
        return this.logger;
    }

    @Override
    public String cmd() {
        return "ingest";
    }

    @Override
    public String desc() {
        return "Load, sample, process and index a dataset";
    }

    @Override
    public void main(String[] args) {
        BooleanRef skipIndexing;
        BooleanRef skipProcessing;
        BooleanRef skipSampling;
        BooleanRef skipLoading;
        BooleanRef ingestAll;
        ObjectRef resources = new ObjectRef((Object)((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
        OptionParser parser = new OptionParser(resources, ingestAll = new BooleanRef(false), skipLoading = new BooleanRef(false), skipSampling = new BooleanRef(false), skipProcessing = new BooleanRef(false), skipIndexing = new BooleanRef(false)){
            {
                this.opt("dr", "dataResourceUid", "comma separated list of resources (uids) to load, sample, process and index. e.g. dr321,dr123", (Function1<String, BoxedUnit>)new Serializable(this, resources$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef resources$1;

                    public final void apply(String v) {
                        this.resources$1.elem = (String[])Predef$.MODULE$.refArrayOps((Object[])v.split(",")).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(String x) {
                                return x.trim();
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                    }
                    {
                        this.resources$1 = resources$1;
                    }
                });
                this.opt("all", "all-resources", "flag to indicate all resources should be loaded", (Function0<BoxedUnit>)new Serializable(this, ingestAll$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef ingestAll$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.ingestAll$1.elem = true;
                    }
                    {
                        this.ingestAll$1 = ingestAll$1;
                    }
                });
                this.opt("skip-loading", "Ingest but don't load.", (Function0<BoxedUnit>)new Serializable(this, skipLoading$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef skipLoading$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.skipLoading$1.elem = true;
                    }
                    {
                        this.skipLoading$1 = skipLoading$1;
                    }
                });
                this.opt("skip-sampling", "Ingest but don't sample.", (Function0<BoxedUnit>)new Serializable(this, skipSampling$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef skipSampling$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.skipSampling$1.elem = true;
                    }
                    {
                        this.skipSampling$1 = skipSampling$1;
                    }
                });
                this.opt("skip-processing", "Ingest but don't process.", (Function0<BoxedUnit>)new Serializable(this, skipProcessing$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef skipProcessing$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.skipProcessing$1.elem = true;
                    }
                    {
                        this.skipProcessing$1 = skipProcessing$1;
                    }
                });
                this.opt("skip-indexing", "Ingest but don't indexing.", (Function0<BoxedUnit>)new Serializable(this, skipIndexing$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef skipIndexing$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.skipIndexing$1.elem = true;
                    }
                    {
                        this.skipIndexing$1 = skipIndexing$1;
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            Loader l = new Loader();
            if (Predef$.MODULE$.refArrayOps((Object[])((String[])resources.elem)).isEmpty()) {
                if (ingestAll.elem) {
                    new Loader().resourceList().foreach((Function1)new Serializable(skipLoading, skipSampling, skipProcessing, skipIndexing){
                        public static final long serialVersionUID = 0L;
                        private final BooleanRef skipLoading$1;
                        private final BooleanRef skipSampling$1;
                        private final BooleanRef skipProcessing$1;
                        private final BooleanRef skipIndexing$1;

                        public final void apply(Map<String, String> resource) {
                            String uid = (String)resource.getOrElse((Object)"uid", (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "";
                                }
                            });
                            String name = (String)resource.getOrElse((Object)"name", (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "";
                                }
                            });
                            IngestTool$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ingesting resource ", ", uid: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, uid})));
                            String string = uid;
                            String string2 = "";
                            if (string == null ? string2 != null : !string.equals(string2)) {
                                String x$6 = uid;
                                boolean x$7 = this.skipLoading$1.elem;
                                boolean x$8 = this.skipSampling$1.elem;
                                boolean x$9 = this.skipProcessing$1.elem;
                                boolean x$10 = this.skipIndexing$1.elem;
                                IngestTool$.MODULE$.ingestResource(x$6, x$10, x$7, x$9, x$8);
                            }
                        }
                        {
                            this.skipLoading$1 = skipLoading$1;
                            this.skipSampling$1 = skipSampling$1;
                            this.skipProcessing$1 = skipProcessing$1;
                            this.skipIndexing$1 = skipIndexing$1;
                        }
                    });
                } else {
                    parser.showUsage();
                }
            } else {
                Predef$.MODULE$.refArrayOps((Object[])((String[])resources.elem)).foreach((Function1)new Serializable(skipLoading, skipSampling, skipProcessing, skipIndexing){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef skipLoading$1;
                    private final BooleanRef skipSampling$1;
                    private final BooleanRef skipProcessing$1;
                    private final BooleanRef skipIndexing$1;

                    public final void apply(String uid) {
                        IngestTool$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ingesting resource uid: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uid})));
                        String string = uid;
                        String string2 = "";
                        if (string == null ? string2 != null : !string.equals(string2)) {
                            String x$1 = uid;
                            boolean x$2 = this.skipLoading$1.elem;
                            boolean x$3 = this.skipSampling$1.elem;
                            boolean x$4 = this.skipProcessing$1.elem;
                            boolean x$5 = this.skipIndexing$1.elem;
                            IngestTool$.MODULE$.ingestResource(x$1, x$5, x$2, x$4, x$3);
                        }
                    }
                    {
                        this.skipLoading$1 = skipLoading$1;
                        this.skipSampling$1 = skipSampling$1;
                        this.skipProcessing$1 = skipProcessing$1;
                        this.skipIndexing$1 = skipIndexing$1;
                    }
                });
            }
        }
    }

    public void ingestResource(String uid, boolean skipIndexing, boolean skipLoading, boolean skipProcessing, boolean skipSampling) {
        if (skipLoading) {
            this.logger().info(new StringBuilder().append((Object)"Skipping loading: ").append((Object)uid).toString());
        } else {
            this.logger().info(new StringBuilder().append((Object)"Loading: ").append((Object)uid).toString());
            Loader qual$1 = new Loader();
            String x$11 = uid;
            boolean x$12 = qual$1.load$default$2();
            boolean x$13 = qual$1.load$default$3();
            boolean x$14 = qual$1.load$default$4();
            qual$1.load(x$11, x$12, x$13, x$14);
        }
        if (skipSampling) {
            this.logger().info(new StringBuilder().append((Object)"Skipping sampling: ").append((Object)uid).toString());
        } else {
            this.logger().info(new StringBuilder().append((Object)"Sampling: ").append((Object)uid).toString());
            Sampling$.MODULE$.main((String[])((Object[])new String[]{"-dr", uid}));
        }
        if (skipProcessing) {
            this.logger().info(new StringBuilder().append((Object)"Skipping processing: ").append((Object)uid).toString());
        } else {
            this.logger().info(new StringBuilder().append((Object)"Processing: ").append((Object)uid).toString());
            ProcessRecords$.MODULE$.processRecords(4, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)uid), ProcessRecords$.MODULE$.processRecords$default$4(), ProcessRecords$.MODULE$.processRecords$default$5(), ProcessRecords$.MODULE$.processRecords$default$6());
        }
        if (skipIndexing) {
            this.logger().info(new StringBuilder().append((Object)"Skipping indexing: ").append((Object)uid).toString());
        } else {
            this.logger().info(new StringBuilder().append((Object)"Indexing: ").append((Object)uid).toString());
            IndexRecords$.MODULE$.index((Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)uid), false, false, IndexRecords$.MODULE$.index$default$6(), IndexRecords$.MODULE$.index$default$7(), IndexRecords$.MODULE$.index$default$8(), IndexRecords$.MODULE$.index$default$9(), IndexRecords$.MODULE$.index$default$10(), IndexRecords$.MODULE$.index$default$11(), IndexRecords$.MODULE$.index$default$12());
        }
        this.logger().info(new StringBuilder().append((Object)"Finished ingest for: ").append((Object)uid).toString());
    }

    public boolean ingestResource$default$2() {
        return false;
    }

    public boolean ingestResource$default$3() {
        return false;
    }

    public boolean ingestResource$default$4() {
        return false;
    }

    public boolean ingestResource$default$5() {
        return false;
    }

    private IngestTool$() {
        MODULE$ = this;
        Tool$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"IngestTool");
    }
}

