/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.load;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.cmd.NoArgsTool;
import au.org.ala.biocache.cmd.NoArgsTool$class;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.load.HabitatLoader$;
import au.org.ala.names.model.LinnaeanRankClassification;
import java.io.File;
import java.net.URL;
import org.gbif.dwc.record.Record;
import org.gbif.dwc.record.StarRecord;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.terms.GbifTerm;
import org.gbif.dwc.terms.Term;
import org.gbif.dwc.text.Archive;
import org.gbif.dwc.text.ArchiveFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.sys.process.package$;

public final class HabitatLoader$
implements NoArgsTool {
    public static final HabitatLoader$ MODULE$;
    private final Logger logger;

    static {
        new HabitatLoader$();
    }

    @Override
    public void proceed(String[] args, Function0<BoxedUnit> proc) {
        NoArgsTool$class.proceed(this, args, proc);
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    public Logger logger() {
        return this.logger;
    }

    @Override
    public String cmd() {
        return "update-habitat-data";
    }

    @Override
    public String desc() {
        return "Load habitat data from sources (e.g. IRMNG)";
    }

    @Override
    public void main(String[] args) {
        this.proceed(args, (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                HabitatLoader$.MODULE$.run();
            }
        });
    }

    public void run() {
        IntRef counter = new IntRef(0);
        String archiveFile = new StringBuilder().append((Object)Config$.MODULE$.tmpWorkDir()).append((Object)File.separator).append((Object)"IRMNG_DWC.zip").toString();
        this.logger().info("Downloading the IRMNG archive...");
        package$.MODULE$.urlToProcess(new URL(Config$.MODULE$.irmngDwcArchiveUrl())).$hash$greater(new File(new StringBuilder().append((Object)Config$.MODULE$.tmpWorkDir()).append((Object)File.separator).append((Object)"IRMNG_DWC.zip").toString())).$bang$bang();
        File myArchiveFile = new File(archiveFile);
        File extractToFolder = new File(new StringBuilder().append((Object)Config$.MODULE$.tmpWorkDir()).append((Object)File.separator).append((Object)"IRMNG_DWC").toString());
        Archive dwcArchive = ArchiveFactory.openArchive((File)myArchiveFile, (File)extractToFolder);
        this.logger().info(new StringBuilder().append((Object)"Archive rowtype: ").append((Object)dwcArchive.getCore().getRowType()).append((Object)", ").append((Object)BoxesRunTime.boxToInteger((int)dwcArchive.getExtensions().size())).append((Object)" extension(s)").toString());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)dwcArchive).asScala()).foreach((Function1)new Serializable(counter){
            public static final long serialVersionUID = 0L;
            public final IntRef counter$1;

            public final void apply(StarRecord starRecord) {
                String guid;
                String string;
                LinnaeanRankClassification cl = new LinnaeanRankClassification();
                String scientificName = starRecord.core().value((Term)DwcTerm.scientificName);
                cl.setScientificName(scientificName);
                cl.setSpecificEpithet(starRecord.core().value((Term)DwcTerm.specificEpithet));
                cl.setGenus(starRecord.core().value((Term)DwcTerm.genus));
                cl.setFamily(starRecord.core().value((Term)DwcTerm.family));
                try {
                    string = Config$.MODULE$.nameIndex().searchForAcceptedLsidDefaultHandling(cl, false);
                }
                catch (Exception exception) {
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Problem looking up name: ").append((Object)scientificName).append((Object)". ").append((Object)exception.getMessage()).toString());
                    string = guid = null;
                }
                if (guid != null && starRecord.extensions().containsKey(GbifTerm.SpeciesProfile)) {
                    ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(starRecord.extension((Term)GbifTerm.SpeciesProfile)).asScala()).foreach((Function1)new Serializable(this, guid){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.run.1 $outer;
                        private final String guid$1;

                        public final void apply(Record extRec) {
                            String rawValue = extRec.value((Term)GbifTerm.isMarine);
                            if (rawValue != null) {
                                String string = rawValue;
                                String string2 = "null";
                                if (string == null ? string2 != null : !string.equals(string2)) {
                                    String habitat = new StringOps(Predef$.MODULE$.augmentString(rawValue)).toBoolean() ? "Marine" : "Terrestrial";
                                    Config$.MODULE$.persistenceManager().put(this.guid$1, "taxon", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"habitats"), (Object)habitat)}))), false);
                                    ++this.$outer.counter$1.elem;
                                    if (this.$outer.counter$1.elem % 1000 == 0) {
                                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Habitat values loaded: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.counter$1.elem)})));
                                    }
                                }
                            }
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.guid$1 = guid$1;
                        }
                    });
                }
            }
            {
                this.counter$1 = counter$1;
            }
        });
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finished. Total habitat values loaded: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)counter.elem)})));
    }

    private HabitatLoader$() {
        MODULE$ = this;
        Tool$class.$init$(this);
        NoArgsTool$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"HabitatLoader");
    }
}

