/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.index;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.ObserverCallback;
import au.org.ala.biocache.cmd.IncrementalTool;
import au.org.ala.biocache.cmd.IncrementalTool$class;
import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.dao.OccurrenceDAO;
import au.org.ala.biocache.index.IndexDAO;
import au.org.ala.biocache.load.FullRecordMapper$;
import au.org.ala.biocache.parser.DateParser$;
import au.org.ala.biocache.persistence.PersistenceManager;
import au.org.ala.biocache.util.FileHelper$;
import au.org.ala.biocache.util.OptionParser;
import au.org.ala.biocache.util.StringFileWriterConsumer;
import java.io.File;
import java.io.FileWriter;
import java.util.Date;
import java.util.concurrent.ArrayBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

public final class IndexRecords$
implements Tool,
IncrementalTool {
    public static final IndexRecords$ MODULE$;
    private final Logger logger;
    private final IndexDAO indexer;
    private final OccurrenceDAO occurrenceDAO;
    private final PersistenceManager persistenceManager;

    static {
        new IndexRecords$();
    }

    @Override
    public Option<String> getDeleteRowFile(String resourceUid) {
        return IncrementalTool$class.getDeleteRowFile(this, resourceUid);
    }

    @Override
    public Tuple2<Object, Option<String>> hasRowKey(String resourceUid) {
        return IncrementalTool$class.hasRowKey(this, resourceUid);
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    @Override
    public String cmd() {
        return "index";
    }

    @Override
    public String desc() {
        return "Index records. Not suitable for full re-indexing (>5m)";
    }

    public Logger logger() {
        return this.logger;
    }

    public IndexDAO indexer() {
        return this.indexer;
    }

    public OccurrenceDAO occurrenceDAO() {
        return this.occurrenceDAO;
    }

    public PersistenceManager persistenceManager() {
        return this.persistenceManager;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void main(String[] args) {
        block8: {
            ObjectRef uuidFile;
            block9: {
                ObjectRef startUuid = new ObjectRef((Object)None$.MODULE$);
                ObjectRef endUuid = new ObjectRef((Object)None$.MODULE$);
                ObjectRef dataResourceUid = new ObjectRef((Object)None$.MODULE$);
                BooleanRef empty = new BooleanRef(false);
                BooleanRef check = new BooleanRef(false);
                ObjectRef startDate = new ObjectRef((Object)None$.MODULE$);
                IntRef pageSize = new IntRef(1000);
                uuidFile = new ObjectRef((Object)"");
                ObjectRef rowKeyFile = new ObjectRef((Object)"");
                IntRef threads = new IntRef(1);
                BooleanRef test = new BooleanRef(false);
                BooleanRef checkRowKeyFile = new BooleanRef(false);
                BooleanRef abortIfNotRowKeyFile = new BooleanRef(false);
                OptionParser parser = new OptionParser(startUuid, endUuid, dataResourceUid, empty, check, startDate, pageSize, uuidFile, rowKeyFile, threads, test, checkRowKeyFile, abortIfNotRowKeyFile){
                    {
                        this.opt("empty", "empty the index first", (Function0<BoxedUnit>)new Serializable(this, empty$1){
                            public static final long serialVersionUID = 0L;
                            private final BooleanRef empty$1;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                this.empty$1.elem = true;
                            }
                            {
                                this.empty$1 = empty$1;
                            }
                        });
                        this.opt("check", "check to see if the record is deleted before indexing", (Function0<BoxedUnit>)new Serializable(this, check$1){
                            public static final long serialVersionUID = 0L;
                            private final BooleanRef check$1;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                this.check$1.elem = true;
                            }
                            {
                                this.check$1 = check$1;
                            }
                        });
                        this.opt("s", "start", "The record to start with", (Function1<String, BoxedUnit>)new Serializable(this, startUuid$1){
                            public static final long serialVersionUID = 0L;
                            private final ObjectRef startUuid$1;

                            public final void apply(String v) {
                                this.startUuid$1.elem = new Some((Object)v);
                            }
                            {
                                this.startUuid$1 = startUuid$1;
                            }
                        });
                        this.opt("e", "end", "The record to end with", (Function1<String, BoxedUnit>)new Serializable(this, endUuid$1){
                            public static final long serialVersionUID = 0L;
                            private final ObjectRef endUuid$1;

                            public final void apply(String v) {
                                this.endUuid$1.elem = new Some((Object)v);
                            }
                            {
                                this.endUuid$1 = endUuid$1;
                            }
                        });
                        this.opt("dr", "resource", "The data resource to (re) index", (Function1<String, BoxedUnit>)new Serializable(this, dataResourceUid$1){
                            public static final long serialVersionUID = 0L;
                            private final ObjectRef dataResourceUid$1;

                            public final void apply(String v) {
                                this.dataResourceUid$1.elem = new Some((Object)v);
                            }
                            {
                                this.dataResourceUid$1 = dataResourceUid$1;
                            }
                        });
                        this.opt("date", "date", "The earliest modification date for records to be indexed. Date in the form yyyy-mm-dd", (Function1<String, BoxedUnit>)new Serializable(this, startDate$1){
                            public static final long serialVersionUID = 0L;
                            private final ObjectRef startDate$1;

                            public final void apply(String v) {
                                this.startDate$1.elem = new Some((Object)v);
                            }
                            {
                                this.startDate$1 = startDate$1;
                            }
                        });
                        this.intOpt("ps", "pageSize", "The page size for indexing", (Function1<Object, BoxedUnit>)new Serializable(this, pageSize$1){
                            public static final long serialVersionUID = 0L;
                            private final IntRef pageSize$1;

                            public final void apply(int v) {
                                this.apply$mcVI$sp(v);
                            }

                            public void apply$mcVI$sp(int v) {
                                this.pageSize$1.elem = v;
                            }
                            {
                                this.pageSize$1 = pageSize$1;
                            }
                        });
                        this.opt("if", "file-uuids-to-index", "Absolute file path to fle containing UUIDs to index", (Function1<String, BoxedUnit>)new Serializable(this, uuidFile$1){
                            public static final long serialVersionUID = 0L;
                            private final ObjectRef uuidFile$1;

                            public final void apply(String v) {
                                this.uuidFile$1.elem = v;
                            }
                            {
                                this.uuidFile$1 = uuidFile$1;
                            }
                        });
                        this.opt("rf", "file-rowkeys-to-index", "Absolute file path to fle containing rowkeys to index", (Function1<String, BoxedUnit>)new Serializable(this, rowKeyFile$1){
                            public static final long serialVersionUID = 0L;
                            private final ObjectRef rowKeyFile$1;

                            public final void apply(String v) {
                                this.rowKeyFile$1.elem = v;
                            }
                            {
                                this.rowKeyFile$1 = rowKeyFile$1;
                            }
                        });
                        this.intOpt("t", "threads", "Number of threads to index from", (Function1<Object, BoxedUnit>)new Serializable(this, threads$1){
                            public static final long serialVersionUID = 0L;
                            private final IntRef threads$1;

                            public final void apply(int v) {
                                this.apply$mcVI$sp(v);
                            }

                            public void apply$mcVI$sp(int v) {
                                this.threads$1.elem = v;
                            }
                            {
                                this.threads$1 = threads$1;
                            }
                        });
                        this.opt("test", "test the speed of creating the index the minus the actual SOLR indexing costs", (Function0<BoxedUnit>)new Serializable(this, test$1){
                            public static final long serialVersionUID = 0L;
                            private final BooleanRef test$1;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                this.test$1.elem = true;
                            }
                            {
                                this.test$1 = test$1;
                            }
                        });
                        this.opt("crk", "check for row key file", (Function0<BoxedUnit>)new Serializable(this, checkRowKeyFile$1){
                            public static final long serialVersionUID = 0L;
                            private final BooleanRef checkRowKeyFile$1;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                this.checkRowKeyFile$1.elem = true;
                            }
                            {
                                this.checkRowKeyFile$1 = checkRowKeyFile$1;
                            }
                        });
                        this.opt("acrk", "abort if no row key file found", (Function0<BoxedUnit>)new Serializable(this, abortIfNotRowKeyFile$1){
                            public static final long serialVersionUID = 0L;
                            private final BooleanRef abortIfNotRowKeyFile$1;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                this.abortIfNotRowKeyFile$1.elem = true;
                            }
                            {
                                this.abortIfNotRowKeyFile$1 = abortIfNotRowKeyFile$1;
                            }
                        });
                    }
                };
                if (!parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) return;
                if (!((Option)dataResourceUid.elem).isEmpty() && checkRowKeyFile.elem) {
                    Tuple2 tuple2;
                    Tuple2<Object, Option<String>> tuple22 = this.hasRowKey((String)((Option)dataResourceUid.elem).get());
                    if (tuple22 == null) throw new MatchError(tuple22);
                    boolean hasRowKey = tuple22._1$mcZ$sp();
                    Option retrievedRowKeyFile = (Option)tuple22._2();
                    Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)hasRowKey), (Object)retrievedRowKeyFile);
                    boolean hasRowKey2 = tuple23._1$mcZ$sp();
                    Option retrievedRowKeyFile2 = (Option)tuple23._2();
                    rowKeyFile.elem = (String)retrievedRowKeyFile2.getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "";
                        }
                    });
                }
                if (abortIfNotRowKeyFile.elem) {
                    String string = (String)rowKeyFile.elem;
                    String string2 = "";
                    if (!(string == null ? string2 != null : !string.equals(string2)) || !new File((String)rowKeyFile.elem).exists()) {
                        this.logger().warn("No rowkey file was found for this index. Aborting.");
                        return;
                    }
                }
                if (empty.elem) {
                    this.logger().info("Emptying index");
                    this.indexer().emptyIndex();
                }
                String string = (String)uuidFile.elem;
                String string3 = "";
                if (string != null ? !string.equals(string3) : string3 != null) break block9;
                String string4 = (String)rowKeyFile.elem;
                String string5 = "";
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    Option x$3 = (Option)startUuid.elem;
                    Option x$4 = (Option)endUuid.elem;
                    Option x$5 = (Option)dataResourceUid.elem;
                    boolean x$6 = false;
                    boolean x$7 = false;
                    Option x$8 = (Option)startDate.elem;
                    boolean x$9 = check.elem;
                    int x$10 = pageSize.elem;
                    boolean x$11 = test.elem;
                    Seq<String> x$12 = this.index$default$9();
                    Seq<String> x$13 = this.index$default$10();
                    ObserverCallback x$14 = this.index$default$11();
                    this.index((Option<String>)x$3, (Option<String>)x$4, (Option<String>)x$5, x$6, x$7, (Option<String>)x$8, x$9, x$10, x$12, x$13, x$14, x$11);
                    break block8;
                } else if (threads.elem == 1) {
                    this.indexList(new File((String)rowKeyFile.elem), this.indexList$default$2());
                    break block8;
                } else {
                    this.indexListThreaded(new File((String)rowKeyFile.elem), threads.elem);
                }
                break block8;
            }
            this.indexListOfUUIDs(new File((String)uuidFile.elem));
        }
        this.indexer().shutdown();
        this.persistenceManager().shutdown();
    }

    public void index(Option<String> startUuid, Option<String> endUuid, Option<String> dataResource, boolean optimise, boolean shutdown, Option<String> startDate, boolean checkDeleted, int pageSize, Seq<String> miscIndexProperties, Seq<String> userProvidedTypeMiscIndexProperties, ObserverCallback callback, boolean test) {
        String startKey = startUuid.isEmpty() && !dataResource.isEmpty() ? new StringBuilder().append((Object)((String)dataResource.get())).append((Object)"|").toString() : (String)startUuid.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        Option<Date> date = None$.MODULE$;
        if (!startDate.isEmpty()) {
            date = DateParser$.MODULE$.parseStringToDate(new StringBuilder().append((Object)((String)startDate.get())).append((Object)" 00:00:00").toString());
            if (date.isEmpty()) {
                throw new Exception("Date is in incorrect format. Try yyyy-mm-dd");
            }
            this.logger().info(new StringBuilder().append((Object)"Indexing will be restricted to records changed after ").append(date.get()).toString());
        }
        String endKey = dataResource.isEmpty() || endUuid.isDefined() ? (String)endUuid.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }) : new StringBuilder().append((Object)((String)dataResource.get())).append((Object)"|~").toString();
        String string = startKey;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.logger().info("Starting full index");
        } else {
            this.logger().info(new StringBuilder().append((Object)"Starting to index ").append((Object)startKey).append((Object)" until ").append((Object)endKey).toString());
        }
        String x$15 = startKey;
        String x$16 = endKey;
        Option<Date> x$17 = date;
        boolean x$18 = checkDeleted;
        Seq<String> x$19 = miscIndexProperties;
        Seq<String> x$20 = userProvidedTypeMiscIndexProperties;
        ObserverCallback x$21 = callback;
        boolean x$22 = test;
        int x$23 = this.indexRange$default$5();
        this.indexRange(x$15, x$16, x$17, x$18, x$23, x$19, x$20, x$21, x$22);
        this.indexer().finaliseIndex(optimise, shutdown);
    }

    public boolean index$default$4() {
        return false;
    }

    public boolean index$default$5() {
        return false;
    }

    public Option<String> index$default$6() {
        return None$.MODULE$;
    }

    public boolean index$default$7() {
        return false;
    }

    public int index$default$8() {
        return 1000;
    }

    public Seq<String> index$default$9() {
        return Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
    }

    public Seq<String> index$default$10() {
        return Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
    }

    public ObserverCallback index$default$11() {
        return null;
    }

    public boolean index$default$12() {
        return false;
    }

    public void indexRange(String startUuid, String endUuid, Option<Date> startDate, boolean checkDeleted, int pageSize, Seq<String> miscIndexProperties, Seq<String> userProvidedTypeMiscIndexProperties, ObserverCallback callback, boolean test) {
        ObjectRef csvFileWriter;
        IntRef counter = new IntRef(0);
        long start = System.currentTimeMillis();
        LongRef startTime = new LongRef(System.currentTimeMillis());
        LongRef finishTime = new LongRef(System.currentTimeMillis());
        ObjectRef objectRef = Config$.MODULE$.exportIndexAsCsvPath().length() > 0 ? new ObjectRef((Object)this.indexer().getCsvWriter(this.indexer().getCsvWriter$default$1())) : (csvFileWriter = new ObjectRef(null));
        ObjectRef csvFileWriterSensitive = Config$.MODULE$.exportIndexAsCsvPathSensitive().length() > 0 ? new ObjectRef((Object)this.indexer().getCsvWriter(true)) : new ObjectRef(null);
        Serializable x$35 = new Serializable(startDate, pageSize, miscIndexProperties, userProvidedTypeMiscIndexProperties, callback, test, counter, startTime, finishTime, csvFileWriter, csvFileWriterSensitive){
            public static final long serialVersionUID = 0L;
            private final Option startDate$2;
            private final int pageSize$2;
            private final Seq miscIndexProperties$1;
            private final Seq userProvidedTypeMiscIndexProperties$1;
            private final ObserverCallback callback$1;
            private final boolean test$2;
            private final IntRef counter$1;
            private final LongRef startTime$1;
            private final LongRef finishTime$1;
            private final ObjectRef csvFileWriter$1;
            private final ObjectRef csvFileWriterSensitive$1;

            public final boolean apply(String guid, scala.collection.immutable.Map<String, String> map) {
                ++this.counter$1.elem;
                boolean shouldcommit = this.counter$1.elem % 10000 == 0;
                String x$24 = guid;
                scala.collection.immutable.Map<String, String> x$25 = map;
                Option x$26 = this.startDate$2;
                boolean x$27 = shouldcommit;
                Seq x$28 = this.miscIndexProperties$1;
                Seq x$29 = this.userProvidedTypeMiscIndexProperties$1;
                boolean x$30 = this.test$2;
                FileWriter x$31 = (FileWriter)this.csvFileWriter$1.elem;
                FileWriter x$32 = (FileWriter)this.csvFileWriterSensitive$1.elem;
                boolean x$33 = IndexRecords$.MODULE$.indexer().indexFromMap$default$3();
                String x$34 = IndexRecords$.MODULE$.indexer().indexFromMap$default$9();
                IndexRecords$.MODULE$.indexer().indexFromMap(x$24, (Map<String, String>)x$25, x$33, (Option<Date>)x$26, x$27, (Seq<String>)x$28, (Seq<String>)x$29, x$30, x$34, x$31, x$32);
                if (this.counter$1.elem % this.pageSize$2 == 0) {
                    if (this.callback$1 != null) {
                        this.callback$1.progressMessage(this.counter$1.elem);
                    }
                    this.finishTime$1.elem = System.currentTimeMillis();
                    IndexRecords$.MODULE$.logger().info(new StringBuilder().append(this.counter$1.elem).append((Object)" >> Last key : ").append((Object)guid).append((Object)", records per sec: ").append((Object)BoxesRunTime.boxToFloat((float)((float)this.pageSize$2 / ((float)(this.finishTime$1.elem - this.startTime$1.elem) / 1000.0f)))).toString());
                    this.startTime$1.elem = System.currentTimeMillis();
                }
                return true;
            }
            {
                this.startDate$2 = startDate$2;
                this.pageSize$2 = pageSize$2;
                this.miscIndexProperties$1 = miscIndexProperties$1;
                this.userProvidedTypeMiscIndexProperties$1 = userProvidedTypeMiscIndexProperties$1;
                this.callback$1 = callback$1;
                this.test$2 = test$2;
                this.counter$1 = counter$1;
                this.startTime$1 = startTime$1;
                this.finishTime$1 = finishTime$1;
                this.csvFileWriter$1 = csvFileWriter$1;
                this.csvFileWriterSensitive$1 = csvFileWriterSensitive$1;
            }
        };
        String x$36 = startUuid;
        String x$37 = endUuid;
        boolean x$38 = checkDeleted;
        int x$39 = pageSize;
        this.performPaging((Function2<String, scala.collection.immutable.Map<String, String>, Object>)x$35, x$36, x$37, x$39, x$38);
        if ((FileWriter)csvFileWriter.elem != null) {
            ((FileWriter)csvFileWriter.elem).flush();
            ((FileWriter)csvFileWriter.elem).close();
        }
        if ((FileWriter)csvFileWriterSensitive.elem != null) {
            ((FileWriter)csvFileWriterSensitive.elem).flush();
            ((FileWriter)csvFileWriterSensitive.elem).close();
        }
        finishTime.elem = System.currentTimeMillis();
        this.logger().info(new StringBuilder().append((Object)"Total indexing time ").append((Object)BoxesRunTime.boxToFloat((float)((float)(finishTime.elem - start) / 1000.0f))).append((Object)" seconds").toString());
    }

    public Option<Date> indexRange$default$3() {
        return None$.MODULE$;
    }

    public boolean indexRange$default$4() {
        return false;
    }

    public int indexRange$default$5() {
        return 1000;
    }

    public Seq<String> indexRange$default$6() {
        return Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
    }

    public Seq<String> indexRange$default$7() {
        return Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
    }

    public ObserverCallback indexRange$default$8() {
        return null;
    }

    public boolean indexRange$default$9() {
        return false;
    }

    public void performPaging(Function2<String, scala.collection.immutable.Map<String, String>, Object> proc, String startKey, String endKey, int pageSize, boolean checkDeleted) {
        if (checkDeleted) {
            this.persistenceManager().pageOverSelect("occ", (Function2<String, scala.collection.immutable.Map<String, String>, Object>)new Serializable(proc){
                public static final long serialVersionUID = 0L;
                private final Function2 proc$1;

                public final boolean apply(String guid, scala.collection.immutable.Map<String, String> map) {
                    Option<scala.collection.immutable.Map<String, String>> map2;
                    Object object = ((String)map.getOrElse((Object)FullRecordMapper$.MODULE$.deletedColumn(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "false";
                        }
                    })).equals("false") ? ((map2 = IndexRecords$.MODULE$.persistenceManager().get(guid, "occ")).isEmpty() ? BoxedUnit.UNIT : this.proc$1.apply((Object)guid, map2.get())) : BoxedUnit.UNIT;
                    return true;
                }
                {
                    this.proc$1 = proc$1;
                }
            }, startKey, endKey, pageSize, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"uuid", "rowKey", FullRecordMapper$.MODULE$.deletedColumn()}));
        } else {
            this.persistenceManager().pageOverAll("occ", (Function2<String, scala.collection.immutable.Map<String, String>, Object>)new Serializable(proc){
                public static final long serialVersionUID = 0L;
                private final Function2 proc$1;

                public final boolean apply(String guid, scala.collection.immutable.Map<String, String> map) {
                    return BoxesRunTime.unboxToBoolean((Object)this.proc$1.apply((Object)guid, map));
                }
                {
                    this.proc$1 = proc$1;
                }
            }, startKey, endKey, pageSize);
        }
    }

    public String performPaging$default$2() {
        return "";
    }

    public String performPaging$default$3() {
        return "";
    }

    public int performPaging$default$4() {
        return 1000;
    }

    public boolean performPaging$default$5() {
        return false;
    }

    public void indexList(List<String> rowKeys) {
        ObjectRef csvFileWriter;
        IntRef counter = new IntRef(0);
        LongRef startTime = new LongRef(System.currentTimeMillis());
        LongRef finishTime = new LongRef(System.currentTimeMillis());
        ObjectRef objectRef = Config$.MODULE$.exportIndexAsCsvPath().length() > 0 ? new ObjectRef((Object)this.indexer().getCsvWriter(this.indexer().getCsvWriter$default$1())) : (csvFileWriter = new ObjectRef(null));
        ObjectRef csvFileWriterSensitive = Config$.MODULE$.exportIndexAsCsvPathSensitive().length() > 0 ? new ObjectRef((Object)this.indexer().getCsvWriter(true)) : new ObjectRef(null);
        rowKeys.foreach((Function1)new Serializable(counter, startTime, finishTime, csvFileWriter, csvFileWriterSensitive){
            public static final long serialVersionUID = 0L;
            private final IntRef counter$2;
            private final LongRef startTime$2;
            private final LongRef finishTime$2;
            private final ObjectRef csvFileWriter$2;
            private final ObjectRef csvFileWriterSensitive$2;

            public final void apply(String rowKey) {
                boolean shouldcommit;
                ++this.counter$2.elem;
                Option<scala.collection.immutable.Map<String, String>> map = IndexRecords$.MODULE$.persistenceManager().get(rowKey, "occ");
                boolean bl = shouldcommit = this.counter$2.elem % 10000 == 0;
                if (!map.isEmpty()) {
                    String x$40 = rowKey;
                    scala.collection.immutable.Map x$41 = (scala.collection.immutable.Map)map.get();
                    boolean x$42 = shouldcommit;
                    FileWriter x$43 = (FileWriter)this.csvFileWriter$2.elem;
                    FileWriter x$44 = (FileWriter)this.csvFileWriterSensitive$2.elem;
                    boolean x$45 = IndexRecords$.MODULE$.indexer().indexFromMap$default$3();
                    Option<Date> x$46 = IndexRecords$.MODULE$.indexer().indexFromMap$default$4();
                    Seq<String> x$47 = IndexRecords$.MODULE$.indexer().indexFromMap$default$6();
                    Seq<String> x$48 = IndexRecords$.MODULE$.indexer().indexFromMap$default$7();
                    boolean x$49 = IndexRecords$.MODULE$.indexer().indexFromMap$default$8();
                    String x$50 = IndexRecords$.MODULE$.indexer().indexFromMap$default$9();
                    IndexRecords$.MODULE$.indexer().indexFromMap(x$40, (Map<String, String>)x$41, x$45, x$46, x$42, x$47, x$48, x$49, x$50, x$43, x$44);
                }
                if (this.counter$2.elem % 100 == 0) {
                    this.finishTime$2.elem = System.currentTimeMillis();
                    IndexRecords$.MODULE$.logger().debug(new StringBuilder().append(this.counter$2.elem).append((Object)" >> Last key : ").append((Object)rowKey).append((Object)", records per sec: ").append((Object)BoxesRunTime.boxToFloat((float)(100.0f / ((float)(this.finishTime$2.elem - this.startTime$2.elem) / 1000.0f)))).toString());
                    this.startTime$2.elem = System.currentTimeMillis();
                }
            }
            {
                this.counter$2 = counter$2;
                this.startTime$2 = startTime$2;
                this.finishTime$2 = finishTime$2;
                this.csvFileWriter$2 = csvFileWriter$2;
                this.csvFileWriterSensitive$2 = csvFileWriterSensitive$2;
            }
        });
        if ((FileWriter)csvFileWriter.elem != null) {
            ((FileWriter)csvFileWriter.elem).flush();
            ((FileWriter)csvFileWriter.elem).close();
        }
        if ((FileWriter)csvFileWriterSensitive.elem != null) {
            ((FileWriter)csvFileWriterSensitive.elem).flush();
            ((FileWriter)csvFileWriterSensitive.elem).close();
        }
        this.indexer().finaliseIndex(false, false);
    }

    public void indexListThreaded(File rowKeys, int threads) {
        ArrayBlockingQueue queue = new ArrayBlockingQueue(100);
        IntRef ids = new IntRef(0);
        FileWriter[] csvFileWriterList = (FileWriter[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(FileWriter.class));
        StringFileWriterConsumer[] pool = (StringFileWriterConsumer[])Array$.MODULE$.fill(threads, (Function0)new Serializable(queue, ids, csvFileWriterList){
            public static final long serialVersionUID = 0L;
            private final ArrayBlockingQueue queue$1;
            private final IntRef ids$1;
            private final FileWriter[] csvFileWriterList$1;

            public final StringFileWriterConsumer apply() {
                IntRef counter = new IntRef(0);
                LongRef startTime = new LongRef(System.currentTimeMillis());
                LongRef finishTime = new LongRef(System.currentTimeMillis());
                FileWriter csvFileWriter = Config$.MODULE$.exportIndexAsCsvPath().length() > 0 ? IndexRecords$.MODULE$.indexer().getCsvWriter(IndexRecords$.MODULE$.indexer().getCsvWriter$default$1()) : null;
                Predef$.MODULE$.refArrayOps((Object[])this.csvFileWriterList$1).$colon$plus((Object)csvFileWriter, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileWriter.class)));
                FileWriter csvFileWriterSensitive = Config$.MODULE$.exportIndexAsCsvPathSensitive().length() > 0 ? IndexRecords$.MODULE$.indexer().getCsvWriter(true) : null;
                Predef$.MODULE$.refArrayOps((Object[])this.csvFileWriterList$1).$colon$plus((Object)csvFileWriterSensitive, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileWriter.class)));
                IndexRecords$.MODULE$.indexer().init();
                StringFileWriterConsumer p = new StringFileWriterConsumer(this.queue$1, this.ids$1.elem, csvFileWriter, csvFileWriterSensitive, (Function3<String, FileWriter, FileWriter, BoxedUnit>)new Serializable(this, counter, startTime, finishTime){
                    public static final long serialVersionUID = 0L;
                    private final IntRef counter$3;
                    private final LongRef startTime$3;
                    private final LongRef finishTime$3;

                    public final void apply(String rowKey, FileWriter csvFileWriter, FileWriter csvFileWriterSensitive) {
                        ++this.counter$3.elem;
                        try {
                            boolean shouldcommit;
                            Option<scala.collection.immutable.Map<String, String>> map = IndexRecords$.MODULE$.persistenceManager().get(rowKey, "occ");
                            boolean bl = shouldcommit = this.counter$3.elem % 1000 == 0;
                            if (!map.isEmpty()) {
                                String x$51 = rowKey;
                                scala.collection.immutable.Map x$52 = (scala.collection.immutable.Map)map.get();
                                boolean x$53 = shouldcommit;
                                FileWriter x$54 = csvFileWriter;
                                FileWriter x$55 = csvFileWriterSensitive;
                                boolean x$56 = IndexRecords$.MODULE$.indexer().indexFromMap$default$3();
                                Option<Date> x$57 = IndexRecords$.MODULE$.indexer().indexFromMap$default$4();
                                Seq<String> x$58 = IndexRecords$.MODULE$.indexer().indexFromMap$default$6();
                                Seq<String> x$59 = IndexRecords$.MODULE$.indexer().indexFromMap$default$7();
                                boolean x$60 = IndexRecords$.MODULE$.indexer().indexFromMap$default$8();
                                String x$61 = IndexRecords$.MODULE$.indexer().indexFromMap$default$9();
                                IndexRecords$.MODULE$.indexer().indexFromMap(x$51, (Map<String, String>)x$52, x$56, x$57, x$53, x$58, x$59, x$60, x$61, x$54, x$55);
                            }
                        }
                        catch (Exception exception) {
                            IndexRecords$.MODULE$.logger().error(new StringBuilder().append((Object)"Problem indexing record with row key: '").append((Object)rowKey).append((Object)"'.  ").toString(), (Throwable)exception);
                        }
                        if (this.counter$3.elem % 1000 == 0) {
                            this.finishTime$3.elem = System.currentTimeMillis();
                            IndexRecords$.MODULE$.logger().info(new StringBuilder().append(this.counter$3.elem).append((Object)" >> Last key : ").append((Object)rowKey).append((Object)", records per sec: ").append((Object)BoxesRunTime.boxToFloat((float)(1000.0f / ((float)(this.finishTime$3.elem - this.startTime$3.elem) / 1000.0f)))).toString());
                            this.startTime$3.elem = System.currentTimeMillis();
                        }
                    }
                    {
                        this.counter$3 = counter$3;
                        this.startTime$3 = startTime$3;
                        this.finishTime$3 = finishTime$3;
                    }
                });
                ++this.ids$1.elem;
                p.start();
                return p;
            }
            {
                this.queue$1 = queue$1;
                this.ids$1 = ids$1;
                this.csvFileWriterList$1 = csvFileWriterList$1;
            }
        }, ClassTag$.MODULE$.apply(StringFileWriterConsumer.class));
        FileHelper$.MODULE$.file2helper(rowKeys).foreachLine((Function1<String, BoxedUnit>)new Serializable(queue){
            public static final long serialVersionUID = 0L;
            private final ArrayBlockingQueue queue$1;

            public final void apply(String line) {
                this.queue$1.put(line.trim());
            }
            {
                this.queue$1 = queue$1;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])pool).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(StringFileWriterConsumer t) {
                t.shouldStop_$eq(true);
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])pool).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(StringFileWriterConsumer x$2) {
                x$2.join();
            }
        });
        this.indexer().finaliseIndex(false, false);
        Predef$.MODULE$.refArrayOps((Object[])csvFileWriterList).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(FileWriter t) {
                if (t != null) {
                    t.flush();
                    t.close();
                }
            }
        });
    }

    public void indexList(File file, boolean shutdown) {
        ObjectRef csvFileWriter;
        this.logger().info("Starting the reindex by row key....");
        IntRef counter = new IntRef(0);
        LongRef startTime = new LongRef(System.currentTimeMillis());
        LongRef finishTime = new LongRef(System.currentTimeMillis());
        ObjectRef objectRef = Config$.MODULE$.exportIndexAsCsvPath().length() > 0 ? new ObjectRef((Object)this.indexer().getCsvWriter(this.indexer().getCsvWriter$default$1())) : (csvFileWriter = new ObjectRef(null));
        ObjectRef csvFileWriterSensitive = Config$.MODULE$.exportIndexAsCsvPathSensitive().length() > 0 ? new ObjectRef((Object)this.indexer().getCsvWriter(this.indexer().getCsvWriter$default$1())) : new ObjectRef(null);
        FileHelper$.MODULE$.file2helper(file).foreachLine((Function1<String, BoxedUnit>)new Serializable(counter, startTime, finishTime, csvFileWriter, csvFileWriterSensitive){
            public static final long serialVersionUID = 0L;
            private final IntRef counter$4;
            private final LongRef startTime$4;
            private final LongRef finishTime$4;
            private final ObjectRef csvFileWriter$3;
            private final ObjectRef csvFileWriterSensitive$3;

            public final void apply(String line) {
                boolean shouldCommit;
                ++this.counter$4.elem;
                String rowKey = BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(line)).head()) == '\"' && BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(line)).last()) == '\"' ? line.substring(1, line.length() - 1) : line;
                Option<scala.collection.immutable.Map<String, String>> map = IndexRecords$.MODULE$.persistenceManager().get(rowKey, "occ");
                boolean bl = shouldCommit = this.counter$4.elem % 10000 == 0;
                if (!map.isEmpty()) {
                    String x$62 = rowKey;
                    scala.collection.immutable.Map x$63 = (scala.collection.immutable.Map)map.get();
                    boolean x$64 = shouldCommit;
                    FileWriter x$65 = (FileWriter)this.csvFileWriter$3.elem;
                    FileWriter x$66 = (FileWriter)this.csvFileWriterSensitive$3.elem;
                    boolean x$67 = IndexRecords$.MODULE$.indexer().indexFromMap$default$3();
                    Option<Date> x$68 = IndexRecords$.MODULE$.indexer().indexFromMap$default$4();
                    Seq<String> x$69 = IndexRecords$.MODULE$.indexer().indexFromMap$default$6();
                    Seq<String> x$70 = IndexRecords$.MODULE$.indexer().indexFromMap$default$7();
                    boolean x$71 = IndexRecords$.MODULE$.indexer().indexFromMap$default$8();
                    String x$72 = IndexRecords$.MODULE$.indexer().indexFromMap$default$9();
                    IndexRecords$.MODULE$.indexer().indexFromMap(x$62, (Map<String, String>)x$63, x$67, x$68, x$64, x$69, x$70, x$71, x$72, x$65, x$66);
                }
                if (this.counter$4.elem % 1000 == 0) {
                    this.finishTime$4.elem = System.currentTimeMillis();
                    IndexRecords$.MODULE$.logger().info(new StringBuilder().append(this.counter$4.elem).append((Object)" >> Last key : ").append((Object)line).append((Object)", records per sec: ").append((Object)BoxesRunTime.boxToFloat((float)(1000.0f / ((float)(this.finishTime$4.elem - this.startTime$4.elem) / 1000.0f)))).toString());
                    this.startTime$4.elem = System.currentTimeMillis();
                }
            }
            {
                this.counter$4 = counter$4;
                this.startTime$4 = startTime$4;
                this.finishTime$4 = finishTime$4;
                this.csvFileWriter$3 = csvFileWriter$3;
                this.csvFileWriterSensitive$3 = csvFileWriterSensitive$3;
            }
        });
        if ((FileWriter)csvFileWriter.elem != null) {
            ((FileWriter)csvFileWriter.elem).flush();
            ((FileWriter)csvFileWriter.elem).close();
        }
        if ((FileWriter)csvFileWriterSensitive.elem != null) {
            ((FileWriter)csvFileWriterSensitive.elem).flush();
            ((FileWriter)csvFileWriterSensitive.elem).close();
        }
        this.indexer().finaliseIndex(false, shutdown);
    }

    public boolean indexList$default$2() {
        return true;
    }

    public void indexListOfUUIDs(File file) {
        ObjectRef csvFileWriter;
        this.logger().info("Starting the reindex by UUIDs....");
        IntRef counter = new IntRef(0);
        LongRef startTime = new LongRef(System.currentTimeMillis());
        LongRef finishTime = new LongRef(System.currentTimeMillis());
        ObjectRef objectRef = Config$.MODULE$.exportIndexAsCsvPath().length() > 0 ? new ObjectRef((Object)this.indexer().getCsvWriter(this.indexer().getCsvWriter$default$1())) : (csvFileWriter = new ObjectRef(null));
        ObjectRef csvFileWriterSensitive = Config$.MODULE$.exportIndexAsCsvPathSensitive().length() > 0 ? new ObjectRef((Object)this.indexer().getCsvWriter(true)) : new ObjectRef(null);
        FileHelper$.MODULE$.file2helper(file).foreachLine((Function1<String, BoxedUnit>)new Serializable(counter, startTime, finishTime, csvFileWriter, csvFileWriterSensitive){
            public static final long serialVersionUID = 0L;
            private final IntRef counter$5;
            private final LongRef startTime$5;
            private final LongRef finishTime$5;
            private final ObjectRef csvFileWriter$4;
            private final ObjectRef csvFileWriterSensitive$4;

            public final void apply(String line) {
                boolean shouldCommit;
                String uuid = line.replaceAll("\"", "");
                ++this.counter$5.elem;
                Option<scala.collection.immutable.Map<String, String>> map = IndexRecords$.MODULE$.persistenceManager().getByIndex(uuid, "occ", "uuid");
                boolean bl = shouldCommit = this.counter$5.elem % 10000 == 0;
                if (!map.isEmpty()) {
                    String x$73 = uuid;
                    scala.collection.immutable.Map x$74 = (scala.collection.immutable.Map)map.get();
                    boolean x$75 = shouldCommit;
                    FileWriter x$76 = (FileWriter)this.csvFileWriter$4.elem;
                    FileWriter x$77 = (FileWriter)this.csvFileWriterSensitive$4.elem;
                    boolean x$78 = IndexRecords$.MODULE$.indexer().indexFromMap$default$3();
                    Option<Date> x$79 = IndexRecords$.MODULE$.indexer().indexFromMap$default$4();
                    Seq<String> x$80 = IndexRecords$.MODULE$.indexer().indexFromMap$default$6();
                    Seq<String> x$81 = IndexRecords$.MODULE$.indexer().indexFromMap$default$7();
                    boolean x$82 = IndexRecords$.MODULE$.indexer().indexFromMap$default$8();
                    String x$83 = IndexRecords$.MODULE$.indexer().indexFromMap$default$9();
                    IndexRecords$.MODULE$.indexer().indexFromMap(x$73, (Map<String, String>)x$74, x$78, x$79, x$75, x$80, x$81, x$82, x$83, x$76, x$77);
                }
                if (this.counter$5.elem % 1000 == 0) {
                    this.finishTime$5.elem = System.currentTimeMillis();
                    IndexRecords$.MODULE$.logger().info(new StringBuilder().append(this.counter$5.elem).append((Object)" >> Last key : ").append((Object)line).append((Object)", records per sec: ").append((Object)BoxesRunTime.boxToFloat((float)(1000.0f / ((float)(this.finishTime$5.elem - this.startTime$5.elem) / 1000.0f)))).toString());
                    this.startTime$5.elem = System.currentTimeMillis();
                }
            }
            {
                this.counter$5 = counter$5;
                this.startTime$5 = startTime$5;
                this.finishTime$5 = finishTime$5;
                this.csvFileWriter$4 = csvFileWriter$4;
                this.csvFileWriterSensitive$4 = csvFileWriterSensitive$4;
            }
        });
        if ((FileWriter)csvFileWriter.elem != null) {
            ((FileWriter)csvFileWriter.elem).flush();
            ((FileWriter)csvFileWriter.elem).close();
        }
        if ((FileWriter)csvFileWriterSensitive.elem != null) {
            ((FileWriter)csvFileWriterSensitive.elem).flush();
            ((FileWriter)csvFileWriterSensitive.elem).close();
        }
        this.logger().info("Finalising index.....");
        this.indexer().finaliseIndex(false, true);
        this.logger().info("Finalised index.");
    }

    private IndexRecords$() {
        MODULE$ = this;
        Tool$class.$init$(this);
        IncrementalTool$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"IndexRecords");
        this.indexer = (IndexDAO)Config$.MODULE$.getInstance(IndexDAO.class);
        this.occurrenceDAO = (OccurrenceDAO)Config$.MODULE$.getInstance(OccurrenceDAO.class);
        this.persistenceManager = (PersistenceManager)Config$.MODULE$.getInstance(PersistenceManager.class);
    }
}

