/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.export;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.export.ExportFromIndexStream$;
import au.org.ala.biocache.util.OptionParser;
import au.org.ala.biocache.vocab.AssertionCodes$;
import au.org.ala.biocache.vocab.ErrorCode;
import java.io.File;
import java.io.FileWriter;
import java.util.Collection;
import java.util.Map;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class ExportFromIndexStream$
implements Tool {
    public static final ExportFromIndexStream$ MODULE$;
    private String outputFilePath;
    private String query;
    private String[] fieldsToExport;
    private int counter;
    private String[] orderFields;
    private boolean queryAssertions;

    static {
        new ExportFromIndexStream$();
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    @Override
    public String cmd() {
        return "export-stream";
    }

    @Override
    public String desc() {
        return "Export from search indexes using streaming";
    }

    public String outputFilePath() {
        return this.outputFilePath;
    }

    public void outputFilePath_$eq(String x$1) {
        this.outputFilePath = x$1;
    }

    public String query() {
        return this.query;
    }

    public void query_$eq(String x$1) {
        this.query = x$1;
    }

    public String[] fieldsToExport() {
        return this.fieldsToExport;
    }

    public void fieldsToExport_$eq(String[] x$1) {
        this.fieldsToExport = x$1;
    }

    public int counter() {
        return this.counter;
    }

    public void counter_$eq(int x$1) {
        this.counter = x$1;
    }

    public String[] orderFields() {
        return this.orderFields;
    }

    public void orderFields_$eq(String[] x$1) {
        this.orderFields = x$1;
    }

    public boolean queryAssertions() {
        return this.queryAssertions;
    }

    public void queryAssertions_$eq(boolean x$1) {
        this.queryAssertions = x$1;
    }

    @Override
    public void main(String[] args) {
        OptionParser parser = new OptionParser(){
            {
                this.arg("output-file", "The file name for the export file", (Function1<String, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(String v) {
                        ExportFromIndexStream$.MODULE$.outputFilePath_$eq(v);
                    }
                });
                this.arg("list-of-fields", "CSV list of fields to export", (Function1<String, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(String v) {
                        ExportFromIndexStream$.MODULE$.fieldsToExport_$eq((String[])Predef$.MODULE$.refArrayOps((Object[])v.split(",")).toArray(ClassTag$.MODULE$.apply(String.class)));
                    }
                });
                this.opt("q", "query", "The SOLR query to use", (Function1<String, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(String v) {
                        ExportFromIndexStream$.MODULE$.query_$eq(v);
                    }
                });
                this.opt("qa", "quality-assertions", "Include query assertions", (Function0<BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        ExportFromIndexStream$.MODULE$.queryAssertions_$eq(true);
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            FileWriter fileWriter = new FileWriter(new File(this.outputFilePath()));
            fileWriter.write(Predef$.MODULE$.refArrayOps((Object[])this.fieldsToExport()).mkString("\t"));
            if (this.queryAssertions()) {
                fileWriter.write("\t");
                fileWriter.write(((TraversableOnce)AssertionCodes$.MODULE$.all().map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(ErrorCode e) {
                        return e.name();
                    }
                }, Set$.MODULE$.canBuildFrom())).mkString("\t"));
            }
            fileWriter.write("\n");
            Config$.MODULE$.indexDAO().streamIndex((Function1<Map<String, Object>, Object>)new Serializable(fileWriter){
                public static final long serialVersionUID = 0L;
                public final FileWriter fileWriter$1;

                public final boolean apply(Map<String, Object> map) {
                    Object object;
                    ExportFromIndexStream$.MODULE$.counter_$eq(ExportFromIndexStream$.MODULE$.counter() + 1);
                    if (ExportFromIndexStream$.MODULE$.counter() % 1000 == 0) {
                        this.fileWriter$1.flush();
                    }
                    String[] outputLine = (String[])Predef$.MODULE$.refArrayOps((Object[])ExportFromIndexStream$.MODULE$.fieldsToExport()).map((Function1)new Serializable(this, map){
                        public static final long serialVersionUID = 0L;
                        private final Map map$1;

                        public final String apply(String f) {
                            return this.map$1.containsKey(f) ? this.map$1.get(f).toString() : "";
                        }
                        {
                            this.map$1 = map$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                    this.fileWriter$1.write(Predef$.MODULE$.refArrayOps((Object[])outputLine).mkString("\t"));
                    if (ExportFromIndexStream$.MODULE$.queryAssertions()) {
                        Collection assertions = (Collection)(map.containsKey("assertions") ? map.get("assertions") : null);
                        Collection assertions_passed = (Collection)(map.containsKey("assertions_passed") ? map.get("assertions_passed") : null);
                        Collection assertions_missing = (Collection)(map.containsKey("assertions_missing") ? map.get("assertions_missing") : null);
                        object = AssertionCodes$.MODULE$.all().map((Function1)new Serializable(this, assertions, assertions_passed, assertions_missing){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.main.2 $outer;
                            private final Collection assertions$1;
                            private final Collection assertions_passed$1;
                            private final Collection assertions_missing$1;

                            public final void apply(ErrorCode e) {
                                String a = e.name();
                                if (this.assertions$1 != null && this.assertions$1.contains(a)) {
                                    this.$outer.fileWriter$1.write("\tfailed");
                                } else if (this.assertions_passed$1 != null && this.assertions_passed$1.contains(a)) {
                                    this.$outer.fileWriter$1.write("\tpassed");
                                } else if (this.assertions_missing$1 != null && this.assertions_missing$1.contains(a)) {
                                    this.$outer.fileWriter$1.write("\tmissing");
                                } else {
                                    this.$outer.fileWriter$1.write("\t");
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.assertions$1 = assertions$1;
                                this.assertions_passed$1 = assertions_passed$1;
                                this.assertions_missing$1 = assertions_missing$1;
                            }
                        }, Set$.MODULE$.canBuildFrom());
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    this.fileWriter$1.write("\n");
                    return true;
                }
                {
                    this.fileWriter$1 = fileWriter$1;
                }
            }, this.queryAssertions() ? (String[])Predef$.MODULE$.refArrayOps((Object[])this.fieldsToExport()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"assertions", "assertions_passed", "assertions_missing"}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))) : this.fieldsToExport(), this.query(), (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), this.orderFields(), (Option<String[]>)None$.MODULE$);
            Config$.MODULE$.indexDAO().shutdown();
            fileWriter.flush();
            fileWriter.close();
        }
    }

    private ExportFromIndexStream$() {
        MODULE$ = this;
        Tool$class.$init$(this);
        this.outputFilePath = "";
        this.query = "*:*";
        this.fieldsToExport = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        this.counter = 0;
        this.orderFields = (String[])((Object[])new String[]{"row_key"});
        this.queryAssertions = false;
    }
}

