/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.tool;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.biocache.Config$;
import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.persistence.PersistenceManager;
import au.org.ala.biocache.util.OptionParser;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.CharRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.util.parsing.json.JSON$;

public final class ImportUtil$
implements Tool {
    public static final ImportUtil$ MODULE$;

    static {
        new ImportUtil$();
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    @Override
    public String cmd() {
        return "import";
    }

    @Override
    public String desc() {
        return "Import data (not for production use)";
    }

    @Override
    public void main(String[] args) {
        ObjectRef entity = new ObjectRef((Object)"");
        ObjectRef fieldsToImport = new ObjectRef((Object)Nil$.MODULE$);
        ObjectRef filesToImport = new ObjectRef((Object)Nil$.MODULE$);
        IntRef linesToSkip = new IntRef(0);
        ObjectRef quoteChar = new ObjectRef((Object)None$.MODULE$);
        CharRef charSeparator = new CharRef('\t');
        IntRef idColumnIdx = new IntRef(0);
        BooleanRef json = new BooleanRef(false);
        OptionParser parser = new OptionParser(entity, fieldsToImport, filesToImport, linesToSkip, quoteChar, charSeparator, idColumnIdx, json){
            {
                this.arg("entity", "the entity (column family in cassandra) to export from", (Function1<String, BoxedUnit>)new Serializable(this, entity$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef entity$1;

                    public final void apply(String v) {
                        this.entity$1.elem = v;
                    }
                    {
                        this.entity$1 = entity$1;
                    }
                });
                this.arg("files-to-import", "the file(s) to import, space separated", (Function1<String, BoxedUnit>)new Serializable(this, filesToImport$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef filesToImport$1;

                    public final void apply(String v) {
                        this.filesToImport$1.elem = Predef$.MODULE$.refArrayOps((Object[])v.split(" ")).toList();
                    }
                    {
                        this.filesToImport$1 = filesToImport$1;
                    }
                });
                this.opt("c", "columns", "<column1 column2 ...>", "column headers", (Function1<String, BoxedUnit>)new Serializable(this, fieldsToImport$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef fieldsToImport$1;

                    public final void apply(String columns) {
                        this.fieldsToImport$1.elem = Predef$.MODULE$.refArrayOps((Object[])columns.split(",")).toList();
                    }
                    {
                        this.fieldsToImport$1 = fieldsToImport$1;
                    }
                });
                this.opt("sp", "separator", "column separator", "column separator for file to import", (Function1<String, BoxedUnit>)new Serializable(this, charSeparator$1){
                    public static final long serialVersionUID = 0L;
                    private final CharRef charSeparator$1;

                    public final void apply(String v) {
                        this.charSeparator$1.elem = v.charAt(0);
                    }
                    {
                        this.charSeparator$1 = charSeparator$1;
                    }
                });
                this.opt("qc", "quotechar", "quote character", "column separator for file to import", (Function1<String, BoxedUnit>)new Serializable(this, quoteChar$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef quoteChar$1;

                    public final void apply(String v) {
                        this.quoteChar$1.elem = new Some((Object)BoxesRunTime.boxToCharacter((char)v.charAt(0)));
                    }
                    {
                        this.quoteChar$1 = quoteChar$1;
                    }
                });
                this.opt("cf", "column header file", "e.g. /data/headers.txt", "column headers", (Function1<String, BoxedUnit>)new Serializable(this, fieldsToImport$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef fieldsToImport$1;

                    public final void apply(String v) {
                        this.fieldsToImport$1.elem = Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(FileUtils.readFileToString((File)new File(v)).trim())).split(',')).toList();
                    }
                    {
                        this.fieldsToImport$1 = fieldsToImport$1;
                    }
                });
                this.opt("json", "import the values as json", (Function0<BoxedUnit>)new Serializable(this, json$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef json$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.json$1.elem = true;
                    }
                    {
                        this.json$1 = json$1;
                    }
                });
                this.intOpt("s", "skip-line", "number of lines to skip before importing", (Function1<Object, BoxedUnit>)new Serializable(this, linesToSkip$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef linesToSkip$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.linesToSkip$1.elem = v;
                    }
                    {
                        this.linesToSkip$1 = linesToSkip$1;
                    }
                });
                this.intOpt("id", "id-column-idx", "id column index. indexed from 0", (Function1<Object, BoxedUnit>)new Serializable(this, idColumnIdx$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef idColumnIdx$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.idColumnIdx$1.elem = v;
                    }
                    {
                        this.idColumnIdx$1 = idColumnIdx$1;
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            PersistenceManager pm = Config$.MODULE$.persistenceManager();
            ((List)filesToImport.elem).foreach((Function1)(json.elem ? new Serializable(entity){
                public static final long serialVersionUID = 0L;
                private final ObjectRef entity$1;

                public final void apply(String x$1) {
                    ImportUtil$.MODULE$.importJson((String)this.entity$1.elem, x$1);
                }
                {
                    this.entity$1 = entity$1;
                }
            } : new Serializable(entity, fieldsToImport, quoteChar, charSeparator, idColumnIdx){
                public static final long serialVersionUID = 0L;
                private final ObjectRef entity$1;
                private final ObjectRef fieldsToImport$1;
                private final ObjectRef quoteChar$1;
                private final CharRef charSeparator$1;
                private final IntRef idColumnIdx$1;

                public final void apply(String x$2) {
                    ImportUtil$.MODULE$.importFile((String)this.entity$1.elem, (List<String>)((List)this.fieldsToImport$1.elem), this.charSeparator$1.elem, (Option<Object>)((Option)this.quoteChar$1.elem), x$2, this.idColumnIdx$1.elem);
                }
                {
                    this.entity$1 = entity$1;
                    this.fieldsToImport$1 = fieldsToImport$1;
                    this.quoteChar$1 = quoteChar$1;
                    this.charSeparator$1 = charSeparator$1;
                    this.idColumnIdx$1 = idColumnIdx$1;
                }
            }));
            pm.shutdown();
        }
    }

    public void importJson(String entity, String filepath) {
        Source$.MODULE$.fromFile(filepath, Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1)new Serializable(entity){
            public static final long serialVersionUID = 0L;
            private final String entity$2;

            public final Object apply(String line) {
                Object object;
                Map map = (Map)JSON$.MODULE$.parseFull(line).get();
                Option guid = map.get((Object)new StringBuilder().append((Object)this.entity$2).append((Object)"rowKey").toString());
                if (guid.isDefined()) {
                    Map finalMap = (Map)map.$minus((Object)new StringBuilder().append((Object)this.entity$2).append((Object)"rowKey").toString());
                    object = Config$.MODULE$.persistenceManager().put((String)guid.get(), this.entity$2, (Map<String, String>)finalMap);
                } else {
                    object = BoxedUnit.UNIT;
                }
                return object;
            }
            {
                this.entity$2 = entity$2;
            }
        });
    }

    public void importFile(String entity, List<String> fieldsToImport, char separator, Option<Object> quotechar, String filepath, int idColumnIdx) {
        boolean bl = quotechar.isEmpty();
        CSVReader cSVReader = false == bl ? new CSVReader((Reader)new FileReader(filepath), separator, BoxesRunTime.unboxToChar((Object)quotechar.get())) : new CSVReader((Reader)new FileReader(filepath), separator);
        CSVReader reader = cSVReader;
        String[] currentLine = reader.readNext();
        int counter = 1;
        while (true) {
            Object object;
            if (currentLine == null) break;
            List columns = Predef$.MODULE$.refArrayOps((Object[])currentLine).toList();
            if (columns.length() == fieldsToImport.length() && StringUtils.isNotEmpty((String)((String)columns.apply(idColumnIdx)))) {
                Map map = (Map)((TraversableOnce)fieldsToImport.zip((GenIterable)columns, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms()).filter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<String, String> x0$1) {
                        Tuple2<String, String> tuple2 = x0$1;
                        if (tuple2 != null) {
                            String value = (String)tuple2._2();
                            boolean bl = value != null && value.toString().trim().length() > 0;
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                });
                object = Config$.MODULE$.persistenceManager().put((String)columns.apply(idColumnIdx), entity, (Map<String, String>)map);
            } else {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Problem loading line: ").append((Object)BoxesRunTime.boxToInteger((int)counter)).append((Object)", cols:fields = ").append((Object)BoxesRunTime.boxToInteger((int)columns.length())).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)fieldsToImport.length())).toString());
                object = BoxedUnit.UNIT;
            }
            ++counter;
            currentLine = reader.readNext();
        }
    }

    public int importFile$default$6() {
        return 0;
    }

    private ImportUtil$() {
        MODULE$ = this;
        Tool$class.$init$(this);
    }
}

