/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.tool;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.export.ExportAllSpatialSpecies;
import au.org.ala.biocache.index.IndexRecords$;
import au.org.ala.biocache.tool.DuplicationDetection;
import au.org.ala.biocache.tool.DuplicationDetection$;
import au.org.ala.biocache.util.FileHelper$;
import au.org.ala.biocache.util.OptionParser;
import au.org.ala.biocache.util.StringConsumer;
import java.io.File;
import java.io.FileWriter;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class DuplicationDetection$
implements Tool {
    public static final DuplicationDetection$ MODULE$;
    private final Logger logger;
    private String workingTmpDir;

    static {
        new DuplicationDetection$();
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    public Logger logger() {
        return this.logger;
    }

    public String workingTmpDir() {
        return this.workingTmpDir;
    }

    public void workingTmpDir_$eq(String x$1) {
        this.workingTmpDir = x$1;
    }

    @Override
    public String cmd() {
        return "duplicate-detection";
    }

    @Override
    public String desc() {
        return "Detects duplication based on a matched species and updates the database with details.";
    }

    @Override
    public void main(String[] args) {
        BooleanRef all = new BooleanRef(false);
        BooleanRef exist = new BooleanRef(false);
        ObjectRef guid = new ObjectRef((Object)None$.MODULE$);
        ObjectRef speciesFile = new ObjectRef((Object)None$.MODULE$);
        IntRef threads = new IntRef(4);
        BooleanRef cleanup = new BooleanRef(false);
        BooleanRef load2 = new BooleanRef(false);
        BooleanRef index = new BooleanRef(false);
        BooleanRef incremental = new BooleanRef(false);
        BooleanRef removeObsoleteData = new BooleanRef(false);
        ObjectRef offlineDir = new ObjectRef((Object)"/data/offline/exports");
        OptionParser parser = new OptionParser(all, exist, guid, speciesFile, threads, cleanup, load2, index, incremental, removeObsoleteData, offlineDir){
            {
                this.opt("all", "detect duplicates for all species", (Function0<BoxedUnit>)new Serializable(this, all$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef all$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.all$1.elem = true;
                    }
                    {
                        this.all$1 = all$1;
                    }
                });
                this.opt("g", "guid", "A single record GUID to test for duplications", (Function1<String, BoxedUnit>)new Serializable(this, guid$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef guid$1;

                    public final void apply(String v) {
                        this.guid$1.elem = new Some((Object)v);
                    }
                    {
                        this.guid$1 = guid$1;
                    }
                });
                this.opt("exist", "use existing occurrence dumps", (Function0<BoxedUnit>)new Serializable(this, exist$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef exist$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.exist$1.elem = true;
                    }
                    {
                        this.exist$1 = exist$1;
                    }
                });
                this.opt("inc", "perform an incremental duplication detection based on the last time it was run", (Function0<BoxedUnit>)new Serializable(this, incremental$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef incremental$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.incremental$1.elem = true;
                    }
                    {
                        this.incremental$1 = incremental$1;
                    }
                });
                this.opt("cleanup", "cleanup the temporary files that get created", (Function0<BoxedUnit>)new Serializable(this, cleanup$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef cleanup$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.cleanup$1.elem = true;
                    }
                    {
                        this.cleanup$1 = cleanup$1;
                    }
                });
                this.opt("load", "load to duplicates into the database", (Function0<BoxedUnit>)new Serializable(this, load$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef load$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.load$1.elem = true;
                    }
                    {
                        this.load$1 = load$1;
                    }
                });
                this.opt("index", "reindex duplicates", (Function0<BoxedUnit>)new Serializable(this, index$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef index$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.index$1.elem = true;
                    }
                    {
                        this.index$1 = index$1;
                    }
                });
                this.opt("f", "file", "A file that contains a list of species guids to detect duplication for", (Function1<String, BoxedUnit>)new Serializable(this, speciesFile$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef speciesFile$1;

                    public final void apply(String v) {
                        this.speciesFile$1.elem = new Some((Object)v);
                    }
                    {
                        this.speciesFile$1 = speciesFile$1;
                    }
                });
                this.opt("removeold", "Removes the duplicate information for records that are no longer duplicates", (Function0<BoxedUnit>)new Serializable(this, removeObsoleteData$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef removeObsoleteData$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.removeObsoleteData$1.elem = true;
                    }
                    {
                        this.removeObsoleteData$1 = removeObsoleteData$1;
                    }
                });
                this.opt("od", "offlinedir", new StringBuilder().append((Object)"The offline directory that contains the export files. Defaults to ").append((Object)((String)offlineDir$1.elem)).toString(), (Function1<String, BoxedUnit>)new Serializable(this, offlineDir$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef offlineDir$1;

                    public final void apply(String v) {
                        this.offlineDir$1.elem = v;
                    }
                    {
                        this.offlineDir$1 = offlineDir$1;
                    }
                });
                this.opt("wd", "workingdir", new StringBuilder().append((Object)"The  directory that contains the files produced during duplicate detection. Defaults to ").append((Object)DuplicationDetection$.MODULE$.workingTmpDir()).toString(), (Function1<String, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(String v) {
                        DuplicationDetection$.MODULE$.workingTmpDir_$eq(v);
                    }
                });
                this.intOpt("t", "threads", new StringBuilder().append((Object)" The number of concurrent species duplications to perform. Defaults to ").append((Object)BoxesRunTime.boxToInteger((int)threads$1.elem)).toString(), (Function1<Object, BoxedUnit>)new Serializable(this, threads$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef threads$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.threads$1.elem = v;
                    }
                    {
                        this.threads$1 = threads$1;
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            if (all.elem) {
                this.detectDuplicates(new File(new StringBuilder().append((Object)this.workingTmpDir()).append((Object)"dd_all_species_guids").toString()), threads.elem, exist.elem, cleanup.elem, load2.elem, (String)offlineDir.elem);
            } else if (removeObsoleteData.elem) {
                this.removeObsoleteDuplicates((Option<String>)((Option)speciesFile.elem));
            } else if (((Option)guid.elem).isDefined()) {
                DuplicationDetection dd = new DuplicationDetection();
                String dataFilename = new StringBuilder().append((Object)this.workingTmpDir()).append((Object)"dd_data_").append((Object)((String)((Option)guid.elem).get()).replaceAll("[\\.:]", "_")).append((Object)".txt").toString();
                String passedFilename = new StringBuilder().append((Object)this.workingTmpDir()).append((Object)"passed").append((Object)((String)((Option)guid.elem).get()).replaceAll("[\\.:]", "_")).append((Object)".txt").toString();
                String dupFilename = new StringBuilder().append((Object)this.workingTmpDir()).append((Object)"duplicates_").append((Object)((String)((Option)guid.elem).get()).replaceAll("[\\.:]", "_")).append((Object)".txt").toString();
                String indexFilename = new StringBuilder().append((Object)this.workingTmpDir()).append((Object)"reindex_").append((Object)((String)((Option)guid.elem).get()).replaceAll("[\\.:]", "_")).append((Object)".txt").toString();
                String oldDup = new StringBuilder().append((Object)this.workingTmpDir()).append((Object)"olddup_").append((Object)((String)((Option)guid.elem).get()).replaceAll("[\\.:]", "_")).append((Object)".txt").toString();
                if (load2.elem) {
                    dd.loadDuplicates((String)((Option)guid.elem).get(), threads.elem, dupFilename, new FileWriter(indexFilename), new FileWriter(oldDup));
                    this.updateLastDuplicateTime();
                } else {
                    String x$12 = dataFilename;
                    FileWriter x$13 = new FileWriter(dupFilename);
                    FileWriter x$14 = new FileWriter(passedFilename);
                    String x$15 = (String)((Option)guid.elem).get();
                    boolean x$16 = !exist.elem;
                    boolean x$17 = cleanup.elem;
                    String x$18 = dd.detect$default$6();
                    dd.detect(x$12, x$13, x$14, x$15, x$16, x$18, x$17);
                }
                if (index.elem) {
                    IndexRecords$.MODULE$.indexList(new File(indexFilename), false);
                }
                Config$.MODULE$.persistenceManager().shutdown();
                Config$.MODULE$.indexDAO().shutdown();
            } else if (((Option)speciesFile.elem).isDefined()) {
                this.detectDuplicates(new File((String)((Option)speciesFile.elem).get()), threads.elem, exist.elem, cleanup.elem, load2.elem, this.detectDuplicates$default$6());
            } else {
                parser.showUsage();
            }
        }
    }

    public void removeObsoleteDuplicates(Option<String> filename) {
        String olddupfilename = (String)filename.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringBuilder().append((Object)DuplicationDetection$.MODULE$.workingTmpDir()).append((Object)"olddups.txt").toString();
            }
        });
        FileHelper$.MODULE$.file2helper(new File(olddupfilename)).foreachLine((Function1<String, BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(String line) {
                String[] parts = line.split("\t");
                String uuid = parts[1];
                Config$.MODULE$.duplicateDAO().deleteObsoleteDuplicate(uuid);
            }
        });
    }

    public boolean exportFilesAvailable(String offlineDir, int threads) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            boolean bl;
            Object object = new Object();
            try {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), threads).foreach$mVc$sp((Function1)new Serializable(offlineDir, object){
                    public static final long serialVersionUID = 0L;
                    private final String offlineDir$3;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(int threadId) {
                        this.apply$mcVI$sp(threadId);
                    }

                    public void apply$mcVI$sp(int threadId) {
                        File file = new File(new StringBuilder().append((Object)this.offlineDir$3).append((Object)File.separator).append((Object)BoxesRunTime.boxToInteger((int)threadId)).append((Object)File.separator).append((Object)"species.out").toString());
                        if (file.exists()) {
                            return;
                        }
                        throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, false);
                    }
                    {
                        this.offlineDir$3 = offlineDir$3;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                bl = true;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    public void detectDuplicates(File file, int threads, boolean exist, boolean cleanup, boolean load2, String offlineDir) {
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting duplicate detection with ", " threads"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)threads)})));
        if (!load2 && !this.exportFilesAvailable(offlineDir, threads)) {
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exporting spatial data for duplicate detection...."})).s((Seq)Nil$.MODULE$));
            ExportAllSpatialSpecies exporter = new ExportAllSpatialSpecies();
            exporter.export(false, threads, offlineDir);
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Export spatial data for duplicate detection....finished"})).s((Seq)Nil$.MODULE$));
        }
        Thread[] pool = (Thread[])Array$.MODULE$.ofDim(threads, ClassTag$.MODULE$.apply(Thread.class));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), threads).foreach$mVc$sp((Function1)new Serializable(threads, load2, offlineDir, pool){
            public static final long serialVersionUID = 0L;
            public final int threads$2;
            private final boolean load$2;
            public final String offlineDir$2;
            private final Thread[] pool$1;

            public final void apply(int threadId) {
                this.apply$mcVI$sp(threadId);
            }

            public void apply$mcVI$sp(int threadId) {
                Thread thread;
                String dir = new StringBuilder().append((Object)DuplicationDetection$.MODULE$.workingTmpDir()).append((Object)BoxesRunTime.boxToInteger((int)threadId)).append((Object)File.separator).toString();
                FileUtils.forceMkdir((File)new File(dir));
                String dupfilename = new StringBuilder().append((Object)dir).append((Object)"duplicates.txt").toString();
                String passedfilename = new StringBuilder().append((Object)dir).append((Object)"passed.txt").toString();
                String indexfilename = new StringBuilder().append((Object)dir).append((Object)"reindex.txt").toString();
                String olddupfilename = new StringBuilder().append((Object)dir).append((Object)"olddups.txt").toString();
                if (this.load$2) {
                    DuplicationDetection$.MODULE$.logger().info(new StringBuilder().append((Object)"Starting loading thread with ID: ").append((Object)BoxesRunTime.boxToInteger((int)threadId)).toString());
                    thread = new Thread(this, dupfilename, passedfilename, indexfilename, olddupfilename){
                        private final /* synthetic */ anonfun.detectDuplicates.1 $outer;
                        private final String dupfilename$1;
                        private final String passedfilename$1;
                        private final String indexfilename$1;
                        private final String olddupfilename$1;

                        public void run() {
                            new DuplicationDetection().loadMultipleDuplicatesFromFile(this.dupfilename$1, this.passedfilename$1, this.$outer.threads$2, new FileWriter(new File(this.indexfilename$1)), new FileWriter(new File(this.olddupfilename$1)));
                            IndexRecords$.MODULE$.indexList(new File(this.indexfilename$1), false);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.dupfilename$1 = dupfilename$1;
                            this.passedfilename$1 = passedfilename$1;
                            this.indexfilename$1 = indexfilename$1;
                            this.olddupfilename$1 = olddupfilename$1;
                        }
                    };
                } else {
                    DuplicationDetection$.MODULE$.logger().info(new StringBuilder().append((Object)"Starting detection thread with ID: ").append((Object)BoxesRunTime.boxToInteger((int)threadId)).toString());
                    thread = new Thread(this, dupfilename, passedfilename, threadId){
                        private final /* synthetic */ anonfun.detectDuplicates.1 $outer;
                        private final String dupfilename$1;
                        private final String passedfilename$1;
                        private final int threadId$1;

                        public void run() {
                            String sourceFileName = new StringBuilder().append((Object)this.$outer.offlineDir$2).append((Object)File.separator).append((Object)BoxesRunTime.boxToInteger((int)this.threadId$1)).append((Object)File.separator).append((Object)"species.out").toString();
                            DuplicationDetection$.MODULE$.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checking file ", " is available.."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourceFileName})));
                            if (new File(sourceFileName).exists()) {
                                new DuplicationDetection().detectMultipleDuplicatesFromFile(sourceFileName, new FileWriter(this.dupfilename$1), new FileWriter(this.passedfilename$1), this.$outer.threads$2);
                            } else {
                                DuplicationDetection$.MODULE$.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Source file ", " not available."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourceFileName})));
                            }
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.dupfilename$1 = dupfilename$1;
                            this.passedfilename$1 = passedfilename$1;
                            this.threadId$1 = threadId$1;
                        }
                    };
                }
                Thread process2 = thread;
                process2.start();
                this.pool$1[threadId] = process2;
            }
            {
                this.threads$2 = threads$2;
                this.load$2 = load$2;
                this.offlineDir$2 = offlineDir$2;
                this.pool$1 = pool$1;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])pool).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Thread t) {
                if (t instanceof StringConsumer) {
                    ((StringConsumer)t).shouldStop_$eq(true);
                }
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])pool).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Thread x$1) {
                x$1.join();
            }
        });
        if (load2) {
            this.updateLastDuplicateTime();
            File baseFile = new File(new StringBuilder().append((Object)this.workingTmpDir()).append((Object)"olddups.txt").toString());
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), threads - 1).foreach$mVc$sp((Function1)new Serializable(baseFile){
                public static final long serialVersionUID = 0L;
                private final File baseFile$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    File ifile = new File(new StringBuilder().append((Object)DuplicationDetection$.MODULE$.workingTmpDir()).append((Object)BoxesRunTime.boxToInteger((int)i)).append((Object)File.separator).append((Object)"olddups.txt").toString());
                    FileHelper$.MODULE$.file2helper(this.baseFile$1).append(FileHelper$.MODULE$.file2helper(ifile));
                }
                {
                    this.baseFile$1 = baseFile$1;
                }
            });
        }
        Config$.MODULE$.persistenceManager().shutdown();
        Config$.MODULE$.indexDAO().shutdown();
    }

    public String detectDuplicates$default$6() {
        return "";
    }

    public void updateLastDuplicateTime() {
        Date date = DateUtils.truncate((Date)new Date(), (int)5);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.add(10, -24);
        Config$.MODULE$.duplicateDAO().setLastDuplicationRun(cal.getTime());
    }

    private DuplicationDetection$() {
        MODULE$ = this;
        Tool$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"DuplicateDetection");
        this.workingTmpDir = "/data/tool/";
    }
}

