/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.tool;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.dao.OccurrenceDAO;
import au.org.ala.biocache.persistence.PersistenceManager;
import au.org.ala.biocache.tool.DataResourceDelete;
import au.org.ala.biocache.tool.FileDelete;
import au.org.ala.biocache.tool.QueryDelete;
import au.org.ala.biocache.tool.RangeDeletor;
import au.org.ala.biocache.tool.RecordDeletor;
import au.org.ala.biocache.util.OptionParser;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public final class DeleteRecords$
implements Tool {
    public static final DeleteRecords$ MODULE$;
    private final OccurrenceDAO occurrenceDAO;
    private final PersistenceManager persistenceManager;

    static {
        new DeleteRecords$();
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    @Override
    public String cmd() {
        return "delete-records";
    }

    @Override
    public String desc() {
        return "Delete records from the system via query, resource or file of IDs";
    }

    public OccurrenceDAO occurrenceDAO() {
        return this.occurrenceDAO;
    }

    public PersistenceManager persistenceManager() {
        return this.persistenceManager;
    }

    @Override
    public void main(String[] args) {
        ObjectRef query = new ObjectRef((Object)None$.MODULE$);
        ObjectRef dr = new ObjectRef((Object)None$.MODULE$);
        ObjectRef file = new ObjectRef((Object)None$.MODULE$);
        ObjectRef startRowkey = new ObjectRef((Object)None$.MODULE$);
        ObjectRef endRowkey = new ObjectRef((Object)None$.MODULE$);
        BooleanRef useUUID = new BooleanRef(false);
        char fieldDelimiter = '\t';
        BooleanRef hasHeader = new BooleanRef(false);
        OptionParser parser = new OptionParser(query, dr, file, startRowkey, endRowkey, useUUID, hasHeader){
            {
                this.opt("q", "query", "The query to run to obtain the records for deletion e.g. 'year:[2001 TO *]' or 'taxon_name:Macropus'", (Function1<String, BoxedUnit>)new Serializable(this, query$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef query$1;

                    public final void apply(String v) {
                        this.query$1.elem = new Some((Object)v);
                    }
                    {
                        this.query$1 = query$1;
                    }
                });
                this.opt("dr", "resource", "The data resource to process", (Function1<String, BoxedUnit>)new Serializable(this, dr$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef dr$1;

                    public final void apply(String v) {
                        this.dr$1.elem = new Some((Object)v);
                    }
                    {
                        this.dr$1 = dr$1;
                    }
                });
                this.opt("f", "file", "The file of row keys to delete. Can be an absolute local file path or URL to a file that contains rowkeys or UUIDs.", (Function1<String, BoxedUnit>)new Serializable(this, file$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef file$1;

                    public final void apply(String v) {
                        this.file$1.elem = new Some((Object)v);
                    }
                    {
                        this.file$1 = file$1;
                    }
                });
                this.opt("s", "startRowkey", "The start rowkey to use", (Function1<String, BoxedUnit>)new Serializable(this, startRowkey$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef startRowkey$1;

                    public final void apply(String v) {
                        this.startRowkey$1.elem = new Some((Object)v);
                    }
                    {
                        this.startRowkey$1 = startRowkey$1;
                    }
                });
                this.opt("e", "endRowkey", "The end rowkey to use", (Function1<String, BoxedUnit>)new Serializable(this, endRowkey$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef endRowkey$1;

                    public final void apply(String v) {
                        this.endRowkey$1.elem = new Some((Object)v);
                    }
                    {
                        this.endRowkey$1 = endRowkey$1;
                    }
                });
                this.opt("hdr", "fileHasHeader", "The supplied file has a header", (Function0<BoxedUnit>)new Serializable(this, hasHeader$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef hasHeader$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.hasHeader$1.elem = true;
                    }
                    {
                        this.hasHeader$1 = hasHeader$1;
                    }
                });
                this.opt("uuid", "useUUID", "The supplied file contains UUIDs (as opposed to row keys)", (Function0<BoxedUnit>)new Serializable(this, useUUID$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef useUUID$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.useUUID$1.elem = true;
                    }
                    {
                        this.useUUID$1 = useUUID$1;
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            Some deletor;
            Object object = ((Option)query.elem).isEmpty() ? (((Option)dr.elem).isEmpty() ? (((Option)file.elem).isDefined() ? new Some((Object)new FileDelete((String)((Option)file.elem).get(), useUUID.elem, fieldDelimiter, hasHeader.elem)) : (((Option)startRowkey.elem).isDefined() && ((Option)endRowkey.elem).isDefined() ? new Some((Object)new RangeDeletor((String)((Option)startRowkey.elem).get(), (String)((Option)endRowkey.elem).get())) : None$.MODULE$)) : new Some((Object)new DataResourceDelete((String)((Option)dr.elem).get()))) : (deletor = new Some((Object)new QueryDelete((String)((Option)query.elem).get())));
            if (deletor.isEmpty()) {
                parser.showUsage();
            } else {
                ((RecordDeletor)deletor.get()).deleteFromPersistent();
                ((RecordDeletor)deletor.get()).deleteFromIndex();
            }
        }
    }

    private DeleteRecords$() {
        MODULE$ = this;
        Tool$class.$init$(this);
        this.occurrenceDAO = Config$.MODULE$.occurrenceDAO();
        this.persistenceManager = Config$.MODULE$.persistenceManager();
    }
}

