/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.processor;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.caches.LocationDAO$;
import au.org.ala.biocache.caches.SensitiveAreaDAO$;
import au.org.ala.biocache.caches.TaxonProfileDAO$;
import au.org.ala.biocache.load.FullRecordMapper$;
import au.org.ala.biocache.model.Feet$;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.model.Location;
import au.org.ala.biocache.model.MeasurementUnit;
import au.org.ala.biocache.model.QualityAssertion;
import au.org.ala.biocache.model.QualityAssertion$;
import au.org.ala.biocache.model.TaxonProfile;
import au.org.ala.biocache.model.Versions$;
import au.org.ala.biocache.parser.DistanceRangeParser$;
import au.org.ala.biocache.parser.VerbatimLatLongParser$;
import au.org.ala.biocache.poso.POSO;
import au.org.ala.biocache.processor.GISPoint;
import au.org.ala.biocache.processor.Processor;
import au.org.ala.biocache.processor.Processor$class;
import au.org.ala.biocache.util.Json$;
import au.org.ala.biocache.util.StringHelper$;
import au.org.ala.biocache.vocab.AssertionCodes$;
import au.org.ala.biocache.vocab.AssertionStatus$;
import au.org.ala.biocache.vocab.BBox;
import au.org.ala.biocache.vocab.Countries$;
import au.org.ala.biocache.vocab.CountryCentrePoints$;
import au.org.ala.biocache.vocab.HabitatMap$;
import au.org.ala.biocache.vocab.LatLng;
import au.org.ala.biocache.vocab.StateProvinceCentrePoints$;
import au.org.ala.biocache.vocab.StateProvinceToCountry$;
import au.org.ala.biocache.vocab.StateProvinces$;
import au.org.ala.biocache.vocab.Term;
import au.org.ala.sds.SensitiveDataService;
import au.org.ala.sds.model.Message;
import au.org.ala.sds.util.GeoLocationHelper;
import au.org.ala.sds.validation.ValidationOutcome;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.math3.util.Precision;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.DefaultCoordinateOperationFactory;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple6;
import scala.collection.JavaConversions$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.io.Source$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\t=f\u0001B\u0001\u0003\u00015\u0011\u0011\u0003T8dCRLwN\u001c)s_\u000e,7o]8s\u0015\t\u0019A!A\u0005qe>\u001cWm]:pe*\u0011QAB\u0001\tE&|7-Y2iK*\u0011q\u0001C\u0001\u0004C2\f'BA\u0005\u000b\u0003\ry'o\u001a\u0006\u0002\u0017\u0005\u0011\u0011-^\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005U1R\"\u0001\u0002\n\u0005]\u0011!!\u0003)s_\u000e,7o]8s\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u0016\u0001!9Q\u0004\u0001b\u0001\n\u0003q\u0012A\u00027pO\u001e,'/F\u0001 !\t\u0001C%D\u0001\"\u0015\t\u00113%A\u0003tY\u001a$$NC\u0001\n\u0013\t)\u0013E\u0001\u0004M_\u001e<WM\u001d\u0005\u0007O\u0001\u0001\u000b\u0011B\u0010\u0002\u000f1|wmZ3sA!9\u0011\u0006\u0001b\u0001\n\u0003Q\u0013aD,H'b\"t,\u0012)T\u000f~\u001bu\u000eZ3\u0016\u0003-\u0002\"\u0001L\u0019\u000e\u00035R!AL\u0018\u0002\t1\fgn\u001a\u0006\u0002a\u0005!!.\u0019<b\u0013\t\u0011TF\u0001\u0004TiJLgn\u001a\u0005\u0007i\u0001\u0001\u000b\u0011B\u0016\u0002!];5\u000b\u000f\u001b`\u000bB\u001bviX\"pI\u0016\u0004\u0003b\u0002\u001c\u0001\u0005\u0004%\taN\u0001\u0004g\u0012\u001cX#\u0001\u001d\u0011\u0005eZT\"\u0001\u001e\u000b\u0005Y2\u0011B\u0001\u001f;\u0005Q\u0019VM\\:ji&4X\rR1uCN+'O^5dK\"1a\b\u0001Q\u0001\na\nAa\u001d3tA!A\u0001\t\u0001EC\u0002\u0013\u0005\u0011)A\bdeN,\u0005o]4D_\u0012,7/T1q+\u0005\u0011\u0005\u0003B\"I\u0015*k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0005\u001d\u0003\u0012AC2pY2,7\r^5p]&\u0011\u0011\n\u0012\u0002\u0004\u001b\u0006\u0004\bCA&O\u001d\tyA*\u0003\u0002N!\u00051\u0001K]3eK\u001aL!AM(\u000b\u00055\u0003\u0002\u0002C)\u0001\u0011\u0003\u0005\u000b\u0015\u0002\"\u0002!\r\u00148/\u00129tO\u000e{G-Z:NCB\u0004\u0003\u0002C*\u0001\u0011\u000b\u0007I\u0011A!\u0002!i|g.Z#qg\u001e\u001cu\u000eZ3t\u001b\u0006\u0004\b\u0002C+\u0001\u0011\u0003\u0005\u000b\u0015\u0002\"\u0002#i|g.Z#qg\u001e\u001cu\u000eZ3t\u001b\u0006\u0004\b\u0005C\u0003X\u0001\u0011\u0005\u0001,A\u0004qe>\u001cWm]:\u0015\u000be\u0013G-[6\u0011\u0007=QF,\u0003\u0002\\!\t)\u0011I\u001d:bsB\u0011Q\fY\u0007\u0002=*\u0011q\fB\u0001\u0006[>$W\r\\\u0005\u0003Cz\u0013\u0001#U;bY&$\u00180Q:tKJ$\u0018n\u001c8\t\u000b\r4\u0006\u0019\u0001&\u0002\t\u001d,\u0018\u000e\u001a\u0005\u0006KZ\u0003\rAZ\u0001\u0004e\u0006<\bCA/h\u0013\tAgL\u0001\u0006Gk2d'+Z2pe\u0012DQA\u001b,A\u0002\u0019\f\u0011\u0002\u001d:pG\u0016\u001c8/\u001a3\t\u000f14\u0006\u0013!a\u0001[\u0006iA.Y:u!J|7-Z:tK\u0012\u00042a\u00048g\u0013\ty\u0007C\u0001\u0004PaRLwN\u001c\u0005\u0006c\u0002!\tA]\u0001\u0016G\",7m\u001b'pG\u0006$\u0018n\u001c8TkB\u0004H.[3e)\u0011\u0019\u0018P_>\u0011\u0007Q<H,D\u0001v\u0015\t1h)A\u0004nkR\f'\r\\3\n\u0005a,(aC!se\u0006L()\u001e4gKJDQ!\u001a9A\u0002\u0019DQA\u001b9A\u0002\u0019DQ\u0001 9A\u0002M\f!\"Y:tKJ$\u0018n\u001c8t\u0011\u0015q\b\u0001\"\u0003\u0000\u0003e\u0001(o\\2fgN\u001cF/\u0019;f\u0007>,h\u000e\u001e:z-\u0006dW/Z:\u0015\u0011\u0005\u0005\u0011qAA\u0005\u0003\u0017\u00012aDA\u0002\u0013\r\t)\u0001\u0005\u0002\u0005+:LG\u000fC\u0003f{\u0002\u0007a\rC\u0003k{\u0002\u0007a\rC\u0003}{\u0002\u00071\u000fC\u0004\u0002\u0010\u0001!\t!!\u0005\u0002G\u001d,GoQ8pe\u0012Lg.\u0019;f+:\u001cWM\u001d;bS:$\u0018P\u0012:p[\u001e\u0013\u0018\u000e\u001a*fMR1\u00111CA\u000e\u0003?\u0001Ba\u00048\u0002\u0016A\u0019q\"a\u0006\n\u0007\u0005e\u0001CA\u0002J]RD\u0001\"!\b\u0002\u000e\u0001\u0007\u0011QC\u0001\u0014]>|eMT;nKJL7-\u00197ES\u001eLGo\u001d\u0005\t\u0003C\ti\u00011\u0001\u0002\u0016\u00059bn\\(g'\u0016\u001cwN\u001c3bef\fE\u000e\u001d5b\u0007\"\f'o\u001d\u0005\b\u0003K\u0001A\u0011AA\u0014\u0003\u0001z7o\u0012:jIJ+g-\u001a:f]\u000e,Gk\\#bgRLgn\u001a(peRD\u0017N\\4\u0015\t\u0005%\u0012\u0011\u0007\t\u0005\u001f9\fY\u0003E\u0005\u0010\u0003[\t)\"!\u0006\u0002\u0014%\u0019\u0011q\u0006\t\u0003\rQ+\b\u000f\\34\u0011\u001d\t\u0019$a\tA\u0002)\u000bqa\u001a:jIJ+g\rC\u0004\u00028\u0001!I!!\u000f\u0002'Y\fG.\u001b3bi\u0016\u001cun\u001c:eS:\fG/Z:\u0015\u0011\u0005\u0005\u00111HA\u001f\u0003\u007fAa!ZA\u001b\u0001\u00041\u0007B\u00026\u00026\u0001\u0007a\r\u0003\u0004}\u0003k\u0001\ra\u001d\u0005\b\u0003\u0007\u0002A\u0011BA#\u0003]\u0001(o\\2fgN\fE\u000e^5uk\u0012,\u0017I\u001c3EKB$\b\u000e\u0006\u0006\u0002\u0002\u0005\u001d\u0013\u0011JA&\u0003\u001bBaaYA!\u0001\u0004Q\u0005BB3\u0002B\u0001\u0007a\r\u0003\u0004k\u0003\u0003\u0002\rA\u001a\u0005\u0007y\u0006\u0005\u0003\u0019A:\t\u000f\u0005E\u0003\u0001\"\u0003\u0002T\u0005\u0011\u0002O]8dKN\u001cX*\u001b8NCb$U\r\u001d;i)!\t\t!!\u0016\u0002X\u0005e\u0003BB3\u0002P\u0001\u0007a\r\u0003\u0004k\u0003\u001f\u0002\rA\u001a\u0005\u0007y\u0006=\u0003\u0019A:\t\u000f\u0005u\u0003\u0001\"\u0003\u0002`\u0005A\u0002O]8dKN\u001ch+\u001a:cCRLW.\u00127fm\u0006$\u0018n\u001c8\u0015\u0011\u0005\u0005\u0011\u0011MA2\u0003KBa!ZA.\u0001\u00041\u0007B\u00026\u0002\\\u0001\u0007a\r\u0003\u0004}\u00037\u0002\ra\u001d\u0005\b\u0003S\u0002A\u0011BA6\u0003Q\u0001(o\\2fgN4VM\u001d2bi&lG)\u001a9uQRA\u0011\u0011AA7\u0003_\n\t\b\u0003\u0004f\u0003O\u0002\rA\u001a\u0005\u0007U\u0006\u001d\u0004\u0019\u00014\t\rq\f9\u00071\u0001t\u0011\u001d\t)\b\u0001C\u0005\u0003o\nqc]3u!J|7-Z:tK\u0012\u001cun\u001c:eS:\fG/Z:\u0015\u0011\u0005\u0005\u0011\u0011PA>\u0003{Ba!ZA:\u0001\u00041\u0007B\u00026\u0002t\u0001\u0007a\r\u0003\u0004}\u0003g\u0002\ra\u001d\u0005\b\u0003\u0003\u0003A\u0011AAB\u00039\u0001(o\\2fgNd\u0015\r\u001e'p]\u001e$\u0002$!\"\u0002\u000e\u0006E\u0015QSAM\u0003;\u000b\t+!*\u0002*\u00065\u0016\u0011WA[!\u0011ya.a\"\u0011\u0007U\tI)C\u0002\u0002\f\n\u0011\u0001bR%T!>Lg\u000e\u001e\u0005\b\u0003\u001f\u000by\b1\u0001K\u0003-\u0011\u0018m\u001e'bi&$X\u000fZ3\t\u000f\u0005M\u0015q\u0010a\u0001\u0015\u0006a!/Y<M_:<\u0017\u000e^;eK\"9\u0011qSA@\u0001\u0004Q\u0015\u0001\u0005:bo\u001e+w\u000eZ3uS\u000e$\u0015\r^;n\u0011\u001d\tY*a A\u0002)\u000b\u0001C^3sE\u0006$\u0018.\u001c'bi&$X\u000fZ3\t\u000f\u0005}\u0015q\u0010a\u0001\u0015\u0006\tb/\u001a:cCRLW\u000eT8oO&$X\u000fZ3\t\u000f\u0005\r\u0016q\u0010a\u0001\u0015\u0006Ya/\u001a:cCRLWn\u0015*T\u0011\u001d\t9+a A\u0002)\u000bq!Z1ti&tw\rC\u0004\u0002,\u0006}\u0004\u0019\u0001&\u0002\u00119|'\u000f\u001e5j]\u001eDq!a,\u0002\u0000\u0001\u0007!*\u0001\u0003{_:,\u0007bBAZ\u0003\u007f\u0002\rAS\u0001\u000eOJLGMU3gKJ,gnY3\t\rq\fy\b1\u0001t\u0011\u001d\tI\f\u0001C\u0001\u0003w\u000bA\u0003\u001d:pG\u0016\u001c8o\u0012:jIJ+g-\u001a:f]\u000e,GCBAC\u0003{\u000by\fC\u0004\u00024\u0006]\u0006\u0019\u0001&\t\rq\f9\f1\u0001t\u0011\u001d\t\u0019\r\u0001C\u0005\u0003\u000b\f\u0011\u0004\u001d:pG\u0016\u001c8\u000fR3dS6\fGnQ8pe\u0012Lg.\u0019;fgRQ\u0011QQAd\u0003\u0013\fY-!4\t\u000f\u0005=\u0015\u0011\u0019a\u0001\u0015\"9\u00111SAa\u0001\u0004Q\u0005bBAL\u0003\u0003\u0004\rA\u0013\u0005\u0007y\u0006\u0005\u0007\u0019A:\t\u000f\u0005E\u0007\u0001\"\u0003\u0002T\u0006Q\u0002O]8dKN\u001ch+\u001a:cCRLWnQ8pe\u0012Lg.\u0019;fgRQ\u0011QQAk\u0003/\fI.!:\t\u000f\u0005\r\u0016q\u001aa\u0001\u0015\"1A0a4A\u0002MD\u0001\"a7\u0002P\u0002\u0007\u0011Q\\\u0001\u0013I\u0016\u001c\u0017.\\1m-\u0016\u0014(-\u0019;j[2\u000bG\u000f\u0005\u0003\u0010]\u0006}\u0007cA\b\u0002b&\u0019\u00111\u001d\t\u0003\u000b\u0019cw.\u0019;\t\u0011\u0005\u001d\u0018q\u001aa\u0001\u0003;\f1\u0003Z3dS6\fGNV3sE\u0006$\u0018.\u001c'p]\u001eDq!a;\u0001\t\u0013\ti/\u0001\u000eqe>\u001cWm]:O_J$\b.\u001b8h\u000b\u0006\u001cH/\u001b8h5>tW\r\u0006\u0007\u0002\u0006\u0006=\u0018\u0011_Az\u0003k\f9\u0010C\u0004\u0002$\u0006%\b\u0019\u0001&\t\u000f\u0005\u001d\u0016\u0011\u001ea\u0001\u0015\"9\u00111VAu\u0001\u0004Q\u0005bBAX\u0003S\u0004\rA\u0013\u0005\u0007y\u0006%\b\u0019A:\t\u000f\u0005m\b\u0001\"\u0003\u0002~\u0006Y\"/\u001a9s_*,7\r^\"p_J$\u0017N\\1uKN$vnV$TqQ\"\"\"a@\u0003\b\tE!Q\u0003B\r!\u0011yaN!\u0001\u0011\u000b=\u0011\u0019A\u0013&\n\u0007\t\u0015\u0001C\u0001\u0004UkBdWM\r\u0005\t\u0005\u0013\tI\u00101\u0001\u0003\f\u0005Y1m\\8sI&t\u0017\r^32!\ry!QB\u0005\u0004\u0005\u001f\u0001\"A\u0002#pk\ndW\r\u0003\u0005\u0003\u0014\u0005e\b\u0019\u0001B\u0006\u0003-\u0019wn\u001c:eS:\fG/\u001a\u001a\t\u000f\t]\u0011\u0011 a\u0001\u0015\u0006\t2o\\;sG\u0016\u001c%o]#qg\u001e\u001cu\u000eZ3\t\u0011\tm\u0011\u0011 a\u0001\u0003+\ta\u0003Z3dS6\fG\u000e\u00157bG\u0016\u001cHk\u001c*pk:$Gk\u001c\u0005\b\u0005?\u0001A\u0011\u0001B\u0011\u0003\u0001:W\r\u001e(v[\n,'o\u00144EK\u000eLW.\u00197QY\u0006\u001cWm]%o\t>,(\r\\3\u0015\t\u0005U!1\u0005\u0005\b\u0005K\u0011i\u00021\u0001K\u0003=!WmY5nC2\f5o\u0015;sS:<\u0007b\u0002B\u0015\u0001\u0011%!1F\u0001\u000fY>|7.\u001e9FaN<7i\u001c3f)\u0011\u0011iCa\f\u0011\u0007=q'\nC\u0004\u00032\t\u001d\u0002\u0019\u0001&\u0002\u0007\r\u00148\u000fC\u0004\u00036\u0001!IAa\u000e\u00025\rDWmY6D_>\u0014H-\u001b8bi\u0016,fnY3si\u0006Lg\u000e^=\u0015\u0011\u0005\u0005!\u0011\bB\u001e\u0005{Aa!\u001aB\u001a\u0001\u00041\u0007B\u00026\u00034\u0001\u0007a\r\u0003\u0004}\u0005g\u0001\ra\u001d\u0005\b\u0005\u0003\u0002A\u0011\u0002B\"\u0003]\u0019\u0007.Z2l\r>\u0014\b*\u00192ji\u0006$X*[:nCR\u001c\u0007\u000e\u0006\u0005\u0002\u0002\t\u0015#q\tB%\u0011\u0019)'q\ba\u0001M\"1!Na\u0010A\u0002\u0019Da\u0001 B \u0001\u0004\u0019\bb\u0002B'\u0001\u0011%!qJ\u0001\u0016C\u0012$7i\u001c8tKJ4\u0018\r^5p]N#\u0018\r^;t)\u0019\t\tA!\u0015\u0003T!1QMa\u0013A\u0002\u0019DaA\u001bB&\u0001\u00041\u0007b\u0002B,\u0001\u0011%!\u0011L\u0001\u0016G\",7m\u001b$peN#\u0018\r^3NSNl\u0017\r^2i)!\t\tAa\u0017\u0003^\t}\u0003BB3\u0003V\u0001\u0007a\r\u0003\u0004k\u0005+\u0002\rA\u001a\u0005\u0007y\nU\u0003\u0019A:\t\u000f\t\r\u0004\u0001\"\u0001\u0003f\u0005Qb/\u00197jI\u0006$XmR3pe\u00164WM]3oG\u00164\u0016\r\\;fgR91Oa\u001a\u0003j\t-\u0004BB3\u0003b\u0001\u0007a\r\u0003\u0004k\u0005C\u0002\rA\u001a\u0005\u0007y\n\u0005\u0004\u0019A:\t\u000f\t=\u0004\u0001\"\u0001\u0003r\u0005Ib/\u00197jI\u0006$XmQ8pe\u0012Lg.\u0019;fgZ\u000bG.^3t)!\u0011\u0019H!\u001f\u0003|\tu\u0004cA\b\u0003v%\u0019!q\u000f\t\u0003\u0007\u0005s\u0017\u0010\u0003\u0004f\u0005[\u0002\rA\u001a\u0005\u0007U\n5\u0004\u0019\u00014\t\rq\u0014i\u00071\u0001t\u0011\u001d\u0011\t\t\u0001C\u0005\u0005\u0007\u000b!\u0003\u001d:pG\u0016\u001c8oU3og&$\u0018N^5usR1\u0011\u0011\u0001BC\u0005\u000fCa!\u001aB@\u0001\u00041\u0007B\u00026\u0003\u0000\u0001\u0007a\rC\u0004\u0003\f\u0002!IA!$\u0002\u001f\u001d,G/\u0012=bGR\u001c6-\u001b(b[\u0016$2A\u0013BH\u0011\u0019)'\u0011\u0012a\u0001M\"1!1\u0013\u0001\u0005\u0002)\nqaZ3u\u001d\u0006lW\rC\u0005\u0003\u0018\u0002\t\n\u0011\"\u0011\u0003\u001a\u0006\t\u0002O]8dKN\u001cH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\tm%fA7\u0003\u001e.\u0012!q\u0014\t\u0005\u0005C\u0013Y+\u0004\u0002\u0003$*!!Q\u0015BT\u0003%)hn\u00195fG.,GMC\u0002\u0003*B\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011iKa)\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class LocationProcessor
implements Processor {
    private final Logger logger;
    private final String WGS84_EPSG_Code;
    private final SensitiveDataService sds;
    private scala.collection.immutable.Map<String, String> crsEpsgCodesMap;
    private scala.collection.immutable.Map<String, String> zoneEpsgCodesMap;
    private volatile byte bitmap$0;

    private scala.collection.immutable.Map crsEpsgCodesMap$lzycompute() {
        LocationProcessor locationProcessor = this;
        synchronized (locationProcessor) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                ObjectRef valuesMap = new ObjectRef((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
                Source$.MODULE$.fromURL(this.getClass().getResource("/crsEpsgCodes.txt"), "utf-8").getLines().toList().foreach((Function1)new Serializable(this, valuesMap){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef valuesMap$1;

                    public final void apply(String line) {
                        String[] values = new StringOps(Predef$.MODULE$.augmentString(line)).split('=');
                        this.valuesMap$1.elem = ((scala.collection.immutable.Map)this.valuesMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)values[0]), (Object)values[1]));
                    }
                    {
                        this.valuesMap$1 = valuesMap$1;
                    }
                });
                this.crsEpsgCodesMap = (scala.collection.immutable.Map)valuesMap.elem;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.crsEpsgCodesMap;
        }
    }

    private scala.collection.immutable.Map zoneEpsgCodesMap$lzycompute() {
        LocationProcessor locationProcessor = this;
        synchronized (locationProcessor) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                ObjectRef valuesMap = new ObjectRef((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
                Source$.MODULE$.fromURL(this.getClass().getResource("/zoneEpsgCodes.txt"), "utf-8").getLines().toList().foreach((Function1)new Serializable(this, valuesMap){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef valuesMap$2;

                    public final void apply(String line) {
                        String[] values = new StringOps(Predef$.MODULE$.augmentString(line)).split('=');
                        this.valuesMap$2.elem = ((scala.collection.immutable.Map)this.valuesMap$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)values[0]), (Object)values[1]));
                    }
                    {
                        this.valuesMap$2 = valuesMap$2;
                    }
                });
                this.zoneEpsgCodesMap = (scala.collection.immutable.Map)valuesMap.elem;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.zoneEpsgCodesMap;
        }
    }

    public Logger logger() {
        return this.logger;
    }

    public String WGS84_EPSG_Code() {
        return this.WGS84_EPSG_Code;
    }

    public SensitiveDataService sds() {
        return this.sds;
    }

    public scala.collection.immutable.Map<String, String> crsEpsgCodesMap() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.crsEpsgCodesMap$lzycompute() : this.crsEpsgCodesMap;
    }

    public scala.collection.immutable.Map<String, String> zoneEpsgCodesMap() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.zoneEpsgCodesMap$lzycompute() : this.zoneEpsgCodesMap;
    }

    @Override
    public QualityAssertion[] process(String guid, FullRecord raw, FullRecord processed, Option<FullRecord> lastProcessed) {
        Tuple3 tuple3;
        block7: {
            ArrayBuffer assertions;
            block6: {
                Tuple3 tuple32;
                Option<Tuple3<Location, scala.collection.immutable.Map<String, String>, scala.collection.immutable.Map<String, String>>> point;
                this.logger().debug(new StringBuilder().append((Object)"Processing location for guid: ").append((Object)guid).toString());
                assertions = new ArrayBuffer();
                this.setProcessedCoordinates(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
                this.processAltitudeAndDepth(guid, raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
                if (processed.location().decimalLatitude() != null && processed.location().decimalLongitude() != null) {
                    this.validateCoordinatesValues(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
                    this.checkCoordinateUncertainty(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
                }
                if (Config$.MODULE$.sdsEnabled()) {
                    this.processSensitivity(raw, processed);
                }
                if (processed.location().decimalLatitude() != null && processed.location().decimalLongitude() != null) {
                    scala.collection.immutable.Map<String, String> intersectValues = SensitiveAreaDAO$.MODULE$.intersect(processed.location().decimalLongitude(), processed.location().decimalLatitude());
                    processed.location().stateProvince_$eq((String)intersectValues.getOrElse((Object)Config$.MODULE$.stateProvinceLayerID(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }));
                    processed.location().lga_$eq((String)intersectValues.getOrElse((Object)Config$.MODULE$.localGovLayerID(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }));
                    processed.location().country_$eq((String)intersectValues.getOrElse((Object)Config$.MODULE$.countriesLayerID(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }));
                    processed.location().habitat_$eq((String)(intersectValues.getOrElse((Object)Config$.MODULE$.terrestrialLayerID(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }) == null ? (intersectValues.getOrElse((Object)Config$.MODULE$.marineLayerID(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }) == null ? null : "Marine") : "Terrestrial"));
                    this.checkForStateMismatch(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
                    this.addConservationStatus(raw, processed);
                    this.checkForHabitatMismatch(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
                }
                if ((point = LocationDAO$.MODULE$.getByLatLon(processed.location().decimalLatitude(), processed.location().decimalLongitude())).isEmpty()) break block6;
                tuple3 = (Tuple3)point.get();
                if (tuple3 == null) break block7;
                Location location = (Location)tuple3._1();
                scala.collection.immutable.Map environmentalLayers = (scala.collection.immutable.Map)tuple3._2();
                scala.collection.immutable.Map contextualLayers = (scala.collection.immutable.Map)tuple3._3();
                Tuple3 tuple33 = tuple32 = new Tuple3((Object)location, (Object)environmentalLayers, (Object)contextualLayers);
                Location location2 = (Location)tuple33._1();
                scala.collection.immutable.Map environmentalLayers2 = (scala.collection.immutable.Map)tuple33._2();
                scala.collection.immutable.Map contextualLayers2 = (scala.collection.immutable.Map)tuple33._3();
                processed.locationDetermined_$eq(true);
                processed.el_$eq(JavaConversions$.MODULE$.mapAsJavaMap((Map)environmentalLayers2));
                processed.cl_$eq(JavaConversions$.MODULE$.mapAsJavaMap((Map)contextualLayers2));
            }
            this.checkLocationSupplied(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
            this.validateCoordinates(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
            this.processStateCountryValues(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
            this.validateGeoreferenceValues(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
            return (QualityAssertion[])assertions.toArray(ClassTag$.MODULE$.apply(QualityAssertion.class));
        }
        throw new MatchError((Object)tuple3);
    }

    @Override
    public Option<FullRecord> process$default$4() {
        return None$.MODULE$;
    }

    public ArrayBuffer<QualityAssertion> checkLocationSupplied(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        return processed.location().decimalLatitude() == null || processed.location().decimalLongitude() == null ? (raw.location().footprintWKT() == null && raw.location().locality() == null && raw.location().locationID() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.LOCATION_NOT_SUPPLIED())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.LOCATION_NOT_SUPPLIED(), AssertionStatus$.MODULE$.PASSED()))) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.LOCATION_NOT_SUPPLIED(), AssertionStatus$.MODULE$.PASSED()));
    }

    private void processStateCountryValues(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        Option<Term> countryCodeTerm;
        Option<Term> countryTerm;
        Option<Term> stateTerm;
        if (processed.location().stateProvince() == null && raw.location().decimalLatitude() == null && raw.location().decimalLongitude() == null && !(stateTerm = StateProvinces$.MODULE$.matchTerm(raw.location().stateProvince())).isEmpty()) {
            processed.location().stateProvince_$eq(((Term)stateTerm.get()).canonical());
            if (Config$.MODULE$.sdsEnabled()) {
                this.processSensitivity(raw, processed);
            }
            processed.location().country_$eq((String)StateProvinceToCountry$.MODULE$.map().getOrElse((Object)processed.location().stateProvince(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            }));
        }
        if (processed.location().country() == null && raw.location().decimalLatitude() == null && raw.location().decimalLongitude() == null && !(countryTerm = Countries$.MODULE$.matchTerm(raw.location().country())).isEmpty()) {
            processed.location().country_$eq(((Term)countryTerm.get()).canonical());
        }
        if (processed.location().country() == null && raw.location().countryCode() != null && !(countryCodeTerm = Countries$.MODULE$.matchTerm(raw.location().countryCode())).isEmpty()) {
            processed.location().country_$eq(((Term)countryCodeTerm.get()).canonical());
        }
    }

    public Option<Object> getCoordinateUncertaintyFromGridRef(int noOfNumericalDigits, int noOfSecondaryAlphaChars) {
        Some some;
        int n;
        int n2 = noOfNumericalDigits;
        switch (n2) {
            default: {
                return None$.MODULE$;
            }
            case 0: {
                n = 100000;
                break;
            }
            case 2: {
                n = 10000;
                break;
            }
            case 4: {
                n = 1000;
                break;
            }
            case 6: {
                n = 100;
                break;
            }
            case 8: {
                n = 10;
            }
        }
        int accuracy = n;
        int n3 = noOfSecondaryAlphaChars;
        switch (n3) {
            default: {
                some = new Some((Object)BoxesRunTime.boxToInteger((int)accuracy));
                break;
            }
            case 1: {
                some = new Some((Object)BoxesRunTime.boxToInteger((int)(accuracy / 5)));
                break;
            }
            case 2: {
                some = new Some((Object)BoxesRunTime.boxToInteger((int)(accuracy / 2)));
            }
        }
        return some;
    }

    public Option<Tuple3<Object, Object, Option<Object>>> osGridReferenceToEastingNorthing(String gridRef) {
        block10: {
            Tuple6 tuple6;
            block11: {
                block19: {
                    int n;
                    int e;
                    Option coordinateUncertainty;
                    block13: {
                        int cellSize;
                        String twoKRef;
                        block18: {
                            String easting;
                            block12: {
                                block17: {
                                    String string;
                                    int cellSize2;
                                    block16: {
                                        block15: {
                                            block14: {
                                                Tuple6 tuple62;
                                                Tuple6 tuple63;
                                                block7: {
                                                    String string2;
                                                    Regex gridRefWithQuadRegex;
                                                    block9: {
                                                        Regex gridRef2kRegex;
                                                        block8: {
                                                            Regex gridRefRegex;
                                                            block6: {
                                                                Regex gridRefRegex1Number = new StringOps(Predef$.MODULE$.augmentString("([A-Z]{2})\\s*([0-9]+)$")).r();
                                                                gridRef2kRegex = new StringOps(Predef$.MODULE$.augmentString("([A-Z]{2})\\s*([0-9]+)\\s*([0-9]+)\\s*([A-Z]{1})")).r();
                                                                gridRefRegex = new StringOps(Predef$.MODULE$.augmentString("([A-Z]{2})\\s*([0-9]+)\\s*([0-9]+)$")).r();
                                                                gridRefWithQuadRegex = new StringOps(Predef$.MODULE$.augmentString("([A-Z]{2})\\s*([0-9]+)\\s*([0-9]+)\\s*([NW|NE|SW|SE]{2})$")).r();
                                                                string2 = gridRef.trim();
                                                                Option option = gridRefRegex1Number.unapplySeq((Object)string2);
                                                                if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(2) != 0) break block6;
                                                                String gridletters = (String)((LinearSeqOptimized)option.get()).apply(0);
                                                                String oneNumber = (String)((LinearSeqOptimized)option.get()).apply(1);
                                                                String gridDigits = oneNumber.toString();
                                                                String[] en = (String[])((Object[])new String[]{gridDigits.substring(0, gridDigits.length() / 2), gridDigits.substring(gridDigits.length() / 2)});
                                                                Option<Object> coordUncertainty = this.getCoordinateUncertaintyFromGridRef(gridDigits.length(), 0);
                                                                tuple63 = new Tuple6((Object)gridletters, (Object)en[0], (Object)en[1], (Object)"", (Object)"", coordUncertainty);
                                                                break block7;
                                                            }
                                                            Option option = gridRefRegex.unapplySeq((Object)string2);
                                                            if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(3) != 0) break block8;
                                                            String gridletters = (String)((LinearSeqOptimized)option.get()).apply(0);
                                                            String easting2 = (String)((LinearSeqOptimized)option.get()).apply(1);
                                                            String northing = (String)((LinearSeqOptimized)option.get()).apply(2);
                                                            tuple63 = new Tuple6((Object)gridletters, (Object)easting2, (Object)northing, (Object)"", (Object)"", this.getCoordinateUncertaintyFromGridRef(easting2.length() * 2, 0));
                                                            break block7;
                                                        }
                                                        Option option = gridRef2kRegex.unapplySeq((Object)string2);
                                                        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(4) != 0) break block9;
                                                        String gridletters = (String)((LinearSeqOptimized)option.get()).apply(0);
                                                        String easting3 = (String)((LinearSeqOptimized)option.get()).apply(1);
                                                        String northing = (String)((LinearSeqOptimized)option.get()).apply(2);
                                                        String twoKRef2 = (String)((LinearSeqOptimized)option.get()).apply(3);
                                                        tuple63 = new Tuple6((Object)gridletters, (Object)easting3, (Object)northing, (Object)twoKRef2, (Object)"", this.getCoordinateUncertaintyFromGridRef(easting3.length() * 2, 1));
                                                        break block7;
                                                    }
                                                    Option option = gridRefWithQuadRegex.unapplySeq((Object)string2);
                                                    if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(4) != 0) break block10;
                                                    String gridletters = (String)((LinearSeqOptimized)option.get()).apply(0);
                                                    String easting4 = (String)((LinearSeqOptimized)option.get()).apply(1);
                                                    String northing = (String)((LinearSeqOptimized)option.get()).apply(2);
                                                    String quadRef = (String)((LinearSeqOptimized)option.get()).apply(3);
                                                    tuple63 = new Tuple6((Object)gridletters, (Object)easting4, (Object)northing, (Object)"", (Object)quadRef, this.getCoordinateUncertaintyFromGridRef(easting4.length() * 2, 2));
                                                }
                                                tuple6 = tuple63;
                                                if (tuple6 == null) break block11;
                                                String gridletters = (String)tuple6._1();
                                                String easting5 = (String)tuple6._2();
                                                String northing = (String)tuple6._3();
                                                String twoKRef3 = (String)tuple6._4();
                                                String quadRef = (String)tuple6._5();
                                                Option coordinateUncertainty2 = (Option)tuple6._6();
                                                if (gridletters == null) break block11;
                                                String string3 = gridletters;
                                                if (easting5 == null) break block11;
                                                String string4 = easting5;
                                                if (northing == null) break block11;
                                                String string5 = northing;
                                                if (twoKRef3 == null) break block11;
                                                String string6 = twoKRef3;
                                                if (quadRef == null) break block11;
                                                String string7 = quadRef;
                                                if (coordinateUncertainty2 == null) break block11;
                                                Option option = coordinateUncertainty2;
                                                Tuple6 tuple64 = tuple62 = new Tuple6((Object)string3, (Object)string4, (Object)string5, (Object)string6, (Object)string7, (Object)option);
                                                String gridletters2 = (String)tuple64._1();
                                                easting = (String)tuple64._2();
                                                String northing2 = (String)tuple64._3();
                                                twoKRef = (String)tuple64._4();
                                                String quadRef2 = (String)tuple64._5();
                                                coordinateUncertainty = (Option)tuple64._6();
                                                int value = Character.codePointAt(gridletters2, 0) - Character.codePointAt("A", 0);
                                                int l1 = value > 7 ? value - 1 : value;
                                                int value2 = Character.codePointAt(gridletters2, 1) - Character.codePointAt("A", 0);
                                                int l2 = value2 > 7 ? value2 - 1 : value2;
                                                int e100km = (l1 - 2) % 5 * 5 + l2 % 5;
                                                int n100km = (int)((double)19 - Math.floor(l1 / 5) * (double)5 - Math.floor(l2 / 5));
                                                if (e100km < 0 || e100km > 6 || n100km < 0 || n100km > 12) {
                                                    return None$.MODULE$;
                                                }
                                                if (easting == null || northing2 == null) {
                                                    return None$.MODULE$;
                                                }
                                                if (easting.length() != northing2.length()) {
                                                    return None$.MODULE$;
                                                }
                                                String easting10digit = new StringBuilder().append((Object)easting).append((Object)"00000").toString().substring(0, 5);
                                                String northing10digit = new StringBuilder().append((Object)northing2).append((Object)"00000").toString().substring(0, 5);
                                                e = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder().append((Object)((Object)BoxesRunTime.boxToInteger((int)e100km)).toString()).append((Object)easting10digit).toString())).toInt();
                                                n = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder().append((Object)((Object)BoxesRunTime.boxToInteger((int)n100km)).toString()).append((Object)northing10digit).toString())).toInt();
                                                String string8 = twoKRef;
                                                String string9 = "";
                                                if (string8 != null ? !string8.equals(string9) : string9 != null) break block12;
                                                String string10 = quadRef2;
                                                String string11 = "";
                                                if (!(string10 == null ? string11 != null : !string10.equals(string11))) break block13;
                                                int n2 = easting.length() == 1 ? 5000 : (easting.length() == 2 ? 500 : (easting.length() == 3 ? 50 : (cellSize2 = easting.length() == 4 ? 5 : 0)));
                                                if (cellSize2 <= 0) break block13;
                                                String string12 = string = twoKRef;
                                                if ("NW" != null ? !"NW".equals(string12) : string12 != null) break block14;
                                                e += cellSize2 / 2;
                                                n += cellSize2 + cellSize2 / 2;
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                break block13;
                                            }
                                            String string13 = string;
                                            if ("NE" != null ? !"NE".equals(string13) : string13 != null) break block15;
                                            e += cellSize2 + cellSize2 / 2;
                                            n += cellSize2 + cellSize2 / 2;
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block13;
                                        }
                                        String string14 = string;
                                        if ("SW" != null ? !"SW".equals(string14) : string14 != null) break block16;
                                        e += cellSize2 / 2;
                                        n += cellSize2 / 2;
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block13;
                                    }
                                    String string15 = string;
                                    if ("SE" != null ? !"SE".equals(string15) : string15 != null) break block17;
                                    e += cellSize2 + cellSize2 / 2;
                                    n += cellSize2 / 2;
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block13;
                                }
                                return None$.MODULE$;
                            }
                            cellSize = easting.length() == 1 ? 2000 : (easting.length() == 2 ? 200 : (easting.length() == 3 ? 20 : (easting.length() == 4 ? 2 : 0)));
                            String string = twoKRef;
                            if (Character.codePointAt(twoKRef, 0) > 78) break block18;
                            e = e + (Character.codePointAt(twoKRef, 0) - 65) / 5 * cellSize + cellSize / 2;
                            n = n + (Character.codePointAt(twoKRef, 0) - 65) % 5 * cellSize + cellSize / 2;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block13;
                        }
                        if (Character.codePointAt(twoKRef, 0) < 80) break block19;
                        e = e + (Character.codePointAt(twoKRef, 0) - 66) / 5 * cellSize + cellSize / 2;
                        n = n + (Character.codePointAt(twoKRef, 0) - 66) % 5 * cellSize + cellSize / 2;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return new Some((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)e), (Object)BoxesRunTime.boxToInteger((int)n), (Object)coordinateUncertainty));
                }
                return None$.MODULE$;
            }
            throw new MatchError((Object)tuple6);
        }
        return None$.MODULE$;
    }

    private void validateCoordinates(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        ArrayBuffer arrayBuffer = raw.location().country() == null && processed.location().country() != null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COUNTRY_INFERRED_FROM_COORDINATES(), AssertionStatus$.MODULE$.FAILED())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COUNTRY_INFERRED_FROM_COORDINATES(), AssertionStatus$.MODULE$.PASSED()));
        ArrayBuffer arrayBuffer2 = StateProvinceCentrePoints$.MODULE$.coordinatesMatchCentre(processed.location().stateProvince(), raw.location().decimalLatitude(), raw.location().decimalLongitude()) ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_CENTRE_OF_STATEPROVINCE(), new StringBuilder().append((Object)"Coordinates are centre point of ").append((Object)processed.location().stateProvince()).toString())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_CENTRE_OF_STATEPROVINCE(), AssertionStatus$.MODULE$.PASSED()));
        if (CountryCentrePoints$.MODULE$.coordinatesMatchCentre(processed.location().country(), raw.location().decimalLatitude(), raw.location().decimalLongitude())) {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_CENTRE_OF_COUNTRY(), new StringBuilder().append((Object)"Coordinates are centre point of ").append((Object)processed.location().country()).toString()));
        } else {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_CENTRE_OF_COUNTRY(), AssertionStatus$.MODULE$.PASSED()));
        }
    }

    private void processAltitudeAndDepth(String guid, FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        this.processVerbatimDepth(raw, processed, assertions);
        this.processVerbatimElevation(raw, processed, assertions);
        this.processMinMaxDepth(raw, processed, assertions);
    }

    private void processMinMaxDepth(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        BoxedUnit boxedUnit;
        if (raw.location().minimumDepthInMeters() == null || raw.location().maximumDepthInMeters() == null) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            try {
                float min = new StringOps(Predef$.MODULE$.augmentString(raw.location().minimumDepthInMeters())).toFloat();
                float max = new StringOps(Predef$.MODULE$.augmentString(raw.location().maximumDepthInMeters())).toFloat();
                if (min > max) {
                    processed.location().minimumDepthInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)max)).toString());
                    processed.location().maximumDepthInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)min)).toString());
                    boxedUnit = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MIN_MAX_DEPTH_REVERSED(), new StringBuilder().append((Object)"The minimum, ").append((Object)BoxesRunTime.boxToFloat((float)min)).append((Object)", and maximum, ").append((Object)BoxesRunTime.boxToFloat((float)max)).append((Object)", depths have been transposed.").toString()));
                } else {
                    processed.location().minimumDepthInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)min)).toString());
                    processed.location().maximumDepthInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)max)).toString());
                    boxedUnit = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MIN_MAX_DEPTH_REVERSED(), AssertionStatus$.MODULE$.PASSED()));
                }
            }
            catch (Exception exception) {
                this.logger().debug(new StringBuilder().append((Object)"Exception thrown processing minimumDepthInMeters:").append((Object)exception.getMessage()).toString());
                boxedUnit = BoxedUnit.UNIT;
            }
        }
        if (raw.location().minimumElevationInMeters() != null && raw.location().maximumElevationInMeters() != null) {
            try {
                float min = new StringOps(Predef$.MODULE$.augmentString(raw.location().minimumElevationInMeters())).toFloat();
                float max = new StringOps(Predef$.MODULE$.augmentString(raw.location().maximumElevationInMeters())).toFloat();
                if (min > max) {
                    processed.location().minimumElevationInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)max)).toString());
                    processed.location().maximumElevationInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)min)).toString());
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MIN_MAX_ALTITUDE_REVERSED(), new StringBuilder().append((Object)"The minimum, ").append((Object)BoxesRunTime.boxToFloat((float)min)).append((Object)", and maximum, ").append((Object)BoxesRunTime.boxToFloat((float)max)).append((Object)", elevations have been transposed.").toString()));
                } else {
                    processed.location().minimumElevationInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)min)).toString());
                    processed.location().maximumElevationInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)max)).toString());
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MIN_MAX_ALTITUDE_REVERSED(), AssertionStatus$.MODULE$.PASSED()));
                }
            }
            catch (Exception exception) {
                this.logger().debug(new StringBuilder().append((Object)"Exception thrown processing elevation:").append((Object)exception.getMessage()).toString());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processVerbatimElevation(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        if (raw.location().verbatimElevation() == null) return;
        Option<Tuple2<Object, MeasurementUnit>> parseElevationResult = DistanceRangeParser$.MODULE$.parse(raw.location().verbatimElevation());
        if (parseElevationResult.isDefined()) {
            Tuple2 tuple2;
            Tuple2 tuple22 = (Tuple2)parseElevationResult.get();
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            float velevation = BoxesRunTime.unboxToFloat((Object)tuple22._1());
            MeasurementUnit sourceUnit = (MeasurementUnit)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)velevation), (Object)sourceUnit);
            float velevation2 = BoxesRunTime.unboxToFloat((Object)tuple23._1());
            MeasurementUnit sourceUnit2 = (MeasurementUnit)tuple23._2();
            processed.location().verbatimElevation_$eq(((Object)BoxesRunTime.boxToFloat((float)velevation2)).toString());
            ArrayBuffer arrayBuffer = velevation2 > (float)10000 || velevation2 < (float)-100 ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ALTITUDE_OUT_OF_RANGE(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Elevation ", " is greater than 10,000 metres or less than -100 metres."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)velevation2)})))) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ALTITUDE_OUT_OF_RANGE(), AssertionStatus$.MODULE$.PASSED()));
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ALTITUDE_NON_NUMERIC(), AssertionStatus$.MODULE$.PASSED()));
            MeasurementUnit measurementUnit = sourceUnit2;
            Feet$ feet$ = Feet$.MODULE$;
            if (!(measurementUnit != null ? !measurementUnit.equals(feet$) : feet$ != null)) {
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ALTITUDE_IN_FEET(), "The supplied altitude was in feet it has been converted to metres"));
                return;
            } else {
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ALTITUDE_IN_FEET(), AssertionStatus$.MODULE$.PASSED()));
            }
            return;
        } else {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ALTITUDE_NON_NUMERIC(), new StringBuilder().append((Object)"Can't parse verbatimElevation ").append((Object)raw.location().verbatimElevation()).toString()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processVerbatimDepth(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        if (raw.location().verbatimDepth() == null) return;
        Option<Tuple2<Object, MeasurementUnit>> parseDepthResult = DistanceRangeParser$.MODULE$.parse(raw.location().verbatimDepth());
        if (parseDepthResult.isDefined()) {
            Tuple2 tuple2;
            Tuple2 tuple22 = (Tuple2)parseDepthResult.get();
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            float vdepth = BoxesRunTime.unboxToFloat((Object)tuple22._1());
            MeasurementUnit sourceUnit = (MeasurementUnit)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)vdepth), (Object)sourceUnit);
            float vdepth2 = BoxesRunTime.unboxToFloat((Object)tuple23._1());
            MeasurementUnit sourceUnit2 = (MeasurementUnit)tuple23._2();
            processed.location().verbatimDepth_$eq(((Object)BoxesRunTime.boxToFloat((float)vdepth2)).toString());
            ArrayBuffer arrayBuffer = vdepth2 > (float)10000 ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DEPTH_OUT_OF_RANGE(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Depth ", " is greater than 10,000 metres"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)vdepth2)})))) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DEPTH_OUT_OF_RANGE(), AssertionStatus$.MODULE$.PASSED()));
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DEPTH_NON_NUMERIC(), AssertionStatus$.MODULE$.PASSED()));
            MeasurementUnit measurementUnit = sourceUnit2;
            Feet$ feet$ = Feet$.MODULE$;
            if (!(measurementUnit != null ? !measurementUnit.equals(feet$) : feet$ != null)) {
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DEPTH_IN_FEET(), "The supplied depth was in feet it has been converted to metres"));
                return;
            } else {
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DEPTH_IN_FEET(), AssertionStatus$.MODULE$.PASSED()));
            }
            return;
        } else {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DEPTH_NON_NUMERIC(), new StringBuilder().append((Object)"Can't parse verbatimDepth ").append((Object)raw.location().verbatimDepth()).toString()));
        }
    }

    private void setProcessedCoordinates(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        if (raw.location().originalDecimalLatitude() == null || raw.location().originalDecimalLongitude() == null) {
            Option<GISPoint> gisPointOption = this.processLatLong(raw.location().decimalLatitude(), raw.location().decimalLongitude(), raw.location().geodeticDatum(), raw.location().verbatimLatitude(), raw.location().verbatimLongitude(), raw.location().verbatimSRS(), raw.location().easting(), raw.location().northing(), raw.location().zone(), raw.location().gridReference(), assertions);
            if (!gisPointOption.isEmpty()) {
                processed.location().decimalLatitude_$eq(((GISPoint)gisPointOption.get()).latitude());
                processed.location().decimalLongitude_$eq(((GISPoint)gisPointOption.get()).longitude());
                processed.location().geodeticDatum_$eq(((GISPoint)gisPointOption.get()).datum());
                processed.location().coordinateUncertaintyInMeters_$eq(((GISPoint)gisPointOption.get()).coordinateUncertaintyInMeters());
            }
        } else {
            processed.location().decimalLatitude_$eq(raw.location().originalDecimalLatitude());
            processed.location().decimalLongitude_$eq(raw.location().originalDecimalLongitude());
            processed.location().verbatimLatitude_$eq(raw.location().originalVerbatimLatitude());
            processed.location().verbatimLongitude_$eq(raw.location().originalVerbatimLongitude());
            raw.location().decimalLatitude_$eq(raw.location().originalDecimalLatitude());
            raw.location().decimalLongitude_$eq(raw.location().originalDecimalLongitude());
        }
    }

    public Option<GISPoint> processLatLong(String rawLatitude, String rawLongitude, String rawGeodeticDatum, String verbatimLatitude, String verbatimLongitude, String verbatimSRS, String easting, String northing, String zone, String gridReference, ArrayBuffer<QualityAssertion> assertions) {
        Option<GISPoint> option;
        if (rawLatitude == null || rawLongitude == null || StringHelper$.MODULE$.string2helper(rawLatitude).toFloatWithOption().isEmpty() || StringHelper$.MODULE$.string2helper(rawLongitude).toFloatWithOption().isEmpty()) {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_COORDINATES_NOT_SUPPLIED()));
            if (verbatimLatitude == null || verbatimLongitude == null) {
                option = easting == null || northing == null || zone == null ? (gridReference == null ? None$.MODULE$ : this.processGridReference(gridReference, assertions)) : this.processNorthingEastingZone(verbatimSRS, easting, northing, zone, assertions);
            } else {
                Option<Object> decimalVerbatimLat = StringHelper$.MODULE$.string2helper(verbatimLatitude).toFloatWithOption();
                Option<Object> decimalVerbatimLong = StringHelper$.MODULE$.string2helper(verbatimLongitude).toFloatWithOption();
                if (decimalVerbatimLat.isEmpty() || decimalVerbatimLong.isEmpty()) {
                    decimalVerbatimLat = VerbatimLatLongParser$.MODULE$.parse(verbatimLatitude);
                    decimalVerbatimLong = VerbatimLatLongParser$.MODULE$.parse(verbatimLongitude);
                }
                option = decimalVerbatimLat.isEmpty() || decimalVerbatimLong.isEmpty() ? None$.MODULE$ : this.processVerbatimCoordinates(verbatimSRS, assertions, decimalVerbatimLat, decimalVerbatimLong);
            }
        } else {
            option = this.processDecimalCoordinates(rawLatitude, rawLongitude, rawGeodeticDatum, assertions);
        }
        return option;
    }

    public Option<GISPoint> processGridReference(String gridReference, ArrayBuffer<QualityAssertion> assertions) {
        Option<Tuple3<Object, Object, Option<Object>>> option;
        block8: {
            None$ none$;
            block7: {
                block3: {
                    Tuple2 tuple2;
                    block6: {
                        None$ none$2;
                        block5: {
                            Tuple2 tuple22;
                            Option<Tuple2<String, String>> coords;
                            Option coordUncertaintyOption;
                            block4: {
                                Some some;
                                Tuple3 tuple3;
                                option = this.osGridReferenceToEastingNorthing(gridReference);
                                if (!(option instanceof Some) || (tuple3 = (Tuple3)(some = (Some)option).x()) == null) break block3;
                                int easting = BoxesRunTime.unboxToInt((Object)tuple3._1());
                                int northing = BoxesRunTime.unboxToInt((Object)tuple3._2());
                                coordUncertaintyOption = (Option)tuple3._3();
                                coords = this.reprojectCoordinatesToWGS84(easting, northing, Config$.MODULE$.defaultSourceCrs(), 5);
                                if (!coords.isEmpty()) break block4;
                                none$2 = None$.MODULE$;
                                break block5;
                            }
                            tuple2 = (Tuple2)coords.get();
                            if (tuple2 == null) break block6;
                            String latitude = (String)tuple2._1();
                            String longitude = (String)tuple2._2();
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)latitude, (Object)longitude);
                            String latitude2 = (String)tuple23._1();
                            String longitude2 = (String)tuple23._2();
                            JavaConversions$.MODULE$.bufferAsJavaList(assertions).add(QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATED_FROM_GRID_REF()));
                            String uncertaintyToUse = coordUncertaintyOption.isEmpty() ? null : coordUncertaintyOption.get().toString();
                            none$2 = new Some((Object)new GISPoint(latitude2, longitude2, this.WGS84_EPSG_Code(), uncertaintyToUse));
                        }
                        none$ = none$2;
                        break block7;
                    }
                    throw new MatchError((Object)tuple2);
                }
                None$ none$3 = None$.MODULE$;
                Option<Tuple3<Object, Object, Option<Object>>> option2 = option;
                if (none$3 != null ? !none$3.equals(option2) : option2 != null) break block8;
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError(option);
    }

    private Option<GISPoint> processDecimalCoordinates(String rawLatitude, String rawLongitude, String rawGeodeticDatum, ArrayBuffer<QualityAssertion> assertions) {
        Tuple2 tuple2;
        block7: {
            Some some;
            block3: {
                Tuple2 tuple22;
                Option<Tuple2<String, String>> reprojectedCoords;
                block6: {
                    Option<String> sourceEpsgCode;
                    block5: {
                        block4: {
                            block2: {
                                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_COORDINATES_NOT_SUPPLIED(), AssertionStatus$.MODULE$.PASSED()));
                                if (rawGeodeticDatum != null) break block2;
                                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.GEODETIC_DATUM_ASSUMED_WGS84(), "Geodetic datum assumed to be WGS84 (EPSG:4326)"));
                                some = new Some((Object)new GISPoint(rawLatitude, rawLongitude, this.WGS84_EPSG_Code(), null));
                                break block3;
                            }
                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.GEODETIC_DATUM_ASSUMED_WGS84(), AssertionStatus$.MODULE$.PASSED()));
                            sourceEpsgCode = this.lookupEpsgCode(rawGeodeticDatum);
                            if (!sourceEpsgCode.isEmpty()) break block4;
                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNRECOGNIZED_GEODETIC_DATUM(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Geodetic datum ", " not recognized."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rawGeodeticDatum}))));
                            some = new Some((Object)new GISPoint(rawLatitude, rawLongitude, rawGeodeticDatum, null));
                            break block3;
                        }
                        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNRECOGNIZED_GEODETIC_DATUM(), AssertionStatus$.MODULE$.PASSED()));
                        Object object = sourceEpsgCode.get();
                        String string = this.WGS84_EPSG_Code();
                        if (object != null ? !object.equals(string) : string != null) break block5;
                        some = new Some((Object)new GISPoint(rawLatitude, rawLongitude, this.WGS84_EPSG_Code(), null));
                        break block3;
                    }
                    int desiredNoDecimalPlaces = package$.MODULE$.min(this.getNumberOfDecimalPlacesInDouble(rawLatitude), this.getNumberOfDecimalPlacesInDouble(rawLongitude));
                    reprojectedCoords = this.reprojectCoordinatesToWGS84(new StringOps(Predef$.MODULE$.augmentString(rawLatitude)).toDouble(), new StringOps(Predef$.MODULE$.augmentString(rawLongitude)).toDouble(), (String)sourceEpsgCode.get(), desiredNoDecimalPlaces);
                    if (!reprojectedCoords.isEmpty()) break block6;
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CONVERSION_FAILED(), "Transformation of decimal latiude and longitude to WGS84 failed"));
                    some = None$.MODULE$;
                    break block3;
                }
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CONVERSION_FAILED(), AssertionStatus$.MODULE$.PASSED()));
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CONVERTED(), "Decimal latitude and longitude were converted to WGS84 (EPSG:4326)"));
                tuple2 = (Tuple2)reprojectedCoords.get();
                if (tuple2 == null) break block7;
                String reprojectedLatitude = (String)tuple2._1();
                String reprojectedLongitude = (String)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)reprojectedLatitude, (Object)reprojectedLongitude);
                String reprojectedLatitude2 = (String)tuple23._1();
                String reprojectedLongitude2 = (String)tuple23._2();
                some = new Some((Object)new GISPoint(reprojectedLatitude2, reprojectedLongitude2, this.WGS84_EPSG_Code(), null));
            }
            return some;
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<GISPoint> processVerbatimCoordinates(String verbatimSRS, ArrayBuffer<QualityAssertion> assertions, Option<Object> decimalVerbatimLat, Option<Object> decimalVerbatimLong) {
        None$ none$;
        if (StringHelper$.MODULE$.string2helper(decimalVerbatimLat.get().toString()).isLatitude() && StringHelper$.MODULE$.string2helper(decimalVerbatimLong.get().toString()).isLongitude()) {
            if (verbatimSRS == null) {
                if (StringHelper$.MODULE$.string2helper(decimalVerbatimLat.get().toString()).isLatitude() && StringHelper$.MODULE$.string2helper(decimalVerbatimLong.get().toString()).isLongitude()) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_VERBATIM_FAILED(), AssertionStatus$.MODULE$.PASSED()));
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATED_FROM_VERBATIM(), "Decimal latitude and longitude were calculated using verbatimLatitude, verbatimLongitude and verbatimSRS"));
                    none$ = new Some((Object)new GISPoint(decimalVerbatimLat.get().toString(), decimalVerbatimLong.get().toString(), this.WGS84_EPSG_Code(), null));
                    return none$;
                } else {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_VERBATIM_FAILED(), "Could not parse verbatim latitude and longitude"));
                    none$ = None$.MODULE$;
                }
                return none$;
            } else {
                Option<String> sourceEpsgCode = this.lookupEpsgCode(verbatimSRS);
                if (sourceEpsgCode.isEmpty()) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_VERBATIM_FAILED(), new StringBuilder().append((Object)"Unrecognized verbatimSRS ").append((Object)verbatimSRS).toString()));
                    none$ = None$.MODULE$;
                    return none$;
                } else {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_VERBATIM_FAILED(), AssertionStatus$.MODULE$.PASSED()));
                    Object object = sourceEpsgCode.get();
                    String string = this.WGS84_EPSG_Code();
                    if (!(object != null ? !object.equals(string) : string != null)) {
                        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATED_FROM_VERBATIM(), "Decimal latitude and longitude were calculated using verbatimLatitude, verbatimLongitude and verbatimSRS"));
                        none$ = new Some((Object)new GISPoint(decimalVerbatimLat.get().toString(), decimalVerbatimLong.get().toString(), this.WGS84_EPSG_Code(), null));
                        return none$;
                    } else {
                        int desiredNoDecimalPlaces = package$.MODULE$.min(this.getNumberOfDecimalPlacesInDouble(decimalVerbatimLat.get().toString()), this.getNumberOfDecimalPlacesInDouble(decimalVerbatimLong.get().toString()));
                        Option<Tuple2<String, String>> reprojectedCoords = this.reprojectCoordinatesToWGS84(BoxesRunTime.unboxToFloat((Object)decimalVerbatimLat.get()), BoxesRunTime.unboxToFloat((Object)decimalVerbatimLong.get()), (String)sourceEpsgCode.get(), desiredNoDecimalPlaces);
                        if (reprojectedCoords.isEmpty()) {
                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_VERBATIM_FAILED(), "Transformation of verbatim latiude and longitude to WGS84 failed"));
                            none$ = None$.MODULE$;
                            return none$;
                        } else {
                            Tuple2 tuple2;
                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_VERBATIM_FAILED(), AssertionStatus$.MODULE$.PASSED()));
                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATED_FROM_VERBATIM(), "Decimal latitude and longitude were calculated using verbatimLatitude, verbatimLongitude and verbatimSRS"));
                            Tuple2 tuple22 = (Tuple2)reprojectedCoords.get();
                            if (tuple22 == null) throw new MatchError((Object)tuple22);
                            String reprojectedLatitude = (String)tuple22._1();
                            String reprojectedLongitude = (String)tuple22._2();
                            Tuple2 tuple23 = tuple2 = new Tuple2((Object)reprojectedLatitude, (Object)reprojectedLongitude);
                            String reprojectedLatitude2 = (String)tuple23._1();
                            String reprojectedLongitude2 = (String)tuple23._2();
                            none$ = new Some((Object)new GISPoint(reprojectedLatitude2, reprojectedLongitude2, this.WGS84_EPSG_Code(), null));
                        }
                    }
                }
            }
            return none$;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<GISPoint> processNorthingEastingZone(String verbatimSRS, String easting, String northing, String zone, ArrayBuffer<QualityAssertion> assertions) {
        None$ none$;
        String epsgCodeKey;
        String string = epsgCodeKey = verbatimSRS == null ? new StringBuilder().append((Object)"GDA94|").append((Object)zone).toString() : new StringBuilder().append((Object)verbatimSRS.toUpperCase()).append((Object)"|").append((Object)zone).toString();
        if (this.zoneEpsgCodesMap().contains((Object)epsgCodeKey)) {
            String crsEpsgCode = (String)this.zoneEpsgCodesMap().apply((Object)epsgCodeKey);
            Option<Object> eastingAsDouble = StringHelper$.MODULE$.string2helper(easting).toDoubleWithOption();
            Option<Object> northingAsDouble = StringHelper$.MODULE$.string2helper(northing).toDoubleWithOption();
            if (eastingAsDouble.isEmpty() || northingAsDouble.isEmpty()) {
                none$ = None$.MODULE$;
                return none$;
            } else {
                Option<Tuple2<String, String>> reprojectedCoords = this.reprojectCoordinatesToWGS84(BoxesRunTime.unboxToDouble((Object)eastingAsDouble.get()), BoxesRunTime.unboxToDouble((Object)northingAsDouble.get()), crsEpsgCode, 5);
                if (reprojectedCoords.isEmpty()) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_EASTING_NORTHING_FAILED(), "Transformation of verbatim easting and northing to WGS84 failed"));
                    none$ = None$.MODULE$;
                    return none$;
                } else {
                    Tuple2 tuple2;
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_EASTING_NORTHING_FAILED(), AssertionStatus$.MODULE$.PASSED()));
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATED_FROM_EASTING_NORTHING(), "Decimal latitude and longitude were calculated using easting, northing and zone."));
                    Tuple2 tuple22 = (Tuple2)reprojectedCoords.get();
                    if (tuple22 == null) throw new MatchError((Object)tuple22);
                    String reprojectedLatitude = (String)tuple22._1();
                    String reprojectedLongitude = (String)tuple22._2();
                    Tuple2 tuple23 = tuple2 = new Tuple2((Object)reprojectedLatitude, (Object)reprojectedLongitude);
                    String reprojectedLatitude2 = (String)tuple23._1();
                    String reprojectedLongitude2 = (String)tuple23._2();
                    none$ = new Some((Object)new GISPoint(reprojectedLatitude2, reprojectedLongitude2, this.WGS84_EPSG_Code(), null));
                }
            }
            return none$;
        } else {
            ArrayBuffer arrayBuffer = verbatimSRS == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_EASTING_NORTHING_FAILED(), new StringBuilder().append((Object)"Unrecognized zone GDA94 / MGA zone ").append((Object)zone).toString())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_EASTING_NORTHING_FAILED(), new StringBuilder().append((Object)"Unrecognized zone ").append((Object)verbatimSRS).append((Object)" / zone ").append((Object)zone).toString()));
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Option<Tuple2<String, String>> reprojectCoordinatesToWGS84(double coordinate1, double coordinate2, String sourceCrsEpsgCode, int decimalPlacesToRoundTo) {
        None$ none$;
        try {
            DefaultGeographicCRS wgs84CRS = DefaultGeographicCRS.WGS84;
            CoordinateReferenceSystem sourceCRS = CRS.decode((String)sourceCrsEpsgCode);
            CoordinateOperation transformOp = new DefaultCoordinateOperationFactory().createOperation(sourceCRS, (CoordinateReferenceSystem)wgs84CRS);
            GeneralDirectPosition directPosition = new GeneralDirectPosition(coordinate1, coordinate2);
            DirectPosition wgs84LatLong = transformOp.getMathTransform().transform((DirectPosition)directPosition, null);
            double longitude = wgs84LatLong.getOrdinate(0);
            double latitude = wgs84LatLong.getOrdinate(1);
            double roundedLongitude = Precision.round((double)longitude, (int)decimalPlacesToRoundTo);
            double roundedLatitude = Precision.round((double)latitude, (int)decimalPlacesToRoundTo);
            none$ = new Some((Object)new Tuple2((Object)((Object)BoxesRunTime.boxToDouble((double)roundedLatitude)).toString(), (Object)((Object)BoxesRunTime.boxToDouble((double)roundedLongitude)).toString()));
        }
        catch (Exception exception) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public int getNumberOfDecimalPlacesInDouble(String decimalAsString) {
        String[] tokens = new StringOps(Predef$.MODULE$.augmentString(decimalAsString)).split('.');
        return tokens.length == 2 ? tokens[1].length() : 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Option<String> lookupEpsgCode(String crs) {
        None$ none$;
        if (StringUtils.startsWithIgnoreCase((String)crs, (String)"EPSG:")) {
            try {
                CRS.decode((String)crs.toUpperCase());
                none$ = new Some((Object)crs.toUpperCase());
                return none$;
            }
            catch (Exception exception) {
                none$ = None$.MODULE$;
                return none$;
            }
        } else {
            if (this.crsEpsgCodesMap().contains((Object)crs.toUpperCase())) {
                none$ = new Some(this.crsEpsgCodesMap().apply((Object)crs.toUpperCase()));
                return none$;
            }
            none$ = None$.MODULE$;
            return none$;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkCoordinateUncertainty(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        ArrayBuffer arrayBuffer;
        BoxedUnit boxedUnit;
        boolean checkedPrecision = false;
        if (raw.location().coordinateUncertaintyInMeters() != null && raw.location().coordinateUncertaintyInMeters().length() > 0) {
            Option<Tuple2<Object, MeasurementUnit>> parsedResult = DistanceRangeParser$.MODULE$.parse(raw.location().coordinateUncertaintyInMeters());
            if (parsedResult.isEmpty()) {
                String comment = new StringBuilder().append((Object)"Supplied uncertainty, ").append((Object)raw.location().coordinateUncertaintyInMeters()).append((Object)", is not a supported format").toString();
                boxedUnit = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNCERTAINTY_RANGE_MISMATCH(), comment));
            } else {
                ArrayBuffer arrayBuffer2;
                Tuple2 tuple2;
                Tuple2 tuple22 = (Tuple2)parsedResult.get();
                if (tuple22 == null) throw new MatchError((Object)tuple22);
                float parsedValue = BoxesRunTime.unboxToFloat((Object)tuple22._1());
                MeasurementUnit rawUnit = (MeasurementUnit)tuple22._2();
                Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)parsedValue), (Object)rawUnit);
                float parsedValue2 = BoxesRunTime.unboxToFloat((Object)tuple23._1());
                MeasurementUnit rawUnit2 = (MeasurementUnit)tuple23._2();
                if (parsedValue2 > 0.0f) {
                    arrayBuffer2 = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNCERTAINTY_RANGE_MISMATCH(), AssertionStatus$.MODULE$.PASSED()));
                } else {
                    String comment = new StringBuilder().append((Object)"Supplied uncertainty, ").append((Object)raw.location().coordinateUncertaintyInMeters()).append((Object)", is not a supported format").toString();
                    arrayBuffer2 = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNCERTAINTY_RANGE_MISMATCH(), comment));
                }
                processed.location().coordinateUncertaintyInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)parsedValue2)).toString());
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            Option<Object> value;
            if (raw.location().coordinatePrecision() != null && !(value = StringHelper$.MODULE$.string2helper(raw.location().coordinatePrecision()).toFloatWithOption()).isEmpty() && BoxesRunTime.unboxToFloat((Object)value.get()) > 1.0f) {
                processed.location().coordinateUncertaintyInMeters_$eq(((Object)BoxesRunTime.boxToInteger((int)((int)BoxesRunTime.unboxToFloat((Object)value.get())))).toString());
                String comment = new StringBuilder().append((Object)"Supplied precision, ").append((Object)raw.location().coordinatePrecision()).append((Object)", is assumed to be uncertainty in metres").toString();
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNCERTAINTY_IN_PRECISION(), comment));
                checkedPrecision = true;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        if (raw.location().coordinatePrecision() == null) {
            arrayBuffer = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_COORDINATEPRECISION(), "Missing coordinatePrecision"));
        } else {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_COORDINATEPRECISION(), AssertionStatus$.MODULE$.PASSED()));
            if (checkedPrecision) {
                arrayBuffer = BoxedUnit.UNIT;
            } else {
                Option<Object> value = StringHelper$.MODULE$.string2helper(raw.location().coordinatePrecision()).toFloatWithOption();
                if (value.isDefined()) {
                    if (BoxesRunTime.unboxToFloat((Object)value.get()) > 0.0f && BoxesRunTime.unboxToFloat((Object)value.get()) <= 1.0f) {
                        int lonp;
                        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.PRECISION_RANGE_MISMATCH(), AssertionStatus$.MODULE$.PASSED()));
                        int pre = raw.location().coordinatePrecision().contains(".") ? raw.location().coordinatePrecision().split("\\.")[1].length() : 0;
                        String lat2 = processed.location().decimalLatitude();
                        String string = processed.location().decimalLongitude();
                        int latp = lat2.contains(".") ? lat2.split("\\.")[1].length() : 0;
                        int n = lonp = string.contains(".") ? string.split("\\.")[1].length() : 0;
                        arrayBuffer = pre == latp && pre == lonp ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATE_PRECISION_MISMATCH(), AssertionStatus$.MODULE$.PASSED())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATE_PRECISION_MISMATCH()));
                    } else {
                        arrayBuffer = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.PRECISION_RANGE_MISMATCH(), "Coordinate precision is not between 0 and 1"));
                    }
                } else {
                    arrayBuffer = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.PRECISION_RANGE_MISMATCH(), "Unable to parse the coordinate precision"));
                }
            }
        }
        if (processed.location().coordinateUncertaintyInMeters() == null) {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNCERTAINTY_NOT_SPECIFIED(), "Uncertainty was not supplied"));
            return;
        } else {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNCERTAINTY_NOT_SPECIFIED(), AssertionStatus$.MODULE$.PASSED()));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void checkForHabitatMismatch(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        block9: {
            block8: {
                if (processed.location().habitat() == null) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATE_HABITAT_MISMATCH(), 2));
                    return;
                }
                taxonProfileWithOption = TaxonProfileDAO$.MODULE$.getByGuid(processed.classification().taxonConceptID());
                genusProfileWithOption = TaxonProfileDAO$.MODULE$.getByGuid(processed.classification().genusID());
                if (taxonProfileWithOption.isEmpty()) break block8;
                if (((TaxonProfile)taxonProfileWithOption.get()).habitats() == null || Predef$.MODULE$.refArrayOps((Object[])((TaxonProfile)taxonProfileWithOption.get()).habitats()).isEmpty()) break block8;
                v0 = ((TaxonProfile)taxonProfileWithOption.get()).habitats();
                break block9;
            }
            if (genusProfileWithOption.isEmpty()) ** GOTO lbl-1000
            if (((TaxonProfile)genusProfileWithOption.get()).habitats() != null && !Predef$.MODULE$.refArrayOps((Object[])((TaxonProfile)genusProfileWithOption.get()).habitats()).isEmpty()) {
                v0 = ((TaxonProfile)genusProfileWithOption.get()).habitats();
            } else lbl-1000:
            // 2 sources

            {
                v0 = habitats = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
            }
        }
        if (Predef$.MODULE$.refArrayOps((Object[])habitats).isEmpty()) {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATE_HABITAT_MISMATCH(), AssertionStatus$.MODULE$.UNCHECKED()));
        } else {
            habitatsAsString = Predef$.MODULE$.refArrayOps((Object[])habitats).mkString(",");
            habitatFromPoint = processed.location().habitat();
            validHabitat = HabitatMap$.MODULE$.areTermsCompatible(habitatFromPoint, habitatsForSpecies = habitats);
            if (!validHabitat.isEmpty()) {
                if (BoxesRunTime.unboxToBoolean((Object)validHabitat.get())) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATE_HABITAT_MISMATCH(), AssertionStatus$.MODULE$.PASSED()));
                } else {
                    this.logger().debug(new StringBuilder().append((Object)"[QualityAssertion] ******** Habitats incompatible for ROWKEY: ").append((Object)raw.rowKey()).append((Object)", processed:").append((Object)processed.location().habitat()).append((Object)", retrieved:").append((Object)habitatsAsString).append((Object)", http://maps.google.com/?ll=").append((Object)processed.location().decimalLatitude()).append((Object)",").append((Object)processed.location().decimalLongitude()).toString());
                    comment = new StringBuilder().append((Object)"Recognised habitats for species: ").append((Object)habitatsAsString).append((Object)", Value determined from coordinates: ").append((Object)habitatFromPoint).toString();
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATE_HABITAT_MISMATCH(), comment));
                }
            }
        }
    }

    private void addConservationStatus(FullRecord raw, FullRecord processed) {
        Option<TaxonProfile> taxonProfileWithOption = TaxonProfileDAO$.MODULE$.getByGuid(processed.classification().taxonConceptID());
        if (!taxonProfileWithOption.isEmpty()) {
            TaxonProfile taxonProfile = (TaxonProfile)taxonProfileWithOption.get();
            if (taxonProfile.conservation() != null) {
                Option<String> country = taxonProfile.retrieveConservationStatus(processed.location().country());
                processed.occurrence().countryConservation_$eq((String)country.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                }));
                Option<String> state = taxonProfile.retrieveConservationStatus(processed.location().stateProvince());
                processed.occurrence().stateConservation_$eq((String)state.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                }));
                Option<String> global = taxonProfile.retrieveConservationStatus("Global");
                processed.occurrence().globalConservation_$eq((String)global.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                }));
            }
        }
    }

    private void checkForStateMismatch(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        if (processed.location().stateProvince() == null || raw.location().stateProvince() == null) {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.STATE_COORDINATE_MISMATCH(), AssertionStatus$.MODULE$.UNCHECKED()));
        } else {
            Option<Term> stateTerm = StateProvinces$.MODULE$.matchTerm(raw.location().stateProvince());
            if (stateTerm.isEmpty() || processed.location().stateProvince().equalsIgnoreCase(((Term)stateTerm.get()).canonical())) {
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.STATE_COORDINATE_MISMATCH(), AssertionStatus$.MODULE$.PASSED()));
            } else {
                this.logger().debug(new StringBuilder().append((Object)"[QualityAssertion] ").append((Object)raw.rowKey()).append((Object)", processed:").append((Object)processed.location().stateProvince()).append((Object)", raw:").append((Object)raw.location().stateProvince()).toString());
                String comment = new StringBuilder().append((Object)"Supplied: ").append((Object)((Term)stateTerm.get()).canonical()).append((Object)", calculated: ").append((Object)processed.location().stateProvince()).toString();
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.STATE_COORDINATE_MISMATCH(), comment));
            }
        }
    }

    public ArrayBuffer<QualityAssertion> validateGeoreferenceValues(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        ArrayBuffer arrayBuffer = raw.location().geodeticDatum() == null && processed.location().geodeticDatum() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEODETICDATUM(), "Missing geodeticDatum")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEODETICDATUM(), AssertionStatus$.MODULE$.PASSED()));
        ArrayBuffer arrayBuffer2 = raw.location().georeferencedBy() == null && processed.location().georeferencedBy() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERNCEDBY(), "Missing georeferencedBy")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERNCEDBY(), AssertionStatus$.MODULE$.PASSED()));
        ArrayBuffer arrayBuffer3 = raw.location().georeferenceProtocol() == null && processed.location().georeferenceProtocol() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCEPROTOCOL(), "Missing georeferenceProtocol")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCEPROTOCOL(), AssertionStatus$.MODULE$.PASSED()));
        ArrayBuffer arrayBuffer4 = raw.location().georeferenceSources() == null && processed.location().georeferenceSources() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCESOURCES(), "Missing georeferenceSources")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCESOURCES(), AssertionStatus$.MODULE$.PASSED()));
        ArrayBuffer arrayBuffer5 = raw.location().georeferenceVerificationStatus() == null && processed.location().georeferenceVerificationStatus() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCEVERIFICATIONSTATUS(), "Missing georeferenceVerificationStatus")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCEVERIFICATIONSTATUS(), AssertionStatus$.MODULE$.PASSED()));
        return StringUtils.isBlank((String)raw.location().georeferencedDate()) && !raw.miscProperties().containsKey("georeferencedDate") ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCE_DATE())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCE_DATE(), AssertionStatus$.MODULE$.PASSED()));
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object validateCoordinatesValues(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        BoxedUnit boxedUnit;
        Some some;
        Tuple2 tuple2;
        float lon2;
        float lat2;
        BoxedUnit boxedUnit2;
        block20: {
            block19: {
                ArrayBuffer arrayBuffer;
                ArrayBuffer arrayBuffer2;
                Option<Object> latWithOption = StringHelper$.MODULE$.string2helper(processed.location().decimalLatitude()).toFloatWithOption();
                Option<Object> lonWithOption = StringHelper$.MODULE$.string2helper(processed.location().decimalLongitude()).toFloatWithOption();
                if (latWithOption.isEmpty() || lonWithOption.isEmpty()) {
                    boxedUnit2 = BoxedUnit.UNIT;
                    return boxedUnit2;
                }
                lat2 = BoxesRunTime.unboxToFloat((Object)latWithOption.get());
                lon2 = BoxesRunTime.unboxToFloat((Object)lonWithOption.get());
                if (lat2 < (float)-90 || lat2 > (float)90 || lon2 < (float)-180 || lon2 > (float)180) {
                    if (lon2 >= (float)-90 && lon2 <= (float)90 && lat2 >= (float)-180 && lat2 <= (float)180) {
                        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVERTED_COORDINATES(), new StringBuilder().append((Object)"Assume that coordinates have been inverted. Original values: ").append((Object)processed.location().decimalLatitude()).append((Object)",").append((Object)processed.location().decimalLongitude()).toString()));
                        String tmp = processed.location().decimalLatitude();
                        processed.location().decimalLatitude_$eq(processed.location().decimalLongitude());
                        processed.location().decimalLongitude_$eq(tmp);
                        arrayBuffer2 = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_OUT_OF_RANGE(), AssertionStatus$.MODULE$.PASSED()));
                    } else {
                        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_OUT_OF_RANGE(), new StringBuilder().append((Object)"Coordinates are out of range: ").append((Object)processed.location().decimalLatitude()).append((Object)",").append((Object)processed.location().decimalLongitude()).toString()));
                        arrayBuffer2 = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVERTED_COORDINATES(), AssertionStatus$.MODULE$.PASSED()));
                    }
                } else {
                    arrayBuffer2 = assertions.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new QualityAssertion[]{QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVERTED_COORDINATES(), AssertionStatus$.MODULE$.PASSED()), QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_OUT_OF_RANGE(), AssertionStatus$.MODULE$.PASSED())}));
                }
                if (lat2 == 0.0f && lon2 == 0.0f) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ZERO_COORDINATES(), "Coordinates 0,0"));
                    processed.location().decimalLatitude_$eq(null);
                    processed.location().decimalLongitude_$eq(null);
                    arrayBuffer = BoxedUnit.UNIT;
                } else {
                    arrayBuffer = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ZERO_COORDINATES(), AssertionStatus$.MODULE$.PASSED()));
                }
                ArrayBuffer arrayBuffer3 = lat2 == 0.0f ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ZERO_LATITUDE_COORDINATES(), "Latitude 0,0")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ZERO_LATITUDE_COORDINATES(), AssertionStatus$.MODULE$.PASSED()));
                ArrayBuffer arrayBuffer4 = lon2 == 0.0f ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ZERO_LONGITUDE_COORDINATES(), "Longitude 0,0")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ZERO_LONGITUDE_COORDINATES(), AssertionStatus$.MODULE$.PASSED()));
                if (raw.location().country() == null) break block19;
                String string = raw.location().country();
                String string2 = "";
                if (string != null ? !string.equals(string2) : string2 != null) break block20;
            }
            boxedUnit2 = BoxedUnit.UNIT;
            return boxedUnit2;
        }
        Option<Term> country = Countries$.MODULE$.matchTerm(raw.location().country());
        if (country.isEmpty()) {
            boxedUnit2 = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNKNOWN_COUNTRY_NAME(), new StringBuilder().append((Object)"Country name '").append((Object)raw.location().country()).append((Object)"' not recognised.").toString()));
            return boxedUnit2;
        }
        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNKNOWN_COUNTRY_NAME(), AssertionStatus$.MODULE$.PASSED()));
        Option<Tuple2<LatLng, BBox>> option = CountryCentrePoints$.MODULE$.matchName(((Term)country.get()).canonical());
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).x()) != null) {
            BoxedUnit boxedUnit3;
            BBox bbox = (BBox)tuple2._2();
            if (bbox.containsPoint(lat2, lon2)) {
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boolean hasCoordinateMismatch = true;
                if (bbox.containsPoint(lat2 * (float)-1, lon2)) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.NEGATED_LATITUDE(), new StringBuilder().append((Object)"Latitude seems to be negated. Original value:").append((Object)processed.location().decimalLatitude()).toString()));
                    processed.location().decimalLatitude_$eq(((Object)BoxesRunTime.boxToFloat((float)(lat2 * (float)-1))).toString());
                    hasCoordinateMismatch = false;
                }
                if (bbox.containsPoint(lat2, lon2 * (float)-1)) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.NEGATED_LONGITUDE(), new StringBuilder().append((Object)"Longitude seems to be negated. Original value: ").append((Object)processed.location().decimalLongitude()).toString()));
                    processed.location().decimalLongitude_$eq(((Object)BoxesRunTime.boxToFloat((float)(lon2 * (float)-1))).toString());
                    hasCoordinateMismatch = false;
                }
                boxedUnit3 = hasCoordinateMismatch ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COUNTRY_COORDINATE_MISMATCH())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COUNTRY_COORDINATE_MISMATCH(), AssertionStatus$.MODULE$.PASSED()));
            }
            boxedUnit = boxedUnit3;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        boxedUnit2 = boxedUnit;
        return boxedUnit2;
    }

    private void processSensitivity(FullRecord raw, FullRecord processed) {
        Object object;
        this.logger().debug("Starting SDS check");
        scala.collection.mutable.Map rawMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Predef$.MODULE$.refArrayOps((Object[])raw.objectArray()).foreach((Function1)new Serializable(this, rawMap){
            public static final long serialVersionUID = 0L;
            private final scala.collection.mutable.Map rawMap$1;

            public final void apply(POSO poso) {
                scala.collection.immutable.Map<String, String> map = FullRecordMapper$.MODULE$.mapObjectToProperties(poso, Versions$.MODULE$.RAW());
                JavaConversions$.MODULE$.mutableMapAsJavaMap(this.rawMap$1).putAll(JavaConversions$.MODULE$.mapAsJavaMap(map));
            }
            {
                this.rawMap$1 = rawMap$1;
            }
        });
        if (StringHelper$.MODULE$.string2helper(processed.location().decimalLongitude()).toDoubleWithOption().isEmpty() || StringHelper$.MODULE$.string2helper(processed.location().decimalLatitude()).toDoubleWithOption().isEmpty()) {
            object = BoxedUnit.UNIT;
        } else {
            Option<Term> stringMatchState;
            scala.collection.immutable.Map<String, String> layerIntersect = SensitiveAreaDAO$.MODULE$.intersect(new StringOps(Predef$.MODULE$.augmentString(processed.location().decimalLongitude())).toDouble(), new StringOps(Predef$.MODULE$.augmentString(processed.location().decimalLatitude())).toDouble());
            JavaConversions$.MODULE$.asScalaBuffer(GeoLocationHelper.getGeospatialLayers()).foreach((Function1)new Serializable(this, rawMap, layerIntersect){
                public static final long serialVersionUID = 0L;
                private final scala.collection.mutable.Map rawMap$1;
                private final scala.collection.immutable.Map layerIntersect$1;

                public final Option<String> apply(String key) {
                    return this.rawMap$1.put((Object)key, this.layerIntersect$1.getOrElse((Object)key, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "n/a";
                        }
                    }));
                }
                {
                    this.rawMap$1 = rawMap$1;
                    this.layerIntersect$1 = layerIntersect$1;
                }
            });
            String intersectStateProvince = (String)layerIntersect.getOrElse((Object)Config$.MODULE$.stateProvinceLayerID(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            });
            object = StringUtils.isBlank((String)intersectStateProvince) ? ((stringMatchState = StateProvinces$.MODULE$.matchTerm(raw.location().stateProvince())).isEmpty() ? BoxedUnit.UNIT : rawMap.put((Object)"stateProvince", (Object)((Term)stringMatchState.get()).canonical())) : rawMap.put((Object)"stateProvince", (Object)intersectStateProvince);
        }
        if (processed.event().day() != null) {
            rawMap.update((Object)"day", (Object)processed.event().day());
        }
        if (processed.event().month() != null) {
            rawMap.update((Object)"month", (Object)processed.event().month());
        }
        if (processed.event().year() != null) {
            rawMap.update((Object)"year", (Object)processed.event().year());
        }
        String exact = this.getExactSciName(raw);
        ValidationOutcome outcome = this.sds().testMapDetails(Config$.MODULE$.sdsFinder(), JavaConversions$.MODULE$.mutableMapAsJavaMap(rawMap), exact, processed.classification().taxonConceptID());
        this.logger().debug(new StringBuilder().append((Object)"SDS outcome: ").append((Object)outcome).toString());
        if (outcome != null && outcome.isValid() && outcome.isSensitive()) {
            Object object2;
            if (outcome.getResult() == null) {
                if (!outcome.isLoadable() && Config$.MODULE$.obeySDSIsLoadable()) {
                    this.logger().warn(new StringBuilder().append((Object)"SDS isLoadable status is currently not being used. Would apply to: ").append((Object)processed.uuid()).toString());
                }
                object2 = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit;
                scala.collection.mutable.Map map = JavaConversions$.MODULE$.mapAsScalaMap(outcome.getResult());
                scala.collection.mutable.Map stringMap = (scala.collection.mutable.Map)map.collect((PartialFunction)new Serializable(this, processed){
                    public static final long serialVersionUID = 0L;
                    private final FullRecord processed$1;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends Tuple2<String, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 != null) {
                            String key = (String)A1._1();
                            Object value = A1._2();
                            if (value != null) {
                                Tuple2 tuple2;
                                String string = key;
                                String string2 = "originalSensitiveValues";
                                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                    HashMap osv = (HashMap)value;
                                    Object object2 = this.processed$1.location().coordinateUncertaintyInMeters() == null ? BoxedUnit.UNIT : osv.put("coordinateUncertaintyInMeters.p", this.processed$1.location().coordinateUncertaintyInMeters());
                                    JavaConversions$.MODULE$.asScalaBuffer(GeoLocationHelper.getGeospatialLayers()).foreach((Function1)new Serializable(this, osv){
                                        public static final long serialVersionUID = 0L;
                                        private final HashMap osv$1;

                                        public final String apply(String key) {
                                            return (String)this.osv$1.remove(key);
                                        }
                                        {
                                            this.osv$1 = osv$1;
                                        }
                                    });
                                    String newv = Json$.MODULE$.toJSON(osv);
                                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)key), (Object)newv);
                                } else {
                                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)key), (Object)value.toString());
                                }
                                object = tuple2;
                                return (B1)object;
                            }
                        }
                        object = function1.apply(x1);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Tuple2<String, Object> x1) {
                        Object value;
                        Tuple2<String, Object> tuple2 = x1;
                        boolean bl = tuple2 != null && (value = tuple2._2()) != null;
                        return bl;
                    }
                    {
                        this.processed$1 = processed$1;
                    }
                }, Map$.MODULE$.canBuildFrom());
                Option uncertainty = stringMap.get((Object)"generalisationInMetres");
                if (uncertainty.isEmpty()) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    if (StringUtils.isNotEmpty((String)((String)uncertainty.get()).toString())) {
                        float currentUncertainty = StringUtils.isNotEmpty((String)processed.location().coordinateUncertaintyInMeters()) ? Float.parseFloat(processed.location().coordinateUncertaintyInMeters()) : 0.0f;
                        float newUncertainty = currentUncertainty + (float)Integer.parseInt(((String)uncertainty.get()).toString());
                        processed.location().coordinateUncertaintyInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)newUncertainty)).toString());
                    }
                    processed.location().decimalLatitude_$eq((String)stringMap.getOrElse((Object)"decimalLatitude", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "";
                        }
                    }));
                    processed.location().decimalLongitude_$eq((String)stringMap.getOrElse((Object)"decimalLongitude", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "";
                        }
                    }));
                    boxedUnit = stringMap.$minus$eq((Object)"generalisationInMetres");
                }
                processed.occurrence().informationWithheld_$eq((String)stringMap.getOrElse((Object)"informationWithheld", (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                }));
                processed.occurrence().dataGeneralizations_$eq((String)stringMap.getOrElse((Object)"dataGeneralizations", (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                }));
                stringMap.$minus$eq((Object)"informationWithheld");
                stringMap.$minus$eq((Object)"dataGeneralizations");
                raw.event().day_$eq("");
                processed.event().day_$eq("");
                processed.event().eventDate_$eq("");
                object2 = StringUtils.isNotBlank((String)raw.rowKey()) ? Config$.MODULE$.persistenceManager().put(raw.rowKey(), "occ", (scala.collection.immutable.Map<String, String>)stringMap.toMap(Predef$.MODULE$.conforms())) : BoxedUnit.UNIT;
            }
            if (outcome.getReport().getMessages() != null) {
                ObjectRef infoMessage = new ObjectRef((Object)"");
                JavaConversions$.MODULE$.asScalaBuffer(outcome.getReport().getMessages()).foreach((Function1)new Serializable(this, infoMessage){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef infoMessage$1;

                    public final void apply(Message message) {
                        this.infoMessage$1.elem = new StringBuilder().append((Object)((String)this.infoMessage$1.elem)).append((Object)new StringBuilder().append((Object)message.getCategory()).append((Object)"\t").append((Object)message.getMessageText()).append((Object)"\n").toString()).toString();
                    }
                    {
                        this.infoMessage$1 = infoMessage$1;
                    }
                });
                processed.occurrence().informationWithheld_$eq((String)infoMessage.elem);
            }
        } else if (StringUtils.isNotBlank((String)raw.rowKey()) && raw.occurrence().originalSensitiveValues() != null && !raw.occurrence().originalSensitiveValues().isEmpty()) {
            Config$.MODULE$.persistenceManager().put(raw.rowKey(), "occ", (scala.collection.immutable.Map<String, String>)raw.occurrence().originalSensitiveValues().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"originalSensitiveValues"), (Object)"")));
        }
    }

    private String getExactSciName(FullRecord raw) {
        return raw.classification().scientificName() == null ? (raw.classification().subspecies() == null ? (raw.classification().species() == null ? (raw.classification().genus() == null ? (raw.classification().vernacularName() == null ? raw.classification().scientificName() : raw.classification().vernacularName()) : (raw.classification().specificEpithet() == null ? raw.classification().genus() : (raw.classification().infraspecificEpithet() == null ? new StringBuilder().append((Object)raw.classification().genus()).append((Object)" ").append((Object)raw.classification().specificEpithet()).toString() : new StringBuilder().append((Object)raw.classification().genus()).append((Object)" ").append((Object)raw.classification().specificEpithet()).append((Object)" ").append((Object)raw.classification().infraspecificEpithet()).toString()))) : raw.classification().species()) : raw.classification().subspecies()) : raw.classification().scientificName();
    }

    @Override
    public String getName() {
        return FullRecordMapper$.MODULE$.geospatialQa();
    }

    public LocationProcessor() {
        Processor$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"LocationProcessor");
        this.WGS84_EPSG_Code = "EPSG:4326";
        this.sds = new SensitiveDataService();
    }
}

