/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.processor;

import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.model.QualityAssertion;
import au.org.ala.biocache.model.QualityAssertion$;
import au.org.ala.biocache.parser.DateParser$;
import au.org.ala.biocache.parser.EventDate;
import au.org.ala.biocache.processor.EventProcessor$;
import au.org.ala.biocache.processor.Processor;
import au.org.ala.biocache.processor.Processor$class;
import au.org.ala.biocache.util.DateUtil$;
import au.org.ala.biocache.util.StringHelper$;
import au.org.ala.biocache.vocab.AssertionCodes$;
import au.org.ala.biocache.vocab.AssertionStatus$;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\u0001\u0003\u00015\u0011a\"\u0012<f]R\u0004&o\\2fgN|'O\u0003\u0002\u0004\t\u0005I\u0001O]8dKN\u001cxN\u001d\u0006\u0003\u000b\u0019\t\u0001BY5pG\u0006\u001c\u0007.\u001a\u0006\u0003\u000f!\t1!\u00197b\u0015\tI!\"A\u0002pe\u001eT\u0011aC\u0001\u0003CV\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u0017\u001b\u0005\u0011\u0011BA\f\u0003\u0005%\u0001&o\\2fgN|'\u000fC\u0003\u001a\u0001\u0011\u0005!$\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011Q\u0003\u0001\u0005\u0006;\u0001!\tAH\u0001\u000fm\u0006d\u0017\u000eZ1uK:+XNY3s)\ry\u0002&\r\t\u0005\u001f\u0001\u0012S%\u0003\u0002\"!\t1A+\u001e9mKJ\u0002\"aD\u0012\n\u0005\u0011\u0002\"aA%oiB\u0011qBJ\u0005\u0003OA\u0011qAQ8pY\u0016\fg\u000eC\u0003*9\u0001\u0007!&\u0001\u0004ok6\u0014WM\u001d\t\u0003W9r!a\u0004\u0017\n\u00055\u0002\u0012A\u0002)sK\u0012,g-\u0003\u00020a\t11\u000b\u001e:j]\u001eT!!\f\t\t\u000bIb\u0002\u0019A\u001a\u0002\u0003\u0019\u0004Ba\u0004\u001b#K%\u0011Q\u0007\u0005\u0002\n\rVt7\r^5p]FBQa\u000e\u0001\u0005\u0002a\nq\u0001\u001d:pG\u0016\u001c8\u000fF\u0003:\u0005\u0012K5\nE\u0002\u0010uqJ!a\u000f\t\u0003\u000b\u0005\u0013(/Y=\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}\"\u0011!B7pI\u0016d\u0017BA!?\u0005A\tV/\u00197jif\f5o]3si&|g\u000eC\u0003Dm\u0001\u0007!&\u0001\u0003hk&$\u0007\"B#7\u0001\u00041\u0015a\u0001:boB\u0011QhR\u0005\u0003\u0011z\u0012!BR;mYJ+7m\u001c:e\u0011\u0015Qe\u00071\u0001G\u0003%\u0001(o\\2fgN,G\rC\u0004MmA\u0005\t\u0019A'\u0002\u001b1\f7\u000f\u001e)s_\u000e,7o]3e!\ryaJR\u0005\u0003\u001fB\u0011aa\u00149uS>t\u0007\"B)\u0001\t\u0003\u0011\u0016!\u0005:v]f+\u0017M\u001d,bY&$\u0017\r^5p]R)1K\u0016-[9B)q\u0002\u0016\u0016&E%\u0011Q\u000b\u0005\u0002\u0007)V\u0004H.Z\u001a\t\u000b]\u0003\u0006\u0019\u0001\u0012\u0002\u000fI\fw/_3be\")\u0011\f\u0015a\u0001E\u0005Y1-\u001e:sK:$\u0018,Z1s\u0011\u001dY\u0006\u000b%AA\u0002\t\n1\u0001Z1z\u0011\u001di\u0006\u000b%AA\u0002\t\nQ!\\8oi\"DQa\u0018\u0001\u0005\u0002\u0001\f\u0011\u0003\u001d:pG\u0016\u001c8OR5sgR$\u0015\r^3t)\u0011\tG-\u001a4\u0011\u0005=\u0011\u0017BA2\u0011\u0005\u0011)f.\u001b;\t\u000b\u0015s\u0006\u0019\u0001$\t\u000b)s\u0006\u0019\u0001$\t\u000b\u001dt\u0006\u0019\u00015\u0002\u0015\u0005\u001c8/\u001a:uS>t7\u000fE\u0002j]rj\u0011A\u001b\u0006\u0003W2\fq!\\;uC\ndWM\u0003\u0002n!\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005=T'aC!se\u0006L()\u001e4gKJDQ!\u001d\u0001\u0005\u0002I\f\u0011\u0003\u001d:pG\u0016\u001c8o\u0014;iKJ$\u0015\r^3t)\u0011\t7\u000f^;\t\u000b\u0015\u0003\b\u0019\u0001$\t\u000b)\u0003\b\u0019\u0001$\t\u000b\u001d\u0004\b\u0019\u00015\t\u000b]\u0004A\u0011\u0001=\u0002\u000f\u001d,GOT1nKV\t\u0011\u0010\u0005\u0002{\u007f6\t1P\u0003\u0002}{\u0006!A.\u00198h\u0015\u0005q\u0018\u0001\u00026bm\u0006L!aL>\t\u0013\u0005\r\u0001!%A\u0005B\u0005\u0015\u0011!\u00059s_\u000e,7o\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011q\u0001\u0016\u0004\u001b\u0006%1FAA\u0006!\u0011\ti!a\u0006\u000e\u0005\u0005=!\u0002BA\t\u0003'\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005U\u0001#\u0001\u0006b]:|G/\u0019;j_:LA!!\u0007\u0002\u0010\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005u\u0001!%A\u0005\u0002\u0005}\u0011a\u0007:v]f+\u0017M\u001d,bY&$\u0017\r^5p]\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\")\u001a!%!\u0003\t\u0013\u0005\u0015\u0002!%A\u0005\u0002\u0005}\u0011a\u0007:v]f+\u0017M\u001d,bY&$\u0017\r^5p]\u0012\"WMZ1vYR$C\u0007")
public class EventProcessor
implements Processor {
    public Tuple2<Object, Object> validateNumber(String number, Function1<Object, Object> f) {
        Tuple2.mcIZ.sp sp2;
        try {
            if (number == null) {
                sp2 = new Tuple2.mcIZ.sp(-1, false);
            } else {
                int parsedNumber = new StringOps(Predef$.MODULE$.augmentString(number)).toInt();
                sp2 = new Tuple2.mcIZ.sp(parsedNumber, f.apply$mcZI$sp(parsedNumber));
            }
        }
        catch (NumberFormatException numberFormatException) {
            sp2 = new Tuple2.mcIZ.sp(-1, false);
        }
        return sp2;
    }

    @Override
    public QualityAssertion[] process(String guid, FullRecord raw, FullRecord processed, Option<FullRecord> lastProcessed) {
        ArrayBuffer assertions;
        block34: {
            boolean dateComplete;
            boolean addPassedInvalidCollectionDate;
            None$ date;
            ArrayBuffer arrayBuffer;
            block39: {
                String comment;
                block40: {
                    Option<EventDate> parsedDate;
                    Option<EventDate> parsedDate2;
                    boolean validDay;
                    int day;
                    boolean validMonth;
                    int month;
                    boolean validYear;
                    int year;
                    int currentYear;
                    block38: {
                        Tuple2<Object, Object> tuple2;
                        block35: {
                            Tuple2<Object, Object> tuple22;
                            block36: {
                                Tuple2<Object, Object> tuple23;
                                block37: {
                                    boolean validDayMonthYear;
                                    BoxedUnit boxedUnit;
                                    Tuple2.mcIZ.sp sp2;
                                    Tuple2.mcIZ.sp sp3;
                                    Tuple2.mcIZ.sp sp4;
                                    block33: {
                                        assertions = new ArrayBuffer();
                                        if (raw.event().day() != null && !raw.event().day().isEmpty() || raw.event().month() != null && !raw.event().month().isEmpty() || raw.event().year() != null && !raw.event().year().isEmpty() || raw.event().eventDate() != null && !raw.event().eventDate().isEmpty() || raw.event().verbatimEventDate() != null && !raw.event().verbatimEventDate().isEmpty()) break block33;
                                        arrayBuffer = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_COLLECTION_DATE(), "No date information supplied"));
                                        break block34;
                                    }
                                    date = None$.MODULE$;
                                    currentYear = DateUtil$.MODULE$.getCurrentYear();
                                    comment = "";
                                    addPassedInvalidCollectionDate = true;
                                    dateComplete = false;
                                    tuple2 = this.validateNumber(raw.event().year(), (Function1<Object, Object>)new $anonfun$1(this, currentYear));
                                    if (tuple2 == null) break block35;
                                    int year2 = tuple2._1$mcI$sp();
                                    boolean validYear2 = tuple2._2$mcZ$sp();
                                    Tuple2.mcIZ.sp sp5 = sp4 = new Tuple2.mcIZ.sp(year2, validYear2);
                                    year = sp5._1$mcI$sp();
                                    validYear = sp5._2$mcZ$sp();
                                    tuple22 = this.validateNumber(raw.event().month(), (Function1<Object, Object>)new $anonfun$2(this));
                                    if (tuple22 == null) break block36;
                                    int month2 = tuple22._1$mcI$sp();
                                    boolean validMonth2 = tuple22._2$mcZ$sp();
                                    Tuple2.mcIZ.sp sp6 = sp3 = new Tuple2.mcIZ.sp(month2, validMonth2);
                                    month = sp6._1$mcI$sp();
                                    validMonth = sp6._2$mcZ$sp();
                                    tuple23 = this.validateNumber(raw.event().day(), (Function1<Object, Object>)new $anonfun$3(this));
                                    if (tuple23 == null) break block37;
                                    int day2 = tuple23._1$mcI$sp();
                                    boolean validDay2 = tuple23._2$mcZ$sp();
                                    Tuple2.mcIZ.sp sp7 = sp2 = new Tuple2.mcIZ.sp(day2, validDay2);
                                    day = sp7._1$mcI$sp();
                                    validDay = sp7._2$mcZ$sp();
                                    if (!validMonth && StringHelper$.MODULE$.string2helper(raw.event().month()).isInt() && StringHelper$.MODULE$.string2helper(raw.event().day()).isInt()) {
                                        int monthValue = new StringOps(Predef$.MODULE$.augmentString(raw.event().month())).toInt();
                                        int dayValue = new StringOps(Predef$.MODULE$.augmentString(raw.event().day())).toInt();
                                        if (monthValue > 12 && dayValue < 12) {
                                            month = dayValue;
                                            day = monthValue;
                                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DAY_MONTH_TRANSPOSED(), "Assume day and month transposed"));
                                            validMonth = true;
                                            boxedUnit = BoxedUnit.UNIT;
                                        } else {
                                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVALID_COLLECTION_DATE(), "Invalid month supplied"));
                                            addPassedInvalidCollectionDate = false;
                                            boxedUnit = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DAY_MONTH_TRANSPOSED(), AssertionStatus$.MODULE$.PASSED()));
                                        }
                                    } else {
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                    if (day == 0 || day > 31) {
                                        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVALID_COLLECTION_DATE(), "Invalid day supplied"));
                                        addPassedInvalidCollectionDate = false;
                                    }
                                    if (year > 0) {
                                        Tuple3<String, Object, Object> tuple3 = this.runYearValidation(year, currentYear, day, month);
                                        if (tuple3 != null) {
                                            Tuple3 tuple32;
                                            String newComment = (String)tuple3._1();
                                            boolean newValidYear = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
                                            int newYear = BoxesRunTime.unboxToInt((Object)tuple3._3());
                                            Tuple3 tuple33 = tuple32 = new Tuple3((Object)newComment, (Object)BoxesRunTime.boxToBoolean((boolean)newValidYear), (Object)BoxesRunTime.boxToInteger((int)newYear));
                                            String newComment2 = (String)tuple33._1();
                                            boolean newValidYear2 = BoxesRunTime.unboxToBoolean((Object)tuple33._2());
                                            int newYear2 = BoxesRunTime.unboxToInt((Object)tuple33._3());
                                            comment = newComment2;
                                            validYear = newValidYear2;
                                            year = newYear2;
                                            if (StringUtils.isNotEmpty((String)comment)) {
                                                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVALID_COLLECTION_DATE(), comment));
                                                addPassedInvalidCollectionDate = false;
                                            }
                                        } else {
                                            throw new MatchError(tuple3);
                                        }
                                    }
                                    boolean bl = validDayMonthYear = validYear && validDay && validMonth;
                                    if (!validDayMonthYear) break block38;
                                    try {
                                        GregorianCalendar calendar = new GregorianCalendar(year, month - 1, day);
                                        calendar.setLenient(false);
                                        date = new Some((Object)calendar.getTime());
                                        dateComplete = true;
                                    }
                                    catch (Exception exception) {
                                        validDayMonthYear = false;
                                        comment = "Invalid year, day, month";
                                        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVALID_COLLECTION_DATE(), comment));
                                        addPassedInvalidCollectionDate = false;
                                    }
                                }
                                throw new MatchError(tuple23);
                            }
                            throw new MatchError(tuple22);
                        }
                        throw new MatchError(tuple2);
                    }
                    if (validYear) {
                        processed.event().year_$eq(((Object)BoxesRunTime.boxToInteger((int)year)).toString());
                    }
                    if (validMonth) {
                        processed.event().month_$eq(String.format("%02d", Predef$.MODULE$.int2Integer(month)));
                    }
                    if (validDay) {
                        processed.event().day_$eq(((Object)BoxesRunTime.boxToInteger((int)day)).toString());
                    }
                    if (!date.isEmpty()) {
                        processed.event().eventDate_$eq(DateFormatUtils.format((Date)((Date)date.get()), (String)"yyyy-MM-dd"));
                    }
                    if (date.isEmpty() && raw.event().eventDate() != null && !raw.event().eventDate().isEmpty() && !(parsedDate2 = DateParser$.MODULE$.parseDate(raw.event().eventDate(), DateParser$.MODULE$.parseDate$default$2(), DateParser$.MODULE$.parseDate$default$3())).isEmpty()) {
                        processed.event().eventDate_$eq(((EventDate)parsedDate2.get()).startDate());
                        processed.event().day_$eq(((EventDate)parsedDate2.get()).startDay());
                        processed.event().month_$eq(((EventDate)parsedDate2.get()).startMonth());
                        processed.event().year_$eq(((EventDate)parsedDate2.get()).startYear());
                        String string = ((EventDate)parsedDate2.get()).startYear();
                        String string2 = "";
                        if (string == null ? string2 != null : !string.equals(string2)) {
                            Tuple3 tuple3;
                            String string3 = ((EventDate)parsedDate2.get()).startDay();
                            String string4 = "";
                            String string5 = ((EventDate)parsedDate2.get()).startMonth();
                            String string6 = "";
                            Tuple3<String, Object, Object> tuple34 = this.runYearValidation(new StringOps(Predef$.MODULE$.augmentString(((EventDate)parsedDate2.get()).startYear())).toInt(), currentYear, !(string3 != null ? !string3.equals(string4) : string4 != null) ? 0 : new StringOps(Predef$.MODULE$.augmentString(((EventDate)parsedDate2.get()).startDay())).toInt(), !(string5 != null ? !string5.equals(string6) : string6 != null) ? 0 : new StringOps(Predef$.MODULE$.augmentString(((EventDate)parsedDate2.get()).startMonth())).toInt());
                            if (tuple34 == null) {
                                throw new MatchError(tuple34);
                            }
                            String newComment = (String)tuple34._1();
                            boolean newValidYear = BoxesRunTime.unboxToBoolean((Object)tuple34._2());
                            int newYear = BoxesRunTime.unboxToInt((Object)tuple34._3());
                            Tuple3 tuple35 = tuple3 = new Tuple3((Object)newComment, (Object)BoxesRunTime.boxToBoolean((boolean)newValidYear), (Object)BoxesRunTime.boxToInteger((int)newYear));
                            String newComment3 = (String)tuple35._1();
                            boolean newValidYear3 = BoxesRunTime.unboxToBoolean((Object)tuple35._2());
                            int newYear3 = BoxesRunTime.unboxToInt((Object)tuple35._3());
                            comment = newComment3;
                            validYear = newValidYear3;
                            year = newYear3;
                        }
                        if (StringUtils.isNotBlank((String)((EventDate)parsedDate2.get()).startDate())) {
                            dateComplete = true;
                        }
                        if (DateUtil$.MODULE$.isFutureDate((EventDate)parsedDate2.get())) {
                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVALID_COLLECTION_DATE(), "Future date supplied"));
                            addPassedInvalidCollectionDate = false;
                        }
                    }
                    if (date.isEmpty() && raw.event().verbatimEventDate() != null && !raw.event().verbatimEventDate().isEmpty() && !(parsedDate = DateParser$.MODULE$.parseDate(raw.event().verbatimEventDate(), DateParser$.MODULE$.parseDate$default$2(), DateParser$.MODULE$.parseDate$default$3())).isEmpty()) {
                        processed.event().eventDate_$eq(((EventDate)parsedDate.get()).startDate());
                        processed.event().day_$eq(((EventDate)parsedDate.get()).startDay());
                        processed.event().month_$eq(((EventDate)parsedDate.get()).startMonth());
                        processed.event().year_$eq(((EventDate)parsedDate.get()).startYear());
                        String string = ((EventDate)parsedDate.get()).startYear();
                        String string7 = "";
                        if (string == null ? string7 != null : !string.equals(string7)) {
                            Tuple3 tuple3;
                            String string8 = ((EventDate)parsedDate.get()).startDay();
                            String string9 = "";
                            String string10 = ((EventDate)parsedDate.get()).startMonth();
                            String string11 = "";
                            Tuple3<String, Object, Object> tuple36 = this.runYearValidation(new StringOps(Predef$.MODULE$.augmentString(((EventDate)parsedDate.get()).startYear())).toInt(), currentYear, !(string8 != null ? !string8.equals(string9) : string9 != null) ? 0 : new StringOps(Predef$.MODULE$.augmentString(((EventDate)parsedDate.get()).startDay())).toInt(), !(string10 != null ? !string10.equals(string11) : string11 != null) ? 0 : new StringOps(Predef$.MODULE$.augmentString(((EventDate)parsedDate.get()).startMonth())).toInt());
                            if (tuple36 == null) {
                                throw new MatchError(tuple36);
                            }
                            String newComment = (String)tuple36._1();
                            boolean newValidYear = BoxesRunTime.unboxToBoolean((Object)tuple36._2());
                            int newYear = BoxesRunTime.unboxToInt((Object)tuple36._3());
                            Tuple3 tuple37 = tuple3 = new Tuple3((Object)newComment, (Object)BoxesRunTime.boxToBoolean((boolean)newValidYear), (Object)BoxesRunTime.boxToInteger((int)newYear));
                            String newComment4 = (String)tuple37._1();
                            boolean newValidYear4 = BoxesRunTime.unboxToBoolean((Object)tuple37._2());
                            int newYear4 = BoxesRunTime.unboxToInt((Object)tuple37._3());
                            comment = newComment4;
                            validYear = newValidYear4;
                            year = newYear4;
                        }
                        if (StringUtils.isNotBlank((String)((EventDate)parsedDate.get()).startDate())) {
                            dateComplete = true;
                        }
                        if (DateUtil$.MODULE$.isFutureDate((EventDate)parsedDate.get())) {
                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVALID_COLLECTION_DATE(), "Future date supplied"));
                            addPassedInvalidCollectionDate = false;
                        }
                    }
                    if (validYear) break block39;
                    if (processed.event().eventDate() == null) break block40;
                    String string = processed.event().eventDate();
                    String string12 = "";
                    if (!(string == null ? string12 != null : !string.equals(string12))) break block40;
                    String string13 = comment;
                    String string14 = "";
                    if (!(string13 == null ? string14 != null : !string13.equals(string14))) break block39;
                }
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVALID_COLLECTION_DATE(), comment));
                addPassedInvalidCollectionDate = false;
            }
            if (!date.isEmpty() && ((Date)date.get()).after(new Date())) {
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVALID_COLLECTION_DATE(), "Future date supplied"));
                addPassedInvalidCollectionDate = false;
            }
            Object object = addPassedInvalidCollectionDate ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVALID_COLLECTION_DATE(), AssertionStatus$.MODULE$.PASSED())) : BoxedUnit.UNIT;
            arrayBuffer = dateComplete ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INCOMPLETE_COLLECTION_DATE(), AssertionStatus$.MODULE$.PASSED())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INCOMPLETE_COLLECTION_DATE(), "The supplied collection date is not complete"));
        }
        this.processOtherDates(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
        this.processFirstDates(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
        return (QualityAssertion[])assertions.toArray(ClassTag$.MODULE$.apply(QualityAssertion.class));
    }

    @Override
    public Option<FullRecord> process$default$4() {
        return None$.MODULE$;
    }

    public Tuple3<String, Object, Object> runYearValidation(int rawyear, int currentYear, int day, int month) {
        boolean validYear = true;
        String comment = "";
        int year = rawyear;
        if (year > 0) {
            if (year < 100) {
                Date date;
                if (year > currentYear % 100) {
                    year += (currentYear / 100 - 1) * 100;
                } else if (day != 0 && month != 0 && (date = DateUtils.parseDate((String)new StringBuilder().append((Object)((Object)BoxesRunTime.boxToInteger((int)(year += currentYear / 100 * 100))).toString()).append((Object)String.format("%02d", Predef$.MODULE$.int2Integer(month))).append((Object)((Object)BoxesRunTime.boxToInteger((int)day)).toString()).toString(), (String[])((String[])((Object[])new String[]{"yyyyMMdd"})))).after(new Date())) {
                    year -= 100;
                }
            } else if (year >= 100 && year < 1600) {
                year = -1;
                validYear = false;
                comment = "Year out of range";
            } else if (year > DateUtil$.MODULE$.getCurrentYear()) {
                year = -1;
                validYear = false;
                comment = "Future year supplied";
            } else if (year == 1788 && month == 1 && day == 26) {
                validYear = false;
                comment = "First Fleet arrival implies a null date";
            }
        }
        return new Tuple3((Object)comment, (Object)BoxesRunTime.boxToBoolean((boolean)validYear), (Object)BoxesRunTime.boxToInteger((int)year));
    }

    public int runYearValidation$default$3() {
        return 0;
    }

    public int runYearValidation$default$4() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void processFirstDates(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        block5: {
            block7: {
                Tuple2.mcIZ.sp sp2;
                block6: {
                    block4: {
                        String string = processed.event().day();
                        String string2 = "1";
                        if (!(string == null ? string2 != null : !string.equals(string2))) break block4;
                        String string3 = processed.event().day();
                        String string4 = "01";
                        if (string3 != null ? !string3.equals(string4) : string4 != null) break block5;
                    }
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.FIRST_OF_MONTH()));
                    String string = processed.event().month();
                    String string5 = "01";
                    if (!(string == null ? string5 != null : !string.equals(string5))) break block6;
                    String string6 = processed.event().month();
                    String string7 = "1";
                    if (string6 != null ? !string6.equals(string7) : string7 != null) break block7;
                }
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.FIRST_OF_YEAR()));
                if (processed.event().year() == null) return;
                Tuple2<Object, Object> tuple2 = this.validateNumber(processed.event().year(), (Function1<Object, Object>)new $anonfun$4(this));
                if (tuple2 == null) throw new MatchError(tuple2);
                int year = tuple2._1$mcI$sp();
                boolean validYear = tuple2._2$mcZ$sp();
                Tuple2.mcIZ.sp sp3 = sp2 = new Tuple2.mcIZ.sp(year, validYear);
                int year2 = sp3._1$mcI$sp();
                boolean validYear2 = sp3._2$mcZ$sp();
                if (validYear2 && year2 % 100 == 0) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.FIRST_OF_CENTURY()));
                    return;
                }
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.FIRST_OF_CENTURY(), AssertionStatus$.MODULE$.PASSED()));
                return;
            }
            if (processed.event().month() == null) return;
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.FIRST_OF_YEAR(), AssertionStatus$.MODULE$.PASSED()));
            return;
        }
        if (processed.event().day() == null) return;
        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.FIRST_OF_MONTH(), AssertionStatus$.MODULE$.PASSED()));
    }

    public void processOtherDates(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        Option<EventDate> parsedDate;
        Option<EventDate> parsedDate2;
        Option<EventDate> parsedDate3;
        if (raw.occurrence().modified() != null && (parsedDate3 = DateParser$.MODULE$.parseDate(raw.occurrence().modified(), DateParser$.MODULE$.parseDate$default$2(), DateParser$.MODULE$.parseDate$default$3())).isDefined()) {
            processed.occurrence().modified_$eq(((EventDate)parsedDate3.get()).startDate());
        }
        if (raw.identification().dateIdentified() != null && (parsedDate2 = DateParser$.MODULE$.parseDate(raw.identification().dateIdentified(), DateParser$.MODULE$.parseDate$default$2(), DateParser$.MODULE$.parseDate$default$3())).isDefined()) {
            processed.identification().dateIdentified_$eq(((EventDate)parsedDate2.get()).startDate());
        }
        if ((raw.location().georeferencedDate() != null || raw.miscProperties().containsKey("georeferencedDate")) && (parsedDate = DateParser$.MODULE$.parseDate(this.rawdate$1(raw), DateParser$.MODULE$.parseDate$default$2(), DateParser$.MODULE$.parseDate$default$3())).isDefined()) {
            processed.location().georeferencedDate_$eq(((EventDate)parsedDate.get()).startDate());
        }
        if (StringUtils.isNotBlank((String)processed.event().eventDate())) {
            Date eventDate = (Date)DateParser$.MODULE$.parseStringToDate(processed.event().eventDate()).get();
            Object object = StringUtils.isNotBlank((String)processed.identification().dateIdentified()) ? (((Date)DateParser$.MODULE$.parseStringToDate(processed.identification().dateIdentified()).get()).before(eventDate) ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ID_PRE_OCCURRENCE(), "The records was identified before it was collected")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ID_PRE_OCCURRENCE(), AssertionStatus$.MODULE$.PASSED()))) : BoxedUnit.UNIT;
            if (StringUtils.isNotBlank((String)processed.location().georeferencedDate())) {
                if (((Date)DateParser$.MODULE$.parseStringToDate(processed.location().georeferencedDate()).get()).after(eventDate)) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.GEOREFERENCE_POST_OCCURRENCE(), "The record was not georeferenced when it was collected"));
                } else {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.GEOREFERENCE_POST_OCCURRENCE(), AssertionStatus$.MODULE$.PASSED()));
                }
            }
        }
    }

    @Override
    public String getName() {
        return "event";
    }

    private final String rawdate$1(FullRecord raw$1) {
        return raw$1.location().georeferencedDate() == null ? raw$1.miscProperties().get("georeferencedDate") : raw$1.location().georeferencedDate();
    }

    public EventProcessor() {
        Processor$class.$init$(this);
    }
}

