/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.outliers;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.biocache.Config$;
import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.index.IndexRecords$;
import au.org.ala.biocache.model.QualityAssertion$;
import au.org.ala.biocache.outliers.JackKnife;
import au.org.ala.biocache.outliers.JackKnifeStats;
import au.org.ala.biocache.outliers.RecordJackKnifeStats;
import au.org.ala.biocache.outliers.ReverseJacknifeProcessor$;
import au.org.ala.biocache.outliers.ReverseJacknifeProcessor$$anonfun$performJacknife$1$;
import au.org.ala.biocache.outliers.SampledRecord;
import au.org.ala.biocache.outliers.SampledRecord$;
import au.org.ala.biocache.outliers.Timings;
import au.org.ala.biocache.util.FileHelper$;
import au.org.ala.biocache.util.OptionParser;
import au.org.ala.biocache.util.StringConsumer;
import au.org.ala.biocache.vocab.AssertionCodes$;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ArrayBlockingQueue;
import net.minidev.json.JSONArray;
import org.ala.layers.intersect.Grid;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenSeq;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.TraversableForwarder;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

public final class ReverseJacknifeProcessor$
implements Tool {
    public static final ReverseJacknifeProcessor$ MODULE$;
    private final Logger logger;
    private final List<String> mandatoryHeaders;
    private final Map<String, String> envLayerMap;

    static {
        new ReverseJacknifeProcessor$();
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    @Override
    public String cmd() {
        return "jacknife";
    }

    @Override
    public String desc() {
        return "Run jacknife processing";
    }

    public Logger logger() {
        return this.logger;
    }

    public List<String> mandatoryHeaders() {
        return this.mandatoryHeaders;
    }

    public Map<String, String> envLayerMap() {
        return this.envLayerMap;
    }

    @Override
    public void main(String[] args) {
        ObjectRef lastModifiedDate;
        BooleanRef index;
        ObjectRef taxonRank;
        IntRef numSourceThreads;
        IntRef numPassThreadWriters;
        BooleanRef persistResults;
        ObjectRef idsToIndexFile;
        ObjectRef taxonID = new ObjectRef((Object)"");
        ObjectRef taxonIDsFilepath = new ObjectRef((Object)"");
        ObjectRef fullDumpFilePath = new ObjectRef((Object)"");
        ObjectRef headerForDumpFile = new ObjectRef((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"taxonConceptID", "uuid", "decimalLatitude", "decimalLongitude", "el882", "el889", "el887", "el865", "el894"})));
        OptionParser parser = new OptionParser(taxonID, taxonIDsFilepath, fullDumpFilePath, headerForDumpFile, idsToIndexFile = new ObjectRef((Object)new StringBuilder().append((Object)Config$.MODULE$.tmpWorkDir()).append((Object)"/idsToReIndex.txt").toString()), persistResults = new BooleanRef(false), numPassThreadWriters = new IntRef(16), numSourceThreads = new IntRef(4), taxonRank = new ObjectRef((Object)"species"), index = new BooleanRef(false), lastModifiedDate = new ObjectRef((Object)None$.MODULE$)){
            {
                this.opt("t", "taxonID", "The LSID of the species to check for outliers. This wll download from LIVE", (Function1<String, BoxedUnit>)new Serializable(this, taxonID$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef taxonID$1;

                    public final void apply(String v) {
                        this.taxonID$1.elem = v;
                    }
                    {
                        this.taxonID$1 = taxonID$1;
                    }
                });
                this.opt("f", "taxonIDsFilepath", "Filepath to taxon IDs. This will perform downloads for each taxonID", (Function1<String, BoxedUnit>)new Serializable(this, taxonIDsFilepath$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef taxonIDsFilepath$1;

                    public final void apply(String v) {
                        this.taxonIDsFilepath$1.elem = v;
                    }
                    {
                        this.taxonIDsFilepath$1 = taxonIDsFilepath$1;
                    }
                });
                this.opt("fd", "fullDumpFile", "Filepath to full extract of data", (Function1<String, BoxedUnit>)new Serializable(this, fullDumpFilePath$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef fullDumpFilePath$1;

                    public final void apply(String v) {
                        this.fullDumpFilePath$1.elem = v;
                    }
                    {
                        this.fullDumpFilePath$1 = fullDumpFilePath$1;
                    }
                });
                this.opt("hfd", "headerForDumpFile", "The header for the dump file, space separated headings. Default is: 'taxonConceptID uuid decimalLatitude decimalLongitude el882 el889 el887 el865 el894'", (Function1<String, BoxedUnit>)new Serializable(this, headerForDumpFile$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef headerForDumpFile$1;

                    public final void apply(String v) {
                        this.headerForDumpFile$1.elem = Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(v)).split(' ')).toList();
                    }
                    {
                        this.headerForDumpFile$1 = headerForDumpFile$1;
                    }
                });
                this.opt("type", "The type either species or subspecies", (Function1<String, BoxedUnit>)new Serializable(this, taxonRank$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef taxonRank$1;

                    public final void apply(String v) {
                        this.taxonRank$1.elem = v;
                    }
                    {
                        this.taxonRank$1 = taxonRank$1;
                    }
                });
                this.intOpt("pt", "passThreads", "The number of threads to use when writing the passed records to the data store", (Function1<Object, BoxedUnit>)new Serializable(this, numPassThreadWriters$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef numPassThreadWriters$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.numPassThreadWriters$1.elem = v;
                    }
                    {
                        this.numPassThreadWriters$1 = numPassThreadWriters$1;
                    }
                });
                this.intOpt("st", "sourceThreads", "The number of threads that were used to create the source files.", (Function1<Object, BoxedUnit>)new Serializable(this, numSourceThreads$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef numSourceThreads$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.numSourceThreads$1.elem = v;
                    }
                    {
                        this.numSourceThreads$1 = numSourceThreads$1;
                    }
                });
                this.opt("if", "indexFilePath", "Filepath to file of IDs to reindex", (Function1<String, BoxedUnit>)new Serializable(this, idsToIndexFile$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef idsToIndexFile$1;

                    public final void apply(String v) {
                        this.idsToIndexFile$1.elem = v;
                    }
                    {
                        this.idsToIndexFile$1 = idsToIndexFile$1;
                    }
                });
                this.opt("persist", "persist results to the database", (Function0<BoxedUnit>)new Serializable(this, persistResults$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef persistResults$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.persistResults$1.elem = true;
                    }
                    {
                        this.persistResults$1 = persistResults$1;
                    }
                });
                this.opt("index", "index the records that are marked as outliers", (Function0<BoxedUnit>)new Serializable(this, index$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef index$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.index$1.elem = true;
                    }
                    {
                        this.index$1 = index$1;
                    }
                });
                this.intOpt("day", "numDaysMod", "Number of days since the last modified.  This will limit the records that are marked as passed.", (Function1<Object, BoxedUnit>)new Serializable(this, lastModifiedDate$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef lastModifiedDate$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        SimpleDateFormat sfd = new SimpleDateFormat("yyyy-MM-dd");
                        int days = 0 - v;
                        this.lastModifiedDate$1.elem = new Some((Object)new StringBuilder().append((Object)sfd.format(DateUtils.addDays((Date)new Date(), (int)days))).append((Object)"T00:00:00Z").toString());
                    }
                    {
                        this.lastModifiedDate$1 = lastModifiedDate$1;
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            ArrayBlockingQueue<String> queue = new ArrayBlockingQueue<String>(200000);
            IntRef ids = new IntRef(0);
            StringConsumer[] pool = (StringConsumer[])Array$.MODULE$.fill(numPassThreadWriters.elem, (Function0)new Serializable(queue, ids){
                public static final long serialVersionUID = 0L;
                private final ArrayBlockingQueue queue$1;
                private final IntRef ids$1;

                public final StringConsumer apply() {
                    IntRef counter = new IntRef(0);
                    LongRef startTime = new LongRef(System.currentTimeMillis());
                    LongRef finishTime = new LongRef(System.currentTimeMillis());
                    StringConsumer p = new StringConsumer(this.queue$1, this.ids$1.elem, (Function1<String, BoxedUnit>)new Serializable(this, counter, startTime, finishTime){
                        public static final long serialVersionUID = 0L;
                        private final IntRef counter$1;
                        private final LongRef startTime$1;
                        private final LongRef finishTime$1;

                        public final void apply(String uuid) {
                            ++this.counter$1.elem;
                            try {
                                Option<String> rowKey = Config$.MODULE$.occurrenceDAO().getRowKeyFromUuid(uuid);
                                if (rowKey.isDefined()) {
                                    Config$.MODULE$.occurrenceDAO().addSystemAssertion((String)rowKey.get(), QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DETECTED_OUTLIER(), 1), Config$.MODULE$.occurrenceDAO().addSystemAssertion$default$3(), Config$.MODULE$.occurrenceDAO().addSystemAssertion$default$4());
                                }
                            }
                            catch (Exception exception) {
                                ReverseJacknifeProcessor$.MODULE$.logger().error(new StringBuilder().append((Object)"Unable to markup ").append((Object)uuid).append((Object)" as passed. ").append((Object)exception.getMessage()).toString());
                            }
                            if (this.counter$1.elem % 1000 == 0) {
                                this.finishTime$1.elem = System.currentTimeMillis();
                                ReverseJacknifeProcessor$.MODULE$.logger().info(new StringBuilder().append(this.counter$1.elem).append((Object)" >> Last key : ").append((Object)uuid).append((Object)", records per sec: ").append((Object)BoxesRunTime.boxToFloat((float)(1000.0f / ((float)(this.finishTime$1.elem - this.startTime$1.elem) / 1000.0f)))).toString());
                                this.startTime$1.elem = System.currentTimeMillis();
                            }
                        }
                        {
                            this.counter$1 = counter$1;
                            this.startTime$1 = startTime$1;
                            this.finishTime$1 = finishTime$1;
                        }
                    });
                    ++this.ids$1.elem;
                    p.start();
                    return p;
                }
                {
                    this.queue$1 = queue$1;
                    this.ids$1 = ids$1;
                }
            }, ClassTag$.MODULE$.apply(StringConsumer.class));
            String string = (String)taxonID.elem;
            String string2 = "";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                String string3 = (String)taxonIDsFilepath.elem;
                String string4 = "";
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    String string5 = (String)fullDumpFilePath.elem;
                    String string6 = "";
                    if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                        parser.showUsage();
                    } else {
                        File file = new File((String)fullDumpFilePath.elem);
                        if (file.isDirectory()) {
                            IntRef dids = new IntRef(0);
                            Thread[] detectpool = (Thread[])Array$.MODULE$.fill(numSourceThreads.elem, (Function0)new Serializable(fullDumpFilePath, headerForDumpFile, idsToIndexFile, persistResults, taxonRank, index, lastModifiedDate, queue, dids){
                                public static final long serialVersionUID = 0L;
                                private final ObjectRef fullDumpFilePath$1;
                                public final ObjectRef headerForDumpFile$1;
                                private final ObjectRef idsToIndexFile$1;
                                public final BooleanRef persistResults$1;
                                public final ObjectRef taxonRank$1;
                                public final BooleanRef index$1;
                                public final ObjectRef lastModifiedDate$1;
                                public final ArrayBlockingQueue queue$1;
                                private final IntRef dids$1;

                                public final Thread apply() {
                                    String dumpFilePath = new StringBuilder().append((Object)((String)this.fullDumpFilePath$1.elem)).append((Object)File.separator).append((Object)BoxesRunTime.boxToInteger((int)this.dids$1.elem)).append((Object)File.separator).append((Object)((String)this.taxonRank$1.elem)).append((Object)".out").toString();
                                    String reindexFile = new StringBuilder().append((Object)((String)this.idsToIndexFile$1.elem)).append((Object)".").append((Object)BoxesRunTime.boxToInteger((int)this.dids$1.elem)).toString();
                                    String passFile = new StringBuilder().append((Object)((String)this.fullDumpFilePath$1.elem)).append((Object)File.separator).append((Object)BoxesRunTime.boxToInteger((int)this.dids$1.elem)).append((Object)File.separator).append((Object)"layer").append((Object)((String)this.taxonRank$1.elem)).append((Object)"-outlier-passed.out").toString();
                                    Thread t = new Thread(this, dumpFilePath, reindexFile, passFile){
                                        private final /* synthetic */ anonfun.16 $outer;
                                        private final String dumpFilePath$1;
                                        private final String reindexFile$1;
                                        private final String passFile$1;

                                        public void run() {
                                            ReverseJacknifeProcessor$.MODULE$.runOutlierTestingForDumpFile(this.dumpFilePath$1, (List<String>)((List)this.$outer.headerForDumpFile$1.elem), this.reindexFile$1, this.$outer.persistResults$1.elem, this.$outer.queue$1, this.$outer.index$1.elem, (Option<String>)((Option)this.$outer.lastModifiedDate$1.elem), new StringBuilder().append((Object)((String)this.$outer.taxonRank$1.elem)).append((Object)"_guid").toString(), this.passFile$1);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                            this.dumpFilePath$1 = dumpFilePath$1;
                                            this.reindexFile$1 = reindexFile$1;
                                            this.passFile$1 = passFile$1;
                                        }
                                    };
                                    ++this.dids$1.elem;
                                    t.start();
                                    return t;
                                }
                                {
                                    this.fullDumpFilePath$1 = fullDumpFilePath$1;
                                    this.headerForDumpFile$1 = headerForDumpFile$1;
                                    this.idsToIndexFile$1 = idsToIndexFile$1;
                                    this.persistResults$1 = persistResults$1;
                                    this.taxonRank$1 = taxonRank$1;
                                    this.index$1 = index$1;
                                    this.lastModifiedDate$1 = lastModifiedDate$1;
                                    this.queue$1 = queue$1;
                                    this.dids$1 = dids$1;
                                }
                            }, ClassTag$.MODULE$.apply(Thread.class));
                            Predef$.MODULE$.refArrayOps((Object[])detectpool).foreach((Function1)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final void apply(Thread x$1) {
                                    x$1.join();
                                }
                            });
                        } else {
                            this.runOutlierTestingForDumpFile((String)fullDumpFilePath.elem, (List<String>)((List)headerForDumpFile.elem), (String)idsToIndexFile.elem, persistResults.elem, queue, index.elem, (Option<String>)((Option)lastModifiedDate.elem), new StringBuilder().append((Object)((String)taxonRank.elem)).append((Object)"_guid").toString(), this.runOutlierTestingForDumpFile$default$9());
                        }
                    }
                } else {
                    Source$.MODULE$.fromFile((String)taxonIDsFilepath.elem, Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1)new Serializable(taxonID){
                        public static final long serialVersionUID = 0L;
                        private final ObjectRef taxonID$1;

                        public final void apply(String line) {
                            ReverseJacknifeProcessor$.MODULE$.testForOutliers((String)this.taxonID$1.elem, ReverseJacknifeProcessor$.MODULE$.testForOutliers$default$2());
                        }
                        {
                            this.taxonID$1 = taxonID$1;
                        }
                    });
                }
            } else {
                this.testForOutliers((String)taxonID.elem, persistResults.elem);
            }
            Predef$.MODULE$.refArrayOps((Object[])pool).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(StringConsumer t) {
                    t.shouldStop_$eq(true);
                }
            });
            Predef$.MODULE$.refArrayOps((Object[])pool).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(StringConsumer x$2) {
                    x$2.join();
                }
            });
        }
        this.logger().debug("Shutting down indexing...");
        Config$.MODULE$.indexDAO().shutdown();
        this.logger().debug("Shutting down cassandra connection...");
        Config$.MODULE$.persistenceManager().shutdown();
        this.logger().debug("Finished.");
    }

    public void runOutlierTestingForDumpFile(String dumpFilePath, List<String> columnHeaders, String idsToIndexFile, boolean persistResults, ArrayBlockingQueue<String> queue, boolean index, Option<String> lastModifiedDate, String field, String passFile) {
        block6: {
            if (new File(dumpFilePath).length() > 0L) {
                List headers;
                File uuidIndexFile = new File(idsToIndexFile);
                FileWriter idsWriter = new FileWriter(uuidIndexFile);
                FileWriter passWriter = new FileWriter(passFile);
                CSVReader reader = new CSVReader((Reader)new FileReader(dumpFilePath), '\t', '~');
                List list = headers = columnHeaders.isEmpty() ? Predef$.MODULE$.refArrayOps((Object[])reader.readNext()).toList() : columnHeaders;
                if (this.mandatoryHeaders().forall((Function1)new Serializable(headers){
                    public static final long serialVersionUID = 0L;
                    private final List headers$1;

                    public final boolean apply(String x$3) {
                        return this.headers$1.contains((Object)x$3);
                    }
                    {
                        this.headers$1 = headers$1;
                    }
                })) {
                    Tuple3<String, Seq<String[]>, String[]> tuple3;
                    List variables = (List)headers.filter((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(String x$4) {
                            return x$4.startsWith("el");
                        }
                    });
                    boolean finished = false;
                    String nextTaxonConceptID = "";
                    Timings timings = new Timings();
                    String[] lastLine = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
                    int latitudeIdx = headers.indexOf((Object)"decimalLatitude");
                    int longitudeIdx = headers.indexOf((Object)"decimalLongitude");
                    int taxonIDIdx = headers.indexOf((Object)"taxonConceptID");
                    int uuidIdx = headers.indexOf((Object)"uuid");
                    int rowKeyIdx = headers.indexOf((Object)"rowKey");
                    while (true) {
                        Tuple3 tuple32;
                        if (finished) {
                            idsWriter.close();
                            passWriter.flush();
                            passWriter.close();
                            if (index) {
                                this.logger().debug("Starting the indexing of marked records....");
                                IndexRecords$.MODULE$.indexListOfUUIDs(uuidIndexFile);
                                this.logger().debug("Finished the indexing of marked records.");
                            }
                            break block6;
                        }
                        tuple3 = this.readAllForTaxon(reader, nextTaxonConceptID, taxonIDIdx, lastLine);
                        if (tuple3 == null) break;
                        String taxonConceptID = (String)tuple3._1();
                        Seq lines = (Seq)tuple3._2();
                        String[] nextLine = (String[])tuple3._3();
                        Tuple3 tuple33 = tuple32 = new Tuple3((Object)taxonConceptID, (Object)lines, (Object)nextLine);
                        String taxonConceptID2 = (String)tuple33._1();
                        Seq lines2 = (Seq)tuple33._2();
                        String[] nextLine2 = (String[])tuple33._3();
                        lastLine = nextLine2;
                        this.logger().info(new StringBuilder().append((Object)taxonConceptID2).append((Object)", records: ").append((Object)BoxesRunTime.boxToInteger((int)lines2.size())).toString());
                        this.logger().debug(Predef$.MODULE$.refArrayOps((Object[])lines2.head()).mkString(","));
                        ListBuffer resultsBuffer = new ListBuffer();
                        ListBuffer recordIds = new ListBuffer();
                        BooleanRef loadedIds = new BooleanRef(false);
                        variables.foreach((Function1)new Serializable(idsWriter, headers, timings, latitudeIdx, longitudeIdx, uuidIdx, rowKeyIdx, lines2, resultsBuffer, recordIds, loadedIds){
                            public static final long serialVersionUID = 0L;
                            public final FileWriter idsWriter$1;
                            private final List headers$1;
                            private final Timings timings$1;
                            public final int latitudeIdx$1;
                            public final int longitudeIdx$1;
                            public final int uuidIdx$1;
                            public final int rowKeyIdx$1;
                            private final Seq lines$1;
                            private final ListBuffer resultsBuffer$1;
                            public final ListBuffer recordIds$1;
                            public final BooleanRef loadedIds$1;

                            public final void apply(String variable) {
                                Grid grid = new Grid((String)ReverseJacknifeProcessor$.MODULE$.envLayerMap().apply((Object)variable));
                                int variableIdx = this.headers$1.indexOf((Object)variable);
                                ListBuffer pointBuffer = new ListBuffer();
                                this.lines$1.foreach((Function1)new Serializable(this, grid, variableIdx, pointBuffer){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.runOutlierTestingForDumpFile.2 $outer;
                                    private final Grid grid$1;
                                    private final int variableIdx$1;
                                    private final ListBuffer pointBuffer$1;

                                    /*
                                     * Enabled aggressive block sorting
                                     */
                                    public final Object apply(String[] line) {
                                        BoxedUnit boxedUnit;
                                        String longitude;
                                        String latitude;
                                        String variableValue;
                                        block3: {
                                            block2: {
                                                variableValue = line[this.variableIdx$1];
                                                latitude = line[this.$outer.latitudeIdx$1];
                                                longitude = line[this.$outer.longitudeIdx$1];
                                                Object object = this.$outer.loadedIds$1.elem ? BoxedUnit.UNIT : this.$outer.recordIds$1.$plus$eq((Object)line[this.$outer.rowKeyIdx$1]);
                                                String string = variableValue;
                                                String string2 = "";
                                                if (!(string == null ? string2 != null : !string.equals(string2)) || variableValue == null) break block2;
                                                String string3 = latitude;
                                                String string4 = "";
                                                if (!(string3 == null ? string4 != null : !string3.equals(string4))) break block2;
                                                String string5 = longitude;
                                                String string6 = "";
                                                if (string5 != null ? !string5.equals(string6) : string6 != null) break block3;
                                            }
                                            boxedUnit = BoxedUnit.UNIT;
                                            return boxedUnit;
                                        }
                                        int cellId = ReverseJacknifeProcessor$.MODULE$.getCellId(this.grid$1, new StringOps(Predef$.MODULE$.augmentString(latitude)).toFloat(), new StringOps(Predef$.MODULE$.augmentString(longitude)).toFloat());
                                        boxedUnit = this.pointBuffer$1.$plus$eq((Object)new SampledRecord(line[this.$outer.uuidIdx$1], new StringOps(Predef$.MODULE$.augmentString(variableValue)).toFloat(), cellId, (Option<String>)new Some((Object)line[this.$outer.rowKeyIdx$1])));
                                        return boxedUnit;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.grid$1 = grid$1;
                                        this.variableIdx$1 = variableIdx$1;
                                        this.pointBuffer$1 = pointBuffer$1;
                                    }
                                });
                                Tuple2<Seq<SampledRecord>, Option<JackKnifeStats>> tuple2 = ReverseJacknifeProcessor$.MODULE$.performJacknife((Seq<SampledRecord>)pointBuffer);
                                if (tuple2 != null) {
                                    Tuple2 tuple22;
                                    Seq recordsIDs = (Seq)tuple2._1();
                                    Option stats = (Option)tuple2._2();
                                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)recordsIDs, (Object)stats);
                                    Seq recordsIDs2 = (Seq)tuple23._1();
                                    Option stats2 = (Option)tuple23._2();
                                    if (!stats2.isEmpty()) {
                                        this.resultsBuffer$1.$plus$eq((Object)new Tuple3((Object)variable, (Object)recordsIDs2, stats2.get()));
                                        recordsIDs2.foreach((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ anonfun.runOutlierTestingForDumpFile.2 $outer;

                                            public final void apply(SampledRecord x) {
                                                this.$outer.idsWriter$1.write(x.id());
                                                this.$outer.idsWriter$1.write("\n");
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw new NullPointerException();
                                                }
                                                this.$outer = $outer;
                                            }
                                        });
                                        this.idsWriter$1.flush();
                                    }
                                    this.timings$1.checkpoint(new StringBuilder().append((Object)"jacknife with ").append((Object)variable).toString());
                                    if (ReverseJacknifeProcessor$.MODULE$.logger().isDebugEnabled()) {
                                        ReverseJacknifeProcessor$.MODULE$.logger().debug(new StringOps(Predef$.MODULE$.augmentString(">>> For layer: %s we've detected: %d outliers out of %d records tested.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{variable, BoxesRunTime.boxToInteger((int)recordsIDs2.length()), BoxesRunTime.boxToInteger((int)this.lines$1.size())})));
                                    }
                                    if (recordsIDs2.length() > this.lines$1.size()) {
                                        if (ReverseJacknifeProcessor$.MODULE$.logger().isDebugEnabled()) {
                                            ReverseJacknifeProcessor$.MODULE$.logger().debug(new StringOps(Predef$.MODULE$.augmentString(">>> records: %d, distinct values: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)recordsIDs2.length()), BoxesRunTime.boxToInteger((int)recordsIDs2.toSet().size())})));
                                        }
                                        throw new RuntimeException("Error in processing");
                                    }
                                    this.loadedIds$1.elem = true;
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.idsWriter$1 = idsWriter$1;
                                this.headers$1 = headers$1;
                                this.timings$1 = timings$1;
                                this.latitudeIdx$1 = latitudeIdx$1;
                                this.longitudeIdx$1 = longitudeIdx$1;
                                this.uuidIdx$1 = uuidIdx$1;
                                this.rowKeyIdx$1 = rowKeyIdx$1;
                                this.lines$1 = lines$1;
                                this.resultsBuffer$1 = resultsBuffer$1;
                                this.recordIds$1 = recordIds$1;
                                this.loadedIds$1 = loadedIds$1;
                            }
                        });
                        Set passedRecords = resultsBuffer.isEmpty() ? (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$) : (Set)recordIds.toSet().$amp$tilde((GenSet)((TraversableForwarder)((TraversableLike)((TraversableForwarder)resultsBuffer.map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final Seq<SampledRecord> apply(Tuple3<String, Seq<SampledRecord>, JackKnifeStats> x$7) {
                                return (Seq)x$7._2();
                            }
                        }, ListBuffer$.MODULE$.canBuildFrom())).foldLeft((Object)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$), (Function2)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final ListBuffer<SampledRecord> apply(ListBuffer<SampledRecord> x$8, Seq<SampledRecord> x$9) {
                                return (ListBuffer)x$8.$plus$plus(x$9);
                            }
                        })).map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply(SampledRecord v) {
                                return (String)v.rowKey().getOrElse((Function0)new Serializable(this, v){
                                    public static final long serialVersionUID = 0L;
                                    private final SampledRecord v$1;

                                    public final String apply() {
                                        return this.v$1.id();
                                    }
                                    {
                                        this.v$1 = v$1;
                                    }
                                });
                            }
                        }, ListBuffer$.MODULE$.canBuildFrom())).toSet());
                        this.logger().info(new StringBuilder().append((Object)"The records that passed ").append((Object)BoxesRunTime.boxToInteger((int)passedRecords.size())).append((Object)" ").append((Object)BoxesRunTime.boxToInteger((int)recordIds.size())).toString());
                        this.storeResultsWithStats(taxonConceptID2, (Seq<Tuple3<String, Seq<SampledRecord>, JackKnifeStats>>)resultsBuffer, (Set<String>)passedRecords, idsWriter, queue, lastModifiedDate, field, passWriter);
                        if (nextLine2 == null) {
                            finished = true;
                            continue;
                        }
                        nextTaxonConceptID = nextLine2[taxonIDIdx];
                    }
                    throw new MatchError(tuple3);
                }
                throw new RuntimeException(new StringBuilder().append((Object)"Missing mandatory headers ").append((Object)this.mandatoryHeaders().mkString(",")).append((Object)", Got: ").append((Object)headers.mkString(",")).toString());
            }
        }
    }

    public List<String> runOutlierTestingForDumpFile$default$2() {
        return Nil$.MODULE$;
    }

    public String runOutlierTestingForDumpFile$default$3() {
        return new StringBuilder().append((Object)Config$.MODULE$.tmpWorkDir()).append((Object)"/idsToReIndex.txt").toString();
    }

    public boolean runOutlierTestingForDumpFile$default$4() {
        return false;
    }

    public boolean runOutlierTestingForDumpFile$default$6() {
        return false;
    }

    public Option<String> runOutlierTestingForDumpFile$default$7() {
        return None$.MODULE$;
    }

    public String runOutlierTestingForDumpFile$default$8() {
        return "species_guid";
    }

    public String runOutlierTestingForDumpFile$default$9() {
        return new StringBuilder().append((Object)Config$.MODULE$.tmpWorkDir()).append((Object)"/layer-outlier-pass.out").toString();
    }

    public Tuple3<String, Seq<String[]>, String[]> readAllForTaxon(CSVReader reader, String taxonConceptID, int taxonConceptIDIdx, String[] lastLine) {
        String[] currentLine = reader.readNext();
        String string = taxonConceptID;
        String string2 = "";
        String idForBatch = !(string != null ? !string.equals(string2) : string2 != null) ? currentLine[taxonConceptIDIdx] : taxonConceptID;
        this.logger().debug(new StringBuilder().append((Object)"###### Running for:").append((Object)idForBatch).toString());
        ListBuffer buffer = new ListBuffer();
        Object object = Predef$.MODULE$.refArrayOps((Object[])lastLine).isEmpty() ? BoxedUnit.UNIT : buffer.$plus$eq((Object)lastLine);
        while (true) {
            if (currentLine == null) break;
            String string3 = currentLine[taxonConceptIDIdx];
            String string4 = idForBatch;
            if (string3 != null ? !string3.equals(string4) : string4 != null) break;
            buffer.$plus$eq((Object)currentLine);
            currentLine = reader.readNext();
        }
        return new Tuple3((Object)idForBatch, (Object)buffer, (Object)currentLine);
    }

    public String[] readAllForTaxon$default$4() {
        return (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
    }

    public void testForOutliers(String lsid, boolean persistResults) {
        String[] variablesToTest = (String[])((Object[])new String[]{"el889", "el882", "el887", "el865", "el894"});
        String[] requiredFields = (String[])Predef$.MODULE$.refArrayOps((Object[])new String[]{"id", "latitude", "longitude"}).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])variablesToTest), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        URL u = new URL(new StringBuilder().append((Object)Config$.MODULE$.biocacheServiceUrl()).append((Object)"/webportal/occurrences.gz?pageSize=3000000&q=lsid:\"").append((Object)lsid).append((Object)"\"&fl=").append((Object)Predef$.MODULE$.refArrayOps((Object[])requiredFields).mkString(",")).toString());
        InputStream in = u.openStream();
        File file = new File(new StringBuilder().append((Object)Config$.MODULE$.tmpWorkDir()).append((Object)"/occurrences.gz").toString());
        FileOutputStream out = new FileOutputStream(file);
        byte[] buffer = new byte[1024];
        int numRead = 0;
        while ((numRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, numRead);
            out.flush();
        }
        out.close();
        Predef$.MODULE$.printf("\nDownloaded. File size: %d kB, Path: %s\n", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(file.length() / 1024L)), file.getAbsolutePath()}));
        File extractedFile = FileHelper$.MODULE$.file2helper(file).extractGzip();
        Seq outlierValues = (Seq)Predef$.MODULE$.refArrayOps((Object[])variablesToTest).map((Function1)new Serializable(requiredFields, extractedFile){
            public static final long serialVersionUID = 0L;
            private final String[] requiredFields$1;
            private final File extractedFile$1;

            public final Tuple2<String, Seq<SampledRecord>> apply(String variable) {
                Tuple2<Seq<SampledRecord>, Option<JackKnifeStats>> tuple2 = ReverseJacknifeProcessor$.MODULE$.performJacknife(variable, this.extractedFile$1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])this.requiredFields$1));
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    Seq list = (Seq)tuple2._1();
                    Option stats = (Option)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)list, (Object)stats);
                    Seq list2 = (Seq)tuple23._1();
                    Option stats2 = (Option)tuple23._2();
                    ReverseJacknifeProcessor$.MODULE$.logger().info(new StringOps(Predef$.MODULE$.augmentString("Variable: %s, Outliers: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{variable, BoxesRunTime.boxToInteger((int)list2.size())})));
                    list2.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(SampledRecord x$11) {
                            Predef$.MODULE$.println((Object)x$11);
                        }
                    });
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)variable), (Object)list2);
                }
                throw new MatchError(tuple2);
            }
            {
                this.requiredFields$1 = requiredFields$1;
                this.extractedFile$1 = extractedFile$1;
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        Seq<Tuple2<SampledRecord, String>> record2Layer = this.invertLayer2Record((Seq<Tuple2<String, Seq<SampledRecord>>>)outlierValues);
        if (persistResults) {
            this.storeResults(lsid, record2Layer);
        }
        Seq<Tuple2<String, Object>> recordLayerCounts = this.generateOutlierCounts(record2Layer);
        List outlier5 = ((TraversableOnce)((TraversableLike)recordLayerCounts.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> x) {
                return x._2$mcI$sp() == 5;
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> x) {
                return (String)x._1();
            }
        }, Seq$.MODULE$.canBuildFrom())).toList();
        List outlier4 = ((TraversableOnce)((TraversableLike)recordLayerCounts.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> x) {
                return x._2$mcI$sp() == 4;
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> x) {
                return (String)x._1();
            }
        }, Seq$.MODULE$.canBuildFrom())).toList();
        List outlier3 = ((TraversableOnce)((TraversableLike)recordLayerCounts.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> x) {
                return x._2$mcI$sp() == 3;
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> x) {
                return (String)x._1();
            }
        }, Seq$.MODULE$.canBuildFrom())).toList();
        List outlier2 = ((TraversableOnce)((TraversableLike)recordLayerCounts.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> x) {
                return x._2$mcI$sp() == 2;
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> x) {
                return (String)x._1();
            }
        }, Seq$.MODULE$.canBuildFrom())).toList();
        List outlier1 = ((TraversableOnce)((TraversableLike)recordLayerCounts.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> x) {
                return x._2$mcI$sp() == 1;
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> x) {
                return (String)x._1();
            }
        }, Seq$.MODULE$.canBuildFrom())).toList();
        this.printLinksForRecords(5, (Seq<String>)outlier5);
        this.printLinksForRecords(4, (Seq<String>)outlier4);
        this.printLinksForRecords(3, (Seq<String>)outlier3);
        this.printLinksForRecords(2, (Seq<String>)outlier2);
        this.printLinksForRecords(1, (Seq<String>)outlier1);
    }

    public boolean testForOutliers$default$2() {
        return false;
    }

    public void storeResultsWithStats(String taxonID, Seq<Tuple3<String, Seq<SampledRecord>, JackKnifeStats>> results, Set<String> passed, FileWriter idsWriter, ArrayBlockingQueue<String> queue, Option<String> lastModifiedDate, String field, FileWriter passedWriter) {
        String[] stringArray;
        Option<String> option;
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)DefaultScalaModule$.MODULE$);
        Map jackKnifeStatsMap = ((TraversableOnce)results.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, JackKnifeStats> apply(Tuple3<String, Seq<SampledRecord>, JackKnifeStats> x) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(x._1()), x._3());
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        Config$.MODULE$.persistenceManager().put(taxonID, "outliers", "jackKnifeStats", mapper.writeValueAsString((Object)jackKnifeStatsMap));
        Seq variableResults = (Seq)results.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Seq<SampledRecord>> apply(Tuple3<String, Seq<SampledRecord>, JackKnifeStats> x) {
                return new Tuple2(x._1(), x._2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq<Tuple2<SampledRecord, String>> record2OutlierLayer = this.invertLayer2Record((Seq<Tuple2<String, Seq<SampledRecord>>>)variableResults);
        try {
            option = Config$.MODULE$.persistenceManager().get(taxonID, "outliers", "jackKnifeOutliers");
        }
        catch (Exception exception) {
            option = None$.MODULE$;
        }
        Option<String> previous = option;
        Object object = previous.isEmpty() ? BoxedUnit.UNIT : Config$.MODULE$.persistenceManager().put(taxonID, "outliers", "previous", (String)previous.get());
        Config$.MODULE$.persistenceManager().put(taxonID, "outliers", "jackKnifeOutliers", mapper.writeValueAsString((Object)variableResults));
        Seq recordStats = (Seq)record2OutlierLayer.map((Function1)new Serializable(jackKnifeStatsMap){
            public static final long serialVersionUID = 0L;
            private final Map jackKnifeStatsMap$1;

            public final RecordJackKnifeStats apply(Tuple2<SampledRecord, String> x) {
                Tuple2 tuple2 = new Tuple2(x._1(), x._2());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    SampledRecord sampledRecord = (SampledRecord)tuple2._1();
                    String layerId = (String)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)sampledRecord, (Object)layerId);
                    SampledRecord sampledRecord2 = (SampledRecord)tuple23._1();
                    String layerId2 = (String)tuple23._2();
                    JackKnifeStats jackKnifeStats = (JackKnifeStats)this.jackKnifeStatsMap$1.get((Object)layerId2).get();
                    return new RecordJackKnifeStats(sampledRecord2.id(), layerId2, sampledRecord2.value(), jackKnifeStats.sampleSize(), jackKnifeStats.min(), jackKnifeStats.max(), jackKnifeStats.mean(), jackKnifeStats.stdDev(), jackKnifeStats.range(), jackKnifeStats.threshold(), jackKnifeStats.outlierValues());
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.jackKnifeStatsMap$1 = jackKnifeStatsMap$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        recordStats.groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(RecordJackKnifeStats x$13) {
                return x$13.uuid();
            }
        }).foreach((Function1)new Serializable(mapper){
            public static final long serialVersionUID = 0L;
            private final ObjectMapper mapper$1;

            public final Object apply(Tuple2<String, Seq<RecordJackKnifeStats>> x) {
                Object object;
                Option<String> rowKey = Config$.MODULE$.occurrenceDAO().getRowKeyFromUuid((String)x._1());
                if (rowKey.isEmpty()) {
                    ReverseJacknifeProcessor$.MODULE$.logger().debug(new StringBuilder().append((Object)"Row key lookup failed for : ").append(x._1()).toString());
                    object = BoxedUnit.UNIT;
                } else {
                    List layerIds = ((TraversableOnce)((TraversableLike)x._2()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(RecordJackKnifeStats x$14) {
                            return x$14.layerId();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).toList();
                    Config$.MODULE$.persistenceManager().put((String)rowKey.get(), "occ", "outlierForLayers.p", this.mapper$1.writeValueAsString((Object)layerIds));
                    Config$.MODULE$.occurrenceDAO().addSystemAssertion((String)rowKey.get(), QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DETECTED_OUTLIER(), new StringBuilder().append((Object)"Outlier for ").append((Object)BoxesRunTime.boxToInteger((int)((SeqLike)x._2()).size())).append((Object)" layers").toString()), Config$.MODULE$.occurrenceDAO().addSystemAssertion$default$3(), Config$.MODULE$.occurrenceDAO().addSystemAssertion$default$4());
                    object = Config$.MODULE$.persistenceManager().put((String)x._1(), "occ_outliers", "jackKnife", this.mapper$1.writeValueAsString(x._2()));
                }
                return object;
            }
            {
                this.mapper$1 = mapper$1;
            }
        });
        if (previous.isDefined()) {
            JsonPath jsonPath = JsonPath.compile((String)"$..id", (Filter[])new Filter[0]);
            JSONArray idArray = (JSONArray)jsonPath.read((String)previous.get());
            stringArray = (String[])idArray.toArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
        } else {
            stringArray = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        }
        String[] previousIDs = stringArray;
        this.logger().debug(new StringBuilder().append((Object)"previousIDs: ").append((Object)previousIDs).toString());
        String[] currentIDs = (String[])((TraversableOnce)record2OutlierLayer.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<SampledRecord, String> x0$1) {
                Tuple2<SampledRecord, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    SampledRecord sampledRecord = (SampledRecord)tuple2._1();
                    String string = sampledRecord.id();
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        String[] newIDs = (String[])Predef$.MODULE$.refArrayOps((Object[])previousIDs).diff((GenSeq)Predef$.MODULE$.wrapRefArray((Object[])currentIDs));
        this.logger().debug(new StringBuilder().append((Object)"previous : ").append((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])previousIDs).size())).append((Object)" current ").append((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])currentIDs).size())).append((Object)" new : ").append((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])newIDs).size())).toString());
        this.logger().debug(new StringBuilder().append((Object)"[WARNING] Number of old IDs not marked as outliers anymore: ").append((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])newIDs).size())).toString());
        Predef$.MODULE$.refArrayOps((Object[])newIDs).foreach((Function1)new Serializable(idsWriter){
            public static final long serialVersionUID = 0L;
            private final FileWriter idsWriter$2;

            public final void apply(String recordID) {
                ReverseJacknifeProcessor$.MODULE$.logger().debug(new StringBuilder().append((Object)"Record ").append((Object)recordID).append((Object)" is no longer an outlier").toString());
                Option<String> rowKey = Config$.MODULE$.occurrenceDAO().getRowKeyFromUuid(recordID);
                if (!rowKey.isEmpty()) {
                    this.idsWriter$2.write(recordID);
                    this.idsWriter$2.write("\n");
                    Config$.MODULE$.persistenceManager().deleteColumns((String)rowKey.get(), "occ", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"outlierForLayers.p"}));
                    Config$.MODULE$.occurrenceDAO().addSystemAssertion((String)rowKey.get(), QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DETECTED_OUTLIER(), 1), true, Config$.MODULE$.occurrenceDAO().addSystemAssertion$default$4());
                }
            }
            {
                this.idsWriter$2 = idsWriter$2;
            }
        });
        None$ rowkeys = lastModifiedDate.isDefined() ? new Some(this.getRecordsChangedSince((String)lastModifiedDate.get(), field, taxonID)) : None$.MODULE$;
        passed.foreach((Function1)new Serializable(passedWriter, (Option)rowkeys){
            public static final long serialVersionUID = 0L;
            private final FileWriter passedWriter$1;
            private final Option rowkeys$1;

            public final void apply(String rowKey) {
                if (this.rowkeys$1.isEmpty() || ((LinearSeqOptimized)this.rowkeys$1.get()).contains((Object)rowKey)) {
                    this.passedWriter$1.write(new StringBuilder().append((Object)rowKey).append((Object)"\n").toString());
                }
            }
            {
                this.passedWriter$1 = passedWriter$1;
                this.rowkeys$1 = rowkeys$1;
            }
        });
        passedWriter.flush();
    }

    public List<String> getRecordsChangedSince(String date, String field, String taxonId) {
        ArrayBuffer buf = new ArrayBuffer();
        Config$.MODULE$.indexDAO().pageOverFacet((Function2<String, Object, Object>)new Serializable(buf){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer buf$1;

            public final boolean apply(String value, int count) {
                this.buf$1.$plus$eq((Object)value);
                return true;
            }
            {
                this.buf$1 = buf$1;
            }
        }, "row_key", new StringBuilder().append((Object)field).append((Object)":\"").append((Object)taxonId).append((Object)"\"").toString(), (String[])((Object[])new String[]{new StringBuilder().append((Object)"last_load_date:[").append((Object)date).append((Object)" TO *]").toString()}));
        return buf.toList();
    }

    public void storeResults(String taxonID, Seq<Tuple2<SampledRecord, String>> record2Layers) {
        Config$.MODULE$.persistenceManager().put(taxonID, "outliers", "current", record2Layers.toString());
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Tuple2<SampledRecord, String>> invertLayer2Record(Seq<Tuple2<String, Seq<SampledRecord>>> layer2Record) {
        void var2_2;
        ListBuffer record2Layer = new ListBuffer();
        layer2Record.foreach((Function1)new Serializable(record2Layer){
            public static final long serialVersionUID = 0L;
            public final ListBuffer record2Layer$1;

            public final void apply(Tuple2<String, Seq<SampledRecord>> layer2Record) {
                Tuple2 tuple2 = new Tuple2(layer2Record._1(), layer2Record._2());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    String layerId = (String)tuple2._1();
                    Seq records = (Seq)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)layerId, (Object)records);
                    String layerId2 = (String)tuple23._1();
                    Seq records2 = (Seq)tuple23._2();
                    records2.foreach((Function1)new Serializable(this, layerId2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.invertLayer2Record.1 $outer;
                        private final String layerId$1;

                        public final void apply(SampledRecord r) {
                            this.$outer.record2Layer$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)r, (Object)this.layerId$1)}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.layerId$1 = layerId$1;
                        }
                    });
                    return;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.record2Layer$1 = record2Layer$1;
            }
        });
        return var2_2;
    }

    public void printLinksForRecords(int count, Seq<String> records) {
        this.logger().info(new StringBuilder().append((Object)"## outlier for : ").append((Object)BoxesRunTime.boxToInteger((int)count)).append((Object)" ##").toString());
        records.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(String c) {
                ReverseJacknifeProcessor$.MODULE$.logger().info(new StringBuilder().append((Object)Config$.MODULE$.biocacheServiceUrl()).append((Object)"/occurrences/").append((Object)c).toString());
            }
        });
        this.logger().info(new StringBuilder().append((Object)"## end of outlier for : ").append((Object)BoxesRunTime.boxToInteger((int)count)).append((Object)" ##").toString());
    }

    public void printLinks(int count, Seq<String> records) {
        this.logger().info(new StringBuilder().append((Object)"************************ outlier for : ").append((Object)BoxesRunTime.boxToInteger((int)count)).append((Object)" ******************").toString());
        records.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(String c) {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)Config$.MODULE$.biocacheServiceUrl()).append((Object)"/occurrences/").append((Object)c).toString());
            }
        });
        this.logger().info(new StringBuilder().append((Object)"************************ end of outlier for : ").append((Object)BoxesRunTime.boxToInteger((int)count)).append((Object)" ******************").toString());
    }

    public Seq<Tuple2<String, Object>> generateOutlierCounts(Seq<Tuple2<SampledRecord, String>> outliers) {
        String[] recordIds = (String[])((TraversableOnce)outliers.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<SampledRecord, String> x) {
                return ((SampledRecord)x._1()).id();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet().toArray(ClassTag$.MODULE$.apply(String.class));
        int[] counts = (int[])Array$.MODULE$.fill(Predef$.MODULE$.refArrayOps((Object[])recordIds).size(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 0;
            }
        }, ClassTag$.MODULE$.Int());
        outliers.foreach((Function1)new Serializable(recordIds, counts){
            public static final long serialVersionUID = 0L;
            private final String[] recordIds$2;
            private final int[] counts$1;

            public final void apply(Tuple2<SampledRecord, String> r) {
                int recordIdx = Predef$.MODULE$.refArrayOps((Object[])this.recordIds$2).indexOf((Object)((SampledRecord)r._1()).id());
                this.counts$1[recordIdx] = this.counts$1[recordIdx] + 1;
            }
            {
                this.recordIds$2 = recordIds$2;
                this.counts$1 = counts$1;
            }
        });
        return (Seq)Predef$.MODULE$.refArrayOps((Object[])recordIds).zip((GenIterable)Predef$.MODULE$.wrapIntArray(counts), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    /*
     * Unable to fully structure code
     */
    public Tuple2<Seq<SampledRecord>, Option<JackKnifeStats>> performJacknife(String variableName, File file, Seq<String> headersFields) {
        r = new CSVReader((Reader)new FileReader(file));
        if (r.readNext() == null) {
            return new Tuple2((Object)Nil$.MODULE$, (Object)None$.MODULE$);
        }
        headers = headersFields.isEmpty() != false ? Predef$.MODULE$.refArrayOps((Object[])r.readNext()).toList() : headersFields;
        grid = new Grid((String)this.envLayerMap().apply((Object)variableName));
        points = new ListBuffer();
        line = r.readNext();
        while (true) {
            if (line == null) break;
            fields = ((TraversableOnce)headers.zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])line), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
            if (!fields.contains((Object)"latitude")) ** GOTO lbl-1000
            v0 = fields.apply((Object)"latitude");
            var10_10 = "";
            if (!(v0 == null ? var10_10 != null : v0.equals(var10_10) == false)) ** GOTO lbl-1000
            v1 = fields.getOrElse((Object)variableName, (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            });
            var11_11 = "";
            if (v1 == null ? var11_11 != null : v1.equals(var11_11) == false) {
                id = (String)fields.apply((Object)"id");
                x = new StringOps(Predef$.MODULE$.augmentString((String)fields.apply((Object)"longitude"))).toFloat();
                y = new StringOps(Predef$.MODULE$.augmentString((String)fields.apply((Object)"latitude"))).toFloat();
                elValue = new StringOps(Predef$.MODULE$.augmentString((String)fields.apply((Object)variableName))).toFloat();
                cellId = this.getCellId(x, y, grid.xmin, grid.xmax, grid.xres, grid.ymin, grid.ymax, grid.yres, grid.nrows, grid.ncols);
                v2 = points.$plus$eq((Object)new SampledRecord(id, elValue, cellId, SampledRecord$.MODULE$.apply$default$4()));
            } else lbl-1000:
            // 3 sources

            {
                v2 = BoxedUnit.UNIT;
            }
            line = r.readNext();
        }
        r.close();
        return this.performJacknife((Seq<SampledRecord>)points);
    }

    public Tuple2<Seq<SampledRecord>, Option<JackKnifeStats>> performJacknife(Seq<SampledRecord> points) {
        Option<JackKnifeStats> option;
        block4: {
            Tuple2 tuple2;
            block3: {
                block2: {
                    Map pointsGroupedByCell = points.groupBy((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final int apply(SampledRecord p) {
                            return p.cellId();
                        }
                    });
                    Map cellToValue = ((Map)pointsGroupedByCell.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Object, Object> apply(Tuple2<Object, Seq<SampledRecord>> g) {
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)g._1$mcI$sp())), (Object)BoxesRunTime.boxToFloat((float)((SampledRecord)((IterableLike)g._2()).head()).value()));
                        }
                    }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
                    Map valuesToCells = ((Map)cellToValue.groupBy((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final float apply(Tuple2<Object, Object> x) {
                            return BoxesRunTime.unboxToFloat((Object)x._2());
                        }
                    }).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Object, Set<Object>> apply(Tuple2<Object, Map<Object, Object>> x) {
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(x._1()), (Object)((MapLike)x._2()).keys().toSet());
                        }
                    }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
                    JackKnife jacknife = new JackKnife();
                    Seq valuesToTest = ((TraversableOnce)cellToValue.values().map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final float apply(float y) {
                            return this.apply$mcFF$sp(y);
                        }

                        public float apply$mcFF$sp(float y) {
                            return y;
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).toSeq();
                    option = jacknife.jackknife((Seq<Object>)valuesToTest, jacknife.jackknife$default$2());
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    JackKnifeStats stats = (JackKnifeStats)some.x();
                    ListBuffer outliers = new ListBuffer();
                    Predef$.MODULE$.floatArrayOps(stats.outlierValues()).foreach((Function1)new Serializable(pointsGroupedByCell, valuesToCells, outliers){
                        public static final long serialVersionUID = 0L;
                        public final Map pointsGroupedByCell$1;
                        private final Map valuesToCells$1;
                        public final ListBuffer outliers$1;

                        public final void apply(float x) {
                            this.apply$mcVF$sp(x);
                        }

                        public void apply$mcVF$sp(float x) {
                            Set cellIds = (Set)this.valuesToCells$1.getOrElse((Object)BoxesRunTime.boxToFloat((float)x), (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Set<Object> apply() {
                                    return (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
                                }
                            });
                            cellIds.foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.performJacknife.1 $outer;

                                public final void apply(int cellId) {
                                    this.apply$mcVI$sp(cellId);
                                }

                                public void apply$mcVI$sp(int cellId) {
                                    Seq points = (Seq)this.$outer.pointsGroupedByCell$1.get((Object)BoxesRunTime.boxToInteger((int)cellId)).get();
                                    points.foreach((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ anonfun$performJacknife$1$$anonfun$apply$mcVF$sp$1 $outer;

                                        public final ListBuffer<SampledRecord> apply(SampledRecord point) {
                                            return this.$outer.au$org$ala$biocache$outliers$ReverseJacknifeProcessor$$anonfun$$anonfun$$$outer().outliers$1.$plus$eq((Object)point);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                }

                                public /* synthetic */ anonfun.performJacknife.1 au$org$ala$biocache$outliers$ReverseJacknifeProcessor$$anonfun$$anonfun$$$outer() {
                                    return this.$outer;
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }
                        {
                            this.pointsGroupedByCell$1 = pointsGroupedByCell$1;
                            this.valuesToCells$1 = valuesToCells$1;
                            this.outliers$1 = outliers$1;
                        }
                    });
                    tuple2 = new Tuple2(outliers.distinct(), (Object)new Some((Object)stats));
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<JackKnifeStats> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                tuple2 = new Tuple2((Object)Nil$.MODULE$, (Object)None$.MODULE$);
            }
            return tuple2;
        }
        throw new MatchError(option);
    }

    public Seq<String> performJacknife$default$3() {
        return List$.MODULE$.empty();
    }

    public int getCellId(Grid grid, float latitude, float longitude) {
        return this.getCellId(longitude, latitude, grid.xmin, grid.xmax, grid.xres, grid.ymin, grid.ymax, grid.yres, grid.nrows, grid.ncols);
    }

    public int getCellId(String fid, float latitude, float longitude) {
        Grid grid = new Grid((String)this.envLayerMap().apply((Object)fid));
        return this.getCellId(longitude, latitude, grid.xmin, grid.xmax, grid.xres, grid.ymin, grid.ymax, grid.yres, grid.nrows, grid.ncols);
    }

    public int getCellId(double x, double y, double xmin, double xmax, double xres, double ymin, double ymax, double yres, int nrows, int ncols) {
        int n;
        if (x < xmin || x > xmax || y < ymin || y > ymax) {
            n = -1;
        } else {
            int col = (int)((x - xmin) / xres);
            int row = nrows - 1 - (int)((y - ymin) / yres);
            if (col < 0) {
                col = 0;
            }
            if (row < 0) {
                row = 0;
            }
            if (col >= ncols) {
                col = ncols - 1;
            }
            if (row >= nrows) {
                row = nrows - 1;
            }
            n = row * ncols + col;
        }
        return n;
    }

    private ReverseJacknifeProcessor$() {
        MODULE$ = this;
        Tool$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"SpeciesOutlierTests");
        this.mandatoryHeaders = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"taxonConceptID", "uuid", "decimalLatitude", "decimalLongitude"}));
        this.envLayerMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"el882"), (Object)"/data/ala/data/layers/ready/diva/bioclim_bio15"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"el889"), (Object)"/data/ala/data/layers/ready/diva/bioclim_bio17"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"el887"), (Object)"/data/ala/data/layers/ready/diva/bioclim_bio23"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"el865"), (Object)"/data/ala/data/layers/ready/diva/bioclim_bio26"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"el894"), (Object)"/data/ala/data/layers/ready/diva/bioclim_bio32")}));
    }
}

