/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.load;

import au.org.ala.biocache.load.DataLoader;
import au.org.ala.biocache.load.DataLoader$class;
import au.org.ala.biocache.load.DataResourceConfig;
import au.org.ala.biocache.load.FlickrLoader;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.model.Multimedia;
import au.org.ala.biocache.parser.DateParser$;
import au.org.ala.biocache.persistence.PersistenceManager;
import au.org.ala.biocache.util.OptionParser;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Date;
import org.apache.commons.lang.time.DateUtils;
import org.gbif.dwc.terms.Term;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

public final class FlickrLoader$
implements DataLoader {
    public static final FlickrLoader$ MODULE$;
    private final Logger logger;
    private final String user;
    private final String temporaryFileStore;
    private final PersistenceManager pm;
    private final String loadTime;
    private final Regex sftpPattern;

    static {
        new FlickrLoader$();
    }

    @Override
    public String user() {
        return this.user;
    }

    @Override
    public String temporaryFileStore() {
        return this.temporaryFileStore;
    }

    @Override
    public PersistenceManager pm() {
        return this.pm;
    }

    @Override
    public String loadTime() {
        return this.loadTime;
    }

    @Override
    public Regex sftpPattern() {
        return this.sftpPattern;
    }

    @Override
    public void au$org$ala$biocache$load$DataLoader$_setter_$user_$eq(String x$1) {
        this.user = x$1;
    }

    @Override
    public void au$org$ala$biocache$load$DataLoader$_setter_$logger_$eq(Logger x$1) {
    }

    @Override
    public void au$org$ala$biocache$load$DataLoader$_setter_$temporaryFileStore_$eq(String x$1) {
        this.temporaryFileStore = x$1;
    }

    @Override
    public void au$org$ala$biocache$load$DataLoader$_setter_$pm_$eq(PersistenceManager x$1) {
        this.pm = x$1;
    }

    @Override
    public void au$org$ala$biocache$load$DataLoader$_setter_$loadTime_$eq(String x$1) {
        this.loadTime = x$1;
    }

    @Override
    public void au$org$ala$biocache$load$DataLoader$_setter_$sftpPattern_$eq(Regex x$1) {
        this.sftpPattern = x$1;
    }

    @Override
    public boolean emptyTempFileStore(String resourceUid) {
        return DataLoader$class.emptyTempFileStore(this, resourceUid);
    }

    @Override
    public FileWriter getDeletedFileWriter(String resourceUid) {
        return DataLoader$class.getDeletedFileWriter(this, resourceUid);
    }

    @Override
    public void deleteOldRowKeys(String resourceUid) {
        DataLoader$class.deleteOldRowKeys(this, resourceUid);
    }

    @Override
    public Option<Writer> getRowKeyWriter(String resourceUid, boolean writeRowKeys) {
        return DataLoader$class.getRowKeyWriter(this, resourceUid, writeRowKeys);
    }

    @Override
    public void setNotLoadedForOtherPhases(String resourceUid) {
        DataLoader$class.setNotLoadedForOtherPhases(this, resourceUid);
    }

    @Override
    public Map<String, String> getDataResourceDetailsAsMap(String uid) {
        return DataLoader$class.getDataResourceDetailsAsMap(this, uid);
    }

    @Override
    public Map<String, String> getDataProviderDetailsAsMap(String uid) {
        return DataLoader$class.getDataProviderDetailsAsMap(this, uid);
    }

    @Override
    public Map<String, String> getInstitutionDetailsAsMap(String uid) {
        return DataLoader$class.getInstitutionDetailsAsMap(this, uid);
    }

    @Override
    public Option<DataResourceConfig> retrieveConnectionParameters(String resourceUid) {
        return DataLoader$class.retrieveConnectionParameters(this, resourceUid);
    }

    @Override
    public Seq<Term> mapConceptTerms(Seq<String> terms) {
        return DataLoader$class.mapConceptTerms(this, terms);
    }

    @Override
    public boolean exists(String dataResourceUid, List<String> identifyingTerms) {
        return DataLoader$class.exists(this, dataResourceUid, identifyingTerms);
    }

    @Override
    public String createUniqueID(String dataResourceUid, Seq<String> identifyingTerms, boolean stripSpaces) {
        return DataLoader$class.createUniqueID(this, dataResourceUid, identifyingTerms, stripSpaces);
    }

    @Override
    public boolean load(String dataResourceUid, FullRecord fr, Seq<String> identifyingTerms, Seq<Multimedia> multimedia) {
        return DataLoader$class.load((DataLoader)this, dataResourceUid, fr, identifyingTerms, multimedia);
    }

    @Override
    public boolean load(String dataResourceUid, FullRecord fr, Seq<String> identifyingTerms) {
        return DataLoader$class.load(this, dataResourceUid, fr, identifyingTerms);
    }

    @Override
    public boolean load(String dataResourceUid, FullRecord fr, Seq<String> identifyingTerms, boolean updateLastModified) {
        return DataLoader$class.load((DataLoader)this, dataResourceUid, fr, identifyingTerms, updateLastModified);
    }

    @Override
    public boolean load(String dataResourceUid, FullRecord fr, Seq<String> identifyingTerms, boolean updateLastModified, boolean downloadMedia2) {
        return DataLoader$class.load(this, dataResourceUid, fr, identifyingTerms, updateLastModified, downloadMedia2);
    }

    @Override
    public boolean load(String dataResourceUid, FullRecord fr, Seq<String> identifyingTerms, boolean updateLastModified, boolean downloadMedia2, boolean stripSpaces, Option<Writer> rowKeyWriter, Seq<Multimedia> multimedia) {
        return DataLoader$class.load(this, dataResourceUid, fr, identifyingTerms, updateLastModified, downloadMedia2, stripSpaces, rowKeyWriter, multimedia);
    }

    @Override
    public FullRecord processMedia(String dataResourceUid, FullRecord fr, Seq<Multimedia> multimedia) {
        return DataLoader$class.processMedia(this, dataResourceUid, fr, multimedia);
    }

    @Override
    public Tuple2<String, Date> downloadArchive(String url, String resourceUid, Option<Date> lastChecked) {
        return DataLoader$class.downloadArchive(this, url, resourceUid, lastChecked);
    }

    @Override
    public Tuple4<File, Date, Object, Object> downloadSFTPArchive(String url, String resourceUid, Option<Date> lastChecked) {
        return DataLoader$class.downloadSFTPArchive(this, url, resourceUid, lastChecked);
    }

    @Override
    public Option<Tuple2<String, Date>> sftpLatestArchive(String url, String resourceUid, Option<Date> afterDate) {
        return DataLoader$class.sftpLatestArchive(this, url, resourceUid, afterDate);
    }

    @Override
    public Tuple4<File, Date, Object, Object> downloadStandardArchive(String url, String resourceUid, Option<Date> afterDate) {
        return DataLoader$class.downloadStandardArchive(this, url, resourceUid, afterDate);
    }

    @Override
    public boolean updateLastChecked(String resourceUid, Option<Date> dataCurrency) {
        return DataLoader$class.updateLastChecked(this, resourceUid, dataCurrency);
    }

    @Override
    public Option<Date> updateLastChecked$default$2() {
        return DataLoader$class.updateLastChecked$default$2(this);
    }

    @Override
    public boolean createUniqueID$default$3() {
        return DataLoader$class.createUniqueID$default$3(this);
    }

    @Override
    public Seq<Multimedia> processMedia$default$3() {
        return DataLoader$class.processMedia$default$3(this);
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    public void main(String[] args) {
        ObjectRef dataResourceUid = new ObjectRef((Object)"");
        ObjectRef startDate = new ObjectRef((Object)None$.MODULE$);
        ObjectRef endDate = new ObjectRef((Object)None$.MODULE$);
        BooleanRef overwriteImages = new BooleanRef(false);
        BooleanRef lastMonth = new BooleanRef(false);
        BooleanRef lastDay = new BooleanRef(false);
        BooleanRef lastWeek = new BooleanRef(false);
        BooleanRef updateCollectory = new BooleanRef(false);
        BooleanRef modifiedLastMonth = new BooleanRef(false);
        BooleanRef modifiedLastDay = new BooleanRef(false);
        BooleanRef modifiedLastWeek = new BooleanRef(false);
        ObjectRef lastUpdatedDate = new ObjectRef((Object)None$.MODULE$);
        OptionParser parser = new OptionParser(dataResourceUid, startDate, endDate, overwriteImages, lastMonth, lastDay, lastWeek, updateCollectory, modifiedLastMonth, modifiedLastDay, modifiedLastWeek, lastUpdatedDate){
            {
                this.arg("<data resource UID>", "The UID of the data resource to load", (Function1<String, BoxedUnit>)new Serializable(this, dataResourceUid$3){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef dataResourceUid$3;

                    public final void apply(String v) {
                        this.dataResourceUid$3.elem = v;
                    }
                    {
                        this.dataResourceUid$3 = dataResourceUid$3;
                    }
                });
                this.opt("s", "startDate", "start date to harvest from in yyyy-MM-dd format", (Function1<String, BoxedUnit>)new Serializable(this, startDate$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef startDate$1;

                    public final void apply(String v) {
                        this.startDate$1.elem = new Some((Object)DateUtils.parseDate((String)v, (String[])((String[])((Object[])new String[]{"yyyy-MM-dd"}))));
                    }
                    {
                        this.startDate$1 = startDate$1;
                    }
                });
                this.opt("e", "endDate", "end date in yyyy-MM-dd format", (Function1<String, BoxedUnit>)new Serializable(this, endDate$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef endDate$1;

                    public final void apply(String v) {
                        this.endDate$1.elem = new Some((Object)DateUtils.parseDate((String)v, (String[])((String[])((Object[])new String[]{"yyyy-MM-dd"}))));
                    }
                    {
                        this.endDate$1 = endDate$1;
                    }
                });
                this.opt("lm", "harvestLastMonth", "Harvest the last month of records", (Function0<BoxedUnit>)new Serializable(this, lastMonth$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef lastMonth$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.lastMonth$1.elem = true;
                    }
                    {
                        this.lastMonth$1 = lastMonth$1;
                    }
                });
                this.opt("ld", "harvestLastDay", "Harvest the last day of records", (Function0<BoxedUnit>)new Serializable(this, lastDay$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef lastDay$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.lastDay$1.elem = true;
                    }
                    {
                        this.lastDay$1 = lastDay$1;
                    }
                });
                this.opt("lw", "harvestLastWeek", "Harvest the last week of records", (Function0<BoxedUnit>)new Serializable(this, lastWeek$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef lastWeek$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.lastWeek$1.elem = true;
                    }
                    {
                        this.lastWeek$1 = lastWeek$1;
                    }
                });
                this.opt("mlm", "modifiedLastMonth", "Harvest the last month of records", (Function0<BoxedUnit>)new Serializable(this, modifiedLastMonth$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef modifiedLastMonth$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.modifiedLastMonth$1.elem = true;
                    }
                    {
                        this.modifiedLastMonth$1 = modifiedLastMonth$1;
                    }
                });
                this.opt("mld", "modifiedLastDay", "Harvest the last day of records", (Function0<BoxedUnit>)new Serializable(this, modifiedLastDay$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef modifiedLastDay$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.modifiedLastDay$1.elem = true;
                    }
                    {
                        this.modifiedLastDay$1 = modifiedLastDay$1;
                    }
                });
                this.opt("mlw", "modifiedLastWeek", "Harvest the last week of records", (Function0<BoxedUnit>)new Serializable(this, modifiedLastWeek$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef modifiedLastWeek$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.modifiedLastWeek$1.elem = true;
                    }
                    {
                        this.modifiedLastWeek$1 = modifiedLastWeek$1;
                    }
                });
                this.opt("o", "overwrite", "overwrite images", (Function0<BoxedUnit>)new Serializable(this, overwriteImages$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef overwriteImages$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.overwriteImages$1.elem = true;
                    }
                    {
                        this.overwriteImages$1 = overwriteImages$1;
                    }
                });
                this.opt("u", "updateCollectory", "Update the harvesting information in the collectory", (Function0<BoxedUnit>)new Serializable(this, updateCollectory$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef updateCollectory$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.updateCollectory$1.elem = true;
                    }
                    {
                        this.updateCollectory$1 = updateCollectory$1;
                    }
                });
                this.opt("md", "lastModifiedDate", "The earliest last modified date allowable on the records to load", (Function1<String, BoxedUnit>)new Serializable(this, lastUpdatedDate$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef lastUpdatedDate$1;

                    public final void apply(String v) {
                        this.lastUpdatedDate$1.elem = DateParser$.MODULE$.parseStringToDate(v);
                    }
                    {
                        this.lastUpdatedDate$1 = lastUpdatedDate$1;
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            FlickrLoader l = new FlickrLoader();
            Date today = new Date();
            lastUpdatedDate.elem = modifiedLastDay.elem ? new Some((Object)DateUtils.addDays((Date)today, (int)-1)) : (modifiedLastWeek.elem ? new Some((Object)DateUtils.addWeeks((Date)today, (int)-1)) : (modifiedLastMonth.elem ? new Some((Object)DateUtils.addMonths((Date)today, (int)-1)) : (((Option)lastUpdatedDate.elem).isDefined() ? (Option)lastUpdatedDate.elem : None$.MODULE$)));
            this.logger().info(new StringBuilder().append((Object)"Last updated date: ").append((Object)BoxesRunTime.boxToLong((long)((Date)((Option)lastUpdatedDate.elem).get()).getTime())).toString());
            if (lastMonth.elem) {
                Date today2 = new Date();
                Date monthAgo = DateUtils.addMonths((Date)today2, (int)-1);
                l.load((String)dataResourceUid.elem, (Option<Date>)new Some((Object)monthAgo), (Option<Date>)new Some((Object)today2), updateCollectory.elem, overwriteImages.elem, (Option<Date>)((Option)lastUpdatedDate.elem));
            } else if (lastDay.elem) {
                Date today3 = new Date();
                Date yesterday = DateUtils.addDays((Date)today3, (int)-1);
                l.load((String)dataResourceUid.elem, (Option<Date>)new Some((Object)yesterday), (Option<Date>)new Some((Object)today3), updateCollectory.elem, overwriteImages.elem, (Option<Date>)((Option)lastUpdatedDate.elem));
            } else if (lastWeek.elem) {
                Date today4 = new Date();
                Date sevenDaysAgo = DateUtils.addWeeks((Date)today4, (int)-1);
                l.load((String)dataResourceUid.elem, (Option<Date>)new Some((Object)sevenDaysAgo), (Option<Date>)new Some((Object)today4), updateCollectory.elem, overwriteImages.elem, (Option<Date>)((Option)lastUpdatedDate.elem));
            } else {
                l.load((String)dataResourceUid.elem, (Option<Date>)((Option)startDate.elem), (Option<Date>)((Option)endDate.elem), updateCollectory.elem, overwriteImages.elem, (Option<Date>)((Option)lastUpdatedDate.elem));
            }
        }
    }

    private FlickrLoader$() {
        MODULE$ = this;
        DataLoader$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"FlickrLoader");
    }
}

