/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.memory;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.memory.DirectDocValuesFormat;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

class DirectDocValuesConsumer
extends DocValuesConsumer {
    IndexOutput data;
    IndexOutput meta;
    final int maxDoc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    DirectDocValuesConsumer(SegmentWriteState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        this.maxDoc = state.segmentInfo.getDocCount();
        boolean success = false;
        try {
            String dataName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)dataExtension);
            this.data = state.directory.createOutput(dataName, state.context);
            CodecUtil.writeHeader((DataOutput)this.data, (String)dataCodec, (int)2);
            String metaName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)metaExtension);
            this.meta = state.directory.createOutput(metaName, state.context);
            CodecUtil.writeHeader((DataOutput)this.meta, (String)metaCodec, (int)2);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this});
            throw throwable;
        }
    }

    public void addNumericField(FieldInfo field, Iterable<Number> values) throws IOException {
        this.meta.writeVInt(field.number);
        this.meta.writeByte((byte)0);
        this.addNumericFieldValues(field, values);
    }

    private void addNumericFieldValues(FieldInfo field, Iterable<Number> values) throws IOException {
        this.meta.writeLong(this.data.getFilePointer());
        long minValue = Long.MAX_VALUE;
        long maxValue = Long.MIN_VALUE;
        boolean missing = false;
        long count = 0L;
        for (Number nv : values) {
            if (nv != null) {
                long v = nv.longValue();
                minValue = Math.min(minValue, v);
                maxValue = Math.max(maxValue, v);
            } else {
                missing = true;
            }
            if (++count < (long)DirectDocValuesFormat.MAX_SORTED_SET_ORDS) continue;
            throw new IllegalArgumentException("DocValuesField \"" + field.name + "\" is too large, must be <= " + DirectDocValuesFormat.MAX_SORTED_SET_ORDS + " values/total ords");
        }
        this.meta.writeInt((int)count);
        if (missing) {
            long start = this.data.getFilePointer();
            this.writeMissingBitset(values);
            this.meta.writeLong(start);
            this.meta.writeLong(this.data.getFilePointer() - start);
        } else {
            this.meta.writeLong(-1L);
        }
        int byteWidth = minValue >= -128L && maxValue <= 127L ? 1 : (minValue >= -32768L && maxValue <= 32767L ? 2 : (minValue >= Integer.MIN_VALUE && maxValue <= Integer.MAX_VALUE ? 4 : 8));
        this.meta.writeByte((byte)byteWidth);
        for (Number nv : values) {
            long v = nv != null ? nv.longValue() : 0L;
            switch (byteWidth) {
                case 1: {
                    this.data.writeByte((byte)v);
                    break;
                }
                case 2: {
                    this.data.writeShort((short)v);
                    break;
                }
                case 4: {
                    this.data.writeInt((int)v);
                    break;
                }
                case 8: {
                    this.data.writeLong(v);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        block7: {
            block6: {
                boolean success = false;
                try {
                    if (this.meta != null) {
                        this.meta.writeVInt(-1);
                        CodecUtil.writeFooter((IndexOutput)this.meta);
                    }
                    if (this.data != null) {
                        CodecUtil.writeFooter((IndexOutput)this.data);
                    }
                    if (!(success = true)) break block6;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{this.data, this.meta});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.data, this.meta});
                    }
                    this.meta = null;
                    this.data = null;
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{this.data, this.meta});
                break block7;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.data, this.meta});
        }
        this.meta = null;
        this.data = null;
    }

    public void addBinaryField(FieldInfo field, Iterable<BytesRef> values) throws IOException {
        this.meta.writeVInt(field.number);
        this.meta.writeByte((byte)1);
        this.addBinaryFieldValues(field, values);
    }

    private void addBinaryFieldValues(FieldInfo field, Iterable<BytesRef> values) throws IOException {
        long startFP = this.data.getFilePointer();
        boolean missing = false;
        long totalBytes = 0L;
        int count = 0;
        for (BytesRef v : values) {
            if (v != null) {
                this.data.writeBytes(v.bytes, v.offset, v.length);
                if ((totalBytes += (long)v.length) > (long)DirectDocValuesFormat.MAX_TOTAL_BYTES_LENGTH) {
                    throw new IllegalArgumentException("DocValuesField \"" + field.name + "\" is too large, cannot have more than DirectDocValuesFormat.MAX_TOTAL_BYTES_LENGTH (" + DirectDocValuesFormat.MAX_TOTAL_BYTES_LENGTH + ") bytes");
                }
            } else {
                missing = true;
            }
            ++count;
        }
        this.meta.writeLong(startFP);
        this.meta.writeInt((int)totalBytes);
        this.meta.writeInt(count);
        if (missing) {
            long start = this.data.getFilePointer();
            this.writeMissingBitset(values);
            this.meta.writeLong(start);
            this.meta.writeLong(this.data.getFilePointer() - start);
        } else {
            this.meta.writeLong(-1L);
        }
        int addr = 0;
        for (BytesRef v : values) {
            this.data.writeInt(addr);
            if (v == null) continue;
            addr += v.length;
        }
        this.data.writeInt(addr);
    }

    void writeMissingBitset(Iterable<?> values) throws IOException {
        long bits = 0L;
        int count = 0;
        for (Object v : values) {
            if (count == 64) {
                this.data.writeLong(bits);
                count = 0;
                bits = 0L;
            }
            if (v != null) {
                bits |= 1L << (count & 0x3F);
            }
            ++count;
        }
        if (count > 0) {
            this.data.writeLong(bits);
        }
    }

    public void addSortedField(FieldInfo field, Iterable<BytesRef> values, Iterable<Number> docToOrd) throws IOException {
        this.meta.writeVInt(field.number);
        this.meta.writeByte((byte)2);
        this.addNumericFieldValues(field, docToOrd);
        this.addBinaryFieldValues(field, values);
    }

    public void addSortedNumericField(FieldInfo field, Iterable<Number> docToValueCount, Iterable<Number> values) throws IOException {
        this.meta.writeVInt(field.number);
        if (DirectDocValuesConsumer.isSingleValued(docToValueCount)) {
            this.meta.writeByte((byte)6);
            this.addNumericFieldValues(field, DirectDocValuesConsumer.singletonView(docToValueCount, values, null));
        } else {
            this.meta.writeByte((byte)5);
            this.addNumericFieldValues(field, this.countToAddressIterator(docToValueCount));
            this.addNumericFieldValues(field, values);
        }
    }

    public void addSortedSetField(FieldInfo field, Iterable<BytesRef> values, Iterable<Number> docToOrdCount, Iterable<Number> ords) throws IOException {
        this.meta.writeVInt(field.number);
        if (DirectDocValuesConsumer.isSingleValued(docToOrdCount)) {
            this.meta.writeByte((byte)4);
            this.addNumericFieldValues(field, DirectDocValuesConsumer.singletonView(docToOrdCount, ords, (Number)-1L));
            this.addBinaryFieldValues(field, values);
        } else {
            this.meta.writeByte((byte)3);
            this.addNumericFieldValues(field, this.countToAddressIterator(docToOrdCount));
            this.addNumericFieldValues(field, ords);
            this.addBinaryFieldValues(field, values);
        }
    }

    private Iterable<Number> countToAddressIterator(final Iterable<Number> counts) {
        return new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                final Iterator iter = counts.iterator();
                return new Iterator<Number>(){
                    long sum;
                    boolean ended;

                    @Override
                    public boolean hasNext() {
                        return iter.hasNext() || !this.ended;
                    }

                    @Override
                    public Number next() {
                        long toReturn = this.sum;
                        if (iter.hasNext()) {
                            Number n = (Number)iter.next();
                            if (n != null) {
                                this.sum += n.longValue();
                            }
                        } else if (!this.ended) {
                            this.ended = true;
                        } else assert (false);
                        return toReturn;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

